/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.statistics;

import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.gui.chart.IDataPoint;
import com.tiani.base.data.IImageRegionProperties;

class OverlayStatisticsValue
implements Comparable<OverlayStatisticsValue>,
IDataPoint {
    private static final boolean USE_MAXMIMUM = Config.impaxee.jvision.OVERLAY.Statistics.useMaximumPixelValue.get();
    private final long acquisitionDateTime;
    private final int seriesNumber;
    private double value;
    private long earliestAcquisitionDateTime;
    private boolean isRelative = false;
    private double scalingFactor = 1.0;

    OverlayStatisticsValue(long l, int n, IImageRegionProperties iImageRegionProperties) {
        this.acquisitionDateTime = l;
        this.seriesNumber = n;
        this.value = USE_MAXMIMUM ? iImageRegionProperties.getMax() : iImageRegionProperties.getMean();
    }

    void setEarliestAcquisitionDateTime(long l) {
        this.earliestAcquisitionDateTime = l;
    }

    @Override
    public double getX() {
        return (double)(this.acquisitionDateTime - this.earliestAcquisitionDateTime) / 1000.0;
    }

    @Override
    public double getY() {
        return this.isRelative ? this.value * this.scalingFactor : this.value;
    }

    public long getAcquisitionDateTime() {
        return this.acquisitionDateTime;
    }

    public void setScalingFactor(double d) {
        this.scalingFactor = d;
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public int getSeriesNumber() {
        return this.seriesNumber;
    }

    public void setRelative(boolean bl) {
        this.isRelative = bl;
    }

    public boolean isRelative() {
        return this.isRelative;
    }

    @Override
    public int compareTo(OverlayStatisticsValue overlayStatisticsValue) {
        if (this.acquisitionDateTime < overlayStatisticsValue.acquisitionDateTime) {
            return -1;
        }
        if (this.acquisitionDateTime > overlayStatisticsValue.acquisitionDateTime) {
            return 1;
        }
        return (int)Math.signum(this.value - overlayStatisticsValue.value);
    }
}

