/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.statistics;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewMouseHandler;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import com.tiani.jvision.overlay.statistics.IPresentationObjectAction;
import com.tiani.jvision.vis.VisData;
import com.tiani.util.message.Message;
import java.awt.Component;

abstract class AbstractMultiSeriesOverlayAction
extends AbstractPAction
implements IPresentationObjectAction {
    AbstractMultiSeriesOverlayAction() {
    }

    @Override
    public String getGroupName() {
        return MARKUPS_GROUP;
    }

    @Override
    protected boolean isEnabledImpl() {
        VisData visData = AbstractPDataAction.getCurrentImage();
        if (visData == null || visData.getView() == null) {
            return false;
        }
        View view = visData.getView();
        return view.getImageInformation() != null && view.getImageInformation().getFrameOfReferenceUID() != null;
    }

    @Override
    public boolean isSupported(PresentationObject presentationObject) {
        return presentationObject instanceof SyncablePresentationObject && this.isSupportedImpl((SyncablePresentationObject)presentationObject);
    }

    protected abstract boolean isSupportedImpl(SyncablePresentationObject var1);

    @Override
    public boolean perform(Component component) {
        this.perform(this.getPresentationObject());
        return true;
    }

    @Override
    public void perform(PresentationObject presentationObject) {
        this.notifyActionPerformed();
        if (presentationObject == null) {
            Message.error(Messages.getString("AbstractMultiSeriesOverlayAction.Error.NoOverlaySelected.Title"), (Object)Messages.getString("AbstractMultiSeriesOverlayAction.Error.NoOverlaySelected.Msg"));
        } else if (!this.isSupported(presentationObject)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Messages.getString("AbstractMultiSeriesOverlayAction.Error.UnsupportedOverlaySelected.Msg1"));
            stringBuilder.append('\n');
            stringBuilder.append('\n');
            stringBuilder.append(Messages.getString(String.valueOf(this.getClass().getSimpleName()) + ".Error.UnsupportedOverlaySelected.Msg2"));
            Message.error(Messages.getString("AbstractMultiSeriesOverlayAction.Error.UnsupportedOverlaySelected.Title"), (Object)stringBuilder.toString());
        } else {
            this.performImpl((SyncablePresentationObject)presentationObject);
        }
    }

    protected abstract void performImpl(SyncablePresentationObject var1);

    private PresentationObject getPresentationObject() {
        View view = AbstractPDataAction.getCurrentImage().getView();
        if (view.getMouseHandler() instanceof ViewMouseHandler) {
            ViewMouseHandler viewMouseHandler = (ViewMouseHandler)view.getMouseHandler();
            return viewMouseHandler.getActivePO();
        }
        return null;
    }
}

