/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.demographics;

import com.tiani.util.expressions.IEvaluableData;
import com.tiani.util.expressions.IEvaluablePrivateData;
import java.util.Date;
import org.dcm4che3.data.Attributes;

public class MappingEvaluable
implements IEvaluablePrivateData {
    public static final String TAG_PREFIX = "CALC";
    public static final String IMAGE_DIMENSION = "IMAGE_DIMENSION";
    public static final String MR_DURATION = "MR_DURATION";
    private final IEvaluableData data;

    MappingEvaluable(IEvaluableData iEvaluableData) {
        this.data = iEvaluableData;
    }

    @Override
    public Object resolveString(String string) {
        Double d;
        if (IMAGE_DIMENSION.equalsIgnoreCase(string)) {
            String string2 = this.getFieldOfView();
            if (string2 != null) {
                return string2;
            }
        } else if (MR_DURATION.equalsIgnoreCase(string) && (d = this.calcDurationTime()) != null) {
            return d;
        }
        return null;
    }

    private String getFieldOfView() {
        Integer n = this.resolveInt(2621456);
        Integer n2 = this.resolveInt(2621457);
        double[] dArray = this.resolveDoubles(2621488);
        if (n != null && n2 != null && dArray != null && dArray.length >= 2) {
            int n3 = (int)((double)n2.intValue() * dArray[1] + 0.5);
            int n4 = (int)((double)n.intValue() * dArray[0] + 0.5);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(n3);
            stringBuilder.append(" x ");
            stringBuilder.append(n4);
            return stringBuilder.toString();
        }
        return null;
    }

    private Double calcDurationTime() {
        long l;
        Date date = this.resolveDate(524323, 524339);
        Date date2 = this.resolveDate(524322, 524338);
        if (date != null && date2 != null && (l = date.getTime() - date2.getTime()) > 100L) {
            return (double)l / 1000.0;
        }
        return null;
    }

    private Date resolveDate(int n, int n2) {
        Date date = this.resolveDate(n);
        Date date2 = this.resolveDate(n2);
        if (date != null && date2 != null) {
            return new Date(date.getTime() + date2.getTime());
        }
        return null;
    }

    private Date resolveDate(int n) {
        Attributes attributes = this.data.resolveStringEnhanced(null, n);
        if (attributes != null) {
            return attributes.getDate(n);
        }
        return null;
    }

    private double[] resolveDoubles(int n) {
        Attributes attributes = this.data.resolveStringEnhanced(null, n);
        if (attributes != null) {
            return attributes.getDoubles(n);
        }
        return null;
    }

    private Integer resolveInt(int n) {
        Attributes attributes = this.data.resolveStringEnhanced(null, n);
        if (attributes != null) {
            return attributes.getInt(n, 0);
        }
        return null;
    }
}

