/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay.demographics;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.data.hw.manager.InputStreamDicomDataReader;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.StudyType;
import com.agfa.pacs.impaxee.utils.FontUtils;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.config.mappingfonts.model.AwtFontFactory;
import com.tiani.config.mappingfonts.model.Wordgroup;
import com.tiani.config.mappingfonts.model.enums.FontStyle;
import com.tiani.config.mappingfonts.model.enums.LevelOfDetail;
import com.tiani.config.mappingfonts.model.enums.WordgroupType;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.View;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayConfig;
import com.tiani.jvision.overlay.demographics.DefaultSubstituteEvaluation;
import com.tiani.jvision.overlay.demographics.ISubstituteEvaluation;
import com.tiani.jvision.overlay.demographics.MappingEvaluable;
import com.tiani.jvision.overlay.demographics.PriorStudyColoring;
import com.tiani.jvision.overlay.demographics.QuadMapping;
import com.tiani.jvision.overlay.demographics.SubstituteEvaluationFactory;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.vis.VisData;
import com.tiani.util.expressions.EvaluationContext;
import com.tiani.util.expressions.IEvaluationContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public abstract class Mapping
extends Overlay {
    protected static final ALogger log = ALogger.getLogger(Mapping.class);
    private static final DataSelectionManager dsm = DataSelectionManager.getInstance();
    private static final boolean usePriorColoring = Config.impaxee.jvision.MAPPING.ColorizePriorsDemographics.get();
    private static boolean isAnonymousMode = Config.impaxee.jvision.MAPPING.UseAnonymousMode.get();
    private static IConfigurationChangeListener configChangeListener = new IConfigurationChangeListener(){

        public void configurationChanged(String string) {
            if (string != null && string.equals(Config.impaxee.jvision.MAPPING.UseAnonymousMode.getKey()) && isAnonymousMode != Config.impaxee.jvision.MAPPING.UseAnonymousMode.get()) {
                Mapping.setAnonymousMode(Config.impaxee.jvision.MAPPING.UseAnonymousMode.get());
                List<VisData> list = JVision2.getMainFrame().getAllVisDatas();
                for (VisData object2 : list) {
                    object2.getView().updateMapping(true);
                }
                TEvent tEvent = new TEvent(81);
                TEventDispatch.sendEvent(tEvent, null, TEventDispatch.ALL_DISPLAYS | TEventDispatch.ALL_VISUALS);
            }
        }
    };
    private static final Font defaultFont;
    private int minSize = default_min_size;
    protected IEvaluationContext ec;
    private volatile String studyKey;
    protected volatile boolean inited = false;
    protected MappingLineEntry[] paintable;
    protected boolean dirty = true;

    static {
        Config.impaxee.jvision.MAPPING.UseAnonymousMode.registerChangeListener(configChangeListener);
        defaultFont = Mapping.getDefaultFont();
    }

    public Color getMappingColor() {
        return OverlayConfig.mappingColor;
    }

    private static Font getDefaultFont() {
        String string = Config.impaxee.jvision.MAPPING.DisplayFontFace.get();
        FontStyle fontStyle = FontUtils.awtFontStyle2MappingFontStyle((int)Config.impaxee.jvision.MAPPING.DisplayFontStyle.get());
        int n = GUI.getScaledDiagnosticInt((int)((int)Config.impaxee.jvision.MAPPING.DisplayFontSize.get()));
        com.tiani.config.mappingfonts.model.Font font = new com.tiani.config.mappingfonts.model.Font();
        font.setName(string);
        font.setStyle(fontStyle);
        font.setSize(n);
        return QuadMapping.getFont(font);
    }

    Mapping(IEvaluationContext iEvaluationContext) {
        this.ec = iEvaluationContext;
        if (iEvaluationContext != null) {
            this.studyKey = iEvaluationContext.getData().resolveString(0x20000D);
        }
    }

    private static boolean isAnonymousMode() {
        return isAnonymousMode;
    }

    private static void setAnonymousMode(boolean bl) {
        isAnonymousMode = bl;
    }

    protected MappingLineEntry[] newContent(AbstractMappingEntry[] abstractMappingEntryArray) {
        if (abstractMappingEntryArray == null || abstractMappingEntryArray.length == 0) {
            return new MappingLineEntry[0];
        }
        ArrayList<MappingLineEntry> arrayList = new ArrayList<MappingLineEntry>(abstractMappingEntryArray.length);
        MappingLineEntry mappingLineEntry = null;
        boolean bl = true;
        int n = 0;
        while (n < abstractMappingEntryArray.length) {
            MappingLineEntry mappingLineEntry2 = abstractMappingEntryArray[n].refreshContent(this.ec, new MappingLineEntry(abstractMappingEntryArray[n]), true);
            if (!abstractMappingEntryArray[n].append) {
                bl = true;
            }
            if (bl) {
                mappingLineEntry = mappingLineEntry2;
                arrayList.add(mappingLineEntry);
                bl = false;
            } else {
                mappingLineEntry.append(mappingLineEntry2);
            }
            ++n;
        }
        return arrayList.toArray(new MappingLineEntry[arrayList.size()]);
    }

    public void resetMinimumSize() {
        this.minSize = default_min_size;
    }

    private static AbstractMappingEntry createDicomTagEntry(int n, Wordgroup wordgroup, WordgroupType wordgroupType, int n2, boolean bl, Font font, Color color, ISubstituteEvaluation iSubstituteEvaluation) {
        if (ElementDictionary.vrOf((int)n, null) == VR.PN) {
            return new NameDicomTagEntry(n, wordgroup.getPrefix(), wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getDecimalFormat(), wordgroup.getMaxlength(), wordgroup.getLevelOfDetail(), iSubstituteEvaluation);
        }
        if (PrivateTagDictionary.isPrivateTag((int)n)) {
            if (n == PrivateTagDictionary.studyLoadOrderTag) {
                return new PriorTagEntry(wordgroup.getPrefix(), wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getMaxlength(), wordgroup.getLevelOfDetail());
            }
            if (n == -65527) {
                return new StringTagEntry("VISUAL.DISPLAY_SET_TYPE", wordgroup.getPrefix(), wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getDecimalFormat(), wordgroup.getMaxlength(), wordgroup.getLevelOfDetail(), iSubstituteEvaluation);
            }
            return new OwnPrivateTagEntry(n, wordgroup.getPrefix(), wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getMaxlength(), wordgroup.getLevelOfDetail(), null, null);
        }
        return new DicomTagEntry(n, wordgroup.getPrefix(), n2, wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getDecimalFormat(), wordgroup.getMaxlength(), wordgroup.getLevelOfDetail(), iSubstituteEvaluation, null, null);
    }

    public static AbstractMappingEntry createTagEntry(Object object, Wordgroup wordgroup, int n, boolean bl, Font font, Color color) {
        WordgroupType wordgroupType = WordgroupType.STRING;
        if (wordgroup.getRenderedAs() != null) {
            wordgroupType = wordgroup.getRenderedAs().getType();
        }
        ISubstituteEvaluation iSubstituteEvaluation = SubstituteEvaluationFactory.getInstance().getSubstituteEvaluation(wordgroup.getSubstituteEvaluation());
        if (object instanceof Integer) {
            if ((Integer)object == -1) {
                return null;
            }
            return Mapping.createDicomTagEntry((Integer)object, wordgroup, wordgroupType, n, bl, font, color, iSubstituteEvaluation);
        }
        if (object instanceof int[]) {
            return new SeqDicomTagEntry((int[])object, wordgroup.getPrefix(), n, wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getDecimalFormat(), wordgroup.getMaxlength(), wordgroup.getLevelOfDetail(), iSubstituteEvaluation);
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.contains(".")) {
                return new StringTagEntry(string, wordgroup.getPrefix(), wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getDecimalFormat(), wordgroup.getMaxlength(), wordgroup.getLevelOfDetail(), iSubstituteEvaluation);
            }
            if (string.contains("\\")) {
                String[] stringArray = string.split("\\\\");
                int[] nArray = new int[stringArray.length];
                if (stringArray.length % 2 != 1) {
                    log.error("Incorrect path length:" + string);
                    return null;
                }
                int n2 = 0;
                while (n2 < stringArray.length) {
                    nArray[n2] = Mapping.getTagNumber(stringArray[n2]);
                    if (nArray[n2] < 0) {
                        log.error("Could not find tag:" + string);
                        return null;
                    }
                    ++n2;
                }
                return new SeqDicomTagEntry(nArray, wordgroup.getPrefix(), n, wordgroup.getPostfix(), wordgroupType, bl, font, color, wordgroup.getDecimalFormat(), wordgroup.getMaxlength(), wordgroup.getLevelOfDetail(), iSubstituteEvaluation);
            }
            Integer n3 = Mapping.getTagNumber(string);
            if (n3 == null) {
                log.error("Could not find tag:" + string);
                return null;
            }
            return Mapping.createDicomTagEntry(n3, wordgroup, wordgroupType, n, bl, font, color, iSubstituteEvaluation);
        }
        log.warn("Not determined type" + object);
        return null;
    }

    private static Integer getTagNumber(String string) {
        Object object = null;
        if (string.contains(",")) {
            try {
                string = string.replace(",", "");
                return (int)Long.parseLong(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Could not parse dicom tag:" + string);
                return null;
            }
        }
        if (Character.isDigit(string.charAt(0))) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Could not parse dicom tag:" + string);
                return null;
            }
        }
        object = TagDictionary.getInstance().isPrivatTag(string) ? TagDictionary.getInstance().getPrivateTagForName(string) : TagDictionary.getInstance().getTagForName(string);
        if (object == null) {
            return null;
        }
        return object.getNumber();
    }

    public void setMinimumSize(int n) {
        this.minSize = n;
    }

    @Override
    protected int getMinSize() {
        return this.minSize;
    }

    protected void refreshContent(MappingLineEntry[] mappingLineEntryArray, boolean bl) {
        if (mappingLineEntryArray != null) {
            int n = 0;
            while (n < mappingLineEntryArray.length) {
                mappingLineEntryArray[n].refreshContent(bl);
                ++n;
            }
        }
    }

    public abstract void updateContent(boolean var1, boolean var2);

    public void updateContent(EvaluationContext evaluationContext, boolean bl, boolean bl2) {
        if (!this.inited) {
            return;
        }
        this.ec = evaluationContext;
        if (this.studyKey == null) {
            this.studyKey = this.ec.getData().resolveString(0x20000D);
        }
        this.updateContent(bl, bl2);
    }

    protected abstract int getClipWidth();

    private void refreshSizes(Graphics2D graphics2D) {
        if (this.paintable == null) {
            this.updateContent(true, false);
            if (this.paintable == null) {
                log.warn("Mapping: Seem to have no valid mapping layout for " + this.getClass());
                return;
            }
        }
        int n = 0;
        while (n < this.paintable.length) {
            this.paintable[n].refreshPaintedDimension(graphics2D);
            int n2 = this.getClipWidth();
            if (n2 > -1) {
                this.paintable[n].clipToWidth(n2);
            }
            ++n;
        }
        this.refreshCoordinates(graphics2D);
    }

    protected abstract void refreshCoordinates(Graphics2D var1);

    @Override
    public void setSize(int n, int n2, ImageState imageState) {
        boolean bl;
        boolean bl2 = bl = n != this.width || n2 != this.height;
        if (bl) {
            this.dirty = true;
        }
        super.setSize(n, n2, imageState);
    }

    private int getPrintScaledConstant(int n) {
        if (this.printScalingFactor == -1.0f) {
            return n;
        }
        return (int)((double)((float)n * this.printScalingFactor) + 0.5);
    }

    private boolean canPaint(Graphics2D graphics2D) {
        if (this.dirty && graphics2D != null) {
            this.dirty = false;
            this.refreshSizes(graphics2D);
        }
        return this.width > this.getMinSize() && this.height > this.getMinSize();
    }

    public static Color getMappingColor(IEvaluationContext iEvaluationContext) {
        if (iEvaluationContext instanceof IFrameObjectData) {
            String string = ((IFrameObjectData)iEvaluationContext).getParent().getParent().getKey();
            return Mapping.getMappingColor(string);
        }
        if (iEvaluationContext != null && iEvaluationContext.getData() instanceof IFrameObjectData) {
            String string = ((IFrameObjectData)iEvaluationContext.getData()).getParent().getParent().getKey();
            return Mapping.getMappingColor(string);
        }
        return null;
    }

    private static Color getMappingColor(String string) {
        if (!PriorStudyColoring.useDifferentColorsForPriors || !usePriorColoring) {
            return null;
        }
        if (string == null) {
            return null;
        }
        StudyType studyType = StudyType.UNKNOWN;
        if (dsm.getActiveHanging() != null && dsm.getActiveHanging().getStudyContainer() != null) {
            studyType = dsm.getActiveHanging().getStudyContainer().getStudyType(string);
        }
        switch (studyType) {
            case BASE_STUDY: 
            case UNKNOWN: {
                return null;
            }
            case FIRST_PRIOR: {
                return PriorStudyColoring.mappingColorPrior1;
            }
            case MERGED: {
                return PriorStudyColoring.mappingColorMergedStudies;
            }
        }
        return PriorStudyColoring.mappingColorPriorX;
    }

    @Override
    public void paint(BufferedImageHolder bufferedImageHolder) {
        if (this.canPaint(bufferedImageHolder.graphics)) {
            int n = 0;
            while (this.paintable != null && n < this.paintable.length) {
                if (this.paintable[n] != null && this.paintable[n].isValid()) {
                    if (this.isUseOutlineFont()) {
                        this.paintable[n].paint(bufferedImageHolder);
                    } else {
                        this.paintable[n].paint(bufferedImageHolder.graphics);
                    }
                }
                ++n;
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.canPaint(graphics2D)) {
            int n = 0;
            while (this.paintable != null && n < this.paintable.length) {
                if (this.paintable[n].isValid()) {
                    this.paintable[n].paint(graphics2D);
                }
                ++n;
            }
        }
    }

    public List<String> getMappingRowsAsStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        MappingLineEntry[] mappingLineEntryArray = this.paintable;
        int n = this.paintable.length;
        int n2 = 0;
        while (n2 < n) {
            MappingLineEntry mappingLineEntry = mappingLineEntryArray[n2];
            String string = mappingLineEntry.toString();
            if (!string.isEmpty()) {
                arrayList.add(string);
            }
            ++n2;
        }
        return arrayList;
    }

    protected static abstract class AbstractMappingEntry
    implements ITagEntry {
        static final String EMPTY_STRING = "";
        static final String VISUAL = "VISUAL";
        private static Map<String, DecimalFormat> formatPool = new Hashtable<String, DecimalFormat>();
        private static final ISubstituteEvaluation defaultSubstitution = new DefaultSubstituteEvaluation();
        protected ExtendedEntryProperties properties = null;
        protected boolean append;
        protected final WordgroupType type;
        protected String prefix;

        private AbstractMappingEntry(String string, int n, String string2, WordgroupType wordgroupType, boolean bl, Font font, Color color, String string3, String string4, LevelOfDetail levelOfDetail, ISubstituteEvaluation iSubstituteEvaluation) {
            this.prefix = string;
            this.append = bl;
            this.type = wordgroupType;
            int n2 = -1;
            try {
                if (string4 != null && string4.length() > 0) {
                    n2 = Integer.parseInt(string4);
                }
            }
            catch (Exception exception) {
                log.warn("attribute maxlength contains invalid characters");
            }
            if (levelOfDetail != null && levelOfDetail == LevelOfDetail.LIMITED) {
                levelOfDetail = null;
            }
            if (string3 != null && "#.##".equals(string3)) {
                string3 = null;
            }
            if (n != -1 || font != null || color != null || levelOfDetail != null || n2 != -1 || iSubstituteEvaluation != null || string2 != null || string3 != null) {
                this.properties = new ExtendedEntryProperties(font, AbstractMappingEntry.getDecimalFormat(string3), n2, levelOfDetail, iSubstituteEvaluation, color, n, string2);
            }
        }

        private static DecimalFormat getDecimalFormat(String string) {
            if (string == null) {
                return null;
            }
            DecimalFormat decimalFormat = formatPool.get(string);
            if (decimalFormat == null) {
                try {
                    decimalFormat = new DecimalFormat(string);
                    formatPool.put(string, decimalFormat);
                }
                catch (Exception exception) {
                    log.error("Mapping: Invalid format string for mapping >" + string + "<", (Throwable)exception);
                }
            }
            return decimalFormat;
        }

        protected abstract boolean isValid();

        protected Font getFont(float f) {
            Font font;
            Font font2 = font = this.properties == null ? null : this.properties.font;
            if (font == null) {
                font = defaultFont;
            }
            if (f != -1.0f) {
                int n = Math.max(Math.round((float)font.getSize() * f), 10);
                return AwtFontFactory.getFont(font.getName(), font.getStyle(), n);
            }
            return font;
        }

        protected Color getColor(IEvaluationContext iEvaluationContext) {
            return this.properties == null ? null : this.properties.color;
        }

        protected abstract String getTagAsString();

        protected final ISubstituteEvaluation getSubstitution() {
            if (this.properties == null || this.properties.substituteEvaluation == null) {
                return defaultSubstitution;
            }
            return this.properties.substituteEvaluation;
        }

        protected abstract String getValue(IEvaluationContext var1, MappingLineEntry var2);

        MappingLineEntry refreshContent(IEvaluationContext iEvaluationContext, MappingLineEntry mappingLineEntry, boolean bl) {
            if (mappingLineEntry.tag != null && mappingLineEntry.tag != this) {
                throw new IllegalArgumentException("Mapping entry might have been created from another TagEntry: " + mappingLineEntry);
            }
            if (mappingLineEntry.content == null || bl) {
                String string = this.getValue(iEvaluationContext, mappingLineEntry);
                if (string != null) {
                    mappingLineEntry.content = string;
                } else {
                    mappingLineEntry.content = EMPTY_STRING;
                }
            }
            return mappingLineEntry;
        }

        protected boolean levelOfDetailVisible() {
            switch (View.getLevelOfDetailForDemographics()) {
                case NONE: {
                    return false;
                }
                case ALL: {
                    return true;
                }
                case LIMITED: {
                    if (this.properties == null) {
                        return true;
                    }
                    if (this.properties.levelOfDetail == null) {
                        return true;
                    }
                    return this.properties.levelOfDetail != LevelOfDetail.ALL;
                }
            }
            return true;
        }

        protected String formatString(String string) {
            if (string == null) {
                return EMPTY_STRING;
            }
            int n = string.length();
            if (this.prefix != null) {
                n += this.prefix.length();
            }
            if (this.properties != null && this.properties.postfix != null) {
                n += this.properties.postfix.length();
            }
            StringBuilder stringBuilder = new StringBuilder(n);
            if (this.prefix != null) {
                stringBuilder.append(this.prefix);
            }
            if (this.properties != null) {
                if (this.properties.maxlength > 0 && string.length() > this.properties.maxlength) {
                    stringBuilder.append(string, 0, this.properties.maxlength);
                } else {
                    stringBuilder.append(string);
                }
            } else {
                stringBuilder.append(string);
            }
            if (this.properties != null && this.properties.postfix != null) {
                stringBuilder.append(this.properties.postfix);
            }
            return stringBuilder.toString();
        }

        protected String formatStrings(String[] stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                return EMPTY_STRING;
            }
            String string = stringArray[0];
            if (stringArray.length == 1) {
                return this.formatString(string);
            }
            StringBuilder stringBuilder = new StringBuilder(string.length() * stringArray.length + stringArray.length);
            stringBuilder.append(string);
            int n = 1;
            while (n < stringArray.length) {
                stringBuilder.append('\\').append(stringArray[n]);
                ++n;
            }
            return this.formatString(stringBuilder.toString());
        }

        static class ExtendedEntryProperties {
            private final Font font;
            private final DecimalFormat decimalFormat;
            private final int maxlength;
            private final LevelOfDetail levelOfDetail;
            private ISubstituteEvaluation substituteEvaluation;
            private final Color color;
            private int offset;
            private final String postfix;

            public ExtendedEntryProperties(Font font, DecimalFormat decimalFormat, int n, LevelOfDetail levelOfDetail, ISubstituteEvaluation iSubstituteEvaluation, Color color, int n2, String string) {
                this.font = font;
                this.decimalFormat = decimalFormat;
                this.maxlength = n;
                this.levelOfDetail = levelOfDetail;
                this.substituteEvaluation = iSubstituteEvaluation;
                this.color = color;
                this.offset = n2;
                this.postfix = string;
            }

            public ExtendedEntryProperties() {
                this.font = null;
                this.decimalFormat = AbstractMappingEntry.getDecimalFormat(null);
                this.maxlength = -1;
                this.levelOfDetail = null;
                this.substituteEvaluation = null;
                this.color = null;
                this.offset = 0;
                this.postfix = null;
            }
        }
    }

    protected static abstract class AbstractTagEntry
    extends AbstractMappingEntry {
        protected int tag;

        private AbstractTagEntry(int n, String string, int n2, String string2, WordgroupType wordgroupType, boolean bl, Font font, Color color, String string3, String string4, LevelOfDetail levelOfDetail, ISubstituteEvaluation iSubstituteEvaluation) {
            super(string, n2, string2, wordgroupType, bl, font, color, string3, string4, levelOfDetail, iSubstituteEvaluation);
            this.tag = n;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Integer getTag() {
            if (this.tag < 0) {
                return null;
            }
            return this.tag;
        }

        @Override
        public String getTagAsString() {
            if (this.tag < 0) {
                return "Unspecified";
            }
            return TagUtils.toString((int)this.tag);
        }
    }

    private static class DicomTagEntry
    extends AbstractTagEntry {
        private DicomTagEntry(int n, String string, int n2, String string2, WordgroupType wordgroupType, boolean bl, Font font, Color color, String string3, String string4, LevelOfDetail levelOfDetail, ISubstituteEvaluation iSubstituteEvaluation) {
            super(n, string, n2, string2, wordgroupType, bl, font, color, string3, string4, levelOfDetail, iSubstituteEvaluation);
            if (TagUtils.isPrivateGroup((int)n) && !PrivateTagDictionary.isPrivateTag((int)n)) {
                InputStreamDicomDataReader.addRequiredPrivateTag((int)n);
                if (this.properties == null) {
                    this.properties = new AbstractMappingEntry.ExtendedEntryProperties();
                } else {
                    this.properties.offset = 0;
                }
            }
        }

        protected String formatResult(String string) {
            return string;
        }

        @Override
        protected String getValue(IEvaluationContext iEvaluationContext, MappingLineEntry mappingLineEntry) {
            String string;
            block11: {
                if (this.tag != 0x100010 && !this.levelOfDetailVisible()) {
                    return null;
                }
                if (Mapping.isAnonymousMode()) {
                    switch (this.tag) {
                        case 0x100010: 
                        case 0x100020: 
                        case 0x101000: {
                            return null;
                        }
                    }
                }
                string = null;
                if (iEvaluationContext.getData() != null) {
                    try {
                        int n;
                        int n2 = n = this.properties == null ? -1 : this.properties.offset;
                        if (n > -1) {
                            string = this.formatString(this.formatResult(this.getSubstitution().getString(iEvaluationContext, null, this.tag, n, this.type, this.properties == null ? null : this.properties.decimalFormat)));
                            break block11;
                        }
                        string = this.formatStrings(this.getSubstitution().getStrings(iEvaluationContext, null, this.tag, this.type, this.properties == null ? null : this.properties.decimalFormat));
                    }
                    catch (Exception exception) {
                        log.error("Mapping: Could not resolve tag '" + this.getTagAsString() + "'", (Throwable)exception);
                        string = null;
                    }
                } else {
                    return null;
                }
            }
            if (string != null) {
                return string;
            }
            return "";
        }

        /* synthetic */ DicomTagEntry(int n, String string, int n2, String string2, WordgroupType wordgroupType, boolean bl, Font font, Color color, String string3, String string4, LevelOfDetail levelOfDetail, ISubstituteEvaluation iSubstituteEvaluation, DicomTagEntry dicomTagEntry, DicomTagEntry dicomTagEntry2) {
            this(n, string, n2, string2, wordgroupType, bl, font, color, string3, string4, levelOfDetail, iSubstituteEvaluation);
        }
    }

    public static interface ITagEntry {
        public Integer getTag();
    }

    protected class MappingLineEntry {
        private String content;
        private final AbstractMappingEntry tag;
        int px;
        int py;
        private MappingLineEntry tail;
        private int paintedWidth;
        private int paintedHeight;
        private int pwPost = 0;

        private MappingLineEntry(AbstractMappingEntry abstractMappingEntry) {
            this.tag = abstractMappingEntry;
        }

        public void setContentPrefix(String string) {
            if (this.content != null && this.content.length() > 0) {
                this.content = String.valueOf(string) + this.content;
            }
        }

        public boolean isValid() {
            return this.tag.isValid() && this.content != null && this.content.length() > 0 || this.tail != null && this.tail.isValid();
        }

        private void append(MappingLineEntry mappingLineEntry) {
            if (this.tail == null) {
                if (mappingLineEntry.content != null && mappingLineEntry.content.length() > 0 && Character.isLetterOrDigit(mappingLineEntry.content.charAt(0))) {
                    this.pwPost = 5;
                }
                this.tail = mappingLineEntry;
            } else {
                this.tail.append(mappingLineEntry);
            }
        }

        private void refreshContent(boolean bl) {
            String string = this.content;
            this.tag.refreshContent(Mapping.this.ec, this, bl);
            if (!CompareUtils.equals((Object)this.content, (Object)string)) {
                Mapping.this.dirty = true;
            }
            if (this.tail != null) {
                this.tail.refreshContent(bl);
            }
        }

        private void clipToWidth(int n) {
            int n2 = this.getPaintedWidth() - n;
            if (n2 > 0) {
                this.refreshContent(true);
                n2 = this.getPaintedWidth() - n;
            }
            if (n2 > 0) {
                n2 += Mapping.this.getPrintScaledConstant(15);
            }
            this.cutFromTail(n2);
        }

        private int cutFromTail(int n) {
            if (n <= 0) {
                return n;
            }
            if (this.tail != null && (n = this.tail.cutFromTail(n)) > 0) {
                this.paintedWidth -= this.pwPost;
                n -= this.pwPost;
                this.pwPost = 0;
            }
            if (n > 0) {
                if (n > this.paintedWidth) {
                    this.content = "";
                    n -= this.paintedWidth;
                    this.paintedWidth = 0;
                } else if (this.content != null) {
                    int n2 = this.content.length() * n / this.paintedWidth;
                    if (this.content.length() - n2 < this.content.length()) {
                        this.content = this.content.substring(0, this.content.length() - n2);
                    }
                    this.paintedWidth -= n;
                    n = 0;
                }
                if (n <= 0) {
                    this.content = String.valueOf(this.content) + "...";
                    this.paintedWidth += Mapping.this.getPrintScaledConstant(15);
                }
            }
            return n;
        }

        private void refreshPaintedDimension(Graphics2D graphics2D) {
            boolean bl = false;
            Font font = Mapping.this.getCurrentFont();
            Font font2 = this.havingOtherFontThan(font);
            if (font2 != null) {
                bl = Mapping.this.setFont(font2, graphics2D);
            }
            this.paintedWidth = this.content != null ? (Mapping.this.isUseOutlineFont() ? Mapping.this.getCurrentOutlineFont().bytesWidth(this.content.toCharArray(), 0, this.content.length()) + this.pwPost : Mapping.this.getCurrentFontMetrics().bytesWidth(this.content.getBytes(), 0, this.content.length()) + this.pwPost) : 0;
            this.paintedHeight = Mapping.this.getFontHeight();
            if (bl) {
                Mapping.this.resetFont(font, graphics2D);
            }
            if (this.tail != null) {
                this.tail.refreshPaintedDimension(graphics2D);
            }
        }

        public int getPaintedWidth() {
            if (this.tail == null) {
                return this.paintedWidth;
            }
            return this.paintedWidth + this.tail.getPaintedWidth();
        }

        public int getPaintedHeight() {
            if (this.tail == null) {
                return this.paintedHeight;
            }
            return Math.max(this.paintedHeight, this.tail.getPaintedHeight());
        }

        private Font havingOtherFontThan(Font font) {
            Font font2 = this.tag.getFont(Mapping.this.printScalingFactor);
            return font2 != null && font2 != font ? font2 : null;
        }

        private void beforePaint(Graphics2D graphics2D) {
            Font font = this.havingOtherFontThan(Mapping.this.getCurrentFont());
            if (font != null) {
                Mapping.this.setFont(font, graphics2D);
            }
        }

        private void afterPaint(BufferedImageHolder bufferedImageHolder, Graphics2D graphics2D) {
            if (this.tail != null) {
                this.tail.px = this.px + this.paintedWidth;
                this.tail.py = this.py;
                if (bufferedImageHolder != null) {
                    this.tail.paint(bufferedImageHolder);
                } else {
                    this.tail.paint(graphics2D);
                }
            }
        }

        private void paint(BufferedImageHolder bufferedImageHolder) {
            if (!this.isValid()) {
                return;
            }
            Graphics2D graphics2D = bufferedImageHolder.graphics;
            Font font = graphics2D.getFont();
            Color color = graphics2D.getColor();
            this.beforePaint(graphics2D);
            FontMetrics fontMetrics = Mapping.this.getCurrentOutlineFont().getFontMetrics();
            Color color2 = this.tag.getColor(Mapping.this.ec);
            if (color2 == null) {
                color2 = Mapping.getMappingColor(Mapping.this.studyKey);
            }
            if (color2 != null) {
                Mapping.this.drawString(this.content, color2, bufferedImageHolder, this.px, this.py - fontMetrics.getDescent());
            } else {
                Mapping.this.drawString(this.content, bufferedImageHolder, this.px, this.py - fontMetrics.getDescent());
            }
            this.afterPaint(bufferedImageHolder, bufferedImageHolder.graphics);
            if (this.havingOtherFontThan(font) != null) {
                Mapping.this.resetFont(font, graphics2D);
            }
            if (color2 != color) {
                graphics2D.setColor(color);
            }
        }

        private void paint(Graphics2D graphics2D) {
            if (!this.isValid()) {
                return;
            }
            Font font = graphics2D.getFont();
            Color color = graphics2D.getColor();
            this.beforePaint(graphics2D);
            Color color2 = this.tag.getColor(Mapping.this.ec);
            graphics2D.setColor(color2 != null ? color2 : Mapping.this.getMappingColor());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.drawString(this.content, this.px, this.py - fontMetrics.getDescent());
            this.afterPaint(null, graphics2D);
            if (this.havingOtherFontThan(font) != null) {
                Mapping.this.resetFont(font, graphics2D);
            }
            if (color2 != color) {
                graphics2D.setColor(color);
            }
        }

        public String toString() {
            return String.valueOf(this.content == null ? "" : this.content) + (this.tail != null ? this.tail.toString() : "");
        }

        public int getExpectedHeight() {
            Graphics graphics = new BufferedImage(100, 100, 1).getGraphics();
            graphics.setFont(this.tag.getFont(Mapping.this.printScalingFactor));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.dispose();
            if (this.tail == null) {
                return fontMetrics.getHeight();
            }
            return Math.max(fontMetrics.getHeight(), this.tail.getExpectedHeight());
        }
    }

    private static class NameDicomTagEntry
    extends DicomTagEntry {
        private NameDicomTagEntry(int n, String string, String string2, WordgroupType wordgroupType, boolean bl, Font font, Color color, String string3, String string4, LevelOfDetail levelOfDetail, ISubstituteEvaluation iSubstituteEvaluation) {
            super(n, string, 0, string2, wordgroupType, bl, font, color, string3, string4, levelOfDetail, iSubstituteEvaluation);
        }

        @Override
        protected String formatResult(String string) {
            if (string != null) {
                return PersonNameUtilities.personNameToHRReverseShortMultiLanguage((PersonName)new PersonName(string, true));
            }
            return string;
        }
    }

    private static class OwnPrivateTagEntry
    extends AbstractTagEntry {
        private OwnPrivateTagEntry(int n, String string, String string2, WordgroupType wordgroupType, boolean bl, Font font, Color color, String string3, LevelOfDetail levelOfDetail) {
            super(n, string, 0, string2, wordgroupType, bl, font, color, null, string3, levelOfDetail, null);
        }

        protected String formatResult(String string) {
            return string;
        }

        @Override
        protected String getValue(IEvaluationContext iEvaluationContext, MappingLineEntry mappingLineEntry) {
            if (!this.levelOfDetailVisible()) {
                return null;
            }
            String string = null;
            if (iEvaluationContext.getData() != null) {
                try {
                    string = this.formatString(this.formatResult(iEvaluationContext.getData().resolveString(this.tag)));
                }
                catch (Exception exception) {
                    log.error("Mapping: Could not resolve tag '" + this.getTagAsString() + "'", (Throwable)exception);
                    string = null;
                }
            } else {
                return null;
            }
            if (string != null) {
                return string;
            }
            return "";
        }

        /* synthetic */ OwnPrivateTagEntry(int n, String string, String string2, WordgroupType wordgroupType, boolean bl, Font font, Color color, String string3, LevelOfDetail levelOfDetail, OwnPrivateTagEntry ownPrivateTagEntry, OwnPrivateTagEntry ownPrivateTagEntry2) {
            this(n, string, string2, wordgroupType, bl, font, color, string3, levelOfDetail);
        }
    }

    private static class PriorTagEntry
    extends OwnPrivateTagEntry {
        private PriorTagEntry(String string, String string2, WordgroupType wordgroupType, boolean bl, Font font, Color color, String string3, LevelOfDetail levelOfDetail) {
            super(PrivateTagDictionary.studyLoadOrderTag, string, string2, wordgroupType, bl, font, color, string3, levelOfDetail);
        }

        @Override
        protected String formatResult(String string) {
            if ("0".equals(string)) {
                return null;
            }
            return string;
        }

        @Override
        protected Color getColor(IEvaluationContext iEvaluationContext) {
            return Mapping.getMappingColor(iEvaluationContext);
        }

        @Override
        MappingLineEntry refreshContent(IEvaluationContext iEvaluationContext, MappingLineEntry mappingLineEntry, boolean bl) {
            return super.refreshContent(iEvaluationContext, mappingLineEntry, bl);
        }
    }

    private static class SeqDicomTagEntry
    extends AbstractMappingEntry {
        private int[] tagPath = null;

        private SeqDicomTagEntry(int[] nArray, String string, int n, String string2, WordgroupType wordgroupType, boolean bl, Font font, Color color, String string3, String string4, LevelOfDetail levelOfDetail, ISubstituteEvaluation iSubstituteEvaluation) {
            super(string, n, string2, wordgroupType, bl, font, color, string3, string4, levelOfDetail, iSubstituteEvaluation);
            this.tagPath = nArray;
            int n2 = nArray[0];
            if (TagUtils.isPrivateGroup((int)n2) && !PrivateTagDictionary.isPrivateTag((int)n2)) {
                InputStreamDicomDataReader.addRequiredPrivateTag((int)n2);
            }
        }

        @Override
        public boolean isValid() {
            return this.tagPath != null;
        }

        @Override
        public Integer getTag() {
            if (this.tagPath == null) {
                return null;
            }
            return this.tagPath[0];
        }

        @Override
        public String getTagAsString() {
            if (this.tagPath == null) {
                return "Unspecified";
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while (n < this.tagPath.length) {
                stringBuilder.append(TagUtils.toString((int)this.tagPath[n])).append('\\');
                ++n;
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }

        @Override
        protected String getValue(IEvaluationContext iEvaluationContext, MappingLineEntry mappingLineEntry) {
            String string = null;
            if (!this.isValid()) {
                return "";
            }
            try {
                int n;
                int n2 = n = this.properties == null ? 0 : this.properties.offset;
                string = n > -1 ? this.formatString(this.getSubstitution().getString(iEvaluationContext, this.tagPath, this.tagPath[this.tagPath.length - 1], n, this.type, this.properties == null ? null : this.properties.decimalFormat)) : this.formatStrings(this.getSubstitution().getStrings(iEvaluationContext, this.tagPath, this.tagPath[this.tagPath.length - 1], this.type, this.properties == null ? null : this.properties.decimalFormat));
            }
            catch (Exception exception) {
                log.error("Mapping: Could not resolve tag '" + this.getTagAsString() + "'", (Throwable)exception);
                string = null;
            }
            if (string != null) {
                return string;
            }
            return "";
        }
    }

    private static class StringTagEntry
    extends AbstractMappingEntry {
        private String tagPrefix = null;
        private String tagPostfix = null;

        private StringTagEntry(String string, String string2, String string3, WordgroupType wordgroupType, boolean bl, Font font, Color color, String string4, String string5, LevelOfDetail levelOfDetail, ISubstituteEvaluation iSubstituteEvaluation) {
            super(string2, -1, string3, wordgroupType, bl, font, color, string4, string5, levelOfDetail, iSubstituteEvaluation);
            string = string.toUpperCase();
            this.tagPrefix = string.substring(0, string.indexOf(46));
            this.tagPostfix = string.substring(string.indexOf(46) + 1, string.length());
        }

        @Override
        MappingLineEntry refreshContent(IEvaluationContext iEvaluationContext, MappingLineEntry mappingLineEntry, boolean bl) {
            if (mappingLineEntry.tag != null && mappingLineEntry.tag != this) {
                throw new IllegalArgumentException("Mapping entry might have been created from another TagEntry: " + mappingLineEntry);
            }
            String string = this.getValue(iEvaluationContext, mappingLineEntry);
            if (string != null) {
                mappingLineEntry.content = string;
            } else {
                mappingLineEntry.content = "";
            }
            return mappingLineEntry;
        }

        @Override
        public boolean isValid() {
            return this.tagPostfix != null && this.tagPostfix.length() > 0;
        }

        @Override
        public Integer getTag() {
            return null;
        }

        @Override
        public String getTagAsString() {
            if (!this.isValid()) {
                return "Unspecified";
            }
            return String.valueOf(this.tagPrefix) + "." + this.tagPostfix;
        }

        @Override
        protected String getValue(IEvaluationContext iEvaluationContext, MappingLineEntry mappingLineEntry) {
            if (!this.isValid()) {
                return "";
            }
            if (!this.levelOfDetailVisible()) {
                return null;
            }
            if (this.tagPrefix.equals("VISUAL")) {
                try {
                    return this.formatString(this.getSubstitution().getString(iEvaluationContext.getVisual(), this.tagPostfix, this.type, this.properties == null ? null : this.properties.decimalFormat));
                }
                catch (Exception exception) {
                    return "";
                }
            }
            if (this.tagPrefix.equals("CALC")) {
                try {
                    return this.formatString(this.getSubstitution().getString(new MappingEvaluable(iEvaluationContext.getData()), this.tagPostfix, this.type, this.properties == null ? null : this.properties.decimalFormat));
                }
                catch (Exception exception) {
                    return "";
                }
            }
            return "";
        }
    }
}

