/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.utils.GuiUtil;
import com.agfa.pacs.listtext.dicomobject.module.ps.TextObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.HorizontalJustification;
import com.agfa.pacs.listtext.dicomobject.type.YN;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.ArrowOverlay;
import com.tiani.jvision.overlay.ColorChooserHandle;
import com.tiani.jvision.overlay.GraphicsWrapper;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.ITextObjectContainer;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.OutlineFont;
import com.tiani.jvision.overlay.OutlinedTranslationHandle;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayConfig;
import com.tiani.jvision.overlay.OverlayFontConfig;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;

public class TextOverlay
extends PresentationObject
implements ITextObjectContainer,
ITransformableOverlay {
    private static final Color colText = OverlayConfig.mappingColor;
    private static final boolean IS_ON_COLOR_MONITOR = ComponentFactory.instance.isOnColorMonitor();
    private static final int COLOR_CHOOSER_INDEX = 2;
    private static final Image SMALL_GRAPHICS_FOR_FONT_METRICS = new BufferedImage(100, 100, 1);
    private static final String NEW_LINE = "\n";
    private static SortedMap<Integer, Integer> fontSizeMap = new TreeMap<Integer, Integer>();
    private static int MIN_FONT_HEIGHT;
    private double[] m;
    private double refOffsx;
    private double refOffsy;
    protected int xo;
    protected int yo;
    protected int w;
    protected int h;
    private JTextArea ta;
    private String[] nonEditable;
    private boolean taLock = false;
    private HorizontalJustification alignment = HorizontalJustification.Left;
    private boolean initWidth = false;
    private double ixs;
    private double iys;
    private double hscx;
    private double hscy;
    private boolean manuallyHidden = false;
    private boolean isScaled = false;
    private FontMetrics fontMetrics;
    private Font currentFont;
    private double[] tmp = null;
    private double[] initialSize;

    static {
        Graphics graphics = SMALL_GRAPHICS_FOR_FONT_METRICS.getGraphics();
        int n = 251;
        int n2 = 1;
        while (n2 < n) {
            Font font = OverlayFontConfig.displayFont.deriveFont((float)n2);
            graphics.setFont(font);
            fontSizeMap.put(graphics.getFontMetrics().getHeight(), n2);
            ++n2;
        }
        graphics.dispose();
        n2 = fontSizeMap.firstKey();
        int n3 = fontSizeMap.lastKey();
        int n4 = 1;
        int n5 = n2;
        while (n5 < n3) {
            if (fontSizeMap.containsKey(n5)) {
                n4 = (Integer)fontSizeMap.get(n5);
            } else {
                fontSizeMap.put(n5, n4);
            }
            ++n5;
        }
        graphics = SMALL_GRAPHICS_FOR_FONT_METRICS.getGraphics();
        Font font = OverlayFontConfig.displayFont.deriveFont(10.0f);
        graphics.setFont(font);
        MIN_FONT_HEIGHT = graphics.getFontMetrics().getHeight();
        graphics.dispose();
    }

    public TextOverlay() {
        super("Text");
        this.m = new double[2];
        this.m[1] = 0.0;
        this.m[0] = 0.0;
    }

    public TextOverlay(double d, double d2, double d3, double d4, String string, String string2, AnnotationUnits annotationUnits, boolean bl, HorizontalJustification horizontalJustification, PresentationObject presentationObject) {
        this();
        this.m[0] = d;
        this.m[1] = d2;
        this.setSpacing(annotationUnits);
        if (presentationObject != null) {
            this.width = presentationObject.width;
            this.height = presentationObject.height;
            this.setImageState(presentationObject.getImageState());
            double[] dArray = this.toImage(new double[]{d, d2});
            this.m[0] = dArray[0];
            this.m[1] = dArray[1];
        }
        if (horizontalJustification == null) {
            horizontalJustification = HorizontalJustification.Left;
        }
        this.alignment = horizontalJustification;
        switch (horizontalJustification) {
            case Left: {
                break;
            }
            case Center: {
                this.refOffsx = d3 / 2.0;
                this.refOffsy = d4 / 2.0;
                break;
            }
            case Right: {
                this.refOffsx = d3;
                this.refOffsy = d4;
            }
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null && string.indexOf(NEW_LINE) >= 0) {
            string2 = string.substring(string.indexOf(NEW_LINE) + 1, string.length());
            string = string.substring(0, string.indexOf(NEW_LINE)).trim();
        }
        this.nonEditable = this.splitList(string2);
        int n = this.getFontHeight();
        if (d3 == 0.0 || d4 == 0.0) {
            d4 = n * this.nonEditable.length + n * 2;
            d3 = this.maxLengthOf(string);
            if (d3 > 20.0) {
                d3 = 20.0;
            }
            int n2 = 0;
            while (n2 < this.nonEditable.length) {
                if ((double)this.nonEditable[n2].length() > d3) {
                    d3 = this.nonEditable[n2].length();
                }
                ++n2;
            }
            d3 *= (double)(n * 2 / 3);
        }
        if (annotationUnits == AnnotationUnits.Pixel && d3 < d4) {
            double d5 = d3;
            d3 = d4;
            d4 = d5;
        }
        this.initTextArea(string, bl);
        if (annotationUnits == AnnotationUnits.Display) {
            this.ixs = d3;
            this.iys = d4;
            this.initWidth = true;
        } else {
            this.ta.setSize(new Dimension((int)d3, (int)d4));
        }
        this.makeHandles();
    }

    public TextOverlay(double d, double d2, double d3, double d4, String string, AnnotationUnits annotationUnits, boolean bl, HorizontalJustification horizontalJustification) {
        this(d, d2, d3, d4, string, null, annotationUnits, bl, horizontalJustification, null);
        if (Math.abs(d4) > 0.001 && annotationUnits == AnnotationUnits.Pixel) {
            this.isScaled = true;
            this.tmp = new double[]{d3, d4};
        }
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        int n3 = 100;
        int n4 = 100;
        String string = "";
        String string2 = "";
        super.initPlacement(n, n2, annotationUnits, false, bl2);
        this.nonEditable = this.splitList(string2);
        this.initTextArea(string, true);
        this.ta.setSize(n3, n4);
        this.makeHandles();
    }

    @Override
    public boolean isROI() {
        return true;
    }

    private int maxLengthOf(String string) {
        int n;
        if (string == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        do {
            n = n3;
            n3 = string.indexOf(10, n2);
            if (n3 - n2 > n4) {
                n4 = n3 - n2;
            }
            n2 = n3 + 1;
        } while (n3 > 0);
        n4 = Math.max(n4, string.substring(n, string.length()).length());
        return n4;
    }

    protected String[] splitList(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = -1;
        while ((n = string.indexOf(10, n2 + 1)) >= 0) {
            arrayList.add(string.substring(n2 + 1, n));
            n2 = n;
        }
        arrayList.add(string.substring(n2 + 1, string.length()));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setNonEditable(String string) {
        this.nonEditable = this.splitList(string);
    }

    boolean hasNonEditableText() {
        return this.nonEditable == null ? false : this.nonEditable.length > 0;
    }

    protected boolean isManuallyHidden() {
        return this.manuallyHidden;
    }

    public void setManuallyHidden(boolean bl) {
        this.manuallyHidden = bl;
    }

    private void updateHeight() {
        if (this.tmp != null) {
            double[] dArray = this.toScreen(new double[]{0.0, 0.0});
            double[] dArray2 = this.toScreen(this.tmp);
            this.h = (int)(dArray2[1] - dArray[1] + 0.5);
            this.updateFont();
            if (!this.isEditable()) {
                this.initialSize = this.tmp;
            }
            this.tmp = null;
        }
    }

    protected void initTextArea(String string, boolean bl) {
        this.ta = new JTextArea();
        this.ta.setText(string);
        this.ta.setBorder(null);
        this.ta.setFont(this.getCurrentFont());
        this.ta.setAlignmentX(0.5f);
        this.ta.setLineWrap(true);
        this.ta.setWrapStyleWord(true);
        this.ta.setOpaque(false);
        this.ta.setForeground(this.objCol);
        this.ta.setCaretColor(OverlayConfig.mappingColor);
        if (bl) {
            this.ta.setSelectionStart(0);
            this.ta.setSelectionEnd(string.length() - 1);
        }
        this.ta.setBackground(new Color(0, 0, 0, 0));
        this.ta.addCaretListener(new CaretListener());
    }

    protected void makeHandles() {
        this.handles = new PresentationHandle[IS_ON_COLOR_MONITOR ? 3 : 2];
        this.translationHandleIndex = 0;
        this.handles[0] = new OutlinedTranslationHandle(this.xo, this.yo);
        this.handles[1] = new PresentationHandle((int)(this.m[0] + (double)this.w), (int)this.m[1] + this.h);
        if (IS_ON_COLOR_MONITOR) {
            this.handles[2] = new ColorChooserHandle(this, (int)this.m[0], (int)this.m[1]);
        }
    }

    @Override
    protected void toScreen() {
        int n;
        Object object;
        if (this.initWidth && this.width > 1 && this.height > 1 && this.ixs < 1.0 && this.iys < 1.0) {
            object = new Dimension((int)(this.ixs * (double)this.width), (int)(this.iys * (double)this.height));
            this.ta.setSize((Dimension)object);
        }
        this.updateHeight();
        object = new double[]{this.m[0], this.m[1]};
        object = this.toScreen((double[])object);
        double[] dArray = new double[]{this.m[0], this.m[1]};
        dArray = this.toScreen(dArray);
        double[] dArray2 = new double[]{0.0, 0.0};
        dArray2 = this.toScreen(dArray2);
        double[] dArray3 = new double[]{this.refOffsx, this.refOffsy};
        dArray3 = this.toScreen(dArray3);
        dArray[0] = dArray[0] + Math.abs(dArray3[0] - dArray2[0]);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.nonEditable.length) {
            n2 = this.getFontMetrics().stringWidth(this.nonEditable[n4]);
            if (n2 > n3) {
                n3 = n2;
            }
            ++n4;
        }
        this.w = n3;
        String string = this.ta.getText();
        int n5 = -1;
        byte[] byArray = string.getBytes();
        do {
            if ((n5 = string.indexOf(10, n = n5 + 1)) < 0) {
                n5 = string.length();
            }
            this.w = Math.max(this.w, this.getFontMetrics().bytesWidth(byArray, n, n5 - n));
        } while (n5 < string.length());
        if (this.w < 0) {
            this.w = 0;
        }
        n = this.ta.getPreferredSize().height + this.nonEditable.length * this.getFontMetrics().getHeight();
        if (this.h == 0) {
            this.h = this.getCurrentFontMetrics().getHeight() * this.getLineCount();
            this.updateFont();
        }
        Font font = this.currentFont;
        this.ta.setBounds(this.xo, this.yo, this.w, n);
        switch (this.alignment) {
            case Left: {
                this.xo = (int)dArray[0];
                this.yo = (int)dArray[1];
                break;
            }
            case Right: {
                this.xo = (int)dArray[0] - this.w;
                this.yo = (int)dArray[1];
                break;
            }
            case Center: {
                this.xo = (int)dArray[0] - this.w / 2;
                this.yo = (int)dArray[1];
            }
        }
        this.ta.setFont(font);
        this.ta.setText(this.ta.getText());
        this.ta.setBorder(null);
        if (!this.taLock) {
            this.ta.setBounds(this.xo, this.yo, this.w, n);
        }
        this.handles[0].setPosition(this.xo + this.w / 2, this.yo + this.h / 2);
        this.hscx = (double)(this.xo + this.w / 2) - object[0];
        this.hscy = (double)(this.yo + this.h / 2) - object[1];
        this.bounds.x = this.xo - PresentationHandle.HANDLE_SIZE;
        this.bounds.y = this.yo - PresentationHandle.HANDLE_SIZE;
        this.bounds.width = this.w + 2 * PresentationHandle.HANDLE_SIZE;
        this.bounds.height = this.h + 2 * PresentationHandle.HANDLE_SIZE;
        this.handles[1].setPosition((int)(object[0] + (double)this.w), (int)(object[1] + (double)this.h));
        if (IS_ON_COLOR_MONITOR) {
            this.handles[2].setPosition((int)object[0] + this.w, (int)object[1]);
        }
    }

    private FontMetrics getFontMetrics() {
        return this.fontMetrics != null ? this.fontMetrics : this.getCurrentFontMetrics();
    }

    private void updateFont() {
        if (this.isScaled) {
            int n = (int)Math.rint((double)this.h / (double)this.getLineCount());
            Integer n2 = (Integer)fontSizeMap.get(n);
            if (n2 == null) {
                n2 = n < MIN_FONT_HEIGHT ? (Integer)fontSizeMap.get(fontSizeMap.firstKey()) : (Integer)fontSizeMap.get(fontSizeMap.lastKey());
            }
            int n3 = (int)Math.rint(this.height / 12);
            if (n2 > n3) {
                n2 = n3;
            } else if (n2 < 10) {
                n2 = 10;
            }
            FontMetrics fontMetrics = this.getFontMetrics();
            Font font = fontMetrics.getFont().deriveFont((float)n2.intValue());
            if (this.fontMetrics == null || this.fontMetrics.getFont().getSize() != n2.intValue()) {
                Graphics graphics = SMALL_GRAPHICS_FOR_FONT_METRICS.getGraphics();
                graphics.setFont(font);
                this.fontMetrics = graphics.getFontMetrics();
                graphics.dispose();
            }
            this.currentFont = font;
        } else {
            this.currentFont = this.getCurrentFont();
            this.h = this.getCurrentFontMetrics().getHeight() * this.getLineCount();
        }
    }

    private int getLineCount() {
        return Math.max(this.splitList(this.ta.getText()).length, 1) + (this.nonEditable == null ? 0 : this.nonEditable.length);
    }

    @Override
    public void setSize(int n, int n2, ImageState imageState) {
        boolean bl;
        boolean bl2 = bl = this.height != 0 && n2 != 0 && this.height != n2;
        if (this.isScaled && bl) {
            this.h = (int)Math.rint((double)(this.h * n2) / (double)this.height);
        }
        super.setSize(n, n2, imageState);
        if (bl) {
            this.updateFont();
        }
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        Font font = this.currentFont;
        bufferedImageHolder.graphics.setFont(font);
        this.fontMetrics = bufferedImageHolder.graphics.getFontMetrics(font);
        this.toScreen();
        OutlineFont outlineFont = OutlineFont.getInstance(font, bufferedImageHolder.graphics.getFontMetrics(font));
        if (this.isSelected() && this.getView().getMouseHandler().isEditingTextROI() && GuiUtil.isOnColorMonitor()) {
            if (this.w == 0) {
                this.w = 100;
            }
            bufferedImageHolder.graphics.setColor(Color.lightGray);
            if (bufferedImageHolder.graphics.getComposite() instanceof AlphaComposite) {
                bufferedImageHolder.graphics.setComposite(AlphaComposite.getInstance(3, 0.85f));
            }
            bufferedImageHolder.graphics.fillRect(this.xo, this.yo, this.w + this.w / 10, this.h);
            bufferedImageHolder.graphics.setPaintMode();
        }
        if (!this.taLock) {
            Graphics graphics;
            if (this.isUseOutlineFont()) {
                graphics = new GraphicsWrapper(bufferedImageHolder, this.xo, this.yo, this.w, this.h, 0);
                this.setSelectedTextColor(bufferedImageHolder, graphics);
            } else {
                graphics = bufferedImageHolder.graphics.create(this.xo, this.yo, this.w, this.h - this.nonEditable.length * bufferedImageHolder.graphics.getFontMetrics().getHeight());
                this.setSelectedTextColor(bufferedImageHolder, graphics);
                graphics.dispose();
            }
        }
        if (this.nonEditable.length > 0) {
            bufferedImageHolder.graphics.setColor(this.objCol);
            int n = bufferedImageHolder.graphics.getFontMetrics().getHeight();
            int n2 = this.yo + this.ta.getPreferredSize().height;
            int n3 = 0;
            while (n3 < this.nonEditable.length) {
                n2 += n;
                if (this.isUseOutlineFont()) {
                    outlineFont.drawBytes(this.nonEditable[n3].toCharArray(), this.objCol, bufferedImageHolder, this.xo, n2);
                } else {
                    bufferedImageHolder.graphics.drawString(this.nonEditable[n3], this.xo, n2);
                }
                ++n3;
            }
            bufferedImageHolder.graphics.setColor(colText);
        }
        bufferedImageHolder.graphics.setFont(this.getCurrentFontMetrics().getFont());
    }

    private void setSelectedTextColor(BufferedImageHolder bufferedImageHolder, Graphics graphics) {
        if (this.isColorUserDefined()) {
            bufferedImageHolder.graphics.setColor(this.objCol);
            this.ta.setForeground(this.objCol);
        } else {
            bufferedImageHolder.graphics.setColor(colText);
        }
        this.ta.paint(graphics);
    }

    @Override
    protected void handleDragged(int n, double[] dArray) {
        super.handleDragged(n, dArray);
        if (super.isHandleOutsideView(dArray)) {
            return;
        }
        this.initWidth = false;
        this.handleInteraction(n, dArray);
        this.setSaved(false);
    }

    private double[] checkInsideView(double[] dArray) {
        double[] dArray2 = dArray;
        if (dArray2[0] < 0.0) {
            dArray2[0] = 0.0;
        } else if (dArray2[0] + (double)this.bounds.width > (double)this.width) {
            dArray2[0] = this.width - this.bounds.width;
        }
        if (dArray2[1] < 0.0) {
            dArray2[1] = 0.0;
        } else if (dArray2[1] + (double)this.bounds.height > (double)this.height) {
            dArray2[1] = this.height - this.bounds.height;
        }
        return dArray2;
    }

    private double[] checkScalingHandleInsideView(double[] dArray) {
        double[] dArray2 = dArray;
        if (dArray2[0] < 0.0) {
            dArray2[0] = 0.0;
        } else if (dArray2[0] > (double)this.width) {
            dArray2[0] = this.width;
        }
        if (dArray2[1] < 0.0) {
            dArray2[1] = 0.0;
        } else if (dArray2[1] > (double)this.height) {
            dArray2[1] = this.height;
        }
        return dArray2;
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        double[] dArray2 = new double[]{0.0, 0.0};
        switch (n) {
            case 0: {
                dArray2 = this.toScreen(dArray);
                dArray2[0] = dArray2[0] - this.hscx;
                dArray2[1] = dArray2[1] - this.hscy;
                dArray2 = this.checkInsideView(dArray2);
                this.m = this.toImage(dArray2);
                this.toScreen();
                break;
            }
            case 1: {
                if (!this.isScaled) {
                    this.isScaled = true;
                }
                dArray2 = this.toScreen(dArray);
                dArray2 = this.checkScalingHandleInsideView(dArray2);
                int n2 = this.bounds.x + this.bounds.width;
                int n3 = this.bounds.y + this.bounds.height;
                double d = dArray2[0] - (double)n2;
                double d2 = dArray2[1] - (double)n3;
                if (this.h + (int)d2 <= 0) break;
                int n4 = this.h + (int)d2;
                int n5 = (int)Math.rint((double)n4 / (double)this.getLineCount());
                Integer n6 = (Integer)fontSizeMap.get(n5);
                if (n6 == null || n6 < 10 || n6 > (int)Math.rint(this.height / 12)) {
                    return;
                }
                this.w += (int)d;
                this.h = n4;
                this.updateFont();
                this.handles[1].setPosition((int)dArray2[0], (int)dArray2[1]);
                this.toScreen();
            }
        }
    }

    @Override
    public void mouseReleased() {
        if (this.activeHandleIndex == 2) {
            JColorChooser jColorChooser = new JColorChooser();
            JDialog jDialog = JColorChooser.createDialog(this.getView().getVisView(), Messages.getString("TextOverlay.ChooseTextColor"), true, jColorChooser, new ColorChooserOkAction(jColorChooser), new ColorChooserCancelAction(jColorChooser));
            ComponentFactory.instance.centerOnOwner(jDialog);
            jDialog.setVisible(true);
            this.activeHandleIndex = -1;
        }
        super.mouseReleased();
    }

    public JTextArea getTextArea() {
        return this.ta;
    }

    public JTextArea startEdit() {
        this.lockTextArea();
        Rectangle rectangle = this.ta.getBounds();
        ++rectangle.x;
        ++rectangle.y;
        if (rectangle.width == 0) {
            rectangle.width = 50;
        }
        if (this.ta.getText().length() == 0) {
            this.ta.setText(" ");
        }
        this.ta.setBounds(rectangle);
        this.ta.setVisible(true);
        this.ta.requestFocusInWindow();
        this.shapeChanged = true;
        this.select(true);
        this.setSaved(false);
        return this.ta;
    }

    public JTextArea stopEditing() {
        this.ta.transferFocus();
        this.unlockTextArea();
        Rectangle rectangle = this.ta.getBounds();
        --rectangle.x;
        --rectangle.y;
        this.ta.setBounds(rectangle);
        this.ta.setText(this.ta.getText().trim());
        this.shapeChanged = true;
        this.select(false);
        return this.ta;
    }

    public void lockTextArea() {
        this.taLock = true;
    }

    @Override
    public boolean matchDiscardCriteria() {
        return !this.visible || this.height < this.getMinSize() && this.width < this.getMinSize();
    }

    public void unlockTextArea() {
        this.taLock = false;
        this.toScreen();
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        this.handleDragged(0, dArray);
        return -1;
    }

    @Override
    public TextObject storeROI() {
        this.updateHeight();
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append(this.ta.getText());
        int n = 0;
        while (n < this.nonEditable.length) {
            stringBuilder.append(NEW_LINE);
            stringBuilder.append(this.nonEditable[n]);
            ++n;
        }
        TextObject textObject = new TextObject();
        if (this.isEditable()) {
            textObject.setTianiROIID(Integer.toString(this.id));
        }
        textObject.setAnchorPointAnnotationUnits(this.spacingType);
        if (this.isScaled) {
            double[] dArray;
            Object[] objectArray;
            float[] fArray = new float[]{(float)this.m[0], (float)this.m[1]};
            textObject.setBoundingBoxTopLeftHandCorner(fArray);
            if (this.initialSize == null || this.isEditable()) {
                objectArray = this.toImage(0, 0);
                dArray = this.toImage(this.w, this.h);
                dArray[0] = dArray[0] - objectArray[0];
                dArray[1] = dArray[1] - objectArray[1];
            } else {
                dArray = this.initialSize;
            }
            objectArray = new float[]{fArray[0] + (float)dArray[0], fArray[1] + (float)dArray[1]};
            textObject.setBoundingBoxBottomRightHandCorner((float[])objectArray);
            textObject.setBoundingBoxAnnotationUnits(AnnotationUnits.Pixel);
            textObject.setScaleTextToBoundingBox(YN.Yes);
        }
        textObject.setBoundingBoxTextHorizontalJustification(this.alignment);
        textObject.setAnchorPointVisiblity(YN.No);
        textObject.setAnchorPoint(new float[]{(float)(this.m[0] + this.refOffsx), (float)this.m[1]});
        textObject.setUnformattedTextValue(stringBuilder.toString());
        return textObject;
    }

    @Override
    public PresentationObject cloneAll() {
        PresentationObject presentationObject = null;
        try {
            Overlay[] overlayArray;
            presentationObject = (PresentationObject)this.clone();
            if (this.getCompanions() == null || !(this.getCompanions()[0] instanceof ArrowOverlay)) {
                super.cloneReferences(presentationObject);
            } else {
                overlayArray = this.ownedCompanions;
                this.ownedCompanions = new Overlay[0];
                super.cloneReferences(presentationObject);
                this.ownedCompanions = overlayArray;
            }
            overlayArray = (Overlay[])presentationObject;
            overlayArray.fontMetrics = null;
            overlayArray.setClonedParameters(ReferencedObjectsCloning.clone(this.m), ReferencedObjectsCloning.clone(this.ta), ReferencedObjectsCloning.clone(this.nonEditable));
        }
        catch (Exception exception) {
            log.error("clone error", (Throwable)exception);
        }
        return presentationObject;
    }

    public void setClonedParameters(double[] dArray, JTextArea jTextArea, String[] stringArray) {
        this.m = dArray;
        this.ta = jTextArea;
        this.nonEditable = stringArray;
        jTextArea.addCaretListener(new CaretListener());
    }

    @Override
    public void updateOverlayPoints(ITransformableOverlay iTransformableOverlay, IOverlayPointModifier iOverlayPointModifier) {
        TextOverlay textOverlay = (TextOverlay)iTransformableOverlay;
        this.m = iOverlayPointModifier.convert(textOverlay.m);
    }

    public void setAnchor(double d, double d2) {
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = this.toScreen(dArray);
        dArray2 = this.checkInsideView(dArray2);
        dArray = this.toImage(dArray2);
        this.m[0] = dArray[0];
        this.m[1] = dArray[1];
        this.toScreen();
    }

    private int getMaxCharWidth() {
        if (this.ta.getFont() != null && this.ta.getGraphics() != null) {
            return (int)(this.ta.getFontMetrics(this.ta.getFont()).getMaxCharBounds(this.ta.getGraphics()).getWidth() + 0.5);
        }
        return GUI.getScaledDiagnosticInt((int)15);
    }

    @Override
    public boolean retainEditModeAfterCompletion() {
        return true;
    }

    class CaretListener
    implements javax.swing.event.CaretListener {
        CaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            int n = TextOverlay.this.getMaxCharWidth();
            if (TextOverlay.this.taLock && (((TextOverlay)TextOverlay.this).ta.getPreferredSize().height != ((TextOverlay)TextOverlay.this).ta.getSize().height || ((TextOverlay)TextOverlay.this).ta.getPreferredSize().width != ((TextOverlay)TextOverlay.this).ta.getSize().width - n && ((TextOverlay)TextOverlay.this).ta.getPreferredSize().width != 0)) {
                switch (TextOverlay.this.alignment) {
                    case Left: {
                        Dimension dimension = TextOverlay.this.ta.getPreferredSize();
                        dimension.width += n;
                        TextOverlay.this.ta.setSize(dimension);
                        break;
                    }
                    case Right: {
                        Rectangle rectangle = TextOverlay.this.ta.getBounds();
                        Dimension dimension = TextOverlay.this.ta.getPreferredSize();
                        rectangle.x = rectangle.x + rectangle.width - dimension.width;
                        rectangle.width = dimension.width + n;
                        rectangle.height = dimension.height;
                        TextOverlay.this.ta.setBounds(rectangle);
                        break;
                    }
                    case Center: {
                        Rectangle rectangle = TextOverlay.this.ta.getBounds();
                        Dimension dimension = TextOverlay.this.ta.getPreferredSize();
                        rectangle.x += (rectangle.width - dimension.width) / 2;
                        rectangle.width = dimension.width + n;
                        rectangle.height = dimension.height;
                        TextOverlay.this.ta.setBounds(rectangle);
                    }
                }
            }
        }
    }

    private class ColorChooserCancelAction
    implements ActionListener {
        private JColorChooser colorChooser;

        public ColorChooserCancelAction(JColorChooser jColorChooser) {
            this.colorChooser = jColorChooser;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.colorChooser.setColor(TextOverlay.this.objCol);
        }
    }

    private class ColorChooserOkAction
    implements ActionListener {
        private JColorChooser colorChooser;

        public ColorChooserOkAction(JColorChooser jColorChooser) {
            this.colorChooser = jColorChooser;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.colorChooser.getColor() != colText) {
                Color color = this.colorChooser.getColor();
                TextOverlay.this.setColor(color);
                SyncablePresentationObject syncablePresentationObject = TextOverlay.this.getCompanionOwner();
                if (syncablePresentationObject != null) {
                    syncablePresentationObject.setColor(color);
                    Overlay[] overlayArray = syncablePresentationObject.getCompanions();
                    if (overlayArray != null) {
                        Overlay[] overlayArray2 = overlayArray;
                        int n = overlayArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Overlay overlay = overlayArray2[n2];
                            if (overlay instanceof PresentationObject) {
                                ((PresentationObject)overlay).setColor(color);
                            }
                            ++n2;
                        }
                    }
                }
                TextOverlay.this.owner.invalidate();
                TextOverlay.this.owner.repaint();
            }
        }
    }
}

