/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.config.Config;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.StatisticsPresentationObject;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisDisplay2;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum TextAnnotationLevel {
    NONE(false, new String[0]),
    USER_DEFINED(true, Config.impaxee.jvision.OVERLAY.TextAnnotation.userDefinedConfig.get().split(";")),
    FULL(true, new String[0]);

    private final boolean isTextAnnotationVisible;
    private final Set<String> filter;

    private TextAnnotationLevel(boolean bl, String ... stringArray) {
        this.isTextAnnotationVisible = bl;
        this.filter = TextAnnotationLevel.createFilter(stringArray);
    }

    private static Set<String> createFilter(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        Collections.addAll(hashSet, stringArray);
        return hashSet;
    }

    public static TextAnnotationLevel readDefaultFromConfig() {
        if (!Config.impaxee.jvision.OVERLAY.TextAnnotation.showAutomaticallyForClosedROIs.get()) {
            return NONE;
        }
        if (Config.impaxee.jvision.OVERLAY.TextAnnotation.userDefined.get()) {
            return USER_DEFINED;
        }
        return FULL;
    }

    public boolean isTextAnnotationVisible() {
        return this.isTextAnnotationVisible;
    }

    public Set<String> getOverlayInformationFilter() {
        return this.filter;
    }

    public void activate() {
        PresentationObject.setTextAnnotationLevel(this);
        if (this.isTextAnnotationVisible) {
            TextAnnotationLevel.showTextAnnotations();
        } else {
            TextAnnotationLevel.hideTextAnnotations();
        }
    }

    private static void hideTextAnnotations() {
        for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
            for (Vis2 vis2 : visDisplay2.getVisViews()) {
                View view = vis2.getView();
                if (view == null) continue;
                boolean bl = false;
                for (Overlay overlay : view.getPresentationObjects()) {
                    StatisticsPresentationObject statisticsPresentationObject;
                    TextOverlay textOverlay;
                    if (!(overlay instanceof StatisticsPresentationObject) || (textOverlay = (statisticsPresentationObject = (StatisticsPresentationObject)overlay).getAnnotation()) == null || !textOverlay.isVisible()) continue;
                    textOverlay.setVisible(false);
                    statisticsPresentationObject.companionVisibilityChanged(textOverlay, true);
                    bl = true;
                }
                if (!bl) continue;
                view.invalidate();
                view.repaint();
            }
        }
    }

    private static void showTextAnnotations() {
        for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
            List<Vis2> list = visDisplay2.getVisViews();
            for (Vis2 vis2 : list) {
                View view = vis2.getView();
                if (view == null) continue;
                List<Overlay> list2 = view.getPresentationObjects();
                for (Overlay overlay : list2) {
                    StatisticsPresentationObject statisticsPresentationObject;
                    TextOverlay textOverlay;
                    if (!(overlay instanceof StatisticsPresentationObject) || (textOverlay = (statisticsPresentationObject = (StatisticsPresentationObject)overlay).getAnnotation()) == null || textOverlay.isVisible() || textOverlay.isManuallyHidden()) continue;
                    textOverlay.setVisible(true);
                    statisticsPresentationObject.companionVisibilityChanged(textOverlay, true);
                }
                view.resetOverlayCachedValues();
                view.invalidate();
                view.repaint();
            }
        }
    }
}

