/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.SelectablePAction;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.TextAnnotationLevel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class TextAnnotationActionProvider
implements PActionProvider {
    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>(3);
        arrayList.add(new TextAnnotationAction(TextAnnotationLevel.NONE));
        arrayList.add(new TextAnnotationAction(TextAnnotationLevel.USER_DEFINED));
        arrayList.add(new TextAnnotationAction(TextAnnotationLevel.FULL));
        return arrayList;
    }

    public static String getActionID(TextAnnotationLevel textAnnotationLevel) {
        return "TEXT_ANNOTATION_" + textAnnotationLevel.name();
    }

    private static class TextAnnotationAction
    extends SelectablePAction {
        private final TextAnnotationLevel level;

        TextAnnotationAction(TextAnnotationLevel textAnnotationLevel) {
            this.level = textAnnotationLevel;
        }

        @Override
        public String getID() {
            return TextAnnotationActionProvider.getActionID(this.level);
        }

        @Override
        public String getGroupName() {
            return MARKUPS_GROUP;
        }

        @Override
        public String getName() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Messages.getString("MarkupLevelAction.TextAnnotation"));
            stringBuilder.append(" - ");
            stringBuilder.append(this.getCaption());
            return stringBuilder.toString();
        }

        @Override
        public String getCaption() {
            return Messages.getString("TextAnnotationLevel." + this.level.name() + ".Caption");
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("TextAnnotationLevel." + this.level.name() + ".ToolTip");
        }

        @Override
        public boolean perform(Component component) {
            this.level.activate();
            return true;
        }

        @Override
        public boolean isSelected() {
            return PresentationObject.getTextAnnotationLevel() == this.level;
        }
    }
}

