/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.tiani.base.data.IImageRegionProperties;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.HistogramOverlay;
import com.tiani.jvision.overlay.IHandlePositionModifier;
import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.OverlayInformation;
import com.tiani.jvision.overlay.OverlayInformationID;
import com.tiani.jvision.overlay.OverlaySynchronizationMode;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.SyncablePresentationObjectList;
import com.tiani.jvision.overlay.TextOverlay;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class SyncablePresentationObject
extends PresentationObject
implements ITransformableOverlay {
    private SyncablePresentationObjectList syncList;
    private List<IOverlayInformation> overlayInformationList;
    private boolean isSynchronizationSuspended;

    public SyncablePresentationObject(String string) {
        super(string);
    }

    public List<SyncablePresentationObject> getRelatives() {
        if (this.syncList == null) {
            return Collections.emptyList();
        }
        return this.syncList.getAllElements();
    }

    private void setNonEditableAnnotation(String string) {
        TextOverlay textOverlay = this.getAnnotation();
        if (textOverlay != null) {
            textOverlay.setNonEditable(string);
        }
    }

    protected void setNonEditableAnnotation(List<IOverlayInformation> list, IImageRegionProperties iImageRegionProperties) {
        int n;
        this.overlayInformationList = list;
        if (iImageRegionProperties != null) {
            this.addStatisticsValues(iImageRegionProperties);
        }
        this.filterOverlayInformation();
        StringBuilder stringBuilder = new StringBuilder();
        for (IOverlayInformation iOverlayInformation : list) {
            stringBuilder.append(iOverlayInformation.getInformationText(iOverlayInformation));
        }
        if (stringBuilder.length() > 0 && stringBuilder.charAt(n = stringBuilder.length() - 1) == '\n') {
            stringBuilder.deleteCharAt(n);
        }
        this.setNonEditableAnnotation(stringBuilder.toString());
    }

    private void addStatisticsValues(IImageRegionProperties iImageRegionProperties) {
        if (this.overlayInformationList == null) {
            this.overlayInformationList = new ArrayList<IOverlayInformation>(5);
        }
        OverlayInformation overlayInformation = new OverlayInformation(OverlayInformationID.AVERAGE);
        OverlayInformation overlayInformation2 = new OverlayInformation(OverlayInformationID.STANDARD_DEVIATION);
        OverlayInformation overlayInformation3 = new OverlayInformation(OverlayInformationID.MAXIMUM);
        OverlayInformation overlayInformation4 = new OverlayInformation(OverlayInformationID.MINIMUM);
        String string = iImageRegionProperties.getUnit();
        if (iImageRegionProperties.isValid()) {
            overlayInformation.setPrimaryInformation(iImageRegionProperties.getMean(), string);
            overlayInformation2.setPrimaryInformation(iImageRegionProperties.getStdDev(), string);
        }
        if (iImageRegionProperties.getMean() <= iImageRegionProperties.getMax()) {
            overlayInformation4.setPrimaryInformation(iImageRegionProperties.getMin(), string);
            overlayInformation3.setPrimaryInformation(iImageRegionProperties.getMax(), string);
        }
        this.overlayInformationList.add(overlayInformation);
        this.overlayInformationList.add(overlayInformation2);
        this.overlayInformationList.add(overlayInformation3);
        this.overlayInformationList.add(overlayInformation4);
    }

    @Override
    public List<IOverlayInformation> getOverlayInformation() {
        return this.overlayInformationList;
    }

    private void filterOverlayInformation() {
        if (!this.state.contains((Object)PresentationObject.OverlayState.UseNonEditableText)) {
            this.overlayInformationList.clear();
            return;
        }
        Set<String> set = annotationLevel.getOverlayInformationFilter();
        if (set != null) {
            Iterator<IOverlayInformation> iterator = this.overlayInformationList.iterator();
            while (iterator.hasNext()) {
                if (set.contains(iterator.next().getID().name())) continue;
                iterator.remove();
            }
        }
    }

    public void removeFromSynclist() {
        if (this.syncList == null) {
            return;
        }
        this.syncList.remove(this);
        this.syncList = null;
    }

    public boolean isSynchronizationEnabled() {
        return this.syncList != null && this.syncList.getTotalSize() > 0;
    }

    private boolean isSynchronizationActive() {
        return this.syncList != null && this.syncList.isSynchronizationActive(this);
    }

    public void activateSynchronization() {
        if (this.isSynchronizationEnabled()) {
            this.isSynchronizationSuspended = false;
            this.syncList.activateSynchronization(this);
            this.resetCachedValues();
        }
    }

    public void suspendSynchronization() {
        if (this.isSynchronizationActive()) {
            this.isSynchronizationSuspended = true;
        }
    }

    private void syncWith(SyncablePresentationObject syncablePresentationObject, OverlaySynchronizationMode overlaySynchronizationMode) throws IllegalArgumentException {
        if (this.syncList == null) {
            this.syncList = new SyncablePresentationObjectList(overlaySynchronizationMode);
        } else {
            this.syncList.setMode(overlaySynchronizationMode);
        }
        if (!this.syncList.contains(this)) {
            this.syncList.add(this);
        }
        if (!this.syncList.contains(syncablePresentationObject)) {
            this.syncList.add(syncablePresentationObject);
        }
        syncablePresentationObject.setSyncList(this.syncList);
    }

    private void setSyncList(SyncablePresentationObjectList syncablePresentationObjectList) {
        this.syncList = syncablePresentationObjectList;
    }

    private void notifyCompanionHandleDragged(String string, int n, double[] dArray, boolean bl) {
        if (this.ownedCompanions != null) {
            int n2 = 0;
            while (n2 < this.ownedCompanions.length) {
                PresentationObject presentationObject;
                if (this.ownedCompanions[n2] instanceof PresentationObject && string.equals((presentationObject = (PresentationObject)this.ownedCompanions[n2]).getName())) {
                    presentationObject.handleInteraction(n, dArray);
                    if (presentationObject.isVisible() && bl) {
                        this.getView().invalidate();
                        this.getView().repaint();
                    }
                }
                ++n2;
            }
        }
    }

    public void companionVisibilityChanged(PresentationObject presentationObject, boolean bl) {
        if (!this.isSynchronizationActive()) {
            return;
        }
        for (SyncablePresentationObject syncablePresentationObject : this.syncList) {
            PresentationObject presentationObject2;
            if (syncablePresentationObject == this) continue;
            if (presentationObject.getName().equals("Text")) {
                presentationObject2 = syncablePresentationObject.getAnnotation();
                if (presentationObject2 == null && bl) {
                    presentationObject2 = syncablePresentationObject.createAnnotation();
                }
                if (presentationObject2 != null) {
                    presentationObject2.setVisible(bl);
                }
            } else if (presentationObject.getName().equals("Histogram")) {
                presentationObject2 = syncablePresentationObject.getHistogramOverlay();
                if (presentationObject2 == null && bl) {
                    presentationObject2 = syncablePresentationObject.createHistogramOverlay();
                }
                if (presentationObject2 != null) {
                    ((HistogramOverlay)presentationObject2).setVisible(bl);
                }
            } else if (presentationObject.getName().equals("Data Profile")) {
                presentationObject2 = syncablePresentationObject.getDataProfilePlot();
                if (presentationObject2 == null && bl) {
                    presentationObject2 = syncablePresentationObject.createDataProfile();
                }
                if (presentationObject2 != null) {
                    presentationObject2.setVisible(bl);
                }
            }
            syncablePresentationObject.shapeChanged = true;
            syncablePresentationObject.getView().invalidate();
            syncablePresentationObject.getView().repaint();
        }
    }

    protected void companionHandleDragged(String string, int n, double[] dArray, boolean bl) {
        IHandlePositionModifier iHandlePositionModifier;
        log.debug("companion " + string + "'s handle " + n + " has been dragged");
        if (this.isSynchronizationActive() && (iHandlePositionModifier = this.syncList.getMode().getHandlePositionModifier(this, dArray)) != null) {
            for (SyncablePresentationObject syncablePresentationObject : this.syncList) {
                if (syncablePresentationObject == this) continue;
                syncablePresentationObject.notifyCompanionHandleDragged(string, n, iHandlePositionModifier.convertTo(syncablePresentationObject.getView()), bl);
            }
        }
    }

    @Override
    protected void handleDragged(int n, double[] dArray) {
        IHandlePositionModifier iHandlePositionModifier;
        if (this.isHandleOutsideView(dArray)) {
            return;
        }
        if (this.isSynchronizationEnabled() && this.isSynchronizationSuspended) {
            this.syncList.deactivateSynchronization(this);
        }
        if (this.isSynchronizationActive() && (iHandlePositionModifier = this.syncList.getMode().getHandlePositionModifier(this, dArray)) != null) {
            for (SyncablePresentationObject syncablePresentationObject : this.syncList) {
                if (syncablePresentationObject == this) continue;
                syncablePresentationObject.handleInteraction(n, iHandlePositionModifier.convertTo(syncablePresentationObject.getView()));
                if (!syncablePresentationObject.isVisible()) continue;
                syncablePresentationObject.shapeChanged = true;
                syncablePresentationObject.toScreen();
                syncablePresentationObject.getView().invalidate();
                if (!syncablePresentationObject.getView().isInView()) continue;
                syncablePresentationObject.getView().repaint();
            }
        }
        this.handleInteraction(n, dArray);
    }

    @Override
    public void mouseReleased() {
        super.mouseReleased();
        if (this.isSynchronizationActive()) {
            for (SyncablePresentationObject syncablePresentationObject : this.syncList) {
                if (syncablePresentationObject == this) continue;
                syncablePresentationObject.shapeChanged = true;
                syncablePresentationObject.toScreen();
                syncablePresentationObject.getView().invalidate();
                syncablePresentationObject.getView().repaint();
            }
        }
    }

    @Override
    public void presentationObjectRemoved(View view) {
        super.presentationObjectRemoved(view);
        this.removeFromSynclist();
    }

    @Override
    public PresentationObject copyTo(View view, OverlaySynchronizationMode overlaySynchronizationMode) throws IllegalArgumentException {
        if (overlaySynchronizationMode == null) {
            throw new IllegalArgumentException("No synchronization mode given.");
        }
        SyncablePresentationObject syncablePresentationObject = (SyncablePresentationObject)super.copyTo(view, overlaySynchronizationMode);
        if (overlaySynchronizationMode.isSynchronizationActive()) {
            this.syncWith(syncablePresentationObject, overlaySynchronizationMode);
        } else {
            syncablePresentationObject.removeFromSynclist();
        }
        overlaySynchronizationMode.updateOverlayPoints(this, syncablePresentationObject);
        return syncablePresentationObject;
    }
}

