/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.listtext.dicomobject.module.ps.BitmapDisplayShutterModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayShutterModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.ShutterShape;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.OverlayFrame;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.overlay.BinBMPShutter;
import com.tiani.jvision.overlay.CircleOverlay;
import com.tiani.jvision.overlay.PolygonOverlay;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.RectangleOverlayMPR;
import com.tiani.jvision.overlay.StatisticsPresentationObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Shutter {
    protected static ALogger log = ALogger.getLogger(Shutter.class);
    public static Color shutterOutlineColor;
    public static boolean displayOutline;
    protected int shutterValue = -16777216;

    static {
        displayOutline = true;
        shutterOutlineColor = new Color((int)Config.impaxee.jvision.SHUTTER.ShutterOutlineColor.get());
    }

    public Shutter() {
    }

    public Shutter(int n) {
        this();
        this.setShutterValue(n);
    }

    public abstract void update(PresentationObject var1);

    public abstract void applyShutter(Object var1, int var2, int var3);

    public void setShutterValue(int n) {
        int n2 = n * 255 / 65535;
        this.shutterValue = n2 << 16 | n2 << 8 | n2;
    }

    public int getShutterValue() {
        int n = this.shutterValue & 0xFF;
        return n * 65535 / 255;
    }

    protected static byte[] convert1To8ByteArray(byte[] byArray, int n, int n2, byte[] byArray2) {
        if (byArray.length * 8 != n * n2) {
            return byArray;
        }
        int n3 = 0;
        int n4 = 0;
        byte by = 0;
        int n5 = 0;
        while (n5 < byArray.length) {
            by = byArray[n3++];
            int n6 = 0;
            while (n6 < 8) {
                byArray2[n4++] = (byte)(by >> n6 & 1);
                ++n6;
            }
            ++n5;
        }
        return byArray2;
    }

    public static List<PresentationObject> createShutterObjectPST(IFramePresentationState iFramePresentationState) {
        ArrayList<PresentationObject> arrayList = new ArrayList<PresentationObject>();
        arrayList.addAll(Shutter.createShutterObjectPST(iFramePresentationState.getDisplayShutterModule(), iFramePresentationState.getBitmapDisplayShutterOverlayFrame()));
        arrayList.addAll(Shutter.createBitmapShutterObjectPST(iFramePresentationState.getBitmapDisplayShutterModule(), iFramePresentationState.getBitmapDisplayShutterOverlayFrame()));
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<PresentationObject> createShutterObjectPST(DisplayShutterModule displayShutterModule, OverlayFrame overlayFrame) {
        if (displayShutterModule == null) {
            return Collections.emptyList();
        }
        ArrayList<PresentationObject> arrayList = new ArrayList<PresentationObject>();
        List list = displayShutterModule.shutterShapes();
        int n = 0;
        if (displayShutterModule.getShutterPresentationValue() != null) {
            n = displayShutterModule.getShutterPresentationValue();
        }
        for (ShutterShape shutterShape : list) {
            try {
                block1 : switch (shutterShape) {
                    case Rectangular: {
                        int n2 = displayShutterModule.getShutterLeftVerticalEdge();
                        int n3 = displayShutterModule.getShutterUpperHorizontalEdge();
                        int n4 = displayShutterModule.getShutterRightVerticalEdge();
                        int n5 = displayShutterModule.getShutterLowerHorizontalEdge();
                        StatisticsPresentationObject statisticsPresentationObject = new RectangleOverlayMPR(n2, n3, n4 - n2, n5 - n3, AnnotationUnits.Pixel, false, false);
                        statisticsPresentationObject.setShutterMode(true);
                        statisticsPresentationObject.setShutterValue(n);
                        arrayList.add(statisticsPresentationObject);
                        break;
                    }
                    case Circular: {
                        int n6 = displayShutterModule.getCenterOfCircularShutter()[1];
                        int n7 = displayShutterModule.getCenterOfCircularShutter()[0];
                        int n8 = displayShutterModule.getRadiusOfCircularShutter();
                        if (n8 <= 0) {
                            log.error("The radius of a circular shutter has to be larger than one!  No shutter was created!");
                            return null;
                        }
                        CircleOverlay circleOverlay = new CircleOverlay(n6, n7, n6 + n8, n7, AnnotationUnits.Pixel, false);
                        circleOverlay.setShutterMode(true);
                        circleOverlay.setShutterValue(n);
                        arrayList.add(circleOverlay);
                        break;
                    }
                    case Polygonal: {
                        StatisticsPresentationObject statisticsPresentationObject;
                        int[] nArray = displayShutterModule.getVerticesOfPolygonalShutter();
                        int n9 = nArray.length;
                        if (n9 < 6) {
                            log.error("Too few vertices for polygonal shutter! There are at least 3 vertices necessary.");
                            return null;
                        }
                        double[] dArray = new double[n9 >>= 1];
                        double[] dArray2 = new double[n9];
                        int n10 = 0;
                        while (true) {
                            if (n10 >= n9) {
                                if (dArray[0] != dArray[n9 - 1] || dArray2[0] != dArray2[n9 - 1]) {
                                    double[] dArray3 = new double[n9 + 1];
                                    double[] dArray4 = new double[n9 + 1];
                                    System.arraycopy(dArray, 0, dArray3, 0, n9);
                                    dArray3[n9] = dArray[0];
                                    System.arraycopy(dArray2, 0, dArray4, 0, n9);
                                    dArray4[n9] = dArray2[0];
                                    ++n9;
                                    dArray = dArray3;
                                    dArray2 = dArray4;
                                }
                                statisticsPresentationObject = new PolygonOverlay(dArray, dArray2, AnnotationUnits.Pixel, false);
                                statisticsPresentationObject.setShutterMode(true);
                                statisticsPresentationObject.setShutterValue(n);
                                arrayList.add(statisticsPresentationObject);
                                break block1;
                            }
                            dArray2[n10] = nArray[2 * n10];
                            dArray[n10] = nArray[2 * n10 + 1];
                            ++n10;
                        }
                    }
                    case Bitmap: {
                        double[] dArray = new double[]{0.0, 0.0, 0.0};
                        PolygonOverlay polygonOverlay = new PolygonOverlay(dArray, dArray, AnnotationUnits.Pixel, false);
                        polygonOverlay.setShutterMode(true);
                        polygonOverlay.setShutterValue(n);
                        polygonOverlay.setShutterMask(new BinBMPShutter(n, overlayFrame));
                        arrayList.add(polygonOverlay);
                    }
                }
            }
            catch (Exception exception) {
                log.error("Error creating shutters", (Throwable)exception);
            }
        }
        return arrayList;
    }

    private static List<PresentationObject> createBitmapShutterObjectPST(BitmapDisplayShutterModule bitmapDisplayShutterModule, OverlayFrame overlayFrame) {
        if (bitmapDisplayShutterModule == null) {
            return Collections.emptyList();
        }
        ArrayList<PresentationObject> arrayList = new ArrayList<PresentationObject>();
        List list = bitmapDisplayShutterModule.shutterShapes();
        int n = 0;
        if (bitmapDisplayShutterModule.getShutterPresentationValue() != null) {
            n = bitmapDisplayShutterModule.getShutterPresentationValue();
        }
        for (ShutterShape shutterShape : list) {
            switch (shutterShape) {
                case Bitmap: {
                    double[] dArray = new double[]{0.0, 0.0, 0.0};
                    PolygonOverlay polygonOverlay = new PolygonOverlay(dArray, dArray, AnnotationUnits.Pixel, false, true, false);
                    polygonOverlay.setShutterValue(n);
                    polygonOverlay.setShutterMask(new BinBMPShutter(n, overlayFrame, false));
                    arrayList.add(polygonOverlay);
                }
            }
        }
        return arrayList;
    }

    public abstract Shutter clone();
}

