/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayShutterModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.module.ps.ShutterShape;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.agfa.pacs.math.Matrix2d;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.ImageRegion;
import com.tiani.jvision.overlay.IAreaOverlay;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.LRShutter;
import com.tiani.jvision.overlay.OverlayInformation;
import com.tiani.jvision.overlay.OverlayInformationID;
import com.tiani.jvision.overlay.PointSequence;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import com.tiani.jvision.overlay.Shutter;
import com.tiani.jvision.overlay.StatisticsPresentationObject;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.TranslationHandle;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Vector2d;

public class RectangleOverlayMPR
extends StatisticsPresentationObject
implements PointSequence,
IGraphicObjectContainer,
IAreaOverlay {
    protected double[] o;
    protected double w;
    protected double h;
    protected int p0x;
    protected int p0y;
    protected int p1x;
    protected int p1y;
    protected int p2x;
    protected int p2y;
    protected int p3x;
    protected int p3y;
    private ImageRegion ir = new ImageRegion(this);
    private double[] widthOrientationVector;
    private Matrix2d conversionMatrix;
    private Matrix2d inversionMatrix;

    public RectangleOverlayMPR() {
        super("Rectangle");
        this.o = new double[2];
        this.o[1] = 0.0;
        this.o[0] = 0.0;
        this.h = 0.0;
        this.w = 0.0;
        this.setWidthOrientationVector(1.0, 0.0);
    }

    public RectangleOverlayMPR(double d, double d2, double d3, double d4, AnnotationUnits annotationUnits) {
        this();
        this.o[0] = d;
        this.o[1] = d2;
        this.w = d3;
        this.h = d4;
        this.setSpacing(annotationUnits);
        this.makeHandles();
    }

    public RectangleOverlayMPR(double d, double d2, double d3, double d4, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        this(d, d2, d3, d4, annotationUnits);
        this.setSolid(bl);
        this.setShutterMode(bl2);
    }

    @Override
    public double[] getXCoordinates() {
        return new double[]{this.o[0], this.o[0] + this.widthOrientationVector[0] * this.w, this.o[0] + this.widthOrientationVector[0] * this.w - this.widthOrientationVector[1] * this.h, this.o[0] - this.widthOrientationVector[1] * this.h, this.o[0]};
    }

    @Override
    public double[] getYCoordinates() {
        return new double[]{this.o[1], this.o[1] + this.widthOrientationVector[1] * this.w, this.o[1] + this.widthOrientationVector[1] * this.w + this.widthOrientationVector[0] * this.h, this.o[1] + this.widthOrientationVector[0] * this.h, this.o[1]};
    }

    @Override
    public int getPointCount() {
        return 5;
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        super.initPlacement(n, n2, annotationUnits, bl, bl2);
        this.makeHandles();
    }

    protected void makeHandles() {
        this.handles = new PresentationHandle[5];
        this.handles[0] = new PresentationHandle(this.p0x, this.p0y);
        this.handles[1] = new PresentationHandle(this.p1x, this.p1y);
        this.handles[2] = new PresentationHandle(this.p3x, this.p3y);
        this.handles[3] = new PresentationHandle(this.p2x, this.p2y);
        this.handles[4] = new TranslationHandle((this.p0x + this.p1x + this.p2x + this.p3x) / 4, (this.p0y + this.p1y + this.p2y + this.p3y) / 4);
        this.translationHandleIndex = 4;
    }

    @Override
    protected void toScreen() {
        double[] dArray = this.getXCoordinates();
        double[] dArray2 = this.getYCoordinates();
        double[] dArray3 = new double[]{dArray[0], dArray2[0]};
        dArray3 = this.toScreen(dArray3);
        this.p0x = (int)dArray3[0];
        this.p0y = (int)dArray3[1];
        dArray3[0] = dArray[1];
        dArray3[1] = dArray2[1];
        dArray3 = this.toScreen(dArray3);
        this.p1x = (int)dArray3[0];
        this.p1y = (int)dArray3[1];
        dArray3[0] = dArray[2];
        dArray3[1] = dArray2[2];
        dArray3 = this.toScreen(dArray3);
        this.p2x = (int)dArray3[0];
        this.p2y = (int)dArray3[1];
        dArray3[0] = dArray[3];
        dArray3[1] = dArray2[3];
        dArray3 = this.toScreen(dArray3);
        this.p3x = (int)dArray3[0];
        this.p3y = (int)dArray3[1];
        this.handles[0].setPosition(this.p0x, this.p0y);
        this.handles[1].setPosition(this.p1x, this.p1y);
        this.handles[2].setPosition(this.p3x, this.p3y);
        this.handles[3].setPosition(this.p2x, this.p2y);
        this.handles[4].setPosition((this.p0x + this.p1x + this.p2x + this.p3x) / 4, (this.p0y + this.p1y + this.p2y + this.p3y) / 4);
        this.bounds.x = Math.min(Math.min(this.p0x, this.p1x), Math.min(this.p2x, this.p3x)) - PresentationHandle.HANDLE_SIZE;
        this.bounds.y = Math.min(Math.min(this.p0y, this.p1y), Math.min(this.p2y, this.p3y)) - PresentationHandle.HANDLE_SIZE;
        this.bounds.width = Math.max(Math.max(this.p0x, this.p1x), Math.max(this.p2x, this.p3x)) - Math.min(Math.min(this.p0x, this.p1x), Math.min(this.p2x, this.p3x)) + 2 * PresentationHandle.HANDLE_SIZE;
        this.bounds.height = Math.max(Math.max(this.p0y, this.p1y), Math.max(this.p2y, this.p3y)) - Math.min(Math.min(this.p0y, this.p1y), Math.min(this.p2y, this.p3y)) + 2 * PresentationHandle.HANDLE_SIZE;
        if (this.ownedCompanions != null && this.ownedCompanions.length > 0 && this.ownedCompanions[0] != null && this.spacingType == AnnotationUnits.Pixel && this.shapeChanged && this.getImageState().window != null) {
            this.shapeChanged = false;
            double d = 2.0 * (Math.abs(this.w) * this.getDataPixelSizeX() + Math.abs(this.h) * this.getDataPixelSizeY());
            double d2 = this.getArea();
            IImageRegionProperties iImageRegionProperties = this.updateHistogram(this.ir);
            ArrayList<IOverlayInformation> arrayList = new ArrayList<IOverlayInformation>();
            arrayList.add(this.createAreaInformation(d2));
            arrayList.add(this.createOverlayInformation(OverlayInformationID.PERIMETER, d));
            arrayList.add(this.createWidthHeightInformation());
            this.setNonEditableAnnotation(arrayList, iImageRegionProperties);
        }
        if (this.isShutter()) {
            if (this.shutterMask == null) {
                this.shutterMask = new LRShutter(this.shutterValue);
            }
            this.shutterMask.update(this);
        }
    }

    private OverlayInformation createWidthHeightInformation() {
        return new OverlayInformation(OverlayInformationID.WIDTH_HEIGHT, Math.abs(this.w) * this.getDataPixelSizeX(), this.dimensionUnit(), Math.abs(this.h) * this.getDataPixelSizeY(), this.dimensionUnit());
    }

    @Override
    public double getArea() {
        return Math.abs(this.w * this.h) * this.getDataPixelSizeX() * this.getDataPixelSizeY();
    }

    @Override
    public boolean isROI() {
        return !this.isShutter();
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder, boolean bl) {
        if (this.isShutter() && !this.isSelected() && this.isCompleted()) {
            ((LRShutter)this.shutterMask).applyShutter(bufferedImageHolder.getImageArray(), bufferedImageHolder.width, bufferedImageHolder.height);
            if (!Shutter.displayOutline) {
                return;
            }
        }
        int[] nArray = new int[]{this.p0x, this.p1x, this.p2x, this.p3x, this.p0x};
        int[] nArray2 = new int[]{this.p0y, this.p1y, this.p2y, this.p3y, this.p0y};
        if (bl) {
            if (bufferedImageHolder.graphics.getComposite() instanceof AlphaComposite) {
                bufferedImageHolder.graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            bufferedImageHolder.graphics.fillPolygon(nArray, nArray2, 5);
            Color color = bufferedImageHolder.graphics.getColor();
            bufferedImageHolder.graphics.setColor(solidOutlineColor);
            bufferedImageHolder.graphics.drawPolygon(nArray, nArray2, 5);
            bufferedImageHolder.graphics.setColor(color);
            bufferedImageHolder.graphics.setPaintMode();
        } else {
            if (this.isUseOutlineFont()) {
                bufferedImageHolder.graphics.setColor(Color.black);
                int n = 1;
                while (n < nArray.length) {
                    if (nArray[n] != nArray[n - 1] && Math.abs(nArray2[n] - nArray2[n - 1]) / Math.abs(nArray[n] - nArray[n - 1]) < 1) {
                        bufferedImageHolder.graphics.drawLine(nArray[n - 1], nArray2[n - 1] - 1, nArray[n], nArray2[n] - 1);
                        bufferedImageHolder.graphics.drawLine(nArray[n - 1], nArray2[n - 1] + 1, nArray[n], nArray2[n] + 1);
                    } else {
                        bufferedImageHolder.graphics.drawLine(nArray[n - 1] - 1, nArray2[n - 1], nArray[n] - 1, nArray2[n]);
                        bufferedImageHolder.graphics.drawLine(nArray[n - 1] + 1, nArray2[n - 1], nArray[n] + 1, nArray2[n]);
                    }
                    ++n;
                }
                bufferedImageHolder.graphics.setColor(this.objCol);
            }
            bufferedImageHolder.graphics.drawPolygon(nArray, nArray2, 5);
        }
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        double[] dArray2 = (double[])this.o.clone();
        double[] dArray3 = (double[])dArray.clone();
        this.conversionMatrix.transform(dArray2);
        this.conversionMatrix.transform(dArray3);
        switch (n) {
            case 0: {
                this.o = (double[])dArray.clone();
                this.w = dArray2[0] + this.w - dArray3[0];
                this.h = dArray2[1] + this.h - dArray3[1];
                break;
            }
            case 1: {
                this.w = dArray3[0] - dArray2[0];
                this.h = dArray2[1] + this.h - dArray3[1];
                dArray2[1] = dArray3[1];
                this.inversionMatrix.transform(dArray2);
                this.o = dArray2;
                break;
            }
            case 2: {
                this.h = dArray3[1] - dArray2[1];
                this.w = dArray2[0] + this.w - dArray3[0];
                dArray2[0] = dArray3[0];
                this.inversionMatrix.transform(dArray2);
                this.o = dArray2;
                break;
            }
            case 3: {
                this.h = dArray3[1] - dArray2[1];
                this.w = dArray3[0] - dArray2[0];
                break;
            }
            case 4: {
                this.o[0] = dArray[0] - this.widthOrientationVector[0] * this.w / 2.0 + this.widthOrientationVector[1] * this.h / 2.0;
                this.o[1] = dArray[1] - this.widthOrientationVector[1] * this.w / 2.0 - this.widthOrientationVector[0] * this.h / 2.0;
            }
        }
        this.toScreen();
        this.setSaved(false);
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        TextOverlay textOverlay;
        int n2 = n;
        switch (n) {
            case 1: {
                this.handleDragged(4, dArray);
                ++n2;
                break;
            }
            case 2: {
                this.activeHandleIndex = 2;
                ++n2;
                break;
            }
            case 3: {
                n2 = -1;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        if (n2 == -1 && (textOverlay = this.createAnnotation()) != null) {
            textOverlay.setVisible(RectangleOverlayMPR.getTextAnnotationLevel().isTextAnnotationVisible());
        }
        return n2;
    }

    @Override
    protected TextOverlay createAnnotation() {
        return this.makeAnnotation(120, "ROI");
    }

    @Override
    public boolean supportsHistogram() {
        return true;
    }

    @Override
    public boolean isInside(int n, int n2) {
        boolean bl;
        double[] dArray = new double[]{(double)n - this.o[0], (double)n2 - this.o[1]};
        this.conversionMatrix.transform(dArray);
        if (this.w > 0.0) {
            bl = 0.0 <= dArray[0] && dArray[0] <= this.w;
        } else {
            boolean bl2 = bl = 0.0 >= dArray[0] && dArray[0] >= this.w;
        }
        bl = this.h > 0.0 ? (bl &= 0.0 <= dArray[1] && dArray[1] <= this.h) : (bl &= 0.0 >= dArray[1] && dArray[1] >= this.h);
        return bl;
    }

    protected void createBoundingShape() {
        this.toScreen();
        int[] nArray = new int[]{this.p0x, this.p1x, this.p2x, this.p3x, this.p0x};
        int[] nArray2 = new int[]{this.p0y, this.p1y, this.p2y, this.p3y, this.p0y};
        Polygon polygon = new Polygon(nArray, nArray2, 5);
        this.outBounds = Collections.singletonList(polygon);
        if (!this.isSolid()) {
            this.inBounds = Collections.singletonList(polygon);
        }
    }

    @Override
    public boolean useBBoxOnly() {
        return false;
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(1);
        double[] dArray = this.getXCoordinates();
        double[] dArray2 = this.getYCoordinates();
        int n = dArray.length;
        float[] fArray = new float[2 * n];
        int n2 = 0;
        while (n2 < n) {
            fArray[2 * n2] = (float)dArray[n2];
            fArray[2 * n2 + 1] = (float)dArray2[n2];
            ++n2;
        }
        GraphicObject graphicObject = this.createGraphicObject();
        if (this.isParaxial()) {
            graphicObject.setTianiSubType(TianiSubType.Rectangle);
        }
        graphicObject.setGraphicType(GraphicType.PolyLine);
        graphicObject.setGraphicData(fArray);
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(n));
        arrayList.add(graphicObject);
        return arrayList;
    }

    @Override
    public DisplayShutterModule getDisplayShutterModule() {
        DisplayShutterModule displayShutterModule = new DisplayShutterModule();
        if (this.shutterMask != null) {
            displayShutterModule.setShutterPresentationValue(Integer.valueOf(this.shutterMask.getShutterValue()));
        }
        if (this.isParaxial()) {
            displayShutterModule.shutterShapes().add(ShutterShape.Rectangular);
            displayShutterModule.setShutterLeftVerticalEdge(Integer.valueOf((int)this.o[0]));
            displayShutterModule.setShutterRightVerticalEdge(Integer.valueOf((int)(this.o[0] + this.w)));
            displayShutterModule.setShutterUpperHorizontalEdge(Integer.valueOf((int)this.o[1]));
            displayShutterModule.setShutterLowerHorizontalEdge(Integer.valueOf((int)(this.o[1] + this.h)));
        } else {
            displayShutterModule.shutterShapes().add(ShutterShape.Polygonal);
            double[] dArray = this.getXCoordinates();
            double[] dArray2 = this.getYCoordinates();
            int n = dArray.length;
            int[] nArray = new int[2 * n];
            int n2 = 0;
            while (n2 < n) {
                nArray[2 * n2] = (int)dArray[n2];
                nArray[2 * n2 + 1] = (int)dArray2[n2];
                ++n2;
            }
            displayShutterModule.setVerticesOfPolygonalShutter(nArray);
        }
        displayShutterModule.hasContent(true);
        return displayShutterModule;
    }

    @Override
    public boolean hasDisplayShutterModule() {
        return true;
    }

    @Override
    public SyncablePresentationObject cloneAll() {
        SyncablePresentationObject syncablePresentationObject = null;
        try {
            syncablePresentationObject = (SyncablePresentationObject)this.clone();
            super.cloneReferences(syncablePresentationObject);
            RectangleOverlayMPR rectangleOverlayMPR = (RectangleOverlayMPR)syncablePresentationObject;
            rectangleOverlayMPR.ir = new ImageRegion(rectangleOverlayMPR);
            rectangleOverlayMPR.setClonedParameters(ReferencedObjectsCloning.clone(this.o));
            rectangleOverlayMPR.setWidthOrientationVector(this.widthOrientationVector[0], this.widthOrientationVector[1]);
        }
        catch (Exception exception) {
            log.error("clone error", (Throwable)exception);
        }
        return syncablePresentationObject;
    }

    private void setClonedParameters(double[] dArray) {
        this.o = dArray;
    }

    @Override
    public void updateOverlayPoints(ITransformableOverlay iTransformableOverlay, IOverlayPointModifier iOverlayPointModifier) {
        RectangleOverlayMPR rectangleOverlayMPR = (RectangleOverlayMPR)iTransformableOverlay;
        this.o = iOverlayPointModifier.convert(rectangleOverlayMPR.o);
        Vector2d vector2d = RectangleOverlayMPR.updateOrientationVector(iOverlayPointModifier, rectangleOverlayMPR.widthOrientationVector[0], rectangleOverlayMPR.widthOrientationVector[1], rectangleOverlayMPR.w);
        this.w = vector2d.length();
        Vector2d vector2d2 = RectangleOverlayMPR.updateOrientationVector(iOverlayPointModifier, -rectangleOverlayMPR.widthOrientationVector[1], rectangleOverlayMPR.widthOrientationVector[0], rectangleOverlayMPR.h);
        this.h = vector2d2.length();
        if (vector2d2.x * -vector2d.y < 0.0 || vector2d2.y * vector2d.x < 0.0) {
            this.h *= -1.0;
        }
        vector2d.normalize();
        this.setWidthOrientationVector(vector2d.x, vector2d.y);
    }

    private static Vector2d updateOrientationVector(IOverlayPointModifier iOverlayPointModifier, double d, double d2, double d3) {
        double[] dArray = new double[2];
        double[] dArray2 = (double[])dArray.clone();
        dArray2[0] = dArray2[0] + d * d3;
        dArray2[1] = dArray2[1] + d2 * d3;
        dArray = iOverlayPointModifier.convert(dArray);
        dArray2 = iOverlayPointModifier.convert(dArray2);
        dArray2[0] = dArray2[0] - dArray[0];
        dArray2[1] = dArray2[1] - dArray[1];
        int n = 0;
        while (n < dArray2.length) {
            if (DoubleEquals.equals((double)dArray2[n], (double)0.0)) {
                dArray2[n] = 0.0;
            }
            ++n;
        }
        return new Vector2d(dArray2);
    }

    @Override
    public boolean inBounds(int n, int n2) {
        boolean bl = false;
        if (this.isSelected()) {
            bl = this.isHandleClicked(n, n2);
        }
        if (!bl) {
            this.createBoundingShape();
            return super.inBounds(n, n2);
        }
        return bl;
    }

    @Override
    public boolean isInterceptionAt(int n) {
        return false;
    }

    private void setWidthOrientationVector(double d, double d2) {
        this.widthOrientationVector = new double[]{d, d2};
        this.inversionMatrix = new Matrix2d(d, -d2, d2, d);
        this.conversionMatrix = new Matrix2d(this.inversionMatrix);
        this.conversionMatrix.invert();
    }

    private boolean isParaxial() {
        return DoubleEquals.equals((double)this.widthOrientationVector[0], (double)1.0) && DoubleEquals.equals((double)this.widthOrientationVector[1], (double)0.0);
    }
}

