/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

class PointToLineProjection {
    private final double x;
    private final double y;
    private final Location location;

    private PointToLineProjection(double d, double d2, Location location) {
        this.x = d;
        this.y = d2;
        this.location = location;
    }

    static PointToLineProjection project(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d3 - d;
        double d8 = d4 - d2;
        double d9 = d7 * d7 + d8 * d8;
        if (d9 > 0.0) {
            double d10 = ((d5 - d) * d7 + (d6 - d2) * d8) / d9;
            Location location = d10 < 0.0 ? Location.BEFORE_LINE_START : (d10 > 1.0 ? Location.AFTER_LINE_END : Location.WITHIN_LINE);
            return new PointToLineProjection(d + d10 * d7, d2 + d10 * d8, location);
        }
        return null;
    }

    double getX() {
        return this.x;
    }

    double getY() {
        return this.y;
    }

    Location getLocation() {
        return this.location;
    }

    static enum Location {
        WITHIN_LINE,
        BEFORE_LINE_START,
        AFTER_LINE_END;

    }
}

