/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.tiani.jvision.image.DoubleRectangle;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.OutlinedTranslationHandle;
import com.tiani.jvision.overlay.OverlayTransformationException;
import com.tiani.jvision.overlay.OverlayTransformationUtils;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import java.awt.Dimension;

public class OverlayContainer
extends PresentationObject
implements ITransformableOverlay {
    public double[] o;
    public double w;
    public double h;
    protected boolean bAllowDragOutOfBounds = true;
    protected double[] o_save;
    protected double[] a_save;
    protected double w_save;
    protected double h_save;
    protected int p0x;
    protected int p0y;
    protected int p1x;
    protected int p1y;
    protected int p2x;
    protected int p2y;
    protected int p3x;
    protected int p3y;
    protected AnchorPosition anchor = AnchorPosition.CENTER;
    protected double[] a = new double[]{0.0, 0.0};
    protected double[] atemp;
    protected boolean onlyTranslateAnchor = false;
    private DoubleRectangle relativePosition;

    public OverlayContainer(String string) {
        super(string);
        this.o = new double[2];
        this.o[1] = 0.0;
        this.o[0] = 0.0;
        this.h = 0.0;
        this.w = 0.0;
    }

    public OverlayContainer(String string, double d, double d2, double d3, double d4) {
        this(string, d, d2, d3, d4, AnnotationUnits.Display);
    }

    public OverlayContainer(String string, double d, double d2, double d3, double d4, AnnotationUnits annotationUnits) {
        this(string);
        this.setShutterMode(false);
        this.setSpacing(annotationUnits);
        this.o[0] = d;
        this.o[1] = d2;
        this.w = d3;
        this.h = d4;
        this.atemp = new double[]{d, d2};
        this.a[1] = 0.0;
        this.a[0] = 0.0;
        this.makeHandles();
    }

    public OverlayContainer(String string, double d, double d2, double d3, double d4, AnnotationUnits annotationUnits, AnchorPosition anchorPosition) {
        this(string, d, d2, d3, d4, annotationUnits);
        this.anchor = anchorPosition;
    }

    protected OverlayContainer(String string, DoubleRectangle doubleRectangle, AnnotationUnits annotationUnits, AnchorPosition anchorPosition) {
        this(string, 0.0, 0.0, 0.0, 0.0, annotationUnits, anchorPosition);
        this.relativePosition = doubleRectangle;
    }

    public void setOnlyTranslateAnchor(boolean bl) {
        this.onlyTranslateAnchor = bl;
    }

    public boolean getOnlyTranslateAnchor() {
        return this.onlyTranslateAnchor;
    }

    protected void makeHandles() {
        this.handles = new PresentationHandle[5];
        this.handles[0] = new PresentationHandle(this.p0x, this.p0y);
        this.handles[1] = new PresentationHandle(this.p1x, this.p1y);
        this.handles[2] = new PresentationHandle(this.p3x, this.p3y);
        this.handles[3] = new PresentationHandle(this.p2x, this.p2y);
        this.handles[4] = new OutlinedTranslationHandle((this.p0x + this.p1x + this.p2x + this.p3x) / 4, (this.p0y + this.p1y + this.p2y + this.p3y) / 4);
        this.translationHandleIndex = 4;
    }

    @Override
    protected void toScreen() {
        if (this.relativePosition != null) {
            this.w = this.relativePosition.width * (double)this.width;
            this.h = this.relativePosition.height * (double)this.height;
            double d = this.relativePosition.x * (double)this.width;
            double d2 = this.relativePosition.y * (double)this.height;
            this.o[0] = d;
            this.o[1] = d2;
            this.atemp = new double[]{d, d2};
            this.relativePosition = null;
        }
        if (this.onlyTranslateAnchor) {
            if (this.a[0] == 0.0 && this.a[1] == 0.0) {
                double[] dArray = this.toImage(this.atemp);
                this.a[0] = dArray[0];
                this.a[1] = dArray[1];
            }
            double[] dArray = this.toScreen(this.a);
            this.toScreenFromAnchor(dArray);
        } else {
            double[] dArray = new double[]{this.o[0], this.o[1]};
            dArray = this.toScreen(dArray);
            this.p0x = (int)(dArray[0] + 0.5);
            this.p0y = (int)(dArray[1] + 0.5);
            dArray[0] = this.o[0] + this.w;
            dArray[1] = this.o[1];
            dArray = this.toScreen(dArray);
            this.p1x = (int)(dArray[0] + 0.5);
            this.p1y = (int)(dArray[1] + 0.5);
            dArray[0] = this.o[0] + this.w;
            dArray[1] = this.o[1] + this.h;
            dArray = this.toScreen(dArray);
            this.p2x = (int)(dArray[0] + 0.5);
            this.p2y = (int)(dArray[1] + 0.5);
            dArray[0] = this.o[0];
            dArray[1] = this.o[1] + this.h;
            dArray = this.toScreen(dArray);
            this.p3x = (int)(dArray[0] + 0.5);
            this.p3y = (int)(dArray[1] + 0.5);
        }
        this.handles[0].setPosition(this.p0x, this.p0y);
        this.handles[1].setPosition(this.p1x, this.p1y);
        this.handles[2].setPosition(this.p3x, this.p3y);
        this.handles[3].setPosition(this.p2x, this.p2y);
        this.handles[4].setPosition((this.p0x + this.p1x + this.p2x + this.p3x) / 4, (this.p0y + this.p1y + this.p2y + this.p3y) / 4);
        this.bounds.x = Math.min(Math.min(this.p0x, this.p1x), Math.min(this.p2x, this.p3x)) - PresentationHandle.HANDLE_SIZE;
        this.bounds.y = Math.min(Math.min(this.p0y, this.p1y), Math.min(this.p2y, this.p3y)) - PresentationHandle.HANDLE_SIZE;
        this.bounds.width = Math.max(Math.max(this.p0x, this.p1x), Math.max(this.p2x, this.p3x)) - Math.min(Math.min(this.p0x, this.p1x), Math.min(this.p2x, this.p3x)) + 2 * PresentationHandle.HANDLE_SIZE;
        this.bounds.height = Math.max(Math.max(this.p0y, this.p1y), Math.max(this.p2y, this.p3y)) - Math.min(Math.min(this.p0y, this.p1y), Math.min(this.p2y, this.p3y)) + 2 * PresentationHandle.HANDLE_SIZE;
    }

    private void toScreenFromAnchor(double[] dArray) {
        switch (this.anchor) {
            case TOPLEFT: {
                this.p0x = (int)dArray[0];
                this.p0y = (int)dArray[1];
                this.p1x = (int)(dArray[0] + this.w);
                this.p1y = (int)dArray[1];
                this.p2x = (int)(dArray[0] + this.w);
                this.p2y = (int)(dArray[1] + this.h);
                this.p3x = (int)dArray[0];
                this.p3y = (int)(dArray[1] + this.h);
                break;
            }
            case TOPRIGHT: {
                this.p0x = (int)(dArray[0] - this.w);
                this.p0y = (int)dArray[1];
                this.p1x = (int)dArray[0];
                this.p1y = (int)dArray[1];
                this.p2x = (int)dArray[0];
                this.p2y = (int)(dArray[1] + this.h);
                this.p3x = (int)(dArray[0] - this.w);
                this.p3y = (int)(dArray[1] + this.h);
                break;
            }
            case BOTTOMLEFT: {
                this.p0x = (int)dArray[0];
                this.p0y = (int)(dArray[1] - this.h);
                this.p1x = (int)(dArray[0] + this.w);
                this.p1y = (int)(dArray[1] - this.h);
                this.p2x = (int)(dArray[0] + this.w);
                this.p2y = (int)dArray[1];
                this.p3x = (int)dArray[0];
                this.p3y = (int)dArray[1];
                break;
            }
            case BOTTOMRIGHT: {
                this.p0x = (int)(dArray[0] - this.w);
                this.p0y = (int)(dArray[1] - this.h);
                this.p1x = (int)dArray[0];
                this.p1y = (int)(dArray[1] - this.h);
                this.p2x = (int)dArray[0];
                this.p2y = (int)dArray[1];
                this.p3x = (int)(dArray[0] - this.w);
                this.p3y = (int)dArray[1];
                break;
            }
            case CENTER: {
                this.p0x = (int)(dArray[0] - this.w / 2.0);
                this.p0y = (int)(dArray[1] - this.h / 2.0);
                this.p1x = (int)(dArray[0] + this.w / 2.0);
                this.p1y = (int)(dArray[1] - this.h / 2.0);
                this.p2x = (int)(dArray[0] + this.w / 2.0);
                this.p2y = (int)(dArray[1] + this.h / 2.0);
                this.p3x = (int)(dArray[0] - this.w / 2.0);
                this.p3y = (int)(dArray[1] + this.h / 2.0);
            }
        }
    }

    @Override
    public PresentationObject cloneAll() {
        double[] dArray = this.getTopLeft();
        OverlayContainer overlayContainer = new OverlayContainer(this.name, dArray[0], dArray[1], this.w, this.h, this.spacingType, this.anchor);
        this.setAllowDragOutOfBounds(this.bAllowDragOutOfBounds);
        this.setOnlyTranslateAnchor(this.getOnlyTranslateAnchor());
        return overlayContainer;
    }

    protected void setClonedParameters(double[] dArray, double[] dArray2) {
        this.a = dArray;
        this.o = dArray2;
        this.atemp = null;
    }

    public PresentationObject cloneAllForPrinting() {
        OverlayContainer overlayContainer = (OverlayContainer)this.cloneAll();
        this.convertToFullTranslation(overlayContainer);
        return overlayContainer;
    }

    public void convertToFullTranslation(OverlayContainer overlayContainer) {
        if (this.getOnlyTranslateAnchor()) {
            overlayContainer.setOnlyTranslateAnchor(false);
            overlayContainer.w = this.w * this.getPixelSizeX() / this.getDataPixelSizeX();
            overlayContainer.h = this.h * this.getPixelSizeY() / this.getDataPixelSizeY();
            switch (this.anchor) {
                case TOPLEFT: {
                    overlayContainer.o[0] = this.a[0];
                    overlayContainer.o[1] = this.a[1];
                    break;
                }
                case TOPRIGHT: {
                    overlayContainer.o[0] = this.a[0] - overlayContainer.w;
                    overlayContainer.o[1] = this.a[1];
                    break;
                }
                case BOTTOMRIGHT: {
                    overlayContainer.o[0] = this.a[0] - overlayContainer.w;
                    overlayContainer.o[1] = this.a[1] - overlayContainer.h;
                    break;
                }
                case BOTTOMLEFT: {
                    overlayContainer.o[0] = this.a[0];
                    overlayContainer.o[1] = this.a[1] - overlayContainer.h;
                    break;
                }
                case CENTER: {
                    overlayContainer.o[0] = this.a[0] - overlayContainer.w / 2.0;
                    overlayContainer.o[1] = this.a[1] - overlayContainer.h / 2.0;
                }
            }
        }
    }

    @Override
    public void updateOverlayPoints(ITransformableOverlay iTransformableOverlay, IOverlayPointModifier iOverlayPointModifier) throws OverlayTransformationException {
        OverlayContainer overlayContainer = (OverlayContainer)iTransformableOverlay;
        this.o = iOverlayPointModifier.convert(overlayContainer.o);
        this.a = iOverlayPointModifier.convert(overlayContainer.a);
        if (!this.onlyTranslateAnchor) {
            this.w = OverlayTransformationUtils.updateLength(iOverlayPointModifier, overlayContainer.w, 0, true);
            this.h = OverlayTransformationUtils.updateLength(iOverlayPointModifier, overlayContainer.h, 1, true);
        }
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        double[] dArray2 = new double[]{0.0, 0.0};
        double[] dArray3 = new double[]{0.0, 0.0};
        double[] dArray4 = new double[]{0.0, 0.0};
        double[] dArray5 = new double[]{0.0, 0.0};
        double[] dArray6 = this.toScreen(new double[]{this.a[0], this.a[1]});
        this.saveGeometry();
        switch (this.anchor) {
            case TOPLEFT: {
                dArray2 = dArray6;
                dArray4 = new double[]{dArray6[0] + this.w, dArray6[1] + this.h};
                dArray5 = new double[]{dArray4[0], dArray2[1]};
                dArray3 = new double[]{dArray2[0], dArray4[1]};
                break;
            }
            case TOPRIGHT: {
                dArray5 = dArray6;
                dArray3 = new double[]{dArray6[0] - this.w, dArray6[1] + this.h};
                dArray4 = new double[]{dArray5[0], dArray3[1]};
                dArray2 = new double[]{dArray3[0], dArray5[1]};
                break;
            }
            case BOTTOMLEFT: {
                dArray3 = dArray6;
                dArray5 = new double[]{dArray6[0] + this.w, dArray6[1] - this.h};
                dArray4 = new double[]{dArray5[0], dArray3[1]};
                dArray2 = new double[]{dArray3[0], dArray5[1]};
                break;
            }
            case BOTTOMRIGHT: {
                dArray4 = dArray6;
                dArray2 = new double[]{dArray6[0] - this.w, dArray6[1] - this.h};
                dArray5 = new double[]{dArray4[0], dArray2[1]};
                dArray3 = new double[]{dArray2[0], dArray4[1]};
                break;
            }
            case CENTER: {
                dArray2 = new double[]{dArray6[0] - this.w / 2.0, dArray6[1] - this.h / 2.0};
                dArray5 = new double[]{dArray6[0] + this.w / 2.0, dArray6[1] - this.h / 2.0};
                dArray3 = new double[]{dArray6[0] - this.w / 2.0, dArray6[1] + this.h / 2.0};
                dArray4 = new double[]{dArray6[0] + this.w / 2.0, dArray6[1] + this.h / 2.0};
            }
        }
        switch (n) {
            case 0: {
                if (this.onlyTranslateAnchor) {
                    dArray2 = this.toScreen(dArray);
                    dArray5[1] = dArray2[1];
                    dArray3[0] = dArray2[0];
                    break;
                }
                double[] dArray7 = this.o;
                this.o = (double[])dArray.clone();
                this.w = dArray7[0] + this.w - this.o[0];
                this.h = dArray7[1] + this.h - this.o[1];
                break;
            }
            case 1: {
                if (this.onlyTranslateAnchor) {
                    dArray5 = this.toScreen(dArray);
                    dArray2[1] = dArray5[1];
                    dArray4[0] = dArray5[0];
                    break;
                }
                double d = this.o[1];
                this.o[1] = dArray[1];
                this.w = dArray[0] - this.o[0];
                this.h = d + this.h - this.o[1];
                break;
            }
            case 2: {
                if (this.onlyTranslateAnchor) {
                    dArray3 = this.toScreen(dArray);
                    dArray2[0] = dArray3[0];
                    dArray4[1] = dArray3[1];
                    break;
                }
                double d = this.o[0];
                this.o[0] = dArray[0];
                this.h = dArray[1] - this.o[1];
                this.w = d + this.w - this.o[0];
                break;
            }
            case 3: {
                if (this.onlyTranslateAnchor) {
                    dArray4 = this.toScreen(dArray);
                    dArray3[1] = dArray4[1];
                    dArray5[0] = dArray4[0];
                    break;
                }
                this.h = dArray[1] - this.o[1];
                this.w = dArray[0] - this.o[0];
                break;
            }
            case 4: {
                double[] dArray7;
                if (this.onlyTranslateAnchor) {
                    dArray7 = this.toScreen(dArray);
                    dArray2 = new double[]{dArray7[0] - this.w / 2.0, dArray7[1] - this.h / 2.0};
                    dArray4 = new double[]{dArray2[0] + this.w, dArray2[1] + this.h};
                    dArray5 = new double[]{dArray4[0], dArray2[1]};
                    dArray3 = new double[]{dArray2[0], dArray4[1]};
                    break;
                }
                this.o = new double[]{dArray[0] - this.w / 2.0, dArray[1] - this.h / 2.0};
            }
        }
        if (this.onlyTranslateAnchor) {
            double[] dArray8;
            double d = this.w;
            double d2 = this.h;
            this.w = Math.max(dArray4[0] - dArray2[0], 5.0);
            this.h = Math.max(dArray4[1] - dArray2[1], 5.0);
            double[] dArray9 = this.toScreen(new double[]{this.a[0], this.a[1]});
            switch (this.anchor) {
                case TOPLEFT: {
                    this.a = this.toImage(dArray2);
                    break;
                }
                case TOPRIGHT: {
                    this.a = this.toImage(dArray5);
                    break;
                }
                case BOTTOMLEFT: {
                    this.a = this.toImage(dArray3);
                    break;
                }
                case BOTTOMRIGHT: {
                    this.a = this.toImage(dArray4);
                    break;
                }
                case CENTER: {
                    this.a = this.toImage(new double[]{dArray2[0] + this.w / 2.0, dArray2[1] + this.h / 2.0});
                }
            }
            if (this.w == 5.0) {
                dArray8 = this.toScreen(this.a);
                dArray8[0] = dArray9[0];
                this.a = this.toImage(dArray8);
                this.w = d;
            }
            if (this.h == 5.0) {
                dArray8 = this.toScreen(this.a);
                dArray8[1] = dArray9[1];
                this.a = this.toImage(dArray8);
                this.h = d2;
            }
        } else {
            if (this.w < 0.0) {
                this.o[0] = this.o_save[0];
                this.w = 0.0;
            }
            if (this.h < 0.0) {
                this.o[1] = this.o_save[1];
                this.h = 0.0;
            }
        }
        this.toScreen();
        if (!this.isAllowDragOutOfBounds()) {
            this.clipIntoView();
        }
    }

    @Override
    public void handleDragged(int n, double[] dArray) {
        super.handleDragged(n, dArray);
        this.handleInteraction(n, dArray);
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        bufferedImageHolder.graphics.drawRect(this.p0x, this.p0y, this.p1x - this.p0x, this.p3y - this.p0y);
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        return -1;
    }

    private void saveGeometry() {
        this.o_save = new double[this.o.length];
        this.a_save = new double[this.a.length];
        int n = 0;
        while (n < this.o.length) {
            this.o_save[n] = this.o[n];
            ++n;
        }
        n = 0;
        while (n < this.a.length) {
            this.a_save[n] = this.a[n];
            ++n;
        }
        this.w_save = this.w;
        this.h_save = this.h;
    }

    protected void clipIntoView() {
        if (!this.onlyTranslateAnchor) {
            double[] dArray = this.toScreen(new double[]{this.w_save, this.h_save});
            if (this.p0x < 0) {
                this.p0x = 0;
                this.w = this.w_save;
            }
            if (this.p0y < 0) {
                this.p0y = 0;
                this.h = this.h_save;
            }
            Dimension dimension = this.owner != null ? this.getView().getVisView().getSize() : new Dimension(this.width, this.height);
            if (this.p2x > dimension.width - 3) {
                this.p0x = dimension.width - (int)dArray[0] - 3;
                this.w = this.w_save;
            }
            if (this.p2y > dimension.height - 3) {
                this.p0y = dimension.height - (int)dArray[1] - 3;
                this.h = this.h_save;
            }
            this.o = this.toImage(new double[]{this.p0x, this.p0y});
        }
        this.toScreen();
    }

    public boolean isAllowDragOutOfBounds() {
        return this.bAllowDragOutOfBounds;
    }

    public void setAllowDragOutOfBounds(boolean bl) {
        this.bAllowDragOutOfBounds = bl;
    }

    public double[] getTopLeft() {
        if (this.onlyTranslateAnchor) {
            return this.toScreen(this.a);
        }
        return this.toScreen(this.o);
    }

    protected static enum AnchorPosition {
        TOPLEFT,
        TOPRIGHT,
        BOTTOMLEFT,
        BOTTOMRIGHT,
        CENTER;

    }
}

