/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.tiani.base.data.IImageInformation;
import com.tiani.gui.dialog.HideableDialogFactory;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewMouseHandler;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.AngleOverlay;
import com.tiani.jvision.overlay.OverlaySynchronizationMode;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.localizer.DisplayLocalizerInfo;
import java.awt.Component;

public class CrossSliceAngleMeasurement {
    private final IDisplaySet sourceDisplaySet;
    private final View sourceView;
    private final IImageInformation sourceImageInformation;
    private final AngleOverlay sourceAngleOverlay;

    private CrossSliceAngleMeasurement(View view, AngleOverlay angleOverlay) {
        this.sourceDisplaySet = view.getDisplayData().getDisplaySet();
        this.sourceView = view;
        this.sourceImageInformation = view.getImageInformation();
        this.sourceAngleOverlay = angleOverlay;
    }

    public static CrossSliceAngleMeasurement newInstance(View view) {
        AngleOverlay angleOverlay = CrossSliceAngleMeasurement.getOverlayToCopy(view);
        if (angleOverlay == null) {
            HideableDialogFactory.showWarningDialog((Component)JVision2.getMainFrame(), Messages.getString("CrossSliceAngleMeasurement.CopyFailure.NoData"), Config.impaxee.jvision.DIALOGS.AngleCopyFailure.getKey());
            return null;
        }
        return new CrossSliceAngleMeasurement(view, angleOverlay);
    }

    private static AngleOverlay getOverlayToCopy(View view) {
        ViewMouseHandler viewMouseHandler;
        if (view.getMouseHandler() instanceof ViewMouseHandler && (viewMouseHandler = (ViewMouseHandler)view.getMouseHandler()).getActivePO() instanceof AngleOverlay) {
            return (AngleOverlay)viewMouseHandler.getActivePO();
        }
        return null;
    }

    public boolean paste(View view) {
        String string = null;
        IImageInformation iImageInformation = view.getImageInformation();
        ViewMouseHandler viewMouseHandler = (ViewMouseHandler)this.sourceView.getMouseHandler();
        if (viewMouseHandler.roiCreationInProgress() && this.sourceAngleOverlay.equals(viewMouseHandler.getActivePO())) {
            string = "CreationStillInProgress";
        } else if (!this.sourceDisplaySet.equals(view.getDisplayData().getDisplaySet())) {
            string = "WrongDisplaySet";
        } else if (this.sourceImageInformation.getRows() != iImageInformation.getRows()) {
            string = "WrongImageSize";
        } else if (this.sourceImageInformation.getColumns() != iImageInformation.getColumns()) {
            string = "WrongImageSize";
        } else if (!DisplayLocalizerInfo.isParallel(this.sourceImageInformation.getPlaneNormalUV(), iImageInformation.getPlaneNormalUV())) {
            string = "SlicesNotParallel";
        } else {
            PresentationObject presentationObject = view.copyPresentationObject(this.sourceAngleOverlay, OverlaySynchronizationMode.IMAGE_COORDINATES);
            view.getMouseHandler().setBackgroundForPriorityHandle(presentationObject);
            view.invalidate();
            return true;
        }
        CrossSliceAngleMeasurement.showPasteWarningDialog(String.valueOf(Messages.getString("CrossSliceAngleMeasurement.PasteFailure.BasicMessage")) + Messages.getString("CrossSliceAngleMeasurement.PasteFailure." + string));
        return false;
    }

    public static void showPasteWarningDialog(String string) {
        HideableDialogFactory.showWarningDialog((Component)JVision2.getMainFrame(), string, Config.impaxee.jvision.DIALOGS.AnglePasteFailure.getKey());
    }
}

