/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayDataWriter;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.OverlayFrame;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.PaddedOverlayDataFactory;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.Shutter;
import javax.vecmath.Vector2d;

public class BinBMPShutter
extends Shutter {
    byte[] fullMask;
    int mwidth;
    int mheight;
    int xo;
    int yo;
    ImageState ist;
    boolean displayOutline;

    private BinBMPShutter() {
    }

    public BinBMPShutter(int n, OverlayFrame overlayFrame) {
        this(n, overlayFrame, Shutter.displayOutline);
    }

    public BinBMPShutter(int n, OverlayFrame overlayFrame, boolean bl) {
        super(n);
        this.displayOutline = bl;
        this.setCompressedMask(overlayFrame);
        if (bl) {
            this.markBorder();
        }
    }

    private void markBorder() {
        int n = this.mheight;
        int n2 = 1;
        while (n2 < this.mheight - 1) {
            ++n;
            int n3 = 1;
            while (n3 < this.mwidth - 1) {
                try {
                    if (this.fullMask[n] != 0 && (this.fullMask[n - 1] == 0 || this.fullMask[n + 1] == 0 || this.fullMask[n - this.mwidth] == 0 || this.fullMask[n + this.mwidth] == 0)) {
                        this.fullMask[n] = 127;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.fullMask[n] = 127;
                }
                ++n;
                ++n3;
            }
            ++n;
            ++n2;
        }
    }

    public void setCompressedMask(byte[] byArray, int n, int n2, int n3, int n4) {
        this.fullMask = new byte[n * n2];
        this.fullMask = BinBMPShutter.convert1To8ByteArray(byArray, n2, n, this.fullMask);
        this.mwidth = n;
        this.mheight = n2;
        this.xo = n3;
        this.yo = n4;
    }

    public void setCompressedMask(OverlayFrame overlayFrame) {
        int n = overlayFrame.getWidth();
        int n2 = overlayFrame.getHeight();
        this.fullMask = new byte[n * n2];
        overlayFrame.getOverlayData().renderTo(0, 0, (Object)this.fullMask, n, 1);
        this.mwidth = n;
        this.mheight = n2;
        this.xo = overlayFrame.getOrigX();
        this.yo = overlayFrame.getOrigY();
    }

    @Override
    public void update(PresentationObject presentationObject) {
        this.ist = presentationObject.getImageState();
    }

    @Override
    public void applyShutter(Object object, int n, int n2) {
        block25: {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            block23: {
                block24: {
                    Vector2d vector2d = new Vector2d(this.ist.cv[0], this.ist.cv[1]);
                    vector2d.normalize();
                    Vector2d vector2d2 = new Vector2d(this.ist.rv[0], this.ist.rv[1]);
                    vector2d2.normalize();
                    n11 = (int)((this.ist.visOrig[0] - vector2d.x * (double)(this.xo - 1) - vector2d2.x * (double)(this.yo - 1)) * 256.0);
                    n10 = (int)((this.ist.visOrig[1] - vector2d.y * (double)(this.xo - 1) - vector2d2.y * (double)(this.yo - 1)) * 256.0);
                    n9 = (int)(this.ist.rv[0] * 256.0);
                    n8 = (int)(this.ist.rv[1] * 256.0);
                    n7 = (int)(this.ist.cv[0] * 256.0);
                    n6 = (int)(this.ist.cv[1] * 256.0);
                    n5 = this.mwidth * 256;
                    n4 = this.mheight * 256;
                    n3 = 0;
                    if (!Shutter.displayOutline) break block23;
                    if (!(object instanceof int[])) break block24;
                    int n12 = shutterOutlineColor.getRGB();
                    int[] nArray = (int[])object;
                    int n13 = 0;
                    while (n13 < n2) {
                        int n14 = n11 + n9 * n13;
                        int n15 = n10 + n8 * n13;
                        int n16 = 0;
                        while (n16 < n) {
                            if (n14 < 0 || n15 < 0 || n14 >= n5 || n15 >= n4) {
                                nArray[n3] = this.shutterValue;
                            } else {
                                byte by = this.fullMask[(n14 >> 8) + (n15 >> 8) * this.mwidth];
                                if (by == 127) {
                                    nArray[n3] = n12;
                                } else if (by == 1) {
                                    nArray[n3] = this.shutterValue;
                                }
                            }
                            ++n3;
                            n14 += n7;
                            n15 += n6;
                            ++n16;
                        }
                        ++n13;
                    }
                    break block25;
                }
                if (!(object instanceof byte[])) break block25;
                int n17 = 127;
                byte[] byArray = (byte[])object;
                int n18 = -1;
                int n19 = 0;
                while (n19 < n2) {
                    int n20 = n11 + n9 * n19;
                    int n21 = n10 + n8 * n19;
                    int n22 = 0;
                    while (n22 < n) {
                        if (n20 < 0 || n21 < 0 || n20 >= n5 || n21 >= n4) {
                            byArray[n3] = n18;
                        } else {
                            byte by = this.fullMask[(n20 >> 8) + (n21 >> 8) * this.mwidth];
                            if (by == 127) {
                                byArray[n3] = n17;
                            } else if (by == 1) {
                                byArray[n3] = n18;
                            }
                        }
                        ++n3;
                        n20 += n7;
                        n21 += n6;
                        ++n22;
                    }
                    ++n19;
                }
                break block25;
            }
            if (object instanceof int[]) {
                int[] nArray = (int[])object;
                int n23 = 0;
                while (n23 < n2) {
                    int n24 = n11 + n9 * n23;
                    int n25 = n10 + n8 * n23;
                    int n26 = 0;
                    while (n26 < n) {
                        if (n24 < 0 || n25 < 0 || n24 >= n5 || n25 >= n4 || this.fullMask[(n24 >> 8) + (n25 >> 8) * this.mwidth] != 0) {
                            nArray[n3] = this.shutterValue;
                        }
                        ++n3;
                        n24 += n7;
                        n25 += n6;
                        ++n26;
                    }
                    ++n23;
                }
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                byte by = (byte)this.shutterValue;
                int n27 = 0;
                while (n27 < n2) {
                    int n28 = n11 + n9 * n27;
                    int n29 = n10 + n8 * n27;
                    int n30 = 0;
                    while (n30 < n) {
                        if (n28 < 0 || n29 < 0 || n28 >= n5 || n29 >= n4 || this.fullMask[(n28 >> 8) + (n29 >> 8) * this.mwidth] != 0) {
                            byArray[n3] = by;
                        }
                        ++n3;
                        n28 += n7;
                        n29 += n6;
                        ++n30;
                    }
                    ++n27;
                }
            }
        }
    }

    public OverlayFrame getOverlayFrame() {
        IOverlayDataWriter iOverlayDataWriter;
        PaddedOverlayDataFactory paddedOverlayDataFactory = new PaddedOverlayDataFactory();
        IOverlayData iOverlayData = null;
        int n = this.mwidth * this.mheight;
        if (this.fullMask.length == n) {
            iOverlayDataWriter = paddedOverlayDataFactory.createOverlayDataWriter();
            iOverlayDataWriter.start();
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.mheight) {
                int n4 = 0;
                while (n4 < this.mwidth) {
                    iOverlayDataWriter.setBit(this.fullMask[n2] & 1);
                    ++n2;
                    ++n4;
                }
                iOverlayDataWriter.nextLine();
                ++n3;
            }
            iOverlayDataWriter.end();
            iOverlayData = iOverlayDataWriter.getOverlayData(this.mwidth, this.mheight);
        } else {
            iOverlayData = paddedOverlayDataFactory.createOverlayData(this.fullMask, this.mwidth, this.mheight, 0);
        }
        iOverlayDataWriter = new OverlayFrame(null, -1);
        iOverlayDataWriter.setOverlayData(this.xo, this.yo, this.mwidth, this.mheight, iOverlayData);
        return iOverlayDataWriter;
    }

    @Override
    public Shutter clone() {
        BinBMPShutter binBMPShutter = new BinBMPShutter();
        binBMPShutter.getFieldsFrom(this);
        return binBMPShutter;
    }

    protected void getFieldsFrom(BinBMPShutter binBMPShutter) {
        this.fullMask = (byte[])binBMPShutter.fullMask.clone();
        this.ist = binBMPShutter.ist;
        this.mwidth = binBMPShutter.mwidth;
        this.mheight = binBMPShutter.mheight;
        this.xo = binBMPShutter.xo;
        this.yo = binBMPShutter.yo;
    }
}

