/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.agfa.pacs.math.GeomUtil;
import com.tiani.jvision.overlay.AbstractDoubleLineOverlay;
import com.tiani.jvision.overlay.AbstractRegionSpacingOverlay;
import com.tiani.jvision.overlay.IOverlayInformation;
import com.tiani.jvision.overlay.OverlayInformation;
import com.tiani.jvision.overlay.OverlayInformationID;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;

public class BidimensionalLengthOverlay
extends AbstractDoubleLineOverlay {
    private int txi;
    private int tyi;
    private double length1;
    private double length2;

    public BidimensionalLengthOverlay() {
        super(TianiSubType.BidimensionalLength, AbstractRegionSpacingOverlay.ImageRegionSpacingMode.ENABLED_EQUAL_PIXEL_SPACING);
        this.setEditable(!Product.isCDViewer());
    }

    public BidimensionalLengthOverlay(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, AnnotationUnits annotationUnits) {
        super(TianiSubType.BidimensionalLength, AbstractRegionSpacingOverlay.ImageRegionSpacingMode.ENABLED_EQUAL_PIXEL_SPACING, d, d2, d3, d4, d5, d6, d7, d8, annotationUnits);
        this.setEditable(!Product.isCDViewer());
    }

    @Override
    public boolean isROI() {
        return true;
    }

    private double roundValueAsDisplayed(double d) {
        if (d > 100.0) {
            return Math.round(d);
        }
        return (double)Math.round(d * 10.0) / 10.0;
    }

    @Override
    protected double calculateMeasurementResult() {
        this.length1 = this.calculateLength(this.p, this.pxi, this.pyi, this.q, this.qxi, this.qyi);
        this.length2 = this.calculateLength(this.r, this.rxi, this.ryi, this.s, this.sxi, this.syi);
        if (this.length1 == 0.0 || Double.isNaN(this.length1) || this.length2 == 0.0 || Double.isNaN(this.length2)) {
            return 0.0;
        }
        return this.roundValueAsDisplayed(this.length1) * this.roundValueAsDisplayed(this.length2);
    }

    @Override
    List<IOverlayInformation> updateAnnotation() {
        OverlayInformation overlayInformation = new OverlayInformation(OverlayInformationID.MANDATORY, Messages.getString("BidimensionalLengthOverlay.DescriptionLength1"), this.length1, this.dimensionUnit());
        OverlayInformation overlayInformation2 = new OverlayInformation(OverlayInformationID.MANDATORY, Messages.getString("BidimensionalLengthOverlay.DescriptionLength2"), this.length2, this.dimensionUnit());
        OverlayInformation overlayInformation3 = new OverlayInformation(OverlayInformationID.MANDATORY, Messages.getString("BidimensionalLengthOverlay.DescriptionProduct"), this.getMeasurementResult(), String.valueOf(this.dimensionUnit()) + "2");
        ArrayList<IOverlayInformation> arrayList = new ArrayList<IOverlayInformation>(3);
        arrayList.add(overlayInformation);
        arrayList.add(overlayInformation2);
        arrayList.add(overlayInformation3);
        return arrayList;
    }

    private double[] getPointForPerpendicularLine(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double[] dArray5 = this.toScreen(dArray);
        double[] dArray6 = this.toScreen(dArray2);
        double[] dArray7 = this.toScreen(dArray3);
        double[] dArray8 = this.toScreen(dArray4);
        double d = dArray6[0] - dArray5[0];
        double d2 = dArray6[1] - dArray5[1];
        double d3 = dArray8[0] + d;
        double d4 = dArray8[1] + d2;
        Vector2d vector2d = new Vector2d(dArray8[0], dArray8[1]);
        Vector2d vector2d2 = new Vector2d(d3, d4);
        double d5 = dArray7[0] - d2;
        double d6 = dArray7[1] + d;
        Vector2d vector2d3 = new Vector2d(dArray7[0], dArray7[1]);
        Vector2d vector2d4 = new Vector2d(d5, d6);
        Vector2d vector2d5 = GeomUtil.intersectLineAndLine2D((Tuple2d)vector2d, (Tuple2d)vector2d2, (Tuple2d)vector2d3, (Tuple2d)vector2d4);
        double[] dArray9 = new double[]{vector2d5.x, vector2d5.y};
        return this.toImage(dArray9);
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder) {
        if (!this.isCompleted() && this.txi != 0 && this.tyi != 0) {
            Stroke stroke = bufferedImageHolder.graphics.getStroke();
            bufferedImageHolder.graphics.setStroke(AUXILIARY_LINE_STROKE);
            bufferedImageHolder.graphics.drawLine(this.txi, this.tyi, this.sxi, this.syi);
            bufferedImageHolder.graphics.setStroke(stroke);
        }
        super.paintShape(bufferedImageHolder);
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        if (this.isCompleted()) {
            switch (n) {
                case 0: {
                    this.s = this.getPointForPerpendicularLine(dArray, this.q, this.r, this.s);
                    break;
                }
                case 1: {
                    this.r = this.getPointForPerpendicularLine(this.p, dArray, this.s, this.r);
                    break;
                }
                case 2: {
                    this.s = this.getPointForPerpendicularLine(this.p, this.q, dArray, this.s);
                    break;
                }
                case 3: {
                    this.r = this.getPointForPerpendicularLine(this.p, this.q, dArray, this.r);
                }
            }
        } else if (n == 3) {
            double[] dArray2 = this.toScreen(dArray);
            this.txi = (int)dArray2[0];
            this.tyi = (int)dArray2[1];
            dArray = this.getPointForPerpendicularLine(this.p, this.q, this.r, dArray);
        }
        super.handleInteraction(n, dArray);
    }

    @Override
    void onTranslation(double d, double d2) {
    }

    @Override
    void paintAdditionalConnections(BufferedImageHolder bufferedImageHolder) {
    }
}

