/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.overlay;

import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.base.data.ImageRegion;
import com.tiani.jvision.overlay.IAreaOverlay;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.IOverlayPointModifier;
import com.tiani.jvision.overlay.ITransformableOverlay;
import com.tiani.jvision.overlay.OverlayTransformationException;
import com.tiani.jvision.overlay.OverlayTransformationUtils;
import com.tiani.jvision.overlay.PresentationHandle;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ReferencedObjectsCloning;
import com.tiani.jvision.overlay.StatisticsPresentationObject;
import com.tiani.jvision.overlay.TextOverlay;
import com.tiani.jvision.overlay.TranslationHandle;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AxisAlignedEllipseOverlay
extends StatisticsPresentationObject
implements IGraphicObjectContainer,
IAreaOverlay {
    protected double[] m;
    protected double r1;
    protected double r2;
    protected int[] xc;
    protected int[] yc;
    protected ImageRegion ir = new ImageRegion(this);
    boolean nonEditableAnnotationEnabled = true;

    public AxisAlignedEllipseOverlay() {
        super("Ellipse");
        this.m = new double[2];
        this.m[1] = 0.0;
        this.m[0] = 0.0;
        this.r1 = 1.0;
        this.r2 = 1.0;
    }

    public AxisAlignedEllipseOverlay(double d, double d2, double d3, double d4, AnnotationUnits annotationUnits, boolean bl) {
        this();
        this.setSolid(bl);
        this.m[0] = d;
        this.m[1] = d2;
        this.r1 = d3 / 2.0;
        this.r2 = d4 / 2.0;
        this.setSpacing(annotationUnits);
        this.makeHandles();
    }

    @Override
    public void initPlacement(int n, int n2, AnnotationUnits annotationUnits, boolean bl, boolean bl2) {
        super.initPlacement(n, n2, annotationUnits, bl, bl2);
        this.makeHandles();
    }

    @Override
    public boolean isROI() {
        return true;
    }

    protected void makeHandles() {
        this.handles = new PresentationHandle[5];
        this.handles[0] = new PresentationHandle(0, 0);
        this.handles[1] = new PresentationHandle(0, 0);
        this.handles[2] = new PresentationHandle(0, 0);
        this.handles[3] = new PresentationHandle(0, 0);
        this.handles[4] = new TranslationHandle(0, 0);
        this.translationHandleIndex = 4;
    }

    protected void mkPolyline() {
        double[] dArray = new double[]{this.m[0] - this.r1, this.m[1] - this.r2};
        dArray = this.toScreen(dArray);
        int n = (int)dArray[0];
        int n2 = (int)dArray[1];
        dArray[0] = this.m[0] + this.r1;
        dArray[1] = this.m[1] - this.r2;
        dArray = this.toScreen(dArray);
        int n3 = (int)dArray[0];
        int n4 = (int)dArray[1];
        dArray[0] = this.m[0] + this.r1;
        dArray[1] = this.m[1] + this.r2;
        dArray = this.toScreen(dArray);
        int n5 = (int)dArray[0];
        int n6 = (int)dArray[1];
        dArray[0] = this.m[0] - this.r1;
        dArray[1] = this.m[1] + this.r2;
        dArray = this.toScreen(dArray);
        int n7 = (int)dArray[0];
        int n8 = (int)dArray[1];
        this.handles[0].setPosition((n + n3) / 2, (n2 + n4) / 2);
        this.handles[1].setPosition((n5 + n7) / 2, (n6 + n8) / 2);
        this.handles[2].setPosition((n + n7) / 2, (n2 + n8) / 2);
        this.handles[3].setPosition((n5 + n3) / 2, (n6 + n4) / 2);
        this.handles[4].setPosition((n5 + n) / 2, (n6 + n2) / 2);
        this.bounds.x = Math.min(Math.min(n, n3), Math.min(n5, n7)) - PresentationHandle.HANDLE_SIZE;
        this.bounds.y = Math.min(Math.min(n2, n4), Math.min(n6, n8)) - PresentationHandle.HANDLE_SIZE;
        this.bounds.width = Math.max(Math.max(n, n3), Math.max(n5, n7)) - Math.min(Math.min(n, n3), Math.min(n5, n7)) + 2 * PresentationHandle.HANDLE_SIZE;
        this.bounds.height = Math.max(Math.max(n2, n4), Math.max(n6, n8)) - Math.min(Math.min(n2, n4), Math.min(n6, n8)) + 2 * PresentationHandle.HANDLE_SIZE;
        double d = Math.sqrt((n - n7) * (n - n7) + (n2 - n8) * (n2 - n8));
        double d2 = Math.sqrt((n - n3) * (n - n3) + (n2 - n4) * (n2 - n4));
        double d3 = Math.PI * (3.0 * d + 3.0 * d2 - Math.sqrt((d + 3.0 * d2) * (d2 + 3.0 * d)));
        double[] dArray2 = new double[]{this.m[0], this.m[1]};
        int n9 = Math.max(10, (int)(d3 / 10.0));
        if (this.xc == null || this.xc.length != n9) {
            this.xc = new int[n9];
            this.yc = new int[n9];
        }
        int n10 = 0;
        while (n10 < n9) {
            dArray2[0] = this.m[0] + this.r1 * Math.cos(Math.PI * 2 / (double)(n9 - 1) * (double)n10);
            dArray2[1] = this.m[1] + this.r2 * Math.sin(Math.PI * 2 / (double)(n9 - 1) * (double)n10);
            dArray2 = this.toScreen(dArray2);
            this.xc[n10] = (int)dArray2[0];
            this.yc[n10] = (int)dArray2[1];
            ++n10;
        }
    }

    @Override
    protected void toScreen() {
        this.mkPolyline();
    }

    @Override
    public double getArea() {
        return Math.PI * this.r1 * this.r2 * this.getDataPixelSizeX() * this.getDataPixelSizeY();
    }

    @Override
    public void paintShape(BufferedImageHolder bufferedImageHolder, boolean bl) {
        if (bl) {
            if (bufferedImageHolder.graphics.getComposite() instanceof AlphaComposite) {
                bufferedImageHolder.graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            bufferedImageHolder.graphics.fillPolygon(this.xc, this.yc, this.xc.length);
            Color color = bufferedImageHolder.graphics.getColor();
            bufferedImageHolder.graphics.setColor(solidOutlineColor);
            bufferedImageHolder.graphics.drawPolygon(this.xc, this.yc, this.xc.length);
            bufferedImageHolder.graphics.setColor(color);
            bufferedImageHolder.graphics.setPaintMode();
        } else {
            if (this.isUseOutlineFont()) {
                bufferedImageHolder.graphics.setColor(Color.black);
                int n = 1;
                while (n < this.xc.length) {
                    if (this.xc[n] != this.xc[n - 1] && Math.abs(this.yc[n] - this.yc[n - 1]) / Math.abs(this.xc[n] - this.xc[n - 1]) < 1) {
                        bufferedImageHolder.graphics.drawLine(this.xc[n - 1], this.yc[n - 1] - 1, this.xc[n], this.yc[n] - 1);
                        bufferedImageHolder.graphics.drawLine(this.xc[n - 1], this.yc[n - 1] + 1, this.xc[n], this.yc[n] + 1);
                    } else {
                        bufferedImageHolder.graphics.drawLine(this.xc[n - 1] - 1, this.yc[n - 1], this.xc[n] - 1, this.yc[n]);
                        bufferedImageHolder.graphics.drawLine(this.xc[n - 1] + 1, this.yc[n - 1], this.xc[n] + 1, this.yc[n]);
                    }
                    ++n;
                }
                bufferedImageHolder.graphics.setColor(this.objCol);
            }
            bufferedImageHolder.graphics.drawPolygon(this.xc, this.yc, this.xc.length);
        }
    }

    @Override
    protected void handleInteraction(int n, double[] dArray) {
        switch (n) {
            case 0: 
            case 1: {
                this.r2 = Math.abs(dArray[1] - this.m[1]);
                this.toScreen();
                if (this.isCompleted()) break;
            }
            case 2: 
            case 3: {
                this.r1 = Math.abs(dArray[0] - this.m[0]);
                this.toScreen();
                break;
            }
            case 4: {
                this.m = (double[])dArray.clone();
                this.toScreen();
                break;
            }
            case 5: {
                this.handleDragged(1, dArray);
                this.handleDragged(2, dArray);
            }
        }
        this.setSaved(false);
    }

    @Override
    protected int setPoint(int n, double[] dArray) {
        TextOverlay textOverlay;
        int n2 = n;
        switch (n) {
            case 1: {
                this.handleDragged(4, dArray);
                ++n2;
                break;
            }
            case 2: {
                this.activeHandleIndex = 5;
                ++n2;
                break;
            }
            case 3: {
                this.handleDragged(5, dArray);
                n2 = -1;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        if (n2 == -1 && (textOverlay = this.createAnnotation()) != null) {
            textOverlay.setVisible(AxisAlignedEllipseOverlay.getTextAnnotationLevel().isTextAnnotationVisible());
        }
        return n2;
    }

    @Override
    protected TextOverlay createAnnotation() {
        return this.makeAnnotation(90, "ROI");
    }

    @Override
    public boolean supportsHistogram() {
        return true;
    }

    @Override
    public boolean isInside(int n, int n2) {
        return 1.0 / (this.r1 * this.r1) * ((double)n - this.m[0]) * ((double)n - this.m[0]) + 1.0 / (this.r2 * this.r2) * ((double)n2 - this.m[1]) * ((double)n2 - this.m[1]) <= 1.0;
    }

    @Override
    public List<GraphicObject> storeROI() {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>(1);
        double[] dArray = new double[]{this.m[0] - this.r1, this.m[1]};
        double[] dArray2 = new double[]{this.m[0] + this.r1, this.m[1]};
        double[] dArray3 = new double[]{this.m[0], this.m[1] - this.r2};
        double[] dArray4 = new double[]{this.m[0], this.m[1] + this.r2};
        GraphicObject graphicObject = this.createGraphicObject();
        graphicObject.setGraphicType(GraphicType.Ellipse);
        graphicObject.setNumberOfGraphicPoints(Integer.valueOf(4));
        graphicObject.setGraphicData(new float[]{(float)dArray[0], (float)dArray[1], (float)dArray2[0], (float)dArray2[1], (float)dArray3[0], (float)dArray3[1], (float)dArray4[0], (float)dArray4[1]});
        arrayList.add(graphicObject);
        return arrayList;
    }

    @Override
    public PresentationObject cloneAll() {
        PresentationObject presentationObject = null;
        try {
            presentationObject = (PresentationObject)this.clone();
            presentationObject.shapeChanged = true;
            super.cloneReferences(presentationObject);
            AxisAlignedEllipseOverlay axisAlignedEllipseOverlay = (AxisAlignedEllipseOverlay)presentationObject;
            axisAlignedEllipseOverlay.ir = new ImageRegion(axisAlignedEllipseOverlay);
            axisAlignedEllipseOverlay.setClonedParameters(ReferencedObjectsCloning.clone(this.m), ReferencedObjectsCloning.clone(this.xc), ReferencedObjectsCloning.clone(this.yc));
        }
        catch (Exception exception) {
            log.error("clone error", (Throwable)exception);
        }
        return presentationObject;
    }

    public void setClonedParameters(double[] dArray, int[] nArray, int[] nArray2) {
        this.m = dArray;
        this.xc = nArray;
        this.yc = nArray2;
    }

    @Override
    public void updateOverlayPoints(ITransformableOverlay iTransformableOverlay, IOverlayPointModifier iOverlayPointModifier) throws OverlayTransformationException {
        AxisAlignedEllipseOverlay axisAlignedEllipseOverlay = (AxisAlignedEllipseOverlay)iTransformableOverlay;
        boolean bl = DoubleEquals.equals((double)axisAlignedEllipseOverlay.r1, (double)axisAlignedEllipseOverlay.r2);
        this.m = iOverlayPointModifier.convert(axisAlignedEllipseOverlay.m);
        this.r1 = OverlayTransformationUtils.updateLength(iOverlayPointModifier, axisAlignedEllipseOverlay.r1, 0, bl);
        this.r2 = OverlayTransformationUtils.updateLength(iOverlayPointModifier, axisAlignedEllipseOverlay.r2, 1, bl);
    }

    public double[] getParameters() {
        double[] dArray = new double[]{this.m[0], this.m[1], this.r1, this.r2};
        return dArray;
    }

    protected void createBoundingShape() {
        this.toScreen();
        Polygon polygon = new Polygon(this.xc, this.yc, this.xc.length);
        if (!this.isSolid()) {
            int n = this.xc.length - 1;
            while (n >= 0) {
                polygon.addPoint(this.xc[n], this.yc[n]);
                --n;
            }
        }
        this.outBounds = Collections.singletonList(polygon);
    }

    @Override
    public boolean inBounds(int n, int n2) {
        boolean bl = false;
        if (this.isSelected()) {
            bl = this.isHandleClicked(n, n2);
        }
        if (!bl) {
            this.createBoundingShape();
            return super.inBounds(n, n2);
        }
        return bl;
    }

    public void enableNonEditableAnnotation(boolean bl) {
        this.nonEditableAnnotationEnabled = bl;
    }
}

