/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main.windowing.gui;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.tiani.jvision.main.windowing.WindowingValue;
import com.tiani.jvision.main.windowing.WindowingValueList;
import com.tiani.jvision.main.windowing.WindowingValuesManager;
import com.tiani.jvision.main.windowing.gui.WindowingValuesTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellEditor;

public class WindowingValuesPanel
extends JPanel {
    private static final String ITEMS_KEY = "items";
    protected static final String CATEGORY_KEY = "category";
    protected static final String NAME_KEY = "name";
    private static final String CENTER_KEY = "center";
    private static final String WIDTH_KEY = "width";
    private WindowingValuesTable table;
    private JScrollPane listScroller;
    private JSpinner spinnerCenter = ComponentFactory.instance.createSpinner(new SpinnerNumberModel(new Integer(1), null, null, new Integer(1)));
    private JSpinner spinnerWidth = ComponentFactory.instance.createSpinner(new SpinnerNumberModel(new Integer(1), new Integer(0), null, new Integer(1)));
    private JComboBox name;
    private WindowingValueList valuesList;

    public WindowingValuesPanel(WindowingValueList windowingValueList, int n) {
        this(windowingValueList);
        this.table.changeSelection(n, 1, false, false);
    }

    public WindowingValuesPanel(WindowingValueList windowingValueList) {
        this.valuesList = windowingValueList;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        WindowingValuesTableModel windowingValuesTableModel = new WindowingValuesTableModel(windowingValueList);
        this.table = new WindowingValuesTable();
        this.table.setModel(windowingValuesTableModel);
        this.table.setSelectionMode(0);
        this.listScroller = ComponentFactory.instance.createScrollPane(this.table);
        jPanel.add((Component)this.listScroller, "Center");
        jPanel.setBorder(ComponentFactory.instance.createTitledBorder(Messages.getString("WINDOWINGVALUES_LABEL_USER_VALUES")));
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(ComponentFactory.instance.createTitledBorder(Messages.getString("WINDOWINGVALUES_LABEL_CUSTOM")));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jPanel3.add(ComponentFactory.instance.createLabel(Messages.getString("WINDOWINGVALUES_LABEL_NAME")));
        jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
        this.name = ComponentFactory.instance.createComboBox(this.getPredefinedWindowingValues());
        this.name.addActionListener(new ComboBoxAction());
        this.name.setSelectedIndex(-1);
        jPanel3.add(this.name);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jPanel4.add(ComponentFactory.instance.createLabel(Messages.getString("WINDOWINGVALUES_LABEL_CENTER")));
        jPanel4.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel4.add(this.spinnerCenter);
        jPanel4.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel4.add(ComponentFactory.instance.createLabel(Messages.getString("WINDOWINGVALUES_LABEL_WIDTH")));
        jPanel4.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel4.add(this.spinnerWidth);
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        JButton jButton = ComponentFactory.instance.createButton(new ButtonResetAction());
        jPanel5.add(jButton);
        jPanel2.add(jPanel5);
        jPanel5.setAlignmentX(0.0f);
        jPanel4.setAlignmentX(0.0f);
        jPanel3.setAlignmentX(0.0f);
        this.add((Component)jPanel2, "South");
    }

    private Vector<WindowingValue> getPredefinedWindowingValues() {
        Vector<WindowingValue> vector = new Vector<WindowingValue>();
        IConfigurationList iConfigurationList = Config.impaxee.jvision.windowingTree.getList();
        for (Map.Entry entry : iConfigurationList.getChildrenItems().entrySet()) {
            if (!((IConfigurationProvider)entry.getValue()).exists(CATEGORY_KEY)) continue;
            IConfigurationList iConfigurationList2 = ((IConfigurationProvider)entry.getValue()).getList(ITEMS_KEY);
            for (Map.Entry entry2 : iConfigurationList2.getChildrenItems().entrySet()) {
                if (!((IConfigurationProvider)entry2.getValue()).exists(NAME_KEY) || !((IConfigurationProvider)entry2.getValue()).exists(CENTER_KEY) || !((IConfigurationProvider)entry2.getValue()).exists(WIDTH_KEY)) continue;
                String string = ((IConfigurationProvider)entry2.getValue()).getString(NAME_KEY);
                Long l = ((IConfigurationProvider)entry2.getValue()).getLong(CENTER_KEY);
                Long l2 = ((IConfigurationProvider)entry2.getValue()).getLong(WIDTH_KEY);
                WindowingValue windowingValue = new WindowingValue(string, l.intValue(), l2.intValue());
                vector.add(windowingValue);
            }
        }
        return vector;
    }

    private void commitEdit(JSpinner jSpinner) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            try {
                defaultEditor.commitEdit();
            }
            catch (ParseException parseException) {}
        }
    }

    private void storeValuesTo(WindowingValue windowingValue) {
        this.commitEdit(this.spinnerCenter);
        this.commitEdit(this.spinnerWidth);
        windowingValue.setCenter((Integer)this.spinnerCenter.getValue());
        windowingValue.setWidth((Integer)this.spinnerWidth.getValue());
    }

    public void saveCurrentlySelected() {
        int n = this.table.getSelectedRow();
        if (n > -1) {
            TableCellEditor tableCellEditor = this.table.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            WindowingValue windowingValue = this.valuesList.getValue(n);
            this.storeValuesTo(windowingValue);
        }
    }

    private WindowingValue getSelectedWindowingValue() {
        int n = this.table.getSelectedRow();
        if (n > -1) {
            return this.valuesList.getValue(n);
        }
        return null;
    }

    private class ButtonResetAction
    extends AbstractAction {
        public ButtonResetAction() {
            super(Messages.getString("WINDOWINGVALUES_BUTTONLABEL_RESET"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = WindowingValuesPanel.this.table.getSelectedRow();
            if (n == -1) {
                return;
            }
            WindowingValuesManager.instance.resetWindowingValues(n);
            WindowingValue windowingValue = (WindowingValue)WindowingValuesPanel.this.table.getModel().getValueAt(n, 1);
            WindowingValuesPanel.this.table.revalidate();
            WindowingValuesPanel.this.table.repaint();
            WindowingValuesPanel.this.name.setSelectedItem(null);
            WindowingValuesPanel.this.spinnerCenter.setValue(windowingValue.getCenter());
            WindowingValuesPanel.this.spinnerWidth.setValue(windowingValue.getWidth() < 0 ? -windowingValue.getWidth() : windowingValue.getWidth());
        }
    }

    private class ComboBoxAction
    extends AbstractAction {
        private ComboBoxAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WindowingValue windowingValue = (WindowingValue)WindowingValuesPanel.this.name.getSelectedItem();
            if (windowingValue == null) {
                return;
            }
            WindowingValuesPanel.this.spinnerCenter.setValue(windowingValue.getCenter());
            WindowingValuesPanel.this.spinnerWidth.setValue(windowingValue.getWidth() < 0 ? -windowingValue.getWidth() : windowingValue.getWidth());
            WindowingValue windowingValue2 = WindowingValuesPanel.this.getSelectedWindowingValue();
            if (!windowingValue2.isNameSpecifiedByUser()) {
                windowingValue2.setName(windowingValue.getName());
                WindowingValuesPanel.this.table.repaint();
            }
        }
    }

    private class WindowingValuesTable
    extends JTable {
        private WindowingValue lastSelectedWindowingValue;

        public WindowingValuesTable() {
            ComponentFactory.instance.scaleFont(this);
            ComponentFactory.instance.scaleFont(this.getTableHeader());
            this.setRowHeight(GUI.getScaledDiagnosticInt((int)this.getRowHeight()));
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            WindowingValue windowingValue = (WindowingValue)this.getModel().getValueAt(this.getSelectedRow(), 1);
            if (this.lastSelectedWindowingValue != null) {
                WindowingValuesPanel.this.storeValuesTo(this.lastSelectedWindowingValue);
            }
            WindowingValuesPanel.this.name.setSelectedItem(null);
            WindowingValuesPanel.this.spinnerCenter.setValue(windowingValue.getCenter());
            WindowingValuesPanel.this.spinnerWidth.setValue(windowingValue.getWidth() < 0 ? -windowingValue.getWidth() : windowingValue.getWidth());
            WindowingValuesPanel.this.name.setSelectedItem(windowingValue);
            this.lastSelectedWindowingValue = windowingValue;
            super.valueChanged(listSelectionEvent);
        }
    }
}

