/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main;

import com.agfa.integration.IntegrationFrameworkFactory;
import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.StartupLFCheckpoint;
import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.core.IApplicationManagement;
import com.agfa.pacs.data.dicom.comm.DicomCFindConst;
import com.agfa.pacs.data.hw.manager.InputStreamDicomDataReader;
import com.agfa.pacs.data.shared.pixel.decoder.PixelDataDecoderFactory;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.IUndoInformation;
import com.agfa.pacs.event.ListenerSynchronizationFactory;
import com.agfa.pacs.impaxee.ImpaxEEUtils;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.PerformanceProfiler;
import com.agfa.pacs.impaxee.User;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.PActionUsageTracker;
import com.agfa.pacs.impaxee.attributefilter.AttributeFilterRegistry;
import com.agfa.pacs.impaxee.attributefilter.NestedAttributeFilter;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.descriptors.Descriptor;
import com.agfa.pacs.impaxee.descriptors.DescriptorRegistry;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.gui.UnsavedHangingsManager;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHangingScreen;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingProtocol;
import com.agfa.pacs.impaxee.hanging.model.xml.ReferencedDescriptor;
import com.agfa.pacs.impaxee.hanging.model.xml.Snapshot;
import com.agfa.pacs.impaxee.hanging.registry.HPRegistry;
import com.agfa.pacs.impaxee.sortorders.registry.CustomSortOrderRegistry;
import com.agfa.pacs.impaxee.splitsort.model.xml.ConditionalSortDisplaySetsCriterion;
import com.agfa.pacs.impaxee.splitsort.model.xml.ConditionalSortImagesCriterion;
import com.agfa.pacs.impaxee.splitsort.model.xml.ConditionalSplitCriterion;
import com.agfa.pacs.impaxee.splitsort.model.xml.SortField;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitField;
import com.agfa.pacs.impaxee.splitsort.registry.SplitSortRegistry;
import com.agfa.pacs.impaxee.tagdictionary.PrivateTagMapper;
import com.agfa.pacs.listtext.lta.base.shutdown.ShutdownType;
import com.agfa.pacs.listtext.lta.base.shutdown.ShutdownUtil;
import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.agfa.pacs.listtext.lta.store.StoreUtils;
import com.agfa.pacs.listtext.lta.util.DicomTagDictionaryFactory;
import com.agfa.pacs.listtext.setaside.SetAsideManager;
import com.agfa.pacs.listtext.swingx.controls.IMessageDialogVisualizer;
import com.agfa.pacs.listtext.swingx.util.SwingWorker;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.security.permission.Permissions;
import com.tiani.config.LayoutConfig;
import com.tiani.gui.controls.hotregion.PopupHotRegion;
import com.tiani.gui.dialog.GUIMessageHandler;
import com.tiani.jvision.keypress.KeypressRegistry;
import com.tiani.jvision.main.DeprecatedConfigKeyWatcher;
import com.tiani.jvision.main.IApplicationLifecycleListener;
import com.tiani.jvision.main.MainFrame2;
import com.tiani.jvision.main.StatisticsUtil;
import com.tiani.jvision.overlay.demographics.Demographics;
import com.tiani.jvision.overlay.demographics.Mapping;
import com.tiani.jvision.overlay.demographics.QuadMapping;
import com.tiani.jvision.patinfo.SeqLabelMapping;
import com.tiani.jvision.vis.VisHRSetDefault;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.dcm4che3.data.Tag;
import org.dcm4che3.util.TagUtils;

public class JVision2
implements IEventListener {
    private static final ALogger logger = ALogger.getLogger(JVision2.class);
    private static final long start = System.currentTimeMillis();
    private static JVision2 instance = null;
    private static MainFrame2 mainFrame = null;
    private static IApplicationManagement applicationManagement;
    private static IEventListenerProvider<IEventListener> prov;
    private static IEventEngine eEngine;
    private static Vector<IApplicationLifecycleListener> lifeCycleListeners;
    private UnsavedHangingsManager unsavedData;
    private IListenerSynchronization sync = ListenerSynchronizationFactory.getInstance();

    static {
        prov = null;
        eEngine = EventEngineFactory.getInstance();
        lifeCycleListeners = new Vector();
    }

    public static MainFrame2 getMainFrame() {
        return mainFrame;
    }

    public static String getProductIDString() {
        return "ImpaxEE v20";
    }

    public static void initInstance(String string) {
        applicationManagement = ApplicationManagement.getInstance();
        StartupLFCheckpoint.waitForLF();
        instance = new JVision2(string);
        logger.info("Started in " + (System.currentTimeMillis() - start) + " millis.");
        JVision2.logSystemProperties();
        DeprecatedConfigKeyWatcher.logDeprecatedConfigKeys();
        applicationManagement.waitForTermination();
    }

    public static boolean showTitleBar() {
        return Config.impaxee.jvision.MAIN.ShowTitlebar.get() || Product.isReducedVersion();
    }

    private static void logSystemProperties() {
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        StringBuilder stringBuilder = new StringBuilder();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("sun.java2d.") && !string.startsWith("sun.awt.")) continue;
            stringBuilder.append(String.valueOf(string) + " = " + properties.getProperty(string));
            stringBuilder.append(',');
        }
        logger.info(stringBuilder.toString());
    }

    public static JVision2 getInstance() {
        return instance;
    }

    void setUnsavedData(UnsavedHangingsManager unsavedHangingsManager) {
        this.unsavedData = unsavedHangingsManager;
    }

    private void exitInternal() {
        PerformanceProfiler.getInstance().closeFile();
        List<IStoreHandler> list = this.unsavedData == null ? null : this.unsavedData.getStoreHandlers();
        StoreUtils.awaitStore(list);
        for (IApplicationLifecycleListener iApplicationLifecycleListener : lifeCycleListeners) {
            try {
                iApplicationLifecycleListener.applicationShutdown();
            }
            catch (Exception exception) {
                logger.error("Shutdown hook error", (Throwable)exception);
            }
        }
        if (!Product.isHeadless()) {
            KeypressRegistry.getInstance().save();
            if (Permissions.getInstance().isAllowed("ImageArea/AllowedToEditHangingProtocols") || Permissions.getInstance().isAllowed("Configuration/ImageArea/HangingProtocols")) {
                try {
                    HPRegistry.getInstance().save();
                    SplitSortRegistry.getInstance().save();
                    DescriptorRegistry.getInstance().save();
                    CustomSortOrderRegistry.saveIfExists();
                }
                catch (Exception exception) {
                    ALogger.getLogger(JVision2.class).error("Error on saving HP/Split/Sorts", (Throwable)exception);
                }
            }
            try {
                PActionUsageTracker.exportUsageStatistics();
                StatisticsUtil.sendStatisticsToServer(PerformanceProfiler.buildXmlString(), "Agility/performancestatistics");
            }
            catch (IOException iOException) {
                logger.error("IO Statistics exception", (Throwable)iOException);
            }
            EventUtil.invokeSynchronous((Runnable)new Runnable(){

                @Override
                public void run() {
                    JVision2.exitAWT();
                }
            });
        }
    }

    private static void exitAWT() {
        JVision2.getMainFrame().shutdownPending();
        boolean bl = false;
        try {
            bl = Boolean.parseBoolean(System.getProperty("jumpstart"));
        }
        catch (Exception exception) {}
        if (mainFrame != null && bl) {
            if (Config.impaxee.jvision.DISPLAY.ClearMainFrameOnHide.get()) {
                for (VisScreen2 visScreen2 : JVision2.getMainFrame().getScreens()) {
                    if (visScreen2 == null) continue;
                    visScreen2.clear();
                }
            }
            mainFrame.setVisible(false);
        }
    }

    public JVision2(String string) {
        logger.info("Working directory: " + System.getProperty("user.dir"));
        logger.info("Locale: " + Locale.getDefault());
        logger.info("Welcome " + User.getUserName());
        eEngine = EventEngineFactory.getInstance();
        prov = eEngine.createListenerProvider((IEventListener)this);
        eEngine.register(prov, "application.management");
        PerformanceProfiler.getInstance();
        if (!Product.isHeadless()) {
            EventUtil.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    Toolkit.getDefaultToolkit().getSystemEventQueue().push(new MainFrame2.MainEventQueue());
                    JVision2.this.createGUI();
                }
            });
        }
        instance = this;
    }

    public static void computeScaling() {
        if (!Product.isHeadless()) {
            LayoutConfig layoutConfig = LayoutConfig.getInstance();
            Dimension dimension = new Dimension(layoutConfig.getScreenWidth(), layoutConfig.getScreenHeight());
            GUI.computeDiagnosticScalingFactor((Dimension)dimension, (boolean)Config.impaxee.workstation.MONITORS.ScalingEnabled.get(), (double)Config.impaxee.workstation.MONITORS.ScalingFactor.get());
        }
    }

    private void createGUI() {
        Message.pushMessageHandler(GUIMessageHandler.getInstance());
        boolean bl = !JVision2.showTitleBar();
        int n = bl ? 1 : 0;
        int n2 = bl ? 1 : 0;
        LayoutConfig layoutConfig = LayoutConfig.getInstance();
        mainFrame = new MainFrame2(layoutConfig);
        mainFrame.setStartSettingLocationX(layoutConfig.getImageAreaX() + n);
        mainFrame.setStartSettingLocationY(layoutConfig.getImageAreaY() + n2);
        mainFrame.setStartSettingSizeW(layoutConfig.getImageAreaWidth() - 2 * n);
        mainFrame.setStartSettingSizeH(layoutConfig.getImageAreaHeight() - 2 * n2);
        mainFrame.setBounds(mainFrame.getStartSettingLocationX(), mainFrame.getStartSettingLocationY(), mainFrame.getStartSettingSizeWidth(), mainFrame.getStartSettingSizeHeight());
        JVision2.computeScaling();
        if (!Product.isCDViewer()) {
            IntegrationFrameworkFactory.getInstance().start(false);
        }
        KeypressRegistry.getInstance().init();
        QuadMapping.registerMappings();
        PopupHotRegion.setGlobalMaxSize(layoutConfig.getScreenWidth() / 2 - 50, layoutConfig.getImageAreaHeight() - 50);
        mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JVision2.this.exit();
            }
        });
        mainFrame.setDefaultCloseOperation(0);
        mainFrame.setLytMode(MainLayoutType.variable, (int)Config.impaxee.jvision.STARTUP.MainLayoutCols.get(), (int)Config.impaxee.jvision.STARTUP.MainLayoutRows.get(), false);
        mainFrame.installTopToolbar();
        if (!Product.isHeadless()) {
            mainFrame.setVisible(true);
            mainFrame.checkDisplayRequirements();
            mainFrame.logMonitorData();
        }
        mainFrame.initDone();
        ImpaxEEUtils.showFolder();
        this.prepareLoading();
        this.initSetAside();
        AbstractPAction.notifyNonPActionPerformed("IMPAXEE_START");
    }

    private void initSetAside() {
        final SetAsideManager setAsideManager = SetAsideManager.getInstance();
        setAsideManager.setMessageDialogVisualizer((IMessageDialogVisualizer)GUIMessageHandler.getInstance());
        if (setAsideManager.enabled() && setAsideManager.serviceable()) {
            try {
                final SetAsideManager.SetAsideContext setAsideContext = SetAsideManager.SetAsideContext.createInstance((Component)mainFrame);
                boolean bl = setAsideManager.available(setAsideContext);
                if (bl) {
                    if (setAsideManager.isOutdated(setAsideContext)) {
                        try {
                            logger.info("Set-aside status outdated!");
                            setAsideManager.delete(setAsideContext, false, false);
                        }
                        catch (Exception exception) {
                            logger.warn("Deleting outdated set-aside status failed!");
                        }
                    } else {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                if (JVision2.this.isSetAsideLoadEnabled()) {
                                    try {
                                        try {
                                            CursorUtil.setWaitCursor((Component)mainFrame);
                                            setAsideManager.restore(setAsideContext);
                                        }
                                        catch (Exception exception) {
                                            logger.error("Restoring available set-aside status failed! Skipped", (Throwable)exception);
                                            CursorUtil.resetWaitCursor((Component)mainFrame);
                                        }
                                    }
                                    finally {
                                        CursorUtil.resetWaitCursor((Component)mainFrame);
                                    }
                                } else if (JVision2.this.isSetAsideDeleteEnabled()) {
                                    try {
                                        try {
                                            CursorUtil.setWaitCursor((Component)mainFrame);
                                            setAsideManager.delete(setAsideContext, true, true);
                                        }
                                        catch (Exception exception) {
                                            logger.error("Deleting set-aside status failed! Skipped", (Throwable)exception);
                                            CursorUtil.resetWaitCursor((Component)mainFrame);
                                        }
                                    }
                                    finally {
                                        CursorUtil.resetWaitCursor((Component)mainFrame);
                                    }
                                }
                            }
                        };
                        if (setAsideManager.isReadyToUse()) {
                            runnable.run();
                        } else {
                            new SetAsideSwingWorker(runnable).start();
                        }
                    }
                }
            }
            catch (Exception exception) {
                logger.error("Restoring available set-aside status failed! Skipped", (Throwable)exception);
            }
        }
    }

    boolean isSetAsideLoadEnabled() {
        return this.isSetAsideEnabled("Load");
    }

    boolean isSetAsideDeleteEnabled() {
        return this.isSetAsideEnabled("Delete");
    }

    private boolean isSetAsideEnabled(String string) {
        if (Product.isRunningAutoTests()) {
            return Boolean.getBoolean("test.setaside.auto" + string.toLowerCase(Locale.ENGLISH) + ".enabled");
        }
        return Message.yesNo(Messages.getString("SetAsideDialog.Title." + string), Messages.getString("SetAsideDialog.Message." + string)) == 0;
    }

    private void prepareLoading() {
        new PrepareLoadingThread().start();
    }

    public void exit() {
        ShutdownUtil.exit((IComponentFactory)ComponentFactory.instance, (Component)JVision2.getMainFrame(), (boolean)false, (ShutdownType)ShutdownType.REGULAR);
    }

    public IListenerSynchronization getSync() {
        return this.sync;
    }

    public boolean handleEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
        if (iEvent.getEventID() == ApplicationManagement.APP_PREPARE_SHUTDOWN) {
            this.exitInternal();
        }
        return false;
    }

    public boolean handleUndoEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
        return false;
    }

    public static void addLifecycleListener(IApplicationLifecycleListener iApplicationLifecycleListener) {
        lifeCycleListeners.add(iApplicationLifecycleListener);
    }

    private static class PrepareLoadingThread
    extends Thread {
        public PrepareLoadingThread() {
            super("Prepare loading");
            this.setDaemon(true);
            this.setPriority(1);
        }

        @Override
        public void run() {
            TagDictionary.getInstance();
            HPRegistry.getInstance();
            DescriptorRegistry.getInstance();
            SplitSortRegistry.getInstance();
            AttributeFilterRegistry.getInstance();
            PixelDataDecoderFactory.getInstance();
            PrivateTagMapper.getInstance();
            this.findRequiredTags();
            VisHRSetDefault.preloadIcons();
            JVision2.getMainFrame().getPluginToolbox();
            logger.info("Maximum number of cursor colors:" + Toolkit.getDefaultToolkit().getMaximumCursorColors());
            logger.info("Finished loading preparation");
        }

        private void findRequiredTags() {
            Object object;
            int n;
            int n2;
            Object object22;
            HashSet<Descriptor> hashSet = new HashSet<Descriptor>();
            HashSet<Object> hashSet2 = new HashSet<Object>();
            for (HangingProtocol object52 : HPRegistry.getInstance().getActiveHangingProtocolsForCurrentRole()) {
                object22 = object52.getHangingApplicability().hangingConditions();
                n2 = ((HangingCondition[])object22).length;
                int n3 = 0;
                while (n3 < n2) {
                    HangingCondition hangingCondition2 = object22[n3];
                    ReferencedDescriptor[] referencedDescriptorArray = hangingCondition2.referencedDescriptors();
                    n = referencedDescriptorArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        object = referencedDescriptorArray[n4];
                        hashSet.add(((ReferencedDescriptor)((Object)object)).referencedDescriptor());
                        ++n4;
                    }
                    ++n3;
                }
                object22 = object52.getHangingDefinition().snapshots();
                n2 = ((Snapshot[])object22).length;
                n3 = 0;
                while (n3 < n2) {
                    HangingCondition hangingCondition3 = object22[n3];
                    object = ((Snapshot)((Object)hangingCondition3)).getConditionalHanging();
                    if (object != null) {
                        for (ConditionalHangingScreen conditionalHangingScreen : object.screens()) {
                            for (DisplaySetCondition displaySetCondition2 : conditionalHangingScreen.displaySetConditions()) {
                                ReferencedDescriptor[] referencedDescriptorArray = displaySetCondition2.referencedDescriptors();
                                int n5 = referencedDescriptorArray.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    ReferencedDescriptor referencedDescriptor = referencedDescriptorArray[n6];
                                    hashSet.add(referencedDescriptor.referencedDescriptor());
                                    ++n6;
                                }
                            }
                        }
                    }
                    ++n3;
                }
            }
            for (ConditionalSplitCriterion conditionalSplitCriterion : SplitSortRegistry.getInstance().getSplitAndSort().conditionalSplitCriteria()) {
                object22 = conditionalSplitCriterion.referencedDescriptors();
                n2 = ((ReferencedDescriptor[])object22).length;
                int n7 = 0;
                while (n7 < n2) {
                    HangingCondition hangingCondition4 = object22[n7];
                    hashSet.add(((ReferencedDescriptor)((Object)hangingCondition4)).referencedDescriptor());
                    ++n7;
                }
                for (SplitField splitField : conditionalSplitCriterion.splitFields()) {
                    hashSet2.add(splitField.getTag());
                }
                for (SplitField splitField : conditionalSplitCriterion.elseSplitFields()) {
                    hashSet2.add(splitField.getTag());
                }
            }
            for (ConditionalSortDisplaySetsCriterion conditionalSortDisplaySetsCriterion : SplitSortRegistry.getInstance().getSplitAndSort().conditionalSortDisplaySetsCriteria()) {
                object22 = conditionalSortDisplaySetsCriterion.referencedDescriptors();
                n2 = ((ReferencedDescriptor[])object22).length;
                int n8 = 0;
                while (n8 < n2) {
                    HangingCondition hangingCondition5 = object22[n8];
                    hashSet.add(((ReferencedDescriptor)((Object)hangingCondition5)).referencedDescriptor());
                    ++n8;
                }
                for (SortField sortField : conditionalSortDisplaySetsCriterion.sortFields()) {
                    hashSet2.add(sortField.getTag());
                }
                for (SortField sortField : conditionalSortDisplaySetsCriterion.elseSortFields()) {
                    hashSet2.add(sortField.getTag());
                }
            }
            for (ConditionalSortImagesCriterion conditionalSortImagesCriterion : SplitSortRegistry.getInstance().getSplitAndSort().conditionalSortImagesCriteria()) {
                object22 = conditionalSortImagesCriterion.referencedDescriptors();
                n2 = ((ReferencedDescriptor[])object22).length;
                int n9 = 0;
                while (n9 < n2) {
                    HangingCondition hangingCondition6 = object22[n9];
                    hashSet.add(((ReferencedDescriptor)((Object)hangingCondition6)).referencedDescriptor());
                    ++n9;
                }
                for (SortField sortField : conditionalSortImagesCriterion.sortFields()) {
                    hashSet2.add(sortField.getTag());
                }
                for (SortField sortField : conditionalSortImagesCriterion.elseSortFields()) {
                    hashSet2.add(sortField.getTag());
                }
            }
            for (Descriptor descriptor : hashSet) {
                for (Condition condition : descriptor.conditions()) {
                    hashSet2.add(condition.getTag());
                }
            }
            for (Demographics demographics2 : SeqLabelMapping.getDemographics()) {
                object22 = demographics2.getTagEntriesAtTopLeft();
                n2 = ((Mapping.ITagEntry[])object22).length;
                int n10 = 0;
                while (n10 < n2) {
                    HangingCondition hangingCondition7 = object22[n10];
                    object = hangingCondition7.getTag();
                    if (object != null) {
                        hashSet2.add(object);
                    }
                    ++n10;
                }
            }
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                if (!PrivateTagDictionary.isPrivateTag((int)((Integer)iterator.next()))) continue;
                iterator.remove();
            }
            AttributeFilterRegistry attributeFilterRegistry = AttributeFilterRegistry.getInstance();
            HashSet<Object> hashSet3 = new HashSet<Object>();
            HashSet<Integer> hashSet4 = new HashSet<Integer>();
            for (DicomTag dicomTag : attributeFilterRegistry.getInstanceDicomTags()) {
                if (hashSet2.contains(dicomTag.getNumber())) {
                    if (TagUtils.isPrivateGroup((int)dicomTag.getNumber())) {
                        InputStreamDicomDataReader.addRequiredPrivateTag((int)dicomTag.getNumber());
                    }
                    hashSet3.add(dicomTag.getNumber());
                    hashSet2.remove(dicomTag.getNumber());
                }
                if (!NestedAttributeFilter.containsRootTag(dicomTag.getNumber())) continue;
                hashSet2.removeAll(NestedAttributeFilter.getNestedTags(dicomTag.getNumber()));
            }
            for (DicomTag dicomTag : attributeFilterRegistry.getSeriesDicomTags()) {
                if (!hashSet2.contains(dicomTag.getNumber())) continue;
                if (TagUtils.isPrivateGroup((int)dicomTag.getNumber())) {
                    InputStreamDicomDataReader.addRequiredPrivateTag((int)dicomTag.getNumber());
                }
                hashSet4.add(dicomTag.getNumber());
                hashSet2.remove(dicomTag.getNumber());
            }
            for (DicomTag dicomTag : attributeFilterRegistry.getStudyDicomTags()) {
                hashSet2.remove(dicomTag.getNumber());
            }
            for (DicomTag dicomTag : attributeFilterRegistry.getPatientDicomTags()) {
                hashSet2.remove(dicomTag.getNumber());
            }
            if (Product.isCDViewer()) {
                hashSet3.addAll(hashSet2);
                hashSet2.clear();
            }
            DicomCFindConst.setRequiredTags(hashSet3, hashSet4);
            if (!hashSet2.isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (Object object22 : hashSet2) {
                    stringBuffer.append(TagUtils.toHexString((int)((Integer)object22))).append(',');
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                object22 = URLProviderFactory.getProvider().getLoginInformation().getRole();
                logger.error("Hanging Protocols,Split and Sort and Series Demographics contains invalid tag (not contained in Blob!):" + stringBuffer.toString());
                if (object22 == null || ((String)object22).toUpperCase().contains("ADMIN")) {
                    Message.error("Not recognized dicom tags in configuration", (Object)("HP Configuration, Split & Sort or Series Demographics contains invalid tags:" + stringBuffer.toString()));
                }
            }
            if (logger.isDebugEnabled() || System.getProperty("config.role") != null) {
                object22 = new HashMap(512);
                Field[] fieldArray = Tag.class.getFields();
                n = fieldArray.length;
                int n11 = 0;
                while (n11 < n) {
                    object = fieldArray[n11];
                    try {
                        Integer n12 = ((Field)object).getInt(null);
                        if (n12 != null) {
                            object22.put(n12, ((Field)object).getName());
                        }
                    }
                    catch (Exception exception) {}
                    ++n11;
                }
                logger.debug("Series Tags:");
                int n13 = 0;
                while (n13 < DicomCFindConst.SERIES_TAGS.length) {
                    logger.debug(String.valueOf(TagUtils.toString((int)DicomCFindConst.SERIES_TAGS[n13])) + " " + this.getTagName(DicomCFindConst.SERIES_TAGS[n13], (Map<Integer, String>)object22));
                    ++n13;
                }
                HashSet<Integer> hashSet5 = new HashSet<Integer>();
                n11 = 0;
                while (n11 < DicomCFindConst.SERIES_NESTED_TAGS.length) {
                    int n14 = DicomCFindConst.SERIES_NESTED_TAGS[n11][0];
                    if (hashSet5.add(n14)) {
                        logger.debug(String.valueOf(TagUtils.toString((int)n14)) + " " + this.getTagName(n14, (Map<Integer, String>)object22));
                    }
                    ++n11;
                }
                logger.debug("Image Tags:");
                n11 = 0;
                while (n11 < DicomCFindConst.IMAGE_TAGS.length) {
                    logger.debug(String.valueOf(TagUtils.toString((int)DicomCFindConst.IMAGE_TAGS[n11])) + " " + this.getTagName(DicomCFindConst.IMAGE_TAGS[n11], (Map<Integer, String>)object22));
                    ++n11;
                }
            }
        }

        private String getTagName(int n, Map<Integer, String> map) {
            String string = map.get(n);
            if (string != null) {
                return string;
            }
            return DicomTagDictionaryFactory.getLocaleDictionary().getNameForTag(n);
        }
    }

    private static class SetAsideSwingWorker
    extends SwingWorker {
        private final Runnable runnable;

        SetAsideSwingWorker(Runnable runnable) {
            this.runnable = runnable;
        }

        public Object construct() {
            logger.info("Waiting for Set Aside initialization ...");
            while (!SetAsideManager.getInstance().isReadyToUse()) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return null;
        }

        public void finished() {
            this.runnable.run();
        }
    }
}

