/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main;

import com.agfa.pacs.data.shared.code.MammoCode;
import com.agfa.pacs.impaxee.hanging.impl.MammoCREvaluation;
import com.agfa.pacs.listtext.dicomobject.type.ImageType;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.ImageInformation2;
import java.util.Set;
import java.util.regex.Pattern;
import org.dcm4che3.data.Attributes;
import org.jfree.util.Log;

public enum DisplaySetType {
    NONE(""),
    PRIMARY,
    LOCALIZER,
    SECONDARY_CAPTURE,
    CT_MPR("MPR"),
    CTA_ARTERIAL("ARTERIAL"),
    CTA_PORTAL_VEIN("PORTALVEIN"),
    CTA_VEIN("VEIN"),
    ML,
    MLO,
    CC,
    LM,
    LMO,
    FB,
    SIO,
    ISO,
    XCCL,
    XCCM,
    XCC,
    T1,
    T2,
    PD,
    DWI,
    ADC,
    FLAIR,
    STIR,
    AP,
    PA,
    LL,
    RL,
    RLO,
    LLO;

    public static final Pattern LATERAL_LEGACY_DETECTION;
    public static final Pattern AP_LEGACY_DETECTION;
    public static final Pattern PA_LEGACY_DETECTION;
    private static final int LONG_TR = 750;
    private static final int SHORT_TR = 500;
    private static final int SHORT_TE = 30;
    private static final int VERY_SHORT_TE = 15;
    private static final int FLAIR_INVERSION = 1500;
    private static final int STIR_INVERSION = 200;
    private String value;

    static {
        LATERAL_LEGACY_DETECTION = Pattern.compile("LAT", 2);
        AP_LEGACY_DETECTION = Pattern.compile("AP", 2);
        PA_LEGACY_DETECTION = Pattern.compile("PA", 2);
    }

    private DisplaySetType(String string2) {
        this.value = string2;
    }

    private DisplaySetType() {
        this.value = this.name();
    }

    public String getValue() {
        return this.value;
    }

    public static DisplaySetType getDisplaySetType(IImageInformation iImageInformation) {
        Set<ImageType> set = iImageInformation.getImageType();
        if (iImageInformation.getImageClass() == IImageInformation.ImageClass.MG || ImageInformation2.isTomosynthesisImage(iImageInformation)) {
            MammoCode mammoCode = MammoCode.getMammoCode((Attributes)iImageInformation.getDataset());
            if (mammoCode != null) {
                return DisplaySetType.valueOf(mammoCode.getViewCode());
            }
        } else if (iImageInformation.getImageClass() == IImageInformation.ImageClass.CR) {
            String string;
            if (MammoCREvaluation.getInstance().isMammoImage(iImageInformation)) {
                return MammoCREvaluation.getInstance().getDisplaySetType(iImageInformation);
            }
            String string2 = iImageInformation.getDataset().getString(1593601);
            if (string2 != null) {
                try {
                    return DisplaySetType.valueOf(string2);
                }
                catch (Exception exception) {
                    Log.debug((Object)"Could not detect CR Type", (Exception)exception);
                }
            }
            if ((string = iImageInformation.getDataset().getString(528446)) != null) {
                if (LATERAL_LEGACY_DETECTION.matcher(string).matches()) {
                    return LL;
                }
                if (AP_LEGACY_DETECTION.matcher(string).matches()) {
                    return AP;
                }
                if (PA_LEGACY_DETECTION.matcher(string).matches()) {
                    return PA;
                }
            }
        } else if (iImageInformation.getImageClass() == IImageInformation.ImageClass.MR) {
            if (set.contains(ImageType.ADC)) {
                return ADC;
            }
            Double d = iImageInformation.getDiffusionBValue();
            if (d != null && d != 0.0) {
                return DWI;
            }
            Double d2 = iImageInformation.getRepetitionTime();
            Double d3 = iImageInformation.getEchoTime();
            if (d2 != null && d3 != null) {
                DisplaySetType displaySetType = d2 >= 750.0 ? (d3 < 30.0 ? PD : T2) : (d2 > 500.0 ? (d3 <= 15.0 ? T1 : T2) : T1);
                if (displaySetType == T2) {
                    Double d4 = iImageInformation.getInversionTime();
                    if (d4 != null && d4 > 1500.0) {
                        return FLAIR;
                    }
                    if (d4 != null && d4 < 200.0) {
                        return STIR;
                    }
                }
                return displaySetType;
            }
        }
        if (set.contains(ImageType.LOCALIZER)) {
            return LOCALIZER;
        }
        if (set.contains(ImageType.MPR) || set.contains(ImageType.REFORMATTED) || set.contains(ImageType.REFORMATED)) {
            return CT_MPR;
        }
        if (set.contains(ImageType.SECONDARY) || iImageInformation.getImageClass() == IImageInformation.ImageClass.SC) {
            return SECONDARY_CAPTURE;
        }
        if (set.contains(ImageType.PRIMARY) && set.contains(ImageType.ORIGINAL)) {
            return PRIMARY;
        }
        return NONE;
    }
}

