/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.logging.ALogger;

public class DeprecatedConfigKeyWatcher {
    private static final ALogger log = ALogger.getLogger(DeprecatedConfigKeyWatcher.class);
    private static final String DEPRECATED_CONFIG_KEY = "DEPRECATED_CONFIG_KEY_";

    public static void logDeprecatedConfigKeys() {
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        if (!iConfigurationProvider.getList("impaxee.jvision.GAMMALUT").isEmpty()) {
            DeprecatedConfigKeyWatcher.logAndClearListKey(iConfigurationProvider, "impaxee.jvision.GAMMALUT");
        }
        if (iConfigurationProvider.exists("impaxee.jvision.SYNCHRONIZE.AutoSyncSameOrientation") && !iConfigurationProvider.getBoolean("impaxee.jvision.SYNCHRONIZE.AutoSyncSameOrientation")) {
            DeprecatedConfigKeyWatcher.logAndRemoveKey(iConfigurationProvider, "impaxee.jvision.SYNCHRONIZE.AutoSyncSameOrientation");
        }
    }

    private static void logAndClearListKey(IConfigurationProvider iConfigurationProvider, String string) {
        log.warn("Deprecated config key '" + string + "' found!");
        iConfigurationProvider.getList(string).clear();
        AbstractPAction.notifyNonPActionPerformed(DEPRECATED_CONFIG_KEY + string);
        log.warn("Cleared deprecated config list key '" + string + "'. (But it may be inherited from an upper level again!)");
    }

    private static void logAndRemoveKey(IConfigurationProvider iConfigurationProvider, String string) {
        log.warn("Deprecated config key '" + string + "' found!");
        iConfigurationProvider.removeValue(string);
        AbstractPAction.notifyNonPActionPerformed(DEPRECATED_CONFIG_KEY + string);
        log.warn("Removed deprecated config key '" + string + "'. (But it may be inherited from an upper level again!)");
    }
}

