/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.keypress.gui;

import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.tiani.jvision.keypress.ShortcutBlock;
import com.tiani.jvision.keypress.gui.ActionTreePanel;
import com.tiani.util.message.Message;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTextField;

public class ShortcutListener
implements KeyListener {
    static final int NONE = 0;
    static final int CTRL = 1;
    static final int ALT = 2;
    static final int SHIFT = 4;
    private JTextField txt;
    private int modifiers = 0;
    private KeyEvent lastPressEvent;
    private List<ShortcutBlock> blocks = null;
    private String originalShortcut;
    private ActionTreePanel panel;

    public ShortcutListener(JTextField jTextField, ActionTreePanel actionTreePanel) {
        this.txt = jTextField;
        this.panel = actionTreePanel;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.lastPressEvent = null;
        this.setControl(keyEvent.isControlDown());
        this.setAlt(keyEvent.isAltDown());
        this.setShift(keyEvent.isShiftDown());
        switch (keyEvent.getKeyCode()) {
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 16: {
                break;
            }
            case 32: {
                if (keyEvent.getModifiers() == 0 && !ModifierKeys.disableFastImageInteraction) break;
            }
            case 27: {
                if (keyEvent.getModifiers() == 0) {
                    return;
                }
            }
            default: {
                this.lastPressEvent = keyEvent;
            }
        }
        keyEvent.consume();
        this.txt.setText(this.getString());
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 17: {
                if (this.lastPressEvent != null) break;
                this.setControl(false);
                break;
            }
            case 18: {
                if (this.lastPressEvent != null) break;
                this.setAlt(false);
                break;
            }
            case 16: {
                if (this.lastPressEvent != null) break;
                this.setShift(false);
                break;
            }
            case 32: {
                if (keyEvent.getModifiers() != 0 || ModifierKeys.disableFastImageInteraction) break;
                return;
            }
        }
        keyEvent.consume();
        LinkedList<PAction> linkedList = new LinkedList<PAction>();
        if (this.blocks != null && this.lastPressEvent != null) {
            for (ShortcutBlock object : this.blocks) {
                PAction pAction = object.isOccupied(this.lastPressEvent.getKeyCode(), this.lastPressEvent.getModifiers());
                if (pAction == null) continue;
                linkedList.add(pAction);
            }
        }
        if (!linkedList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(512);
            stringBuilder.append(String.valueOf(Messages.getString("ShortcutListener.KeysOccupied")) + "\n");
            for (Object object3 : linkedList) {
                stringBuilder.append(object3.getName()).append("\n");
            }
            stringBuilder.append(Messages.getString("ShortcutListener.Continue"));
            int n = Message.yesNo(stringBuilder);
            if (n == 1) {
                this.txt.setText(this.originalShortcut);
                return;
            }
            for (ShortcutBlock shortcutBlock : this.blocks) {
                for (PAction pAction : linkedList) {
                    shortcutBlock.removeShortcutForAction(pAction);
                }
            }
        }
        this.txt.setText(this.getString());
        this.panel.handleChange();
    }

    public void setShortcutScope(List<ShortcutBlock> list) {
        this.blocks = list;
        this.originalShortcut = this.txt.getText();
    }

    public int getResultModifier() {
        if (this.lastPressEvent != null) {
            return this.lastPressEvent.getModifiers();
        }
        return 0;
    }

    public int getResultKeyCode() {
        if (this.lastPressEvent != null) {
            return this.lastPressEvent.getKeyCode();
        }
        return 0;
    }

    private void setControl(boolean bl) {
        if (this.isControl() == bl) {
            return;
        }
        this.modifiers = bl ? (this.modifiers |= 1) : (this.modifiers ^= 1);
    }

    private void setAlt(boolean bl) {
        if (this.isAlt() == bl) {
            return;
        }
        this.modifiers = bl ? (this.modifiers |= 2) : (this.modifiers ^= 2);
    }

    private void setShift(boolean bl) {
        if (this.isShift() == bl) {
            return;
        }
        this.modifiers = bl ? (this.modifiers |= 4) : (this.modifiers ^= 4);
    }

    private boolean isControl() {
        return (this.modifiers & 1) != 0;
    }

    private boolean isAlt() {
        return (this.modifiers & 2) != 0;
    }

    private boolean isShift() {
        return (this.modifiers & 4) != 0;
    }

    private String getString() {
        String string = "";
        String string2 = "";
        string = this.getModifierString();
        string2 = this.getKeyString();
        return String.valueOf(string) + string2;
    }

    private String getModifierString() {
        if (this.modifiers == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isControl()) {
            stringBuilder.append(KeyEvent.getKeyText(17)).append("+");
        }
        if (this.isAlt()) {
            stringBuilder.append(KeyEvent.getKeyText(18)).append("+");
        }
        if (this.isShift()) {
            stringBuilder.append(KeyEvent.getKeyText(16)).append("+");
        }
        return stringBuilder.toString();
    }

    private String getKeyString() {
        if (this.lastPressEvent == null) {
            return "";
        }
        String string = KeyEvent.getKeyText(this.lastPressEvent.getKeyCode());
        return string;
    }
}

