/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.keypress.gui;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.security.permission.Permissions;
import com.tiani.jvision.keypress.ShortCut;
import com.tiani.jvision.keypress.ShortcutBlock;
import com.tiani.jvision.keypress.gui.ActionTree;
import com.tiani.jvision.keypress.gui.ActionsDlg;
import com.tiani.jvision.keypress.gui.ShortcutListener;
import com.tiani.jvision.plugin.PluginName;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class ActionTreePanel
extends JPanel
implements TreeSelectionListener {
    ActionTree tree;
    private JScrollPane treeScroller;
    private JPanel treePanel = new JPanel();
    private JPanel descriptionPanel = new JPanel();
    private JPanel shortcutPanel = new JPanel();
    private JTextField textFieldShortcut;
    private JTextField textFieldSearch;
    private boolean editShortcuts;
    private JToggleButton btnEditShortcut;
    private JButton btnResetShortcut;
    private JButton btnRemoveShortcut;
    private PAction selectedAction;
    private ShortCut selectedShortcut;
    private ShortcutListener listener;
    private JTextArea txtDescription;
    private JScrollPane txtDescriptionScroller;
    private boolean modified = false;

    public ActionTreePanel(ShortcutBlock shortcutBlock, Map<PluginName, ShortcutBlock> map, IComponentFactory iComponentFactory) {
        Object object;
        TableLayout tableLayout = new TableLayout(new double[]{-1.0}, new double[]{-1.0, -2.0, -2.0});
        this.setLayout((LayoutManager)tableLayout);
        this.editShortcuts = Permissions.getInstance().isAllowed("ImageArea/AllowToEditShortCuts");
        this.tree = new ActionTree(shortcutBlock, map, iComponentFactory);
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 8: 
                    case 127: {
                        ActionTreePanel.this.removeSelectedShortcut();
                    }
                }
            }
        });
        this.treeScroller = iComponentFactory.createScrollPane((Component)this.tree);
        this.treePanel.setBorder(iComponentFactory.createTitledBorder(Messages.getString("ACTIONS_LABEL_ACTIONS")));
        this.treePanel.setLayout(new BorderLayout());
        this.textFieldSearch = iComponentFactory.createTextField();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("ActionTreePanel.Search")) + ":"), "West");
        jPanel.add((Component)this.textFieldSearch, "Center");
        jPanel.setOpaque(false);
        this.textFieldSearch.addKeyListener(this.tree);
        this.treePanel.add((Component)jPanel, "North");
        this.treePanel.add((Component)this.treeScroller, "Center");
        this.add((Component)this.treePanel, "0,0");
        this.descriptionPanel.setBorder(iComponentFactory.createTitledBorder(Messages.getString("ACTIONS_LABEL_DESCRIPTION")));
        this.descriptionPanel.setLayout(new BorderLayout());
        this.txtDescription = iComponentFactory.createTextArea();
        this.txtDescription.setLineWrap(true);
        this.txtDescription.setWrapStyleWord(true);
        this.txtDescription.setEditable(false);
        Border border = this.txtDescription.getBorder();
        Insets insets = border.getBorderInsets(this.txtDescription);
        this.txtDescription.setBorder(BorderFactory.createEmptyBorder(0, insets.left, 0, insets.right));
        this.txtDescription.setOpaque(false);
        Color color = this.txtDescription.getForeground();
        Color color2 = this.txtDescription.getBackground();
        this.txtDescription.setForeground(color2);
        this.txtDescription.setBackground(color);
        this.txtDescription.setRows(2);
        this.txtDescriptionScroller = iComponentFactory.createScrollPane((Component)this.txtDescription);
        this.descriptionPanel.add((Component)this.txtDescriptionScroller, "Center");
        this.add((Component)this.descriptionPanel, "0,1");
        if (this.editShortcuts) {
            this.textFieldShortcut = iComponentFactory.createTextField();
            this.shortcutPanel.setBorder(iComponentFactory.createTitledBorder(Messages.getString("ACTIONS_LABEL_SHORTCUTS")));
            this.shortcutPanel.setLayout(new BorderLayout());
            this.shortcutPanel.add((Component)this.textFieldShortcut, "Center");
            this.textFieldShortcut.setEditable(false);
            this.listener = new ShortcutListener(this.textFieldShortcut, this);
            object = iComponentFactory.createPanel((LayoutManager)new GridBagLayout());
            ((JComponent)object).setOpaque(false);
            this.btnRemoveShortcut = iComponentFactory.createButton((Action)new RemoveShortcut());
            this.btnEditShortcut = iComponentFactory.createToggleButton((Action)new EditShortcut());
            this.btnResetShortcut = iComponentFactory.createButton((Action)new ResetShortcut());
            this.btnResetShortcut.setEnabled(false);
            this.btnEditShortcut.setEnabled(false);
            this.btnRemoveShortcut.setEnabled(false);
            this.addComponent((JPanel)object, 0, 0, 1, this.btnRemoveShortcut);
            this.addComponent((JPanel)object, 1, 0, 1, this.btnEditShortcut);
            this.addComponent((JPanel)object, 2, 0, 1, this.btnResetShortcut);
            this.shortcutPanel.add((Component)object, "East");
            this.add((Component)this.shortcutPanel, "0, 2");
        }
        this.tree.getSelectionModel().addTreeSelectionListener(this);
        if (this.editShortcuts) {
            object = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n = ActionTreePanel.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    TreePath treePath = ActionTreePanel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n != -1) {
                        if (mouseEvent.getClickCount() == 2) {
                            Object object = treePath.getLastPathComponent();
                            if (!(object instanceof PAction)) {
                                return;
                            }
                            ActionTreePanel.this.editModeOn();
                        } else {
                            ActionTreePanel.this.editModeOff();
                        }
                    } else {
                        ActionTreePanel.this.editModeOff();
                    }
                }
            };
            this.tree.addMouseListener((MouseListener)object);
        }
    }

    private void removeSelectedShortcut() {
        if (this.selectedAction != null) {
            for (ShortcutBlock shortcutBlock : this.tree.getBlockForAction(this.selectedAction)) {
                shortcutBlock.removeShortcutForAction(this.selectedAction);
            }
            this.modified = true;
            this.reloadTree();
            this.editModeOff();
        }
    }

    private void editModeOn() {
        this.textFieldShortcut.setEditable(true);
        this.listener.setShortcutScope(this.tree.getBlockForAction(this.selectedAction));
        this.textFieldShortcut.addKeyListener(this.listener);
        this.textFieldShortcut.requestFocusInWindow();
        this.btnEditShortcut.setSelected(true);
    }

    private void editModeOff() {
        this.textFieldShortcut.setEditable(false);
        this.textFieldShortcut.removeKeyListener(this.listener);
        this.btnEditShortcut.setSelected(false);
        this.tree.requestFocusInWindow();
    }

    void handleChange() {
        if (this.listener != null && this.textFieldShortcut != null) {
            this.textFieldShortcut.removeKeyListener(this.listener);
            if (this.selectedAction != null && this.textFieldShortcut.isEditable()) {
                if (this.listener.getResultKeyCode() == 0 && this.listener.getResultModifier() == 0) {
                    if (this.selectedShortcut != null) {
                        this.textFieldShortcut.setText(this.selectedShortcut.toString());
                    } else {
                        this.textFieldShortcut.setText("");
                    }
                } else {
                    List<ShortcutBlock> list = this.tree.getBlockForAction(this.selectedAction);
                    if (this.selectedShortcut != null) {
                        for (ShortcutBlock shortcutBlock : list) {
                            shortcutBlock.removeShortcutForAction(this.selectedAction);
                        }
                    }
                    for (ShortcutBlock shortcutBlock : list) {
                        shortcutBlock.addShortCutOnRuntime(this.listener.getResultKeyCode(), this.listener.getResultModifier(), this.selectedAction);
                    }
                    this.modified = true;
                    this.reloadTree();
                }
            }
            this.editModeOff();
        }
    }

    public void onExit() {
        this.handleChange();
    }

    public boolean wasModified() {
        return this.modified && this.editShortcuts;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        Object object = null;
        if (treePath != null) {
            object = treePath.getLastPathComponent();
        }
        if (treeSelectionEvent.getNewLeadSelectionPath() == treeSelectionEvent.getOldLeadSelectionPath()) {
            this.handleChange();
        }
        if (object instanceof PAction) {
            this.selectedAction = (PAction)object;
            if (this.selectedAction.getToolTipText() != null) {
                this.txtDescription.setText(this.selectedAction.getToolTipText());
            } else {
                this.txtDescription.setText(this.selectedAction.getCaption());
            }
            if (this.editShortcuts) {
                this.btnResetShortcut.setEnabled(true);
                this.btnEditShortcut.setEnabled(true);
                this.selectedShortcut = this.tree.getShortcutForAction(this.selectedAction);
                if (this.selectedShortcut == null) {
                    this.btnRemoveShortcut.setEnabled(false);
                    this.textFieldShortcut.setText("");
                } else {
                    this.btnRemoveShortcut.setEnabled(true);
                    this.textFieldShortcut.setText(this.selectedShortcut.toString());
                }
            }
        } else {
            this.txtDescription.setText("");
            this.selectedAction = null;
            this.selectedShortcut = null;
            if (this.editShortcuts) {
                this.textFieldShortcut.setText("");
                this.btnResetShortcut.setEnabled(false);
                this.btnEditShortcut.setEnabled(false);
                this.btnRemoveShortcut.setEnabled(false);
            }
        }
    }

    public void addComponent(JPanel jPanel, int n, int n2, int n3, Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add(component, gridBagConstraints);
    }

    public ActionTree getTree() {
        return this.tree;
    }

    public void reloadTree() {
        TreePath treePath = this.tree.getSelectionPath();
        this.tree.reload(this.textFieldSearch);
        this.tree.getSelectionModel().setSelectionPath(treePath);
    }

    private class EditShortcut
    extends AbstractAction {
        public EditShortcut() {
            super(Messages.getString("ActionTreePanel.Edit"));
            super.putValue("ShortDescription", Messages.getString("ActionTreePanel.EditTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ActionTreePanel.this.textFieldShortcut.isEditable()) {
                ActionTreePanel.this.editModeOn();
            } else {
                ActionTreePanel.this.editModeOff();
            }
        }
    }

    private class RemoveShortcut
    extends AbstractAction {
        public RemoveShortcut() {
            super(null, (Icon)IAIconFactory.DEFAULT_FACTORY.loadIcon(ActionsDlg.class, "close.svg"));
            super.putValue("ShortDescription", Messages.getString("ActionTreePanel.RemoveTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionTreePanel.this.removeSelectedShortcut();
        }
    }

    private class ResetShortcut
    extends AbstractAction {
        public ResetShortcut() {
            super(Messages.getString("ActionTreePanel.Reset"));
            super.putValue("ShortDescription", Messages.getString("ActionTreePanel.ResetTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ActionTreePanel.this.selectedAction != null) {
                for (ShortcutBlock shortcutBlock : ActionTreePanel.this.tree.getBlockForAction(ActionTreePanel.this.selectedAction)) {
                    shortcutBlock.removeShortcutForAction(ActionTreePanel.this.selectedAction);
                }
                KeyShortcut keyShortcut = ActionTreePanel.this.selectedAction.getDefaultShortcut();
                if (keyShortcut != null) {
                    for (ShortcutBlock shortcutBlock : ActionTreePanel.this.tree.getBlockForAction(ActionTreePanel.this.selectedAction)) {
                        if (shortcutBlock.isOccupied(keyShortcut.keyCode, keyShortcut.modifiers) != null) continue;
                        shortcutBlock.addShortCutOnRuntime(keyShortcut.keyCode, keyShortcut.modifiers, ActionTreePanel.this.selectedAction);
                    }
                }
                ActionTreePanel.this.modified = true;
                ActionTreePanel.this.reloadTree();
            }
        }
    }
}

