/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.keypress.gui;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.tiani.gui.util.tree.ImpaxEETree;
import com.tiani.jvision.keypress.ShortCut;
import com.tiani.jvision.keypress.ShortcutBlock;
import com.tiani.jvision.keypress.gui.ActionTreeCellRenderer;
import com.tiani.jvision.keypress.gui.ActionTreeModel;
import com.tiani.jvision.plugin.PluginName;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ActionTree
extends ImpaxEETree
implements KeyListener {
    private List<PAction> actions;
    private ShortcutBlock global;
    private Map<PluginName, ShortcutBlock> plugin;
    private Object root = new Object();
    private boolean filtered = false;

    public ActionTree(ShortcutBlock shortcutBlock, Map<PluginName, ShortcutBlock> map, IComponentFactory iComponentFactory) {
        super(iComponentFactory);
        Object object;
        this.global = shortcutBlock;
        this.plugin = map;
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.actions = PActionRegistry.getShortcutActions();
        Iterator<PAction> iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!object.getGroupName().equals("INTERNAL") || object.getScopes() != null) continue;
            iterator.remove();
        }
        object = new ActionTreeModel(this.root, this.actions);
        this.setModel((TreeModel)object);
        this.setCellRenderer(new ActionTreeCellRenderer());
        this.getSelectionModel().setSelectionMode(1);
        this.expandAll(new TreePath(this.root));
    }

    public void reload(Component component) {
        this.filtered = true;
        this.keyReleased(new KeyEvent(component, 402, 0L, 0, 0));
    }

    ShortCut getShortcutForAction(PAction pAction) {
        return this.getBlockForAction(pAction).get(0).getShortcutForAction(pAction);
    }

    List<ShortcutBlock> getBlockForAction(PAction pAction) {
        if (pAction != null && pAction.getScopes() != null) {
            ArrayList<ShortcutBlock> arrayList = new ArrayList<ShortcutBlock>();
            PluginName[] pluginNameArray = pAction.getScopes();
            int n = pluginNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                PluginName pluginName = pluginNameArray[n2];
                if (pluginName == null) {
                    arrayList.add(this.global);
                } else {
                    arrayList.add(this.plugin.get((Object)pluginName));
                }
                ++n2;
            }
            return arrayList;
        }
        return Collections.singletonList(this.global);
    }

    public void setGlobal(ShortcutBlock shortcutBlock) {
        this.global = shortcutBlock;
    }

    public void setPlugin(Map<PluginName, ShortcutBlock> map) {
        this.plugin = map;
    }

    private void expandAll(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        int n = this.getModel().getChildCount(object);
        if (n >= 0) {
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.getModel().getChild(object, n2);
                TreePath treePath2 = treePath.pathByAddingChild(object2);
                this.expandAll(treePath2);
                ++n2;
            }
        }
        this.expandPath(treePath);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        JTextField jTextField = (JTextField)keyEvent.getComponent();
        String string = jTextField.getText().toLowerCase();
        if (string.length() < 2) {
            if (this.filtered) {
                this.setModel(new ActionTreeModel(this.root, this.actions));
            }
            this.filtered = false;
        } else {
            this.filtered = true;
            ArrayList<PAction> arrayList = new ArrayList<PAction>(this.actions.size());
            block0: for (PAction pAction : this.actions) {
                if (pAction.getName() != null && pAction.getName().toLowerCase().contains(string)) {
                    arrayList.add(pAction);
                    continue;
                }
                if (pAction.getGroupName() != null && pAction.getGroupName().toLowerCase().contains(string)) {
                    arrayList.add(pAction);
                    continue;
                }
                if (pAction.getScopes() == null) continue;
                PluginName[] pluginNameArray = pAction.getScopes();
                int n = pluginNameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PluginName pluginName = pluginNameArray[n2];
                    if (pluginName != null && pluginName.getCaption().toLowerCase().contains(string)) {
                        arrayList.add(pAction);
                        continue block0;
                    }
                    ++n2;
                }
            }
            this.setModel(new ActionTreeModel(this.root, arrayList));
        }
        this.expandAll(new TreePath(this.root));
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

