/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.event.ZoomParameter;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewEventHandler;
import com.tiani.jvision.image.fithandler.ViewportDefinition;
import javax.vecmath.Vector2f;

public abstract class ViewportHandler
implements ViewEventHandler,
Cloneable {
    protected int myNodeID = 0;
    protected float centerX;
    protected float centerY;

    public Object clone() throws CloneNotSupportedException {
        ViewportHandler viewportHandler = (ViewportHandler)super.clone();
        return viewportHandler;
    }

    public void setNodeID(int n) {
        this.myNodeID = n;
    }

    @Override
    public int handleTEvent(TEvent tEvent, Object object, int n, View view) {
        if (tEvent.source == view) {
            return 0;
        }
        switch (tEvent.id) {
            case 17: {
                if (!(object instanceof ViewportDefinition)) break;
                ViewportDefinition viewportDefinition = (ViewportDefinition)object;
                this.normalizedZoom(viewportDefinition.relXo, viewportDefinition.relYo, viewportDefinition.relWidth, viewportDefinition.relHeight, view);
                break;
            }
            case 2: {
                if (tEvent.interactionModifier != 2) break;
                if (object instanceof ZoomParameter) {
                    this.normalizedZoom(0.0, 0.0, ((ZoomParameter)object).zoom, ((ZoomParameter)object).zoom, view);
                    this.endZooming(view);
                } else {
                    this.panNormalized(((double[])object)[0], ((double[])object)[1], view);
                    this.endPanning(view);
                }
                return 1;
            }
        }
        return 0;
    }

    protected void startZooming(View view) {
        view.actionStarted(this);
    }

    protected void startPanning(View view) {
        view.actionStarted(this);
    }

    protected void endZooming(View view) {
        if (this.myNodeID == 0) {
            view.actionFinished(this);
        }
    }

    protected void endPanning(View view) {
        if (this.myNodeID == 0) {
            view.actionFinished(this);
        }
    }

    public abstract double getZoomFactor();

    public abstract void reset(View var1);

    protected void getZoomRectModeCenter(float f, Vector2f vector2f, Vector2f vector2f2) {
        vector2f2.x = 1.0f / f;
        vector2f2.y = 1.0f / f;
        vector2f.x = this.centerX - vector2f2.x / 2.0f;
        vector2f.y = this.centerY - vector2f2.y / 2.0f;
    }

    public void centerZoomStart(float f, View view) {
        this.startZooming(view);
        if (f > 32.0f) {
            f = 32.0f;
        }
        Vector2f vector2f = new Vector2f();
        Vector2f vector2f2 = new Vector2f();
        this.centerX = 0.5f;
        this.centerY = 0.5f;
        this.getZoomRectModeCenter(f, vector2f, vector2f2);
        TEvent tEvent = new TEvent();
        tEvent.source = view;
        tEvent.destinationNodeID = this.myNodeID;
        tEvent.id = 2;
        tEvent.interactionModifier = 0;
        int n = TEventDispatch.SYNCHRONIZED_DISPLAYS | TEventDispatch.SELECTED_VISUALS;
        TEventDispatch.sendEvent(tEvent, (Object)new ZoomParameter(1.0 / this.getZoomFactor()), n);
    }

    public void centerZoomProgress(float f, View view) {
        this.centerZoomProgress(f, view, 32.0f);
    }

    public void centerZoomProgress(float f, View view, float f2) {
        if (f > f2) {
            f = f2;
        }
        Vector2f vector2f = new Vector2f();
        Vector2f vector2f2 = new Vector2f();
        this.getZoomRectModeCenter(f, vector2f, vector2f2);
        this.normalizedZoom(vector2f.x, vector2f.y, vector2f2.x, vector2f2.y, view);
        TEvent tEvent = new TEvent();
        tEvent.source = view;
        tEvent.id = 2;
        tEvent.interactionModifier = 1;
        tEvent.destinationNodeID = this.myNodeID;
        int n = TEventDispatch.SYNCHRONIZED_DISPLAYS | TEventDispatch.SELECTED_VISUALS;
        TEventDispatch.sendEvent(tEvent, (Object)new ZoomParameter(1.0 / this.getZoomFactor()), n);
    }

    public void centerZoomEnd(float f, View view) {
        this.centerZoomEnd(f, view, 32.0f);
    }

    public void centerZoomEnd(float f, View view, float f2) {
        this.endZooming(view);
        if (f > f2) {
            f = f2;
        }
        Vector2f vector2f = new Vector2f();
        Vector2f vector2f2 = new Vector2f();
        this.getZoomRectModeCenter(f, vector2f, vector2f2);
        this.normalizedZoom(vector2f.x, vector2f.y, vector2f2.x, vector2f2.y, view);
        TEvent tEvent = new TEvent();
        tEvent.source = view;
        tEvent.id = 2;
        tEvent.destinationNodeID = this.myNodeID;
        tEvent.interactionModifier = 2;
        TEventDispatch.sendEvent(tEvent, new ZoomParameter(1.0 / this.getZoomFactor()));
    }

    protected abstract void normalizedZoom(double var1, double var3, double var5, double var7, View var9);

    public abstract void startActivePanning(View var1);

    public abstract void panRelative(double var1, double var3, View var5);

    public abstract void panNormalized(double var1, double var3, View var5);

    public abstract void endActivePanning(View var1);
}

