/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.data.shared.pixel.PixelDataFrameUtilities;
import com.agfa.pacs.impaxee.cache.ByteGrayscaleBufferedImageHolder;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.listtext.dicomobject.module.image.ImagePixel;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.StringOverlayData;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.BitmapOverlay;
import com.tiani.jvision.overlay.OrientationMapping;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayBitmap;
import com.tiani.jvision.overlay.RulerMapping;
import com.tiani.jvision.overlay.demographics.Mapping;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.dcm4che3.data.Attributes;

public class ViewSnapshot {
    private View.OverlayMode overlayMode;
    private int width;
    private int height;
    private boolean forceRGB = false;
    private Object dataBuffer;
    private List<BitmapOverlay> overlayData = new ArrayList<BitmapOverlay>(2);
    private boolean shrinkOverlayData = true;
    private Attributes dataset = new Attributes();
    private int fontSize = 10;
    private Hashtable<String, BitmapOverlay> bitmapOverlays = new Hashtable();
    private boolean closeUpWorkDone = false;
    private ImagePixel imagePixel;

    public ViewSnapshot(View.OverlayMode overlayMode, int n, int n2, boolean bl) {
        this.overlayMode = overlayMode;
        this.width = n;
        this.height = n2;
        this.forceRGB = bl;
    }

    public boolean forceRGB() {
        return this.forceRGB;
    }

    public void setForceRGB(boolean bl) {
        this.forceRGB = bl;
    }

    public void applyOverlays(List<Overlay> list) {
        this.applyOverlays(list, 0, 0, this.width, this.height);
    }

    public void setOverlayMode(View.OverlayMode overlayMode) {
        this.overlayMode = overlayMode;
    }

    public void mergeDataset(Attributes attributes) {
        this.dataset.addAll(attributes);
    }

    public Attributes getDataset() {
        return this.dataset;
    }

    public void applyOverlays(List<Overlay> list, int n, int n2, int n3, int n4) {
        if (this.overlayMode == View.OverlayMode.PRINT_OVERLAY_NONE) {
            return;
        }
        if (this.overlayMode == View.OverlayMode.PRINT_BURN_MAPPINGS) {
            this.burnOverlays(list, n, n2, n3, n4);
        } else if (this.overlayMode == View.OverlayMode.PRINT_BURN_ROI) {
            ArrayList<Overlay> arrayList = new ArrayList<Overlay>();
            for (Overlay overlay : list) {
                if (overlay instanceof Mapping || overlay instanceof RulerMapping || overlay instanceof OrientationMapping) continue;
                arrayList.add(overlay);
            }
            this.burnOverlays(arrayList, n, n2, n3, n4);
        } else {
            Hashtable<String, Vector<Overlay>> hashtable = new Hashtable<String, Vector<Overlay>>();
            for (Overlay object2 : list) {
                Vector<Overlay> vector;
                String string = object2.getLayerLabel();
                if (object2.captureAsRGB()) {
                    string = "__JV_BURN__";
                }
                if ((vector = (Vector<Overlay>)hashtable.get(string)) == null) {
                    vector = new Vector<Overlay>();
                    hashtable.put(string, vector);
                }
                vector.addElement(object2);
            }
            if (hashtable.get("__JV_BURN__") != null) {
                this.burnOverlays((List)hashtable.get("__JV_BURN__"), n, n2, n3, n4);
                hashtable.remove("__JV_BURN__");
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.burnIntoBitplane(string, (Vector)hashtable.get(string), n, n2, n3, n4);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void burnIntoBitplane(String string, Vector<Overlay> vector, int n, int n2, int n3, int n4) {
        ByteGrayscaleBufferedImageHolder byteGrayscaleBufferedImageHolder;
        ByteGrayscaleBufferedImageHolder byteGrayscaleBufferedImageHolder2 = byteGrayscaleBufferedImageHolder = new ByteGrayscaleBufferedImageHolder(this.width, this.height);
        String string2 = string;
        if (n != 0 && n2 != 0 && n3 != this.width && n4 != this.height) {
            byteGrayscaleBufferedImageHolder2 = byteGrayscaleBufferedImageHolder.getSubImage(n, n2, n3, n4);
        }
        byteGrayscaleBufferedImageHolder2.graphics.setStroke(new BasicStroke(this.fontSize / 8));
        byteGrayscaleBufferedImageHolder.clear();
        OverlayBitmap overlayBitmap = null;
        boolean bl = false;
        byteGrayscaleBufferedImageHolder2.locked = true;
        for (Overlay object2 : vector) {
            if (this.overlayMode == View.OverlayMode.PRINT_OVERLAY_ALL || !(object2 instanceof Mapping) && !(object2 instanceof RulerMapping) && !(object2 instanceof OrientationMapping)) {
                object2.setPrintFont(byteGrayscaleBufferedImageHolder2.graphics, new Rectangle(this.width, this.height), 72.0);
                object2.paint(byteGrayscaleBufferedImageHolder2);
                object2.resetPrintFont();
            }
            bl |= object2.isVisible();
            if (!(object2 instanceof OverlayBitmap)) continue;
            overlayBitmap = (OverlayBitmap)object2;
        }
        byteGrayscaleBufferedImageHolder2.locked = false;
        if (bl) {
            void var12_19;
            Object object;
            Object var12_14 = null;
            if ("__JV_DEFAULT__".equals(string) || "__JV_UNSAVED__".equals(string) || "JV_OBJECTS".equals(string)) {
                if (this.overlayMode == View.OverlayMode.PRINT_OVERLAY_ALL) {
                    string2 = "JV_SCRMAP";
                    BitmapOverlay bitmapOverlay = new BitmapOverlay(this.height, this.width, "screen mappings", 1, 1, "G", "AUTOMATED", null, string2, true);
                } else {
                    string2 = "JV_OBJECTS";
                    object = this.bitmapOverlays.get(string2);
                    if (object != null) {
                        ((BitmapOverlay)object).getData().renderTo(((BitmapOverlay)object).getOriginX(), ((BitmapOverlay)object).getOriginY(), (Graphics)byteGrayscaleBufferedImageHolder2.graphics);
                    }
                    BitmapOverlay bitmapOverlay = new BitmapOverlay(this.height, this.width, "manual/generated overlay objects", 1, 1, "G", "USER", null, string2, true);
                }
            } else if (overlayBitmap != null) {
                object = overlayBitmap.getOverlayDefinition();
                BitmapOverlay bitmapOverlay = new BitmapOverlay(this.height, this.width, ((BitmapOverlay)object).getDescription(), 1, 1, ((BitmapOverlay)object).getOverlayType(), ((BitmapOverlay)object).getOverlaySubType(), null, ((BitmapOverlay)object).getLabel(), true);
            } else {
                BitmapOverlay bitmapOverlay = new BitmapOverlay(this.height, this.width, "", 1, 1, "G", "AUTOMATED", null, string, true);
            }
            this.bitmapOverlays.put(string2, (BitmapOverlay)var12_19);
            object = byteGrayscaleBufferedImageHolder2.data;
            int n5 = 0;
            byte by = 0;
            byte[] byArray = new byte[this.width * this.height + 7 >> 3];
            int n6 = 0;
            while (n6 < this.width * this.height >> 3) {
                int n7 = 0;
                while (n7 < 8) {
                    by = (byte)(by | (object[n5++] != false ? 1 : 0) << n7);
                    ++n7;
                }
                byArray[n6] = by;
                by = 0;
                ++n6;
            }
            byArray[byArray.length - 1] = (byte)(byArray[byArray.length - 1] << (8 - this.width * this.height % 8) % 8);
            var12_19.setOverlayData((IOverlayData)new StringOverlayData(byArray, byteGrayscaleBufferedImageHolder2.width, byteGrayscaleBufferedImageHolder2.height), false);
            byteGrayscaleBufferedImageHolder.release();
        }
    }

    public void burnOverlays(List<Overlay> list, int n, int n2, int n3, int n4) {
        RGBBufferedImageHolder rGBBufferedImageHolder;
        RGBBufferedImageHolder rGBBufferedImageHolder2 = rGBBufferedImageHolder = new RGBBufferedImageHolder(this.width, this.height);
        if (n != 0 && n2 != 0 && n3 != this.width && n4 != this.height) {
            rGBBufferedImageHolder2 = rGBBufferedImageHolder.getSubImage(n, n2, n3, n4);
        }
        rGBBufferedImageHolder2.graphics.setColor(Color.white);
        if (this.dataBuffer instanceof int[]) {
            System.arraycopy(this.dataBuffer, 0, rGBBufferedImageHolder2.data, 0, this.width * this.height);
        } else {
            rGBBufferedImageHolder2.clear();
        }
        rGBBufferedImageHolder2.graphics.setStroke(new BasicStroke(this.fontSize / 8));
        for (Overlay overlay : list) {
            overlay.setPrintFont(rGBBufferedImageHolder2.graphics, new Rectangle(this.width, this.height), 72.0);
            if (overlay.getView() != null) {
                overlay.getView().setImgInvalid(true);
            }
            overlay.paint(rGBBufferedImageHolder2);
            overlay.resetPrintFont();
        }
        if (this.dataBuffer instanceof int[]) {
            System.arraycopy(rGBBufferedImageHolder2.data, 0, this.dataBuffer, 0, this.width * this.height);
        } else {
            this.burnIntoDataBuffer(rGBBufferedImageHolder2.data);
        }
        rGBBufferedImageHolder.release();
        rGBBufferedImageHolder2.release();
    }

    private void burnIntoDataBuffer(int[] nArray) {
        if (this.dataBuffer instanceof byte[]) {
            byte[] byArray = (byte[])this.dataBuffer;
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] != 0) {
                    byArray[n] = (byte)(((nArray[n] & 0xFF) + (nArray[n] >> 8 & 0xFF) + (nArray[n] >> 16 & 0xFF)) / 3);
                }
                ++n;
            }
        } else if (this.dataBuffer instanceof short[]) {
            int n = this.imagePixel.getBitsStored() - 8;
            short[] sArray = (short[])this.dataBuffer;
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] != 0) {
                    int n3 = ((nArray[n2] & 0xFF) + (nArray[n2] >> 8 & 0xFF) + (nArray[n2] >> 16 & 0xFF)) / 3;
                    sArray[n2] = (short)(n3 << n);
                }
                ++n2;
            }
        } else {
            int[] nArray2 = (int[])this.dataBuffer;
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] != 0) {
                    nArray2[n] = nArray[n];
                }
                ++n;
            }
        }
    }

    public void setDataBuffer(Object object) {
        int n;
        if (object instanceof int[]) {
            n = ((int[])object).length;
        } else if (object instanceof short[]) {
            n = ((short[])object).length;
        } else if (object instanceof byte[]) {
            n = ((byte[])object).length;
        } else {
            throw new IllegalArgumentException();
        }
        this.setDataBuffer(object, n);
    }

    public void setDataBuffer(Object object, int n) {
        if (object instanceof int[]) {
            this.dataBuffer = new int[n];
        } else if (object instanceof short[]) {
            this.dataBuffer = new short[n];
        } else if (object instanceof byte[]) {
            this.dataBuffer = new byte[n];
        } else {
            throw new IllegalArgumentException();
        }
        System.arraycopy(object, 0, this.dataBuffer, 0, n);
        this.imagePixel = this.createImagePixel(this.dataBuffer.getClass(), this.width, this.height);
    }

    public Object getDataBuffer() {
        return this.dataBuffer;
    }

    public RGBBufferedImageHolder getDataBufferAsImage() {
        if (this.dataBuffer instanceof int[]) {
            return new RGBBufferedImageHolder(this.width, this.height, (int[])this.dataBuffer);
        }
        throw new UnsupportedOperationException();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setShrinkOverlayData(boolean bl) {
        this.shrinkOverlayData = bl;
    }

    private void finishConstruction() {
        if (this.closeUpWorkDone) {
            return;
        }
        this.closeUpWorkDone = true;
        for (BitmapOverlay bitmapOverlay : this.bitmapOverlays.values()) {
            this.overlayData.add(bitmapOverlay);
            bitmapOverlay.creationDone(this.shrinkOverlayData);
        }
        this.bitmapOverlays.clear();
    }

    private ImagePixel createImagePixel(Class<?> clazz, int n, int n2) {
        ImagePixel imagePixel = new ImagePixel();
        imagePixel.setRows(Integer.valueOf(n2));
        imagePixel.setColumns(Integer.valueOf(n));
        if (clazz == byte[].class) {
            imagePixel.setSamplesPerPixel(Integer.valueOf(1));
            imagePixel.setBitsAllocated(Integer.valueOf(8));
            imagePixel.setPhotometricInterpretation(PhotometricInterpretation.Monochrome);
            imagePixel.setBitsStored(Integer.valueOf(8));
            imagePixel.setHighBit(Integer.valueOf(7));
            imagePixel.setPixelRepresentation(0);
        } else if (clazz == short[].class) {
            imagePixel.setSamplesPerPixel(Integer.valueOf(1));
            imagePixel.setBitsAllocated(Integer.valueOf(16));
            imagePixel.setPhotometricInterpretation(PhotometricInterpretation.Monochrome);
            imagePixel.setBitsStored(Integer.valueOf(16));
            imagePixel.setHighBit(Integer.valueOf(15));
            imagePixel.setPixelRepresentation(0);
        } else if (clazz == int[].class) {
            imagePixel.setSamplesPerPixel(Integer.valueOf(3));
            imagePixel.setBitsAllocated(Integer.valueOf(8));
            imagePixel.setPhotometricInterpretation(PhotometricInterpretation.RGBColor);
            imagePixel.setPlanarConfiguration(Integer.valueOf(0));
            imagePixel.setBitsStored(Integer.valueOf(8));
            imagePixel.setHighBit(Integer.valueOf(7));
            imagePixel.setPixelRepresentation(0);
        }
        return imagePixel;
    }

    public List<BitmapOverlay> getOverlayData() {
        return this.overlayData;
    }

    public IPixelDataFrame toPixelDataFrame() {
        if (this.dataBuffer == null) {
            return null;
        }
        this.finishConstruction();
        return PixelDataFrameUtilities.createPixelDataFrame((Attributes)this.imagePixel.toDataset(), (Object)this.dataBuffer);
    }
}

