/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.exceptionhandler.ExceptionHandlerFactory;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.model.IDisplayState;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.menu.IMenuEntry;
import com.agfa.pacs.impaxee.presentationstate.IPresentationStateProvider;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationStateSource;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.ClippingShape;
import com.tiani.base.data.Histogram;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.ImageRegion;
import com.tiani.config.mappingfonts.model.enums.LevelOfDetail;
import com.tiani.gui.controls.basic.TProgressBar;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.gui.util.TIcon;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.IViewMouseHandler;
import com.tiani.jvision.image.MousePositionDestination;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.image.PresentationObjectCopyData;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.ViewEventHandler;
import com.tiani.jvision.image.ViewMouseHandler;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.image.WindowTransferFunction;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.multimedia.Capturable;
import com.tiani.jvision.overlay.IOverlayOwner;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlaySynchronizationMode;
import com.tiani.jvision.overlay.PointSequence;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import com.tiani.jvision.overlay.demographics.Mapping;
import com.tiani.jvision.overlay.demographics.MappingFactory;
import com.tiani.jvision.overlay.localizer.LocalizerManager;
import com.tiani.jvision.overlay.localizer.MyWeakReference;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.toptoolbar.LoopModeActionProvider;
import com.tiani.jvision.vis.SyncUtils;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.VisHRSet;
import com.tiani.jvision.workers.ProgressListener;
import com.tiani.util.expressions.EvaluationContext;
import com.tiani.util.expressions.IEvaluablePrivateData;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public abstract class View
implements Cloneable,
IEvaluablePrivateData,
ProgressListener,
IOverlayOwner {
    private static final ALogger log = ALogger.getLogger(View.class);
    protected static final Image failIcon = new TIcon("/icons/load_failed.gif").getImage();
    protected static LevelOfDetail levelOfDetailForDemographics = Config.impaxee.jvision.MAPPING.LevelOfDetail.get() == null ? LevelOfDetail.ALL : LevelOfDetail.valueOf(Config.impaxee.jvision.MAPPING.LevelOfDetail.get());
    private static boolean globalEnabled = true;
    private static final Set<PluginName> DIRECTLY_RENDERABLE_PLUGINS_FOR_EXPORT = EnumSet.of(PluginName.DEFAULT, PluginName.ANIM2D);
    protected static boolean broadcastPointOfInterest = false;
    private static int fastLivesyncDelay = (int)Config.impaxee.jvision.DISPLAY.FastLiveSyncDelay.get();
    protected static boolean paintOverlays = true;
    protected IFrameObjectData frameData;
    protected List<Overlay> overlays = new Vector<Overlay>(5);
    protected EvaluationContext evaluationContext;
    protected IViewMouseHandler mouseHandler = new ViewMouseHandler(this);
    private Mapping map;
    protected int cwidth = 1;
    protected int cheight = 1;
    protected int delayedRepaint = 0;
    private Rectangle bounds = new Rectangle(0, 0, 1, 1);
    public boolean imgInvalid = false;
    protected boolean lockBackground;
    private boolean hasRemovedPO = false;
    private RGBBufferedImageHolder myImage;
    public Collection<Overlay> excludeFromLock;
    private InViewData inView;
    private List<ViewEventHandler> teventListeners = null;
    private Capturable captureDestination;
    protected VisData vis;

    public static void setGlobalEnabled(boolean bl) {
        globalEnabled = bl;
    }

    public static void togglePointOfInterest() {
        boolean bl = broadcastPointOfInterest = !broadcastPointOfInterest;
        if (broadcastPointOfInterest && LoopModeActionProvider.getCurrentLoopMode() != LoopModeActionProvider.LoopMode.STOP) {
            log.warn("For livesync disable looping/switching");
            LoopModeActionProvider.setCurrentLoopMode(LoopModeActionProvider.LoopMode.STOP);
        }
        PActionRegistry.getAction("LiveSync").fireSelectionChanged();
        if (!broadcastPointOfInterest) {
            TEvent tEvent = new TEvent(57);
            TEventDispatch.sendEvent(tEvent, null, TEventDispatch.ALL_DISPLAYS | TEventDispatch.ALL_VISUALS);
        }
    }

    public static boolean isPointOfInterestBroadcasting() {
        return broadcastPointOfInterest;
    }

    public static void setLevelOfDetailForDemographics(LevelOfDetail levelOfDetail) {
        levelOfDetailForDemographics = levelOfDetail;
    }

    public static void setPaintOverlays(boolean bl) {
        paintOverlays = bl;
    }

    public static boolean getPaintOverlays() {
        return paintOverlays;
    }

    public static LevelOfDetail getLevelOfDetailForDemographics() {
        if (!paintOverlays) {
            return LevelOfDetail.NONE;
        }
        return levelOfDetailForDemographics;
    }

    public View() {
    }

    public View(IFrameObjectData iFrameObjectData) {
        this();
        this.frameData = iFrameObjectData;
    }

    public IFrameObjectData getFrameData() {
        return this.frameData;
    }

    public IImageInformation getImageInformation() {
        if (this.frameData == null) {
            return null;
        }
        return this.frameData.getImageInformation();
    }

    public EvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    public void setEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public Histogram getHistogram() {
        return this.frameData.getRawDataContainer().getHistogram();
    }

    public Color getBackground() {
        return Color.BLACK;
    }

    public IViewMouseHandler getMouseHandler() {
        return this.mouseHandler;
    }

    public void presentationObjectCreationDone(PresentationObject presentationObject) {
    }

    public void presentationObjectModified(PresentationObject presentationObject) {
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    public boolean isInView() {
        return this.inView != null;
    }

    public String getInfoAt(int n, int n2) {
        return "";
    }

    public int[] getImageCoordsAtScreenPosition(int n, int n2) {
        return null;
    }

    public void broadcastPointOfInterest(int n, int n2) {
    }

    public Mapping getMapping() {
        return this.map;
    }

    public void setMapping(Mapping mapping) {
        this.map = mapping;
    }

    protected Mapping newExplicitTopLeftRightMapping(EvaluationContext evaluationContext) {
        return MappingFactory.getDefaultTopLeftRightMapping(evaluationContext);
    }

    public abstract void reset();

    public void actionStarted(ViewEventHandler viewEventHandler) {
        if (this.inView != null && !this.inView.interaction) {
            this.inView.interaction = true;
            this.inView.bgWasLockedOnStart = this.lockBackground;
            if (this.lockBackground) {
                this.inView.wasExcludedOnStart = this.excludeFromLock;
                this.lockBackground(false);
            }
        }
    }

    public void actionFinished(ViewEventHandler viewEventHandler) {
        this.actionFinished();
    }

    void actionFinished(boolean bl) {
        if (this.inView != null && this.inView.interaction) {
            this.inView.interaction = false;
            this.imgInvalid = bl;
            if (this.map != null) {
                this.map.updateContent(this.evaluationContext, true, false);
            }
            if (this.inView.bgWasLockedOnStart) {
                this.lockBackground(true, this.inView.wasExcludedOnStart);
                this.inView.wasExcludedOnStart = null;
                this.inView.bgWasLockedOnStart = false;
            }
            if (this.vis != null && this.vis.getVisual() != null && globalEnabled) {
                this.vis.getVisual().addHRs();
            }
        }
    }

    public void updateMapping(boolean bl) {
        if (this.map != null) {
            this.map.updateContent(this.evaluationContext, true, bl);
        }
        if (this.vis != null && this.vis.getVisual() != null) {
            this.invalidate();
            this.repaint();
        }
    }

    public EnumSet<CAPTURE_STATES> captureStates() {
        return EnumSet.allOf(CAPTURE_STATES.class);
    }

    public boolean captureSpatialTransformation(IDisplayState iDisplayState) {
        return false;
    }

    public void actionFinished() {
        if (this.map != null && this.isInView()) {
            this.map.updateContent(this.evaluationContext, true, false);
        }
        if (this.inView != null && this.inView.interaction) {
            this.inView.interaction = false;
            this.imgInvalid = true;
            if (this.inView.bgWasLockedOnStart) {
                this.lockBackground(true, this.inView.wasExcludedOnStart);
                this.inView.wasExcludedOnStart = null;
                this.inView.bgWasLockedOnStart = false;
            }
        }
        if (this.vis != null && this.vis.getVisual() != null && globalEnabled) {
            this.vis.getVisual().addHRs();
        }
    }

    public void refreshPresentationObjects() {
        if (this.cwidth == 1 || this.overlays == null) {
            return;
        }
        ImageState imageState = this.getImageState();
        int n = 0;
        while (n < this.overlays.size()) {
            this.overlays.get(n).setSize(this.cwidth, this.cheight, imageState);
            ++n;
        }
        if (this.map != null) {
            this.map.updateContent(this.evaluationContext, true, false);
        }
    }

    public abstract boolean isFunctional();

    @Override
    public abstract ImageState getImageState();

    public void cleanUp() {
        try {
            if (this.captureDestination != null) {
                this.captureDestination.stop();
            }
            this.captureDestination = null;
            this.teventListeners = null;
            this.mouseHandler.destruct();
            this.map = null;
            while (this.overlays.size() > 0) {
                this.removeOverlay(this.overlays.get(this.overlays.size() - 1));
            }
            this.overlays.clear();
            this.evaluationContext = null;
            this.vis = null;
        }
        catch (Throwable throwable) {
            log.error("Clean up", throwable);
        }
    }

    public boolean onEnterView() {
        if (this.inView == null) {
            this.inView = new InViewData();
            return true;
        }
        return false;
    }

    public void onExitView() {
        this.inView = null;
        this.lockBackground = false;
        if (this.myImage != null) {
            this.myImage.release();
            this.myImage = null;
        }
    }

    public abstract String getVisualType();

    @Override
    public Object resolveString(String string) {
        if (string.equals("TYPE")) {
            return this.getVisualType();
        }
        if (string.equals("OUTPUT_DEVICE")) {
            return "screen";
        }
        if (string.equals("DIAG_RELEVANT") && KeyImageManager.getInstance().isMarked(this.getFrameData(), KeyImageType.OfInterest)) {
            return "DIAG_RELEVANT";
        }
        return null;
    }

    public boolean allowROIs() {
        return false;
    }

    public List<Overlay> getOverlays() {
        return this.overlays;
    }

    public <U extends Overlay> List<U> getOverlays(Class<U> clazz) {
        return Overlay.filter(clazz, this.getOverlays());
    }

    public PresentationObject getShutterPO() {
        for (PresentationObject presentationObject : this.getOverlays(PresentationObject.class)) {
            if (!presentationObject.isShutter()) continue;
            return presentationObject;
        }
        return null;
    }

    public void addOverlay(Overlay overlay) {
        if (overlay == null) {
            return;
        }
        overlay.presentationObjectAdded(this);
        if (overlay instanceof PresentationObject) {
            if (((PresentationObject)overlay).isShutter()) {
                if (this.getShutterPO() != null) {
                    this.removeOverlay(this.getShutterPO());
                }
                this.overlays.add(0, overlay);
            } else {
                this.overlays.add(overlay);
            }
        } else {
            this.overlays.add(overlay);
        }
        overlay.setSize(this.cwidth, this.cheight, this.getImageState());
        if (this.lockBackground && this.excludeFromLock != null) {
            this.excludeFromLock.add(overlay);
        }
    }

    public void addOverlay(Overlay overlay, int n) {
        if (this.overlays.size() == 0 || this.overlays.get(this.overlays.size() - 1) != overlay) {
            overlay.presentationObjectAdded(this);
            if (overlay instanceof PresentationObject) {
                if (((PresentationObject)overlay).isShutter()) {
                    if (this.getShutterPO() != null) {
                        this.removeOverlay(this.getShutterPO());
                    }
                    this.overlays.add(0, overlay);
                } else {
                    this.overlays.add(n, overlay);
                }
            } else {
                this.overlays.add(n, overlay);
            }
            overlay.setSize(this.cwidth, this.cheight, this.getImageState());
            if (this.lockBackground && this.excludeFromLock != null) {
                this.excludeFromLock.add(overlay);
            }
        }
    }

    public void removeOverlay(Overlay overlay) {
        PresentationObject presentationObject;
        this.mouseHandler.cancelPresentationObjectCreation();
        if (this.overlays == null) {
            return;
        }
        if (this.overlays.remove(overlay)) {
            overlay.presentationObjectRemoved(this);
        }
        if (this.lockBackground && this.excludeFromLock != null) {
            this.excludeFromLock.remove(overlay);
        }
        if (overlay instanceof PresentationObject && (presentationObject = (PresentationObject)overlay).isROI() && presentationObject.isSaved()) {
            this.hasRemovedPO = true;
        }
        this.invalidate();
    }

    public boolean hasRemovedPO() {
        return this.hasRemovedPO;
    }

    public void removeAllOverlays() {
        while (this.overlays.size() > 0) {
            this.removeOverlay(this.overlays.get(0));
        }
    }

    public int getcwidth() {
        return this.cwidth;
    }

    public int getcheight() {
        return this.cheight;
    }

    public void updateGeometry() {
        Renderer renderer = this.getRenderer();
        if (renderer != null && this.cwidth > 1 && this.cheight > 1) {
            renderer.setGeometry(this.cwidth, this.cheight, 0, this.cwidth);
        }
    }

    public abstract void onCanvasSizeChanged(boolean var1);

    public void canvasSizeChanged() {
        boolean bl = this.cwidth != this.bounds.width || this.cheight != this.bounds.height;
        this.cwidth = this.getBounds().width;
        this.cheight = this.getBounds().height;
        this.onCanvasSizeChanged(bl);
    }

    public Rectangle getBoundsForVis() {
        return this.getBounds();
    }

    public void setBoundsForVis(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3 + 2, n4 + 2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        if ((n4 -= 2) <= 0 || (n3 -= 2) <= 0) {
            return;
        }
        boolean bl = false;
        if (this.getBounds().width == n3 && this.getBounds().height == n4) {
            this.bounds.x = n;
            this.bounds.y = n2;
            this.bounds.width = n3;
            this.bounds.height = n4;
            this.cwidth = n3;
            this.cheight = n4;
        } else {
            this.bounds.x = n;
            this.bounds.y = n2;
            this.bounds.width = n3;
            this.bounds.height = n4;
            this.cwidth = n3;
            this.cheight = n4;
            if (this.map != null) {
                this.map.setSize(n3, n4, this.getImageState());
            }
            bl = true;
        }
        if (bl) {
            this.canvasSizeChanged();
            bl = false;
        }
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean isImgInvalid() {
        return this.imgInvalid;
    }

    public void setImgInvalid(boolean bl) {
        this.imgInvalid = bl;
    }

    public void delayedRepaint() {
        this.delayedRepaint |= 1;
    }

    public void delayedRepaintBroadcast() {
        this.delayedRepaint |= 2;
    }

    public void invalidate() {
        this.imgInvalid = true;
    }

    protected boolean isPreviewRendering() {
        return this.isInteraction();
    }

    public boolean isInteraction() {
        return this.inView != null && this.inView.interaction;
    }

    public void setInteraction(boolean bl) {
        this.inView.interaction = bl;
    }

    public RGBBufferedImageHolder getImageReference() {
        return this.myImage;
    }

    public BufferedImage captureImage() {
        return this.getImage();
    }

    public BufferedImage getImage() {
        if (this.myImage == null || this.myImage.width != this.bounds.width || this.myImage.height != this.bounds.height) {
            if (this.myImage != null) {
                this.myImage.release();
            }
            try {
                this.myImage = new RGBBufferedImageHolder(this.bounds.width, this.bounds.height);
                this.myImage.locked = false;
                this.myImage.imgInvalid = true;
            }
            catch (Throwable throwable) {
                log.error("Get Image", throwable);
                this.myImage = null;
                return null;
            }
        }
        this.paintContent(this.myImage);
        if (this.myImage == null) {
            return null;
        }
        return this.myImage.image;
    }

    public void repaint() {
        block8: {
            if (!globalEnabled) {
                return;
            }
            try {
                if (this.myImage == null) {
                    if (this.vis != null) {
                        this.vis.paintForVisual();
                    }
                    return;
                }
                if (this.myImage == null) break block8;
                try {
                    if (this.vis != null && this.vis.isInView()) {
                        EventUtil.invoke((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (View.this.vis != null) {
                                    View.this.vis.paintForVisual();
                                }
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    log.error(exception.getMessage(), (Throwable)exception);
                }
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public abstract void paint(RGBBufferedImageHolder var1);

    public boolean isRenderableForExport() {
        return DIRECTLY_RENDERABLE_PLUGINS_FOR_EXPORT.contains((Object)this.getVis().getParent().getPlugin().getPluginName());
    }

    public boolean addingHRsAllowed() {
        return true;
    }

    public void lockBackground(boolean bl) {
        this.lockBackground(bl, null);
    }

    public void lockBackground(boolean bl, Collection<Overlay> collection) {
        if (bl) {
            if (!this.lockBackground) {
                this.excludeFromLock = collection;
            } else if (this.excludeFromLock != null) {
                if (collection != null) {
                    this.excludeFromLock.addAll(collection);
                }
            } else {
                this.excludeFromLock = collection;
            }
            this.lockBackground = false;
            this.invalidate();
            this.getImage();
            if (this.inView != null) {
                RGBBufferedImageHolder rGBBufferedImageHolder = this.getImageReference();
                if (rGBBufferedImageHolder != null) {
                    int[] nArray = rGBBufferedImageHolder.data;
                    this.inView.lockedBgBuffer = (int[])nArray.clone();
                } else {
                    this.inView.lockedBgBuffer = null;
                }
            }
        } else {
            this.excludeFromLock = null;
            if (this.inView != null) {
                this.inView.lockedBgBuffer = null;
            }
        }
        this.lockBackground = bl;
    }

    private void paintContent(RGBBufferedImageHolder rGBBufferedImageHolder) {
        block8: {
            try {
                boolean bl = this.imgInvalid | this.lockBackground;
                if (!this.lockBackground) {
                    this.paint(rGBBufferedImageHolder);
                } else {
                    rGBBufferedImageHolder.locked = true;
                    int[] nArray = rGBBufferedImageHolder.data;
                    if ((nArray.length != this.inView.lockedBgBuffer.length || this.imgInvalid) && !LocalizerManager.isFastRepaintInProgress()) {
                        Collection<Overlay> collection = this.excludeFromLock;
                        Capturable capturable = this.captureDestination;
                        this.captureDestination = null;
                        this.lockBackground(false);
                        this.lockBackground(true, collection);
                        this.imgInvalid = false;
                        this.captureDestination = capturable;
                    }
                    if (this.inView.lockedBgBuffer.length <= nArray.length) {
                        System.arraycopy(this.inView.lockedBgBuffer, 0, nArray, 0, nArray.length);
                    }
                    this.paintOverlays(rGBBufferedImageHolder);
                }
                boolean bl2 = rGBBufferedImageHolder.imgInvalid = !this.isFunctional();
                if (bl && this.captureDestination != null) {
                    this.captureDestination.frame(this, rGBBufferedImageHolder);
                }
            }
            catch (Throwable throwable) {
                log.error("View", throwable);
                ExceptionHandlerFactory.getInstance().handleException(throwable);
                if (rGBBufferedImageHolder == null) break block8;
                rGBBufferedImageHolder.clear();
            }
        }
        if (this.myImage != null && this.myImage.imgInvalid && this.isFunctional()) {
            log.warn("image invalid on exit!");
            this.myImage.clear();
        }
    }

    public void refresh() {
        if (this.myImage != null) {
            this.myImage.imgInvalid = true;
            this.getImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintOverlays(RGBBufferedImageHolder rGBBufferedImageHolder) {
        if (this.overlays != null) {
            List<Overlay> list = this.overlays;
            synchronized (list) {
                for (Overlay overlay : this.overlays) {
                    if (!paintOverlays && !(overlay instanceof Mapping)) continue;
                    if (this.excludeFromLock == null) {
                        overlay.paint(rGBBufferedImageHolder);
                        continue;
                    }
                    if (!this.lockBackground) {
                        if (this.excludeFromLock.contains(overlay)) continue;
                        overlay.paint(rGBBufferedImageHolder);
                        continue;
                    }
                    if (!this.excludeFromLock.contains(overlay)) continue;
                    overlay.paint(rGBBufferedImageHolder);
                }
            }
        }
    }

    public boolean handleMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.inView.lastDenied = false;
                return this.handleMousePressed(mouseEvent);
            }
            case 506: {
                if (!this.acceptMouseEvent(mouseEvent)) {
                    return false;
                }
                boolean bl = this.handleMouseDragged(mouseEvent);
                this.mouseEventComplete(mouseEvent);
                return bl;
            }
            case 502: {
                if (this.inView.lastDenied) {
                    this.handleMouseDragged(mouseEvent);
                }
                return this.handleMouseReleased(mouseEvent);
            }
            case 507: {
                return this.wantsMouseWheelEvent((MouseWheelEvent)mouseEvent);
            }
            case 500: {
                return this.handleMouseClicked(mouseEvent);
            }
        }
        return false;
    }

    public boolean handleMousePressed(MouseEvent mouseEvent) {
        return false;
    }

    public boolean handleMouseClicked(MouseEvent mouseEvent) {
        return false;
    }

    public boolean handleMouseDragged(MouseEvent mouseEvent) {
        return false;
    }

    public boolean handleMouseReleased(MouseEvent mouseEvent) {
        return false;
    }

    public boolean wantsMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        return false;
    }

    public boolean handleMouseWheel(MouseWheelEvent mouseWheelEvent) {
        return false;
    }

    public void sendLiveSyncEvent(Point point) {
        PickingResult pickingResult = this.getRenderer().pick(point.getX(), point.getY());
        View.sendLiveSyncEvent(pickingResult, this);
    }

    public static void sendLiveSyncEvent(PickingResult pickingResult, Object object) {
        if (pickingResult != null && pickingResult.hasFrameOfReference()) {
            final TEvent tEvent = new TEvent(57);
            tEvent.source = object;
            TEventDispatch.sendEvent(tEvent, (Object)pickingResult, TEventDispatch.ALL_DISPLAYS | TEventDispatch.ALL_VISUALS);
            EventUtil.invokeNotOnEDT((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(fastLivesyncDelay);
                    }
                    catch (InterruptedException interruptedException) {}
                    TEventDispatch.sendEvent(tEvent, null, TEventDispatch.ALL_DISPLAYS | TEventDispatch.ALL_VISUALS);
                }
            });
        }
    }

    public void addViewEventListener(ViewEventHandler viewEventHandler) {
        if (this.teventListeners == null) {
            this.teventListeners = new Vector<ViewEventHandler>(2);
        }
        if (!this.teventListeners.contains(viewEventHandler)) {
            this.teventListeners.add(viewEventHandler);
        }
    }

    public void removeViewEventListener(ViewEventHandler viewEventHandler) {
        if (this.teventListeners == null) {
            return;
        }
        this.teventListeners.remove(viewEventHandler);
    }

    public abstract VisHRSet getHRSet(VisHRSet var1, Vis2 var2);

    public Capturable getCaptureDestination() {
        return this.captureDestination;
    }

    public void setCaptureDestination(Capturable capturable) {
        if (capturable != null) {
            RGBBufferedImageHolder rGBBufferedImageHolder = this.getImageReference();
            this.captureDestination = !capturable.start(rGBBufferedImageHolder.width, rGBBufferedImageHolder.height) ? null : capturable;
        } else {
            if (this.captureDestination != null) {
                this.captureDestination.stop();
            }
            this.captureDestination = capturable;
        }
    }

    public boolean setCaptureDestination(Capturable capturable, int n) {
        if (capturable != null) {
            this.captureDestination = capturable;
            RGBBufferedImageHolder rGBBufferedImageHolder = this.getImageReference();
            if (!this.captureDestination.start(rGBBufferedImageHolder.width, rGBBufferedImageHolder.height, n)) {
                this.captureDestination = null;
            }
        } else {
            if (this.captureDestination != null) {
                this.captureDestination.stop();
            }
            this.captureDestination = capturable;
        }
        return this.captureDestination != null;
    }

    public List<IMenuEntry> getLegacyMenuEntries() {
        ArrayList<IMenuEntry> arrayList = new ArrayList<IMenuEntry>(2);
        return arrayList;
    }

    public List<PAction> getMenuEntries() {
        if (this.frameData == null) {
            return Collections.emptyList();
        }
        return this.frameData.getMenuEntries();
    }

    public List<IMenuEntry> getMenuEntriesForPO(PresentationObject presentationObject) {
        return Collections.emptyList();
    }

    public void hotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
        this.inView.lastDxAbs = 0;
        this.inView.lastDyAbs = 0;
        this.handleHotRegionPressed(hotRegion, mouseEvent);
    }

    public abstract void handleHotRegionPressed(HotRegion var1, MouseEvent var2);

    public void hotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
        if (!this.acceptMouseEvent(mouseEvent)) {
            InViewData inViewData = this.inView;
            inViewData.lostdxRel = inViewData.lostdxRel + n3;
            InViewData inViewData2 = this.inView;
            inViewData2.lostdyRel = inViewData2.lostdyRel + n4;
            return;
        }
        if (n3 * this.inView.lostdxRel >= 0) {
            n3 += this.inView.lostdxRel;
        }
        if (n4 * this.inView.lostdyRel >= 0) {
            n4 += this.inView.lostdyRel;
        }
        this.inView.lostdyRel = 0;
        this.inView.lostdxRel = 0;
        this.inView.lastDxAbs = n;
        this.inView.lastDyAbs = n2;
        this.handleHotRegionDragged(hotRegion, mouseEvent, n, n2, n3, n4);
        this.mouseEventComplete(mouseEvent);
    }

    public abstract void handleHotRegionDragged(HotRegion var1, MouseEvent var2, int var3, int var4, int var5, int var6);

    public void hotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent) {
        this.handleHotRegionReleased(hotRegion, mouseEvent, this.inView.lastDxAbs, this.inView.lastDyAbs);
    }

    public abstract void handleHotRegionReleased(HotRegion var1, MouseEvent var2, int var3, int var4);

    public IPresentationStateProvider getPresentationStateProvider() {
        return null;
    }

    public void applyPresentationState(IFramePresentationStateSource iFramePresentationStateSource) {
    }

    public boolean getLastDenied() {
        return this.inView.lastDenied;
    }

    public void mouseEventComplete(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            this.inView.systemDuration = System.currentTimeMillis() - this.inView.lastStartMillis;
            this.inView.lastMouseEventWhen = mouseEvent.getWhen() + this.inView.systemDuration;
        } else {
            this.inView.lastMouseEventWhen = System.currentTimeMillis();
        }
    }

    public boolean acceptMouseEvent(MouseEvent mouseEvent) {
        this.inView.lastDenied = mouseEvent.getWhen() < this.inView.lastMouseEventWhen;
        if (!this.inView.lastDenied) {
            this.inView.lastStartMillis = System.currentTimeMillis();
        }
        return !this.inView.lastDenied;
    }

    public void handleTEvent(TEvent tEvent, Object object, int n) {
        if (this.teventListeners != null) {
            int n2 = 0;
            while (n2 < this.teventListeners.size()) {
                this.teventListeners.get(n2).handleTEvent(tEvent, object, n, this);
                ++n2;
            }
        }
        switch (tEvent.id) {
            case 95: {
                SpacingDef spacingDef = (SpacingDef)object;
                if (!this.getImageState().spacingDefs().contains(spacingDef)) break;
                this.getImageState().pixelSizeX = spacingDef.getDataPixelSizeX();
                this.getImageState().pixelSizeY = spacingDef.getDataPixelSizeY();
                this.resetOverlayCachedValues();
                this.getImageState().updated();
                this.paintOverlays(this.myImage);
                if (this.getRenderer() != null) {
                    this.getRenderer().handleTEvent(tEvent, object, n, this);
                }
                this.getImageState().updated();
                this.refresh();
                this.invalidate();
                this.repaint();
                break;
            }
            case 123: {
                PresentationObjectCopyData presentationObjectCopyData = (PresentationObjectCopyData)object;
                this.copyPresentationObject(presentationObjectCopyData.getPresentationObject(), presentationObjectCopyData.getMode());
            }
        }
    }

    public void setVis(VisData visData) {
        this.vis = visData;
        if (!this.isFunctional()) {
            this.init();
        }
    }

    public void init() {
    }

    public VisDisplay2 getDisplay() {
        if (this.vis == null || this.vis.getParent() == null) {
            return null;
        }
        return this.vis.getParent().getVisDisplay();
    }

    public VisDisplayData getDisplayData() {
        if (this.vis == null) {
            return null;
        }
        return this.vis.getParent();
    }

    public VisData getVis() {
        return this.vis;
    }

    public Vis2 getVisView() {
        if (this.vis == null) {
            return null;
        }
        return this.vis.getVisual();
    }

    public int getOptimumViewingWidth() {
        return 512;
    }

    public int getOptimumViewingHeight() {
        return 512;
    }

    public boolean isColor() {
        return this.getTransferFunction() == null || this.getTransferFunction().getClass() != WindowTransferFunction.class;
    }

    public synchronized void print(Graphics graphics, Rectangle rectangle, boolean bl, int n, boolean bl2) {
        Rectangle rectangle2 = new Rectangle(this.getBounds());
        this.setBounds(0, 0, rectangle.width, rectangle.height);
        this.invalidate();
        RGBBufferedImageHolder rGBBufferedImageHolder = new RGBBufferedImageHolder(rectangle.width, rectangle.height);
        int n2 = 0;
        while (n2 < this.overlays.size()) {
            Overlay overlay = this.overlays.get(n2);
            overlay.setPrintFont(rGBBufferedImageHolder.graphics, rectangle, n);
            ++n2;
        }
        if (this.getMapping() != null) {
            this.getMapping().setPrintFont(rGBBufferedImageHolder.graphics, rectangle, n);
        }
        this.setBounds(0, 0, rectangle.width + 2, rectangle.height + 2);
        if (this.getMapping() != null) {
            this.getMapping().updateContent(true, false);
        }
        this.paint(rGBBufferedImageHolder);
        graphics.drawImage(rGBBufferedImageHolder.image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        n2 = 0;
        while (n2 < this.overlays.size()) {
            this.overlays.get(n2).resetPrintFont();
            ++n2;
        }
        rGBBufferedImageHolder.release();
        this.setBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    public ViewSnapshot renderToSnapshot(int n, int n2, int n3, int n4, double d, double d2, OverlayMode overlayMode, boolean bl) {
        Object object;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        this.print(bufferedImage.getGraphics(), rectangle, false, 0, false);
        if (!bl) {
            object = this.getOverlays();
            Iterator<Overlay> iterator = object.iterator();
            while (iterator.hasNext()) {
                Overlay overlay = iterator.next();
                if (!overlay.captureAsRGB()) continue;
                bl = true;
                break;
            }
        }
        object = new ViewSnapshot(overlayMode, n, n2, bl);
        ((ViewSnapshot)object).setDataBuffer(((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData());
        return object;
    }

    public void localWindow(int n, int n2) {
    }

    public TransferFunction getTransferFunction() {
        return null;
    }

    public List<Overlay> getPresentationObjects() {
        return this.overlays;
    }

    public List<Overlay> getVisiblePresentationObjects() {
        return this.getPresentationObjects();
    }

    public void broadcastUpdate(Object object) {
        TEvent tEvent = new TEvent();
        tEvent.id = 71;
        tEvent.source = this;
        TEventDispatch.sendEvent(tEvent, object);
    }

    protected MousePositionDestination getMouseFollower() {
        return null;
    }

    @Override
    public void progressNotification(final String string, final double d) {
        EventUtil.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                View.this.progressNotificationImpl(string, d);
            }
        });
    }

    private void progressNotificationImpl(String string, double d) {
        InViewData inViewData = this.inView;
        if (inViewData == null) {
            this.inView = inViewData = new InViewData();
        }
        if (inViewData.progress == null && (int)(d * 100.0) < 100) {
            inViewData.progress = new TProgressBar();
            inViewData.progress.setMinimum(0);
            inViewData.progress.setMaximum(100);
            inViewData.progress.setShowProgressText(true);
        }
        if ((int)(d * 100.0) >= 100) {
            inViewData.progress = null;
        } else {
            inViewData.progress.setProgressText(String.valueOf(string) + ": ");
            inViewData.progress.setVal((int)(d * 100.0));
        }
        if (this.getVisView() != null) {
            this.getVisView().repaint();
        }
    }

    @Override
    public Component getProgressDisplay() {
        if (this.inView == null) {
            return null;
        }
        return this.inView.progress;
    }

    public void resetOverlayCachedValues() {
        List<Overlay> list = this.getPresentationObjects();
        for (Overlay overlay : list) {
            if (overlay == null) continue;
            overlay.resetCachedValues();
        }
    }

    public PresentationObject getSelectedPO() {
        for (PresentationObject presentationObject : Overlay.filter(PresentationObject.class, this.getPresentationObjects())) {
            if (!presentationObject.isSelected()) continue;
            return presentationObject;
        }
        return null;
    }

    public boolean copyToOtherDisplays(SyncablePresentationObject syncablePresentationObject) {
        SyncUtils.CompatibilityMode compatibilityMode = SyncUtils.CompatibilityMode.FRAME_OF_REFERENCE_TRANSFORM_AVAILABLE;
        return this.copyToDestinations(syncablePresentationObject, compatibilityMode.getOverlaySynchronizationMode(), SyncUtils.getCompatibleDisplaySets(this.getVis(), JVision2.getMainFrame().getDisplays(), compatibilityMode));
    }

    public boolean copyToDestinations(SyncablePresentationObject syncablePresentationObject, OverlaySynchronizationMode overlaySynchronizationMode, List<VisData> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (VisData visData : list) {
            this.copyToVis(visData, syncablePresentationObject, overlaySynchronizationMode);
            VisDisplay2 visDisplay2 = visData.getParent().getVisDisplay();
            visDisplay2.setNavigPos(visData.getParent().indexOf(visData), true, false);
            visDisplay2.invalidate();
            visDisplay2.repaint();
        }
        return true;
    }

    public void copyToSelectedVis(PresentationObject presentationObject, OverlaySynchronizationMode overlaySynchronizationMode) {
        List<VisData> list = this.getDisplay().getVis();
        for (VisData visData : list) {
            View view = visData.getView();
            if (!visData.isSelected() || view == this) continue;
            this.copyToVis(visData, presentationObject, overlaySynchronizationMode);
        }
    }

    private void copyToVis(VisData visData, PresentationObject presentationObject, OverlaySynchronizationMode overlaySynchronizationMode) {
        View view = visData.getView();
        if (!visData.isLoaded()) {
            visData.loadFinal();
        }
        try {
            TEvent tEvent = new TEvent();
            tEvent.id = 123;
            tEvent.source = this;
            view.handleTEvent(tEvent, new PresentationObjectCopyData(presentationObject, overlaySynchronizationMode), 0);
        }
        catch (Exception exception) {
            log.error("Copying overlay failed.", (Throwable)exception);
        }
    }

    public PresentationObject copyPresentationObject(PresentationObject presentationObject, OverlaySynchronizationMode overlaySynchronizationMode) {
        Object object;
        Cloneable cloneable;
        if (this.getRenderer() instanceof IRDCRenderer) {
            cloneable = presentationObject.getView();
            ((IRDCRenderer)((Object)this.getRenderer())).setGeometry(((View)cloneable).getcwidth(), ((View)cloneable).getcheight(), 0, ((View)cloneable).getcwidth());
        }
        cloneable = presentationObject.copyTo(this, overlaySynchronizationMode);
        this.addOverlay((Overlay)cloneable);
        if (((PresentationObject)cloneable).getHistogramOverlay() != null && ((PresentationObject)cloneable).getHistogramOverlay().isVisible()) {
            object = new ImageRegion((ClippingShape)((Object)cloneable));
            IImageRegionProperties iImageRegionProperties = null;
            Renderer renderer = this.getRenderer();
            if (renderer.getRegionSource() != null) {
                iImageRegionProperties = renderer.getRegionSource().getImageRegionProperties((ImageRegion)object, ((Overlay)cloneable).getHeight(), ((Overlay)cloneable).getHeight(), renderer.getImageState().getCurrentValueMapping());
            }
            if (iImageRegionProperties != null && iImageRegionProperties.getHistogram() != null) {
                ((PresentationObject)cloneable).getHistogramOverlay().setHistogram(iImageRegionProperties.getHistogram());
                ((PresentationObject)cloneable).setShapeChanged(true);
            }
        }
        if (((PresentationObject)cloneable).getDataProfilePlot() != null) {
            ((PresentationObject)cloneable).getDataProfilePlot().setPointSequence((PointSequence)((Object)cloneable));
            ((PresentationObject)cloneable).setShapeChanged(true);
        }
        if ((object = ((PresentationObject)cloneable).getCompanions()) != null) {
            int n = 0;
            while (n < ((Overlay[])object).length) {
                if (object[n] != null) {
                    if (object[n] instanceof PresentationObject) {
                        ((PresentationObject)object[n]).setShapeChanged(true);
                    }
                    this.addOverlay(object[n]);
                }
                ++n;
            }
        }
        ((PresentationObject)cloneable).setShapeChanged(true);
        this.invalidate();
        ((PresentationObject)cloneable).updateLegend();
        this.setImgInvalid(true);
        this.repaint();
        this.getVis().unsave("PRESENTATION_STATE");
        return cloneable;
    }

    public boolean isLockBackground() {
        return this.lockBackground;
    }

    public Collection<Overlay> getExcludeFromLock() {
        return this.excludeFromLock;
    }

    public void setExcludeFromLock(Collection<Overlay> collection) {
        this.excludeFromLock = collection;
    }

    public PresentationObject getCustomizedOverlay(PresentationObject presentationObject) {
        return null;
    }

    public void visSet(Vis2 vis2) {
        if (vis2 == null) {
            this.lockBackground(false);
        } else {
            IViewMouseHandler iViewMouseHandler = this.getMouseHandler();
            if (iViewMouseHandler.POselectedOnThisView()) {
                PresentationObject presentationObject = this.getDisplay().getSelectedPO();
                if (presentationObject == null && iViewMouseHandler instanceof ViewMouseHandler) {
                    presentationObject = ((ViewMouseHandler)iViewMouseHandler).getActivePO();
                }
                iViewMouseHandler.lockBackgroundForPOandCompanions(presentationObject);
            }
        }
        if (vis2 == null && this.frameData != null && this.frameData.getRawDataContainer() != null) {
            this.frameData.getRawDataContainer().resetHistogram();
        }
    }

    @SuppressWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"})
    public boolean equals(Object object) {
        if (object instanceof MyWeakReference) {
            View view = (View)((MyWeakReference)object).get();
            return this == view;
        }
        return super.equals(object);
    }

    public boolean repaintViewAfterEachWindowingEvent() {
        return false;
    }

    public boolean visBorderEnabled() {
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public List<PAction> getViewContextMenuButtonActions() {
        return new ArrayList<PAction>();
    }

    public IVOILUT createVOILUTForHijackedPresentationState(boolean bl, IPixelDataFrame<?> iPixelDataFrame) {
        return null;
    }

    public List<PAction> getViewContextMenuTextActions() {
        return new ArrayList<PAction>(1);
    }

    public boolean isCine() {
        return false;
    }

    public static enum CAPTURE_STATES {
        ZOOM_PAN,
        WINDOW_LEVEL,
        INVERT,
        TRANSFORMATION,
        FILTER;

    }

    private static class InViewData {
        private int lostdxRel;
        private int lostdyRel;
        private boolean interaction;
        private int lastDxAbs;
        private int lastDyAbs;
        private boolean lastDenied;
        private long lastMouseEventWhen;
        private long lastStartMillis;
        private long systemDuration;
        private TProgressBar progress;
        private int[] lockedBgBuffer;
        private boolean bgWasLockedOnStart;
        private Collection<Overlay> wasExcludedOnStart;

        private InViewData() {
        }
    }

    public static enum OverlayMode {
        PRINT_BURN_MAPPINGS,
        PRINT_OVERLAY_ALL,
        PRINT_OVERLAY_ROI,
        PRINT_OVERLAY_NONE,
        PRINT_OVERLAY_ALL_AND_ROI,
        PRINT_BURN_ROI;

    }
}

