/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.tiani.jvision.image.OutputDeviceMetric;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.FullVisualFitHandler;
import com.tiani.jvision.image.fithandler.TrueSizeFitHandler;

public class SnapOutputGeometry {
    public int minWidth;
    public int minHeight;
    public int maxWidth;
    public int maxHeight;
    public double widthMM;
    public double heightMM;
    public AreaFitHandler vpHandler;
    public int destinationWidth;
    public int destinationHeight;
    public boolean aspectRatioChangeAllowed = true;

    public SnapOutputGeometry(int n, int n2, int n3, int n4) {
        this.minWidth = n;
        this.minHeight = n2;
        this.maxWidth = n3;
        this.maxHeight = n4;
        this.widthMM = 0.0;
        this.heightMM = 0.0;
        this.vpHandler = new FullVisualFitHandler(OutputDeviceMetric.neutral);
        this.vpHandler.setBorderLockMode(false);
        this.destinationWidth = n;
        this.destinationHeight = n2;
    }

    public SnapOutputGeometry(int n, int n2, int n3, int n4, double d, double d2) {
        this.minWidth = n;
        this.minHeight = n2;
        this.maxWidth = n3;
        this.maxHeight = n4;
        this.widthMM = d;
        this.heightMM = d2;
        OutputDeviceMetric outputDeviceMetric = new OutputDeviceMetric(d / (double)this.maxWidth, d2 / (double)this.maxHeight);
        this.vpHandler = new TrueSizeFitHandler(outputDeviceMetric);
        this.vpHandler.setBorderLockMode(false);
        this.destinationWidth = 0;
        this.destinationHeight = 0;
    }

    public void initDestination() {
        if (this.vpHandler instanceof TrueSizeFitHandler) {
            ((TrueSizeFitHandler)this.vpHandler).setOutputDevice(new OutputDeviceMetric(this.widthMM / (double)this.destinationWidth, this.heightMM / (double)this.destinationHeight));
        }
    }
}

