/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.IPickingHandler;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.info.ImageState;
import javax.vecmath.Point3d;

public class PickingHandler2D
implements IPickingHandler {
    private static PickingHandler2D instance = new PickingHandler2D();

    private PickingHandler2D() {
    }

    public static PickingHandler2D getInstance() {
        return instance;
    }

    public PickingResult getPickByImageCoordinates(double[] dArray, ImageState imageState, IImageInformation iImageInformation) {
        Point3d point3d = iImageInformation.getPointOrigin();
        double[] dArray2 = iImageInformation.getImageOrientation();
        if (iImageInformation.getFrameOfReferenceUID() != null && point3d != null && dArray2 != null) {
            dArray[0] = dArray[0] * imageState.getDataPixelSizeX();
            dArray[1] = dArray[1] * imageState.getDataPixelSizeY();
            Point3d point3d2 = new Point3d(point3d.x + dArray[0] * dArray2[0] + dArray[1] * dArray2[3], point3d.y + dArray[0] * dArray2[1] + dArray[1] * dArray2[4], point3d.z + dArray[0] * dArray2[2] + dArray[1] * dArray2[5]);
            return new PickingResult(point3d2, point3d2, point3d2, iImageInformation.getFrameOfReferenceUID());
        }
        Point3d point3d3 = new Point3d(dArray[0], dArray[1], 0.0);
        return new PickingResult(point3d3, point3d3, point3d3, "");
    }

    @Override
    public PickingResult pick(double d, double d2, ImageState imageState, IImageInformation iImageInformation) {
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = new double[]{0.0, 0.0};
        imageState.screenToImage(dArray, dArray2, null);
        return this.getPickByImageCoordinates(dArray2, imageState, iImageInformation);
    }
}

