/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.ILocalizerPlane;
import com.tiani.jvision.overlay.LocalizerLineOverlay;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class PassiveLocalizerPlane
implements ILocalizerPlane {
    private static final ALogger LOG = ALogger.getLogger(PassiveLocalizerPlane.class);
    private static final String DEFAULT_IMAGE_ORIENTATION = "LINEAR";
    private final IImageInformation ii;

    public PassiveLocalizerPlane(IImageInformation iImageInformation) {
        this.ii = iImageInformation;
    }

    @Override
    public LocalizerLineOverlay getImageRepresentation(IImageInformation iImageInformation, boolean bl) {
        if (iImageInformation.getImageClass() != IImageInformation.ImageClass.OPT3D) {
            return null;
        }
        Sequence sequence = iImageInformation.getDatasetPerFrame().getSequence(2228273);
        if (sequence == null || sequence.isEmpty()) {
            return null;
        }
        Attributes attributes = (Attributes)sequence.get(0);
        if (!this.ii.getSOPInstanceUID().equals(attributes.getString(528725))) {
            return null;
        }
        if (!DEFAULT_IMAGE_ORIENTATION.equals(attributes.getString(2228281))) {
            return null;
        }
        double[] dArray = attributes.getDoubles(0x220032);
        if (dArray == null || dArray.length != 4) {
            LOG.debug("Unsupported OCT Localizer with curved path");
            return null;
        }
        return new LocalizerLineOverlay(dArray[1], dArray[0], dArray[3], dArray[2], iImageInformation.getInstanceNumber(), iImageInformation.getFrameNumber());
    }
}

