/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.event;

import com.agfa.pacs.exceptionhandler.ExceptionHandlerFactory;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.event.EventDispatchInterface;
import com.tiani.jvision.event.JVEventDispatch;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventHandler;
import com.tiani.jvision.vis.VisDisplay2;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TEventDispatch {
    private static final ALogger log = ALogger.getLogger(TEventDispatch.class);
    public static int ALL_DISPLAYS = 4;
    public static int SYNCHRONIZED_DISPLAYS = 8;
    public static int ALL_VISUALS = 16;
    public static int SELECTED_VISUALS = 32;
    public static int LASTMODIFIED_VISUAL = 256;
    public static int RENDERER_ROOT = 512;
    public static int REGISTERED_LISTENERS = 4096;
    protected static EventDispatchInterface dispatcher = new JVEventDispatch();
    private static Vector<WeakReference<TEventHandler>> addonListeners = new Vector();

    public static void sendEvent(TEvent tEvent, Object object) {
        dispatcher.sendEvent(null, tEvent, object, true);
        TEventDispatch.dispatchToOthers(tEvent, object, 0);
    }

    public static void sendEvent(TEvent tEvent, Object object, boolean bl) {
        dispatcher.sendEvent(null, tEvent, object, bl);
        TEventDispatch.dispatchToOthers(tEvent, object, 0);
    }

    public static void sendEvent(List<VisDisplay2> list, TEvent tEvent, Object object, boolean bl) {
        for (VisDisplay2 visDisplay2 : list) {
            dispatcher.sendEvent(visDisplay2, tEvent, object, bl);
        }
        TEventDispatch.dispatchToOthers(tEvent, object, 0);
    }

    public static void sendEvent(VisDisplay2 visDisplay2, TEvent tEvent, Object object, boolean bl) {
        dispatcher.sendEvent(visDisplay2, tEvent, object, bl);
        TEventDispatch.dispatchToOthers(tEvent, object, 0);
    }

    public static void sendEvent(TEvent tEvent, Object object, int n) {
        dispatcher.sendEventToVisScreens(tEvent, object, n);
        if ((n & REGISTERED_LISTENERS) != 0) {
            TEventDispatch.dispatchToOthers(tEvent, object, n);
        }
    }

    public static void sendEventToVis(VisDisplay2 visDisplay2, TEvent tEvent, Object object, int n) {
        dispatcher.sendEventToVis(visDisplay2, tEvent, object, n);
        if ((n & REGISTERED_LISTENERS) != 0) {
            TEventDispatch.dispatchToOthers(tEvent, object, n);
        }
    }

    private static boolean containsListener(TEventHandler tEventHandler) {
        Iterator<WeakReference<TEventHandler>> iterator = addonListeners.iterator();
        while (iterator.hasNext()) {
            Reference reference = iterator.next();
            if (reference.get() == null) {
                iterator.remove();
                continue;
            }
            if (tEventHandler != reference.get()) continue;
            return true;
        }
        return false;
    }

    public static void addListener(TEventHandler tEventHandler) {
        if (!TEventDispatch.containsListener(tEventHandler)) {
            addonListeners.addElement(new WeakReference<TEventHandler>(tEventHandler));
        }
    }

    public static void removeListener(TEventHandler tEventHandler) {
        Iterator<WeakReference<TEventHandler>> iterator = addonListeners.iterator();
        while (iterator.hasNext()) {
            Reference reference = iterator.next();
            if (reference.get() == null) {
                iterator.remove();
                continue;
            }
            if (tEventHandler != reference.get()) continue;
            iterator.remove();
            return;
        }
    }

    private static void dispatchToOthers(TEvent tEvent, Object object, int n) {
        if (addonListeners.isEmpty()) {
            return;
        }
        Iterator<WeakReference<TEventHandler>> iterator = addonListeners.iterator();
        while (iterator.hasNext()) {
            Reference reference = iterator.next();
            TEventHandler tEventHandler = (TEventHandler)reference.get();
            if (tEventHandler == null) {
                iterator.remove();
                continue;
            }
            try {
                tEventHandler.handleTEvent(tEvent, object, n);
            }
            catch (Throwable throwable) {
                log.error("Exception occured while dispatchToOthers(" + tEvent.id + "): ", throwable);
                ExceptionHandlerFactory.getInstance().handleException(throwable);
            }
        }
    }
}

