/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.event;

import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.image.IEarlyEvent;
import java.lang.reflect.Field;
import java.util.Hashtable;

public class TEvent
implements IEarlyEvent {
    private static final ALogger log = ALogger.getLogger(TEvent.class);
    public static final int EVENTID_VISUAL_NAVIGATION = 1;
    public static final int EVENTID_VISUAL_ZOOM = 2;
    public static final int EVENTID_VISUAL_INVERT = 6;
    public static final int EVENTID_VISUAL_FLIP_HOR = 7;
    public static final int EVENTID_VISUAL_FLIP_VER = 8;
    public static final int EVENTID_VISUAL_ROTATE_LEFT = 9;
    public static final int EVENTID_VISUAL_ROTATE_RIGHT = 10;
    public static final int EVENTID_VISUAL_FILTER = 12;
    public static final int EVENTID_VISUAL_VIEWPORT = 17;
    public static final int EVENTID_HOTREGION_ENTERED = 21;
    public static final int EVENTID_HOTREGION_EXITED = 22;
    public static final int EVENTID_ACTIVE_IMAGE = 53;
    public static final int EVENTID_TOPO_VISIBILITY = 55;
    public static final int EVENTID_POINT_OF_INTEREST = 57;
    public static final int EVENTID_VISUAL_WINDOW = 62;
    public static final int EVENTID_VISUAL_TF_SPEC = 63;
    public static final int EVENTID_VISUAL_WINDOW_PRESET = 64;
    public static final int EVENTID_CALIBRATE_PIXELSIZE = 65;
    public static final int EVENTID_VISUAL_RESET_ALL = 66;
    public static final int EVENTID_LEFTDOUBLECLICK = 69;
    public static final int EVENTID_UPDATE = 71;
    public static final int EVENTID_VIEW_CENTER = 72;
    public static final int EVENTID_VIEW_TRANSFORM = 73;
    public static final int EVENTID_LIGHT_TRANSFORM = 74;
    public static final int EVENTID_VOLUME_TRANSFORM = 75;
    public static final int EVENTID_UPDATE_CPR_VIEW = 78;
    public static final int EVENTID_ZOOM_MODE = 80;
    public static final int EVENTID_VISUAL_REPAINT = 81;
    public static final int EVENTID_RENDERER_FUSION_OPERATOR = 84;
    public static final int EVENTID_RENDERER_FILTER_OPERATOR = 85;
    public static final int EVENTID_MPR_CENTER_PLANES = 87;
    public static final int EVENTID_SYNC_RENDERER_BY_NAME = 88;
    public static final int EVENTID_PLANAR_CLIP = 89;
    public static final int EVENTID_SYNC_DISPLAYS = 90;
    public static final int EVENTID_OVERLAY_MINILOCALIZER = 92;
    public static final int EVENTID_IMAGE_SPACING_CHANGED = 95;
    public static final int EVENTID_RENDERER_PROVIDES_NEW_TF = 101;
    public static final int EVENTID_RENDERER_PROVIDES_NEW_HR = 102;
    public static final int EVENTID_INDEX_CHANGED = 103;
    public static final int EVENTID_COLOR_WINDOWING_SYNC = 106;
    public static final int EVENTID_FORCE_COLORPALETTE = 107;
    public static final int EVENTID_TF_FLIP_REQUEST = 108;
    public static final int EVENTID_SET_TF_FLIPPED = 109;
    public static final int EVENTID_LOCALIZER_TOGGLE = 116;
    public static final int EVENTID_TF_SET_LIVE = 117;
    public static final int EVENTID_OVERLAY_PICTURE_IN_PICTURE = 119;
    public static final int EVENTID_VALUE_MAPPING_CHANGED = 120;
    public static final int EVENTID_OVERLAY_NUK_COLORBAR = 121;
    public static final int EVENTID_OVERLAY_NUK_UPDATE = 122;
    public static final int EVENTID_COPY_OVERLAY = 123;
    public static final int EVENTID_UPDATE_REGISTRATION_TRANSFORM = 124;
    public static final int EVENTID_UPDATE_FUSION_PERCENTAGE = 125;
    public static final int EVENTID_MAMMO_ZOOM_BY_SCROLL_WHEEL = 126;
    public static final int EVENTID_MAMMO_CAD_MARKERS = 127;
    public static final int EVENTID_NEXT_QUADRANT = 128;
    public static final int EVENTID_PREVIOUS_QUADRANT = 129;
    public static final int EVENTID_MAMMO_FIT_TO_BREAST = 130;
    public static final int EVENTID_SLICE_THICKNESS = 131;
    public static final int EVENTID_VISUAL_VIEWPORT_ALIGNMENT_X = 132;
    public static final int EVENTID_MAMMO_CAD_MARKERS_AVAILABLE = 133;
    public static final int ADD_NEW_ISODOSE_BITMASK = 134;
    public static final int EVENTID_OVERLAY_PROVIDER_ADDED = 135;
    public static final int ACTION_START = 0;
    public static final int ACTION_PROGRESS = 1;
    public static final int ACTION_END = 2;
    protected static int dynamicID = 1000;
    protected static Hashtable<String, Integer> dyn_table = new Hashtable(50);
    private static Hashtable<Integer, String> names = new Hashtable();
    public Object source = null;
    public int id = 0;
    public int interactionModifier = 2;
    public int destinationNodeID = 0;

    static {
        try {
            Field[] fieldArray = TEvent.class.getFields();
            int n = 0;
            while (n < fieldArray.length) {
                if (fieldArray[n].getName().startsWith("EVENTID")) {
                    names.put(new Integer(fieldArray[n].getInt(null)), fieldArray[n].getName());
                }
                ++n;
            }
        }
        catch (Exception exception) {
            log.error("An exception occured: ", (Throwable)exception);
        }
    }

    public TEvent() {
    }

    public TEvent(int n) {
        this.id = n;
        this.interactionModifier = 2;
        this.destinationNodeID = 0;
    }

    public static int getNewEventID(String string) {
        if (dyn_table.containsKey(string)) {
            return -1;
        }
        dyn_table.put(string, new Integer(++dynamicID));
        names.put(new Integer(dynamicID), string);
        return dynamicID;
    }

    public static int getEventID(String string) {
        Integer n = dyn_table.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static int getThisEventID(String string) {
        int n = TEvent.getEventID(string);
        if (n < 0) {
            n = TEvent.getNewEventID(string);
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(names.get(this.id)).append('/');
        switch (this.interactionModifier) {
            case 0: {
                stringBuilder.append("START");
                break;
            }
            case 1: {
                stringBuilder.append("PROGRESS");
                break;
            }
            case 2: {
                stringBuilder.append("END");
            }
        }
        stringBuilder.append(" destNode:").append(this.destinationNodeID);
        return stringBuilder.toString();
    }

    @Override
    public boolean isPresentationState() {
        return false;
    }
}

