/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util.panel.flexible.behaviourcontrol;

import com.tiani.config.resources.ResourceManager;
import com.tiani.gui.util.panel.flexible.AbstractBehaviourControl;
import com.tiani.gui.util.panel.flexible.FlexiblePanel;
import com.tiani.gui.util.panel.flexible.behaviourcontrol.MouseOverVisibilityTrigger;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorButton;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorPanel;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;

public class MouseOverButtonsBehaviourControl
extends AbstractBehaviourControl {
    private JButton[] buttons;
    private JPanel buttonsPanel;
    private MouseOverVisibilityTrigger listener;
    private int realButtonsCount;

    public MouseOverButtonsBehaviourControl(FlexiblePanel flexiblePanel, int n) {
        super(flexiblePanel, n);
        this.buttons = new JButton[this.orderedActions.length];
        int n2 = 0;
        while (n2 < this.orderedActions.length) {
            if (this.orderedActions[n2] != null) {
                this.buttons[n2] = new StateControlButton(this.orderedActions[n2]);
                this.buttons[n2].setText(null);
                ++this.realButtonsCount;
            }
            ++n2;
        }
        this.buttonsPanel = new Panel();
        this.buttonsPanel.setOpaque(false);
        this.buttonsPanel.setLayout(new GridLayout(1, this.realButtonsCount));
        n2 = 0;
        while (n2 < this.buttons.length) {
            if (this.buttons[n2] != null) {
                this.buttonsPanel.add(this.buttons[n2]);
            }
            ++n2;
        }
        this.listener = new MouseOverVisibilityTrigger(flexiblePanel, this.buttonsPanel);
        this.listener.installOn(this.buttonsPanel);
        this.listener.installOn(flexiblePanel);
    }

    @Override
    public void close() {
        this.listener.deinstallFrom(this.flexiblePanel);
        this.listener.deinstallFrom(this.buttonsPanel);
        super.close();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.flexiblePanel.getBehaviour();
        int n2 = 0;
        while (n2 < this.buttons.length) {
            if (this.buttons[n2] != null && this.isIndexForState(n, n2)) {
                this.showAllExcept(this.buttons[n2]);
                break;
            }
            ++n2;
        }
        super.stateChanged(changeEvent);
        this.buttonsPanel.setVisible(false);
        if (this.buttonsPanel.getParent() != null) {
            this.buttonsPanel.getParent().remove(this.buttonsPanel);
        }
    }

    private void showAllExcept(JButton jButton) {
        this.buttonsPanel.removeAll();
        this.buttonsPanel.setLayout(new GridLayout(1, this.realButtonsCount - 1));
        int n = 0;
        while (n < this.buttons.length) {
            if (this.buttons[n] != null && jButton != this.buttons[n]) {
                this.buttonsPanel.add(this.buttons[n]);
            }
            ++n;
        }
    }

    @Override
    protected Icon loadIcon(String string) {
        return ResourceManager.icon(MouseOverButtonsBehaviourControl.class, string);
    }

    public static class Panel
    extends MultiMonitorPanel {
        @Override
        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (bl) {
                this.getComponent(0).requestFocus();
            }
        }
    }

    private static class StateControlButton
    extends MultiMonitorButton {
        StateControlButton(Action action) {
            this.setAction(action);
            this.setName((String)action.getValue("Name"));
        }

        @Override
        public Insets getInsets() {
            return new Insets(3, 3, 3, 3);
        }
    }
}

