/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util.panel.flexible;

import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.util.FocusUtil;
import com.tiani.gui.util.panel.flexible.AbstractVisualizer;
import com.tiani.gui.util.panel.flexible.FlexiblePanel;
import com.tiani.gui.workarounds.WindowLocationWorkaround;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class DialogVisualizer
extends AbstractVisualizer {
    private static final ALogger log = ALogger.getLogger(DialogVisualizer.class);
    protected final String title;
    private Component parentContainer;
    private boolean stopped;
    private JDialog dialog;
    private WindowListener dialogWindowAdapter;
    private FocusListener dialogFocusAdapter;
    private WindowLocationWorkaround dialogLocationAdapter;
    private int dialogCloseBehaviour;

    protected DialogVisualizer(FlexiblePanel flexiblePanel, Component component, Rectangle rectangle, String string, boolean bl, int n) {
        super(flexiblePanel);
        this.parentContainer = component;
        this.title = string != null ? string : "Dialog";
        this.dialogCloseBehaviour = n;
        this.dialogWindowAdapter = new DialogWindowAdapter();
        this.dialogFocusAdapter = new DialogFocusAdapter();
        this.dialogLocationAdapter = new WindowLocationWorkaround();
        this.startWhenParentIsPresent(bl, rectangle);
    }

    private void startWhenParentIsPresent(final boolean bl, final Rectangle rectangle) {
        if (this.stopped) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this.parentContainer);
        if (window == null) {
            Thread.yield();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogVisualizer.this.startWhenParentIsPresent(bl, rectangle);
                }
            });
            return;
        }
        this.buildDialog(window, rectangle);
        if (bl && rectangle != null) {
            this.setHidden(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHidden(boolean bl) {
        DialogVisualizer dialogVisualizer = this;
        synchronized (dialogVisualizer) {
            if (this.dialog != null) {
                boolean bl2;
                boolean bl3 = bl2 = !bl;
                if (this.shouldRetainFocusWindow()) {
                    FocusUtil.setVisibleButRetainWindowFocus(this.dialog, bl2);
                } else {
                    this.dialog.setVisible(bl2);
                }
                if (bl) {
                    this.notifyWasHidden();
                }
            } else {
                log.warn("Doing nothing. setHidden(" + bl + ") was called while waiting for Window parent to get non-null: " + this.parentContainer.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHidden() {
        DialogVisualizer dialogVisualizer = this;
        synchronized (dialogVisualizer) {
            return !this.dialogIsVisible();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deinstall() {
        DialogVisualizer dialogVisualizer = this;
        synchronized (dialogVisualizer) {
            this.stopped = true;
            if (this.dialog != null) {
                this.dialog.setVisible(false);
                try {
                    this.dialog.dispose();
                }
                catch (Exception exception) {}
            }
            this.dialog = null;
            this.setVisualStateListener(null);
        }
        super.deinstall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Rectangle getRealDialogBounds() {
        DialogVisualizer dialogVisualizer = this;
        synchronized (dialogVisualizer) {
            return this.dialogIsVisible() ? this.dialog.getBounds() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRealDialogBounds(Rectangle rectangle, boolean bl) {
        DialogVisualizer dialogVisualizer = this;
        synchronized (dialogVisualizer) {
            if (this.dialog != null) {
                if (bl) {
                    this.dialog.setLocation(rectangle.getLocation());
                    this.dialog.pack();
                } else {
                    this.dialog.setBounds(rectangle);
                }
                this.dialogLocationAdapter.setLocation(rectangle.getLocation());
                if (this.dialog.isShowing()) {
                    log.debug("Setting dialog bounds after dialog was made visible: this might lead to an unpainted Dialog!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh() {
        DialogVisualizer dialogVisualizer = this;
        synchronized (dialogVisualizer) {
            Dimension dimension;
            if (this.dialog != null && (dimension = this.getPreferredPanelSize()) != null) {
                Insets insets = this.dialog.getInsets();
                Insets insets2 = this.dialog.getContentPane().getInsets();
                this.dialog.setSize(dimension.width + insets.left + insets2.left + insets.right + insets2.right, dimension.height + insets.top + insets2.top + insets.bottom + insets2.bottom);
            }
        }
    }

    protected JDialog newDialog(Window window) {
        return window instanceof Dialog ? new JDialog((Dialog)window, this.title, false) : new JDialog((Frame)window, this.title, false);
    }

    protected boolean shouldRetainFocusWindow() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JDialog buildDialog(Window window, Rectangle rectangle) {
        DialogVisualizer dialogVisualizer = this;
        synchronized (dialogVisualizer) {
            if (this.dialog != null) {
                this.dialog.removeWindowListener(this.dialogWindowAdapter);
                this.dialog.removeFocusListener(this.dialogFocusAdapter);
                this.dialog.removeWindowListener(this.dialogLocationAdapter);
            }
            this.dialog = this.newDialog(window);
            this.dialog.setResizable(true);
            this.dialog.setDefaultCloseOperation(this.dialogCloseBehaviour);
            this.dialog.addWindowListener(this.dialogWindowAdapter);
            this.dialog.addFocusListener(this.dialogFocusAdapter);
            this.dialog.addWindowListener(this.dialogLocationAdapter);
            this.dialog.getContentPane().add(this.flexiblePanel);
            this.dialog.pack();
            if (rectangle != null) {
                this.setRealDialogBounds(this.ensureDialogSize(rectangle), false);
            } else {
                this.dialog.setLocationRelativeTo(this.parentContainer);
            }
            return this.dialog;
        }
    }

    public Dialog getRealDialog() {
        return this.dialog;
    }

    private Rectangle ensureDialogSize(Rectangle rectangle) {
        if (rectangle.width <= 0) {
            rectangle.width = this.dialog.getPreferredSize().width;
        }
        if (rectangle.height <= 0) {
            rectangle.height = this.dialog.getPreferredSize().height;
        }
        assert (rectangle.width > 0 && rectangle.height > 0) : "Cannot calculate dialog bounds, the panel seems to have no preferred size: " + rectangle;
        return rectangle;
    }

    private boolean dialogIsVisible() {
        return this.dialog == null ? false : this.dialog.isShowing();
    }

    private class DialogFocusAdapter
    extends FocusAdapter {
        private DialogFocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            DialogVisualizer.this.notifyGainedFocus();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            DialogVisualizer.this.notifyLostFocus();
        }
    }

    private class DialogWindowAdapter
    extends WindowAdapter {
        private boolean wasClose;

        private DialogWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.wasClose = true;
            DialogVisualizer.this.notifyWasClosed();
            ((Window)windowEvent.getComponent()).removeWindowListener(DialogVisualizer.this.dialogWindowAdapter);
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            if (!this.wasClose) {
                this.windowClosing(windowEvent);
            }
        }
    }
}

