/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.controls.hotregion;

import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.listtext.swingx.icon.IconUtil;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.gui.controls.hotregion.HotRegionImage;
import com.tiani.gui.controls.hotregion.HotRegionListener;
import com.tiani.gui.controls.hotregion.HotRegionPopup;
import com.tiani.gui.controls.hotregion.ToolbarHotRegion;
import com.tiani.gui.dialog.GUIMessageHandler;
import com.tiani.gui.util.LocationUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseEvent;

public class PopupHotRegion
extends ToolbarHotRegion
implements HotRegionListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static int maxSizeHorizontal = 999999;
    private static int maxSizeVertical = 999999;
    private static PIcon imgTriggerLB = new IAIconFactory(15).loadIcon("hotpopuplb.gif");
    int popupDirection = 0;
    int cols;
    int rows;
    private PopupHotRegionType popupTriggerType;
    private HotRegionPopup popup = new HotRegionPopup(this);
    private HotRegion popupTriggerHR = new ToolbarHotRegion();
    private boolean didMouseEnterWhilePopupWasOpen = false;
    private HotRegion activeHR;
    private Dimension popupImageSize;

    public PopupHotRegion() {
        this.setPopupTriggerType(PopupHotRegionType.Normal);
        this.setPopupTriggerFrontImage(imgTriggerLB);
        this.activeHR = this;
    }

    public static void setGlobalMaxSize(int n, int n2) {
        maxSizeHorizontal = n;
        maxSizeVertical = n2;
    }

    @Override
    public void destruct() {
        this.popupTriggerHR.destruct();
        super.destruct();
    }

    public HotRegion getHotRegionByName(String string) {
        int n = this.popup.getHotRegionCount();
        int n2 = 0;
        while (n2 < n) {
            HotRegion hotRegion = this.popup.getHotRegion(n2);
            String string2 = hotRegion.getName();
            if (string2.equals(string)) {
                return hotRegion;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        if (this.popup != null) {
            this.popup.setName(String.valueOf(string) + "Popup");
        }
    }

    public void setPopupDirection(int n) {
        this.popupDirection = n;
    }

    @Override
    public void setBackImage(Image image) {
        super.setBackImage(image);
        this.popupTriggerHR.setBackImage(image);
        this.popupTriggerHR.setGrabOffset(this.getBounds().x + this.grabOffsetX, this.getBounds().y + this.grabOffsetY);
    }

    @Override
    public void setGrabOffset(int n, int n2) {
        super.setGrabOffset(n, n2);
        this.popupTriggerHR.setGrabOffset(this.getBounds().x + this.grabOffsetX, this.getBounds().y + this.grabOffsetY);
    }

    public void addToPopup(HotRegion hotRegion) {
        if (this.popupTriggerType == PopupHotRegionType.Normal_NoClose) {
            this.popup.add(hotRegion, false);
        } else if (this.popupTriggerType == PopupHotRegionType.Normal) {
            hotRegion.setType(HotRegion.HotRegionType.Twostate_On);
            this.popup.add(hotRegion);
        } else {
            this.popup.add(hotRegion);
        }
        hotRegion.addListener(this);
    }

    public void removeFromPopup(HotRegion hotRegion) {
        this.popup.remove(hotRegion);
        hotRegion.removeListener(this);
    }

    public void removeAllFromPopup() {
        int n = 0;
        while (n < this.popup.getHotRegionCount()) {
            this.popup.getHotRegion(n).removeListener(this);
            ++n;
        }
        this.popup.removeAll();
    }

    @Override
    public void setDimmed(boolean bl) {
        super.setDimmed(bl);
        this.popupTriggerHR.setDimmed(bl);
        if (!bl) {
            this.hidePopup();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.popupTriggerHR.setEnabled(bl);
        if (!bl) {
            this.hidePopup();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.popupTriggerHR.setVisible(bl);
        if (!bl) {
            this.hidePopup();
        }
    }

    public void setPopupTriggerFrontImage(PIcon pIcon) {
        this.popupTriggerHR.setImage(pIcon);
    }

    public HotRegion getActiveHotRegion() {
        return this.activeHR;
    }

    public void setActiveHotRegion(HotRegion hotRegion) {
        this.activeHR = hotRegion;
        this.popup.setActiveHotRegion(hotRegion);
        if (hotRegion != null) {
            hotRegion.setOn(true);
            this.setScaledImage(hotRegion.getImage());
        }
        this.repaint();
    }

    private void setScaledImage(HotRegionImage hotRegionImage) {
        Image image = hotRegionImage.getImage();
        int n = image.getWidth(null);
        int n2 = this.calculateImageRectangle().width;
        HotRegionImage hotRegionImage2 = n2 > 0 && n2 < n ? new HotRegionImage(IconUtil.scaleImage((Image)image, (int)n2, (int)-1), true) : hotRegionImage;
        this.setImage(hotRegionImage2);
    }

    public void setPopupTriggerType(PopupHotRegionType popupHotRegionType) {
        if (this.popupTriggerType == popupHotRegionType) {
            return;
        }
        this.popupTriggerType = popupHotRegionType;
        this.remove(this.popupTriggerHR);
        this.removeListener(this);
        this.popupTriggerHR.removeListener(this);
        this.popup.removeFocusListener(this.popup);
        switch (this.popupTriggerType) {
            case Normal: {
                this.setType(HotRegion.HotRegionType.Twostate);
                this.addListener(this);
                break;
            }
            case Normal_NoClose: {
                this.setType(HotRegion.HotRegionType.Twostate);
                this.addListener(this);
                break;
            }
            case Hotregion: {
                this.setType(HotRegion.HotRegionType.Normal);
                this.addPopupTriggerHR();
                break;
            }
            case Hotregion_Dark: {
                this.setType(HotRegion.HotRegionType.Normal_Dark);
                this.addPopupTriggerHR();
            }
        }
        this.popup.addFocusListener(this.popup);
        this.relayout();
    }

    private void addPopupTriggerHR() {
        this.add(this.popupTriggerHR);
        this.popupTriggerHR.addListener(this);
    }

    public void setPopupImageSize(int n, int n2) {
        if (this.popup == null) {
            return;
        }
        this.popupImageSize = n == -1 && n2 == -1 ? null : new Dimension(n, n2);
    }

    public void showPopup() {
        int n;
        int n2;
        if (this.popup == null) {
            return;
        }
        int n3 = this.getBounds().height;
        int n4 = this.getLocationOnScreen().x;
        int n5 = this.getLocationOnScreen().y;
        int n6 = n4;
        int n7 = n5;
        if (this.popupImageSize == null) {
            HotRegionImage hotRegionImage = this.activeHR.getImage();
            if (hotRegionImage == null) {
                this.setPopupImageSize(0, 0);
            } else {
                this.setPopupImageSize(hotRegionImage.getImageMaxWidth(), hotRegionImage.getImageMaxHeight());
            }
        }
        this.rows = 1;
        this.cols = 1;
        if (this.popupDirection == 0) {
            n2 = this.popup.getHotRegionCount() * this.popupImageSize.width + 2;
            n = this.popupImageSize.height + 2;
            this.cols = this.popup.getHotRegionCount();
            if (n2 > maxSizeHorizontal) {
                int n8;
                this.cols = n8 = maxSizeHorizontal / this.popupImageSize.width;
                this.rows = (int)Math.ceil((float)this.popup.getHotRegionCount() / (float)n8);
                n2 = n8 * this.popupImageSize.width + 2;
                n += (this.rows - 1) * this.popupImageSize.height;
            }
        } else {
            n2 = this.popupImageSize.width + 2;
            n = this.popup.getHotRegionCount() * this.popupImageSize.height + 2;
            this.rows = this.popup.getHotRegionCount();
            if (n > maxSizeVertical) {
                int n9;
                this.rows = n9 = maxSizeVertical / this.popupImageSize.height;
                this.cols = (int)Math.ceil((float)this.popup.getHotRegionCount() / (float)n9);
                n = n9 * this.popupImageSize.height + 2;
                n2 += (this.cols - 1) * this.popupImageSize.width;
            }
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 > 999999) {
            n2 = 999999;
        }
        if (n > 999999) {
            n = 999999;
        }
        if (this.popupDirection == 0) {
            n7 = n5 + (n3 - n);
            n6 = n4 - n2;
        } else {
            n6 = n4;
            n7 = n5 + n3;
        }
        this.popup.setBounds(n6, n7, n2, n);
        LocationUtil.ensureVisibleLocationOverParent(this.popup, GUIMessageHandler.getParentWindow());
        this.popup.setVisible(true);
    }

    public void hidePopup() {
        if (this.popup == null) {
            return;
        }
        this.popup.setVisible(false);
    }

    public void popupClosed() {
        if (this.popupTriggerType.isHotregion()) {
            this.popupTriggerHR.setModeOut();
            this.popupTriggerHR.repaint();
        } else {
            this.setOn(false);
            this.setModeOut();
            this.repaint();
        }
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.relayout();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.setScaledImage(this.getImage());
        this.relayout();
    }

    public void relayout() {
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        if (this.popupTriggerType.isHotregion()) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            n5 = n < n2 ? n / 5 : n2 / 5;
            if (n5 < 9) {
                n5 = 9;
            }
            int n6 = n5;
            int n7 = n5;
            n4 = n2 - n7;
            this.popupTriggerHR.setBounds(n3, n4, n6, n7);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.didMouseEnterWhilePopupWasOpen = this.popup.isVisible();
        super.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.didMouseEnterWhilePopupWasOpen = false;
        super.mouseExited(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        if (this.popupTriggerType.isNormal() && this.didMouseEnterWhilePopupWasOpen) {
            this.didMouseEnterWhilePopupWasOpen = false;
            return;
        }
        super.mousePressed(mouseEvent);
    }

    private void fireReleaseActionExceptThis(MouseEvent mouseEvent, HotRegion hotRegion) {
        if (this.doNotFireAction()) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            HotRegionListener hotRegionListener = (HotRegionListener)this.listeners.get(n);
            if (hotRegionListener != this) {
                hotRegionListener.hotRegionReleased(hotRegion, mouseEvent);
            }
            ++n;
        }
    }

    @Override
    public void hotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent) {
        if (hotRegion == this && this.popupTriggerType.isNormal()) {
            this.didMouseEnterWhilePopupWasOpen = true;
            if (this.isOn()) {
                this.showPopup();
            } else {
                this.hidePopup();
            }
        } else if (hotRegion == this.popupTriggerHR) {
            this.showPopup();
        } else if (this.popupTriggerType != PopupHotRegionType.Normal_NoClose) {
            this.setActiveHotRegion(hotRegion);
            this.hidePopup();
            if (this.popupTriggerType != PopupHotRegionType.Hotregion && this.popupTriggerType != PopupHotRegionType.Hotregion_Dark) {
                this.setOn(false);
            }
            this.repaint();
            this.fireReleaseActionExceptThis(mouseEvent, hotRegion);
        }
    }

    @Override
    public void hotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
    }

    @Override
    public void hotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
    }

    public static enum PopupHotRegionType {
        Normal(true),
        Normal_NoClose(true),
        Hotregion(false),
        Hotregion_Dark(false);

        private boolean normal;

        private PopupHotRegionType(boolean bl) {
            this.normal = bl;
        }

        public boolean isHotregion() {
            return !this.normal;
        }

        public boolean isNormal() {
            return this.normal;
        }
    }
}

