/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.controls.hotregion;

import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.gui.controls.hotregion.HotRegionGroup;
import com.tiani.gui.controls.hotregion.PopupHotRegion;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorPanel;
import com.tiani.jvision.main.JVision2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JDialog;
import javax.swing.UIManager;

class HotRegionPopup
extends JDialog
implements FocusListener {
    private static final Color BORDER_COLOR = UIManager.getColor("color.secondary.2");
    private int focusRequestCounter = 0;
    private PopupHotRegion listener = null;
    private HotRegionGroup group = new HotRegionGroup();

    public HotRegionPopup(PopupHotRegion popupHotRegion) {
        super(JVision2.getMainFrame());
        this.listener = popupHotRegion;
        this.setUndecorated(true);
        this.setContentPane(new MultiMonitorPanel(new BorderLayout()));
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.getContentPane().setName(String.valueOf(string) + "ContentPane");
        this.getLayeredPane().setName(String.valueOf(string) + "LayeredPane");
        this.getRootPane().setName(String.valueOf(string) + "RootPane");
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.focusRequestCounter > 0) {
            --this.focusRequestCounter;
            this.requestFocus();
            return;
        }
        this.setVisible(false);
        this.listener.popupClosed();
    }

    @Override
    public void setVisible(boolean bl) {
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(Color.black);
        this.setBackground(Color.black);
        super.setVisible(bl);
        if (bl) {
            ++this.focusRequestCounter;
            this.requestFocus();
        } else {
            this.group.updateActive();
        }
    }

    public void setActiveHotRegion(HotRegion hotRegion) {
        this.group.setActive(hotRegion);
    }

    public void add(HotRegion hotRegion) {
        this.add(hotRegion, true);
    }

    public void add(HotRegion hotRegion, boolean bl) {
        if (bl) {
            this.group.add(hotRegion);
        }
        this.getContentPane().add(hotRegion);
    }

    public void remove(HotRegion hotRegion) {
        this.group.remove(hotRegion);
        this.getContentPane().remove(hotRegion);
    }

    @Override
    public void removeAll() {
        this.group.removeAll();
        this.getContentPane().removeAll();
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        super.paint(graphics);
        graphics.setColor(BORDER_COLOR);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
    }

    public int getHotRegionCount() {
        try {
            if (this.getContentPane() == null) {
                return 0;
            }
        }
        catch (Exception exception) {
            return 0;
        }
        return this.getContentPane().getComponentCount();
    }

    public HotRegion getHotRegion(int n) {
        if (this.getContentPane() == null) {
            return null;
        }
        return (HotRegion)this.getContentPane().getComponent(n);
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.relayout();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.relayout();
    }

    public void relayout() {
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        int n6 = 1;
        if (this.listener == null) {
            return;
        }
        if (this.listener.popupDirection == 0) {
            n3 = (n - 2) / this.listener.cols;
            n4 = n2 / this.listener.rows - 2;
            int n7 = 0;
            int n8 = n5;
            int n9 = 0;
            while (n9 < this.listener.rows) {
                int n10 = 0;
                while (n10 < this.listener.cols) {
                    this.getHotRegion(n7).setBounds(n5, n6, n3, n4);
                    n5 += n3;
                    if (++n7 == this.getHotRegionCount()) {
                        n9 = this.listener.rows;
                        n10 = this.listener.cols;
                    }
                    ++n10;
                }
                n6 += n4;
                n5 = n8;
                ++n9;
            }
        } else {
            n3 = n / this.listener.cols - 2;
            n4 = (n2 - 2) / this.listener.rows;
            int n11 = 0;
            int n12 = n6;
            int n13 = 0;
            while (n13 < this.listener.cols) {
                int n14 = 0;
                while (n14 < this.listener.rows) {
                    this.getHotRegion(n11).setBounds(n5, n6, n3, n4);
                    n6 += n4;
                    if (++n11 == this.getHotRegionCount()) {
                        n14 = this.listener.rows;
                        n13 = this.listener.cols;
                    }
                    ++n14;
                }
                n5 += n3;
                n6 = n12;
                ++n13;
            }
        }
    }
}

