/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.config.mappingfonts.model;

import com.tiani.config.mappingfonts.model.Font;
import com.tiani.config.mappingfonts.model.Line;
import com.tiani.config.mappingfonts.model.enums.ParagraphLocation;
import com.tiani.config.xml.minijaxb.AbstractIntermediateXMLElement;
import java.util.ArrayList;
import java.util.List;

public class Paragraph
extends AbstractIntermediateXMLElement {
    private ParagraphLocation location;
    private Font font;
    private final List<Line> lines = new ArrayList<Line>();

    public Paragraph() {
    }

    public Paragraph(Paragraph paragraph) {
        this.location = paragraph.location;
        if (paragraph.font != null) {
            this.font = new Font(paragraph.font);
        }
        for (Line line : paragraph.lines) {
            this.lines.add(new Line(line));
        }
    }

    public ParagraphLocation getLocation() {
        return this.location;
    }

    public void setLocation(ParagraphLocation paragraphLocation) {
        this.location = paragraphLocation;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Line getLine(int n) {
        return n >= this.lines.size() || n < 0 ? null : this.lines.get(n);
    }

    public Line[] getLines() {
        return this.lines.toArray(new Line[this.lines.size()]);
    }

    public void setLine(int n, Line line) {
        this.lines.set(n, line);
    }

    public void addLine(Line line) {
        this.lines.add(line);
    }

    public void addLine(int n, Line line) {
        this.lines.add(n, line);
    }

    public void removeLine(Line line) {
        this.lines.remove((Object)line);
    }

    public void clearLines() {
        this.lines.clear();
    }

    public int lineCount() {
        return this.lines.size();
    }

    public int indexOf(Line line) {
        return this.lines.indexOf((Object)line);
    }
}

