/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.config;

import com.agfa.pacs.base.lic.LicenseManager;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.MonitorQueryInterfaceFactory;
import com.tiani.gui.util.GraphicsDeviceInfo;
import java.awt.Dialog;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class LayoutConfig {
    private static final ALogger log = ALogger.getLogger(LayoutConfig.class);
    private static final String LAST_USED_MONITOR_SUBSET = "impaxee.local.MONITORS.lastUsedMonitorSubset";
    private static final double ROUNDING_FACTOR = 3000.0;
    private static LayoutConfig instance = new LayoutConfig();
    public final GraphicsDeviceInfo gdi = new GraphicsDeviceInfo();
    private volatile boolean automaticDetectionPerformed;
    private final boolean shouldPerformAutoDetection;
    private int screenCount;
    private int screenColumns;
    private int screenRows;
    private int screenWidth;
    private int screenHeight;
    private int imageAreaWidth;
    private int imageAreaHeight;
    private int imageAreaX;
    private int imageAreaY;
    private int firstMonitorNumber;

    public static LayoutConfig getInstance() {
        if (!LayoutConfig.instance.automaticDetectionPerformed && LayoutConfig.instance.shouldPerformAutoDetection) {
            instance.performAutomaticDetection();
            instance.afterInit();
        }
        return instance;
    }

    private LayoutConfig() {
        if (Product.isHeadless()) {
            this.shouldPerformAutoDetection = false;
            return;
        }
        if (this.gdi != null && Config.impaxee.workstation.MONITORS.UseDynamicMonitorDetection.get()) {
            this.shouldPerformAutoDetection = true;
            try {
                this.performAutomaticDetection();
            }
            catch (Exception exception) {
                return;
            }
        } else {
            this.shouldPerformAutoDetection = false;
            this.imageAreaWidth = (int)Config.impaxee.workstation.MONITORS.ScreenSizeX.get();
            this.imageAreaHeight = (int)Config.impaxee.workstation.MONITORS.ScreenSizeY.get();
            this.imageAreaX = (int)Config.impaxee.workstation.MONITORS.ScreenOffsetX.get();
            this.imageAreaY = (int)Config.impaxee.workstation.MONITORS.ScreenOffsetY.get();
            this.screenRows = (int)Config.impaxee.workstation.MONITORS.NumberOfRows.get();
            this.screenCount = (int)Config.impaxee.local.MONITORS.NumberOfMonitorsInUse.get();
            this.checkCurrentConfiguration();
        }
        this.afterInit();
    }

    private void afterInit() {
        int n = 0;
        while (n < this.gdi.screens.length) {
            if (this.gdi.screens[n].device.getDefaultConfiguration().getBounds().contains(this.imageAreaX, this.imageAreaY)) {
                this.firstMonitorNumber = n + 1;
                break;
            }
            ++n;
        }
        this.screenCount = Math.max(1, this.screenCount);
        this.screenColumns = this.screenCount > this.screenRows ? this.screenCount / this.screenRows : this.screenCount;
        this.screenWidth = Math.round((float)this.imageAreaWidth / (float)this.screenColumns);
        this.screenHeight = Math.round((float)this.imageAreaHeight / (float)this.screenRows);
    }

    private void performAutomaticDetection() {
        Object object;
        Object object2;
        int n = 1;
        int n2 = this.gdi.screens.length - 1;
        boolean bl = this.detectReverseSetup(this.gdi.screens);
        Object[] objectArray = this.countMonitorSizes(this.gdi.screens, bl);
        log.info("Found " + objectArray.length + " different monitor sizes");
        if (this.gdi.screens.length <= 2 && objectArray.length == 1) {
            n = 0;
        }
        if (bl && (this.gdi.screens.length > 2 || objectArray.length > 1)) {
            n = 0;
            n2 = this.gdi.screens.length - 2;
        }
        boolean bl2 = false;
        if (objectArray.length == 2) {
            bl2 = Boolean.parseBoolean(System.getProperty("monitor.selection.force", Boolean.FALSE.toString()));
        }
        if (objectArray.length == 3 && !Product.isCDViewer() || bl2) {
            String string;
            int n3;
            Object[] objectArray2;
            Object object3;
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new UnsupportedOperationException();
            }
            object2 = MonitorQueryInterfaceFactory.getInterface();
            object = null;
            MonitorSelection monitorSelection = null;
            Object object4 = null;
            Object object5 = objectArray;
            int n4 = objectArray.length;
            int n5 = 0;
            while (n5 < n4) {
                object3 = object5[n5];
                object = object2.getMonitorManufacturer(((MonitorSelection)object3).id);
                if (object != null) {
                    ((MonitorSelection)object3).setName(MessageFormat.format("{0}x {1} ({2}MP)", ((MonitorSelection)object3).getScreenCount(), object, Math.round((double)((MonitorSelection)object3).area / 1048576.0)));
                }
                ++n5;
            }
            object3 = ConfigurationProviderFactory.getConfig();
            if (object3.exists(LAST_USED_MONITOR_SUBSET)) {
                String string2 = object3.getString(LAST_USED_MONITOR_SUBSET);
                objectArray2 = objectArray;
                n3 = objectArray.length;
                int n6 = 0;
                while (n6 < n3) {
                    MonitorSelection monitorSelection2 = objectArray2[n6];
                    if (monitorSelection2.toString().equalsIgnoreCase(string2)) {
                        monitorSelection = monitorSelection2;
                    }
                    ++n6;
                }
            }
            if ((string = System.getProperty("monitor.selection", "").trim()).length() > 0) {
                objectArray2 = objectArray;
                n3 = objectArray.length;
                int n7 = 0;
                while (n7 < n3) {
                    Object object6 = objectArray2[n7];
                    if (((MonitorSelection)object6).toString().toUpperCase().contains(string.toUpperCase())) {
                        object4 = object6;
                    }
                    ++n7;
                }
            }
            if (object4 == null) {
                JOptionPane jOptionPane = new JOptionPane(Messages.getString("LayoutConfig.ChooseMonitorConfiguration"), 3, -1, null, objectArray, monitorSelection);
                object5 = jOptionPane.createDialog(null, Messages.getString("LayoutConfig.ChooseMonitorConfigurationTitle"));
                ((Window)object5).setAlwaysOnTop(true);
                ((Dialog)object5).setVisible(true);
                object4 = (MonitorSelection)jOptionPane.getValue();
            }
            if (object4 != null) {
                n = ((MonitorSelection)object4).startScreen;
                n2 = ((MonitorSelection)object4).getLastScreen();
                log.info("Selection setup with " + ((MonitorSelection)object4).toString());
                object3.setString(LAST_USED_MONITOR_SUBSET, ((MonitorSelection)object4).toString());
            }
            monitorSelection = null;
        } else if (objectArray.length == 2 && objectArray[0].getScreenCount() == 2 && objectArray[1].getScreenCount() == 2) {
            object2 = objectArray[1];
            n = ((MonitorSelection)object2).startScreen;
            n2 = ((MonitorSelection)object2).getLastScreen();
            log.info("Detected 2+2 setup, choosing 2 larger monitors");
        }
        if (!LayoutConfig.allowsMultiMonitor()) {
            n2 = n;
        }
        object2 = this.gdi.screens[n].getBounds();
        object = this.gdi.screens[n2].getBounds();
        this.imageAreaWidth = ((Rectangle)object).x + ((Rectangle)object).width - ((Rectangle)object2).x;
        this.imageAreaHeight = Integer.MAX_VALUE;
        int n8 = n;
        while (n8 <= n2) {
            if (this.imageAreaHeight > this.gdi.screens[n8].getBounds().height) {
                this.imageAreaHeight = this.gdi.screens[n8].getBounds().height;
            }
            ++n8;
        }
        this.imageAreaX = ((Rectangle)object2).x;
        this.imageAreaY = ((Rectangle)object2).y;
        this.screenCount = n2 - n + 1;
        this.screenRows = 1;
        this.automaticDetectionPerformed = true;
    }

    private long getArea(GraphicsDeviceInfo.RasterScreen rasterScreen) {
        Rectangle rectangle = rasterScreen.getBounds();
        return (long)rectangle.height * (long)rectangle.width;
    }

    private boolean detectReverseSetup(GraphicsDeviceInfo.RasterScreen[] rasterScreenArray) {
        long l = Math.round((double)this.getArea(rasterScreenArray[0]) / 3000.0);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(0);
        int n = 1;
        while (n < rasterScreenArray.length) {
            long l2 = Math.round((double)this.getArea(rasterScreenArray[n]) / 3000.0);
            if (l > l2) {
                arrayList.clear();
                arrayList.add(n);
                l = l2;
            } else if (l == l2) {
                arrayList.add(n);
            }
            ++n;
        }
        if (arrayList.contains(rasterScreenArray.length - 1) && !arrayList.contains(0)) {
            log.info("Detected true reverse setup");
            return true;
        }
        if (arrayList.contains(0)) {
            log.info("Detected true normal setup");
            return false;
        }
        log.info("Not detected monitor ordering, choosing normal one");
        return false;
    }

    private MonitorSelection[] countMonitorSizes(GraphicsDeviceInfo.RasterScreen[] rasterScreenArray, boolean bl) {
        LinkedList<MonitorSelection> linkedList = new LinkedList<MonitorSelection>();
        MonitorSelection monitorSelection = null;
        int n = 0;
        GraphicsDeviceInfo.RasterScreen[] rasterScreenArray2 = rasterScreenArray;
        int n2 = rasterScreenArray.length;
        int n3 = 0;
        while (n3 < n2) {
            GraphicsDeviceInfo.RasterScreen rasterScreen = rasterScreenArray2[n3];
            long l = this.getArea(rasterScreen);
            if (monitorSelection != null && monitorSelection.sameSize(l)) {
                monitorSelection.includeScreen(n);
            } else {
                monitorSelection = new MonitorSelection(n, l, rasterScreen.device.getIDstring());
                linkedList.add(monitorSelection);
            }
            ++n;
            ++n3;
        }
        if (bl) {
            Collections.reverse(linkedList);
        }
        return linkedList.toArray(new MonitorSelection[linkedList.size()]);
    }

    private void checkCurrentConfiguration() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        GraphicsDeviceInfo.RasterScreen[] rasterScreenArray = this.gdi.screens;
        int n5 = this.gdi.screens.length;
        int n6 = 0;
        while (n6 < n5) {
            GraphicsDeviceInfo.RasterScreen rasterScreen = rasterScreenArray[n6];
            Rectangle rectangle = rasterScreen.getBounds();
            if (rectangle.x < n) {
                n = rectangle.x;
            }
            if (rectangle.y < n2) {
                n2 = rectangle.y;
            }
            if (rectangle.x + rectangle.width > n3) {
                n3 = rectangle.x + rectangle.width;
            }
            if (rectangle.y + rectangle.height > n4) {
                n4 = rectangle.y + rectangle.height;
            }
            ++n6;
        }
        if (this.screenCount > 1 && !LayoutConfig.allowsMultiMonitor()) {
            log.warn("License does not allow Multi-Monitor support");
            this.performAutomaticDetection();
            return;
        }
        if (this.imageAreaX < n || this.imageAreaX + this.imageAreaWidth > n3 || this.imageAreaY < n2 || this.imageAreaY + this.imageAreaHeight > n4) {
            log.warn("The configured screens cannot be displayed falling back to automatic detection.");
            this.performAutomaticDetection();
            return;
        }
    }

    private static boolean allowsMultiMonitor() {
        return LicenseManager.getInstance().getLicense("MULTI_MONITOR") != null || Product.isInEmergencyMode();
    }

    public int toScreenColumn(Point point) {
        int n = point.x >= 0 ? point.x : 0;
        return n / this.screenWidth;
    }

    public int toScreenRow(Point point) {
        int n = point.y >= 0 ? point.y : 0;
        return n / this.screenHeight;
    }

    public int onWhichScreen(Point point) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n = graphicsDeviceArray != null ? graphicsDeviceArray.length : -1;
        boolean bl = System.getProperty("os.name").toLowerCase().contains("win");
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (graphicsDeviceArray[n3].getType() == 0) {
                ++n2;
                if ((graphicsDeviceArray[n3].getDisplayMode().getRefreshRate() != 0 || !bl) && graphicsDeviceArray[n3].getDefaultConfiguration().getBounds().contains(point)) {
                    return n2;
                }
            }
            ++n3;
        }
        return -1;
    }

    public Point toAbsoluteDesktopCoordinate(Point point) {
        int n = this.toScreenColumn(point);
        int n2 = this.toScreenRow(point);
        int n3 = this.imageAreaX + n * this.screenWidth;
        int n4 = this.imageAreaY + n2 * this.screenHeight;
        return new Point(n3, n4);
    }

    public Rectangle centerOnFirstJVisionMonitor(int n, int n2) {
        return new Rectangle(this.imageAreaX + (this.screenWidth - n) / 2, this.imageAreaY + (this.screenHeight - n2) / 2, n, n2);
    }

    public int monitorColumnForAbsoluteMouseX(int n) {
        int n2 = n - this.imageAreaX;
        return n2 / this.screenWidth;
    }

    public Point getBestJVisionMonitorCenter(Point point) {
        int n = this.monitorColumnForAbsoluteMouseX(point.x);
        n = Math.max(n, 0);
        n = Math.min(n, this.screenColumns - 1);
        int n2 = this.imageAreaX + n * this.screenWidth + this.screenWidth / 2;
        int n3 = this.imageAreaY + this.screenHeight / 2;
        return new Point(n2, n3);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("LayoutConfig: ");
        stringBuilder.append("usedMonitorsCount=" + this.screenCount + ", ");
        stringBuilder.append("monitorColumns=" + this.screenColumns + ", ");
        stringBuilder.append("monitorRows=" + this.screenRows + ", ");
        stringBuilder.append("monitorWidth=" + this.screenWidth + ", ");
        stringBuilder.append("monitorHeight=" + this.screenHeight + ", ");
        stringBuilder.append("imageAreaWidth=" + this.imageAreaWidth + ", ");
        stringBuilder.append("imageAreaHeight=" + this.imageAreaHeight + ", ");
        stringBuilder.append("imageAreaX=" + this.imageAreaX + ", ");
        stringBuilder.append("imageAreaY=" + this.imageAreaY);
        return stringBuilder.toString();
    }

    public int getImageAreaWidth() {
        return this.imageAreaWidth;
    }

    public int getImageAreaHeight() {
        return this.imageAreaHeight;
    }

    public int getImageAreaX() {
        return this.imageAreaX;
    }

    public int getImageAreaY() {
        return this.imageAreaY;
    }

    public GraphicsConfiguration getImageAreaGraphicsConfiguration() {
        return this.gdi.screens[this.firstMonitorNumber - 1].device.getDefaultConfiguration();
    }

    public int getScreenCount() {
        return this.screenCount;
    }

    public int getFirstMonitorNumber() {
        return this.firstMonitorNumber;
    }

    public int getScreenRows() {
        return this.screenRows;
    }

    public int getScreenColumns() {
        return this.screenColumns;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    private class MonitorSelection {
        public final int startScreen;
        private int lastScreen;
        private Rectangle bounds;
        private String name = null;
        private long area;
        private String id;

        private MonitorSelection(int n, long l, String string) {
            this.startScreen = n;
            this.lastScreen = n;
            this.area = l;
            this.id = string;
            this.bounds = LayoutConfig.this.gdi.screens[n].getBounds();
        }

        public int getLastScreen() {
            return this.lastScreen;
        }

        public boolean sameSize(long l) {
            return Math.round((double)this.area / 3000.0) == Math.round((double)l / 3000.0);
        }

        public void setName(String string) {
            this.name = string;
        }

        public int getScreenCount() {
            return this.lastScreen - this.startScreen + 1;
        }

        public void includeScreen(int n) {
            this.lastScreen = n;
        }

        public String toString() {
            if (this.name != null) {
                return this.name;
            }
            return String.valueOf(Messages.getString("LayoutConfig.Monitors")) + this.bounds.width + "x" + this.bounds.height;
        }
    }
}

