/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.pacs.listtext.dicomobject.type.ImageType;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageObjectData;
import com.tiani.util.expressions.IEvaluableData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class SliceDistanceCalculator {
    private static final ALogger logger = ALogger.getLogger(SliceDistanceCalculator.class);
    private static final double MINIMUM_SLICE_DISTANCE = 0.01;
    private static final double SLICE_DISTANCE_TOLERANCE = 0.02;

    public static double[] getSliceDistances(List<IFrameObjectData> list, List<IFrameObjectData> list2) throws SortingException {
        try {
            Object object;
            IFrameObjectData iFrameObjectData2;
            if (list.get(0).getImageInformation().getImageClass() == IImageInformation.ImageClass.NM) {
                return SliceDistanceCalculator.handleNMMultiFrame(list, list2);
            }
            SliceDistanceCalculator.checkEnhancedCTMR(list);
            ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>(list.size());
            ArrayList<IFrameObjectData> arrayList2 = new ArrayList<IFrameObjectData>(list.size());
            ArrayList<IFrameObjectData> arrayList3 = new ArrayList<IFrameObjectData>(list.size());
            boolean bl = list.size() > 1;
            for (IFrameObjectData iFrameObjectData2 : list) {
                object = iFrameObjectData2.getImageInformation();
                if (bl && object.getImageType().contains(ImageType.LOCALIZER)) {
                    logger.info("Skip scout at volume build{}", (Object)object.getSOPInstanceUID());
                    continue;
                }
                if (object.getImagePosition() != null) {
                    arrayList.add(iFrameObjectData2);
                }
                if (object.getSliceLocation() != null) {
                    arrayList2.add(iFrameObjectData2);
                }
                if (object.getSliceThickness() == null) continue;
                arrayList3.add(iFrameObjectData2);
            }
            iFrameObjectData2 = null;
            int n = 1;
            object = null;
            int n2 = 0;
            if (arrayList2.size() > arrayList.size()) {
                IEvaluableData iEvaluableData;
                logger.info("sorting slices by slice location");
                Collections.sort(arrayList2, new SliceLocationComparator(n, (Map<IFrameObjectData, Double>)((Object)iFrameObjectData2)));
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                int n3 = 0;
                while (n3 < arrayList2.size() - 1) {
                    iEvaluableData = (IFrameObjectData)arrayList2.get(n3);
                    IFrameObjectData iFrameObjectData3 = (IFrameObjectData)arrayList2.get(n3 + 1);
                    IImageInformation iImageInformation = iEvaluableData.getImageInformation();
                    IImageInformation iImageInformation2 = iFrameObjectData3.getImageInformation();
                    double d6 = Math.abs(iImageInformation.getSliceLocation() - iImageInformation2.getSliceLocation());
                    if (d6 < 0.01 || d != 0.0 && d6 < 0.1 * d && d6 < 0.1 * d2) {
                        arrayList2.remove(n3 + 1);
                        --n3;
                        ++n2;
                        logger.warn("(almost) duplicate slice!");
                    } else {
                        d2 = d;
                        d = d6;
                    }
                    if (n3 == 0) {
                        d3 = d6;
                    } else if (n3 == arrayList2.size() - 2) {
                        d4 = d6;
                    } else {
                        d5 = d6;
                    }
                    ++n3;
                }
                if ((double)n2 > 0.2 * (double)arrayList.size() && n2 > 10) {
                    throw new SortingException("Multiple duplicate slices, possible mixed-up series.");
                }
                if (d4 > 3.0 * d5) {
                    logger.warn("slice sequence ends with outlier, removed");
                    list.remove(arrayList2.get(arrayList2.size() - 1));
                }
                if (d3 > 3.0 * d5) {
                    logger.warn("slice sequence starts with outlier, removed");
                    list.remove(arrayList2.get(0));
                }
                list2.addAll(arrayList2);
                object = new double[list2.size()];
                n3 = 0;
                while (n3 < list2.size()) {
                    iEvaluableData = list2.get(n3).getImageInformation();
                    object[n3] = iEvaluableData.getSliceLocation() * (double)n;
                    ++n3;
                }
            } else {
                Object object2;
                IImageInformation iImageInformation;
                logger.info("sorting slices by image position");
                ImgPositionComparator imgPositionComparator = new ImgPositionComparator(SliceDistanceCalculator.findExtremalImageOrigin(arrayList), n);
                Collections.sort(arrayList, imgPositionComparator);
                IImageInformation iImageInformation3 = ((IFrameObjectData)arrayList.get(0)).getImageInformation();
                IImageInformation iImageInformation4 = ((IFrameObjectData)arrayList.get(2)).getImageInformation();
                Vector3d vector3d = iImageInformation3.getVectorU();
                Vector3d vector3d2 = iImageInformation3.getVectorV();
                Vector3d vector3d3 = iImageInformation4.getVectorOrigin();
                vector3d3.sub((Tuple3d)iImageInformation3.getVectorOrigin());
                if (vector3d.length() != 0.0 && vector3d2.length() != 0.0 && vector3d3.length() != 0.0) {
                    vector3d.normalize();
                    vector3d2.normalize();
                    vector3d3.normalize();
                    Vector3d vector3d4 = new Vector3d();
                    vector3d4.cross(vector3d, vector3d2);
                    double d = vector3d4.dot(vector3d3);
                    if (d < 0.0) {
                        logger.warn("FLIP ORDER");
                        imgPositionComparator.invertOrdering();
                        Collections.sort(arrayList, imgPositionComparator);
                    }
                }
                double d = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = 0.0;
                int n4 = 0;
                while (n4 < arrayList.size() - 1) {
                    iImageInformation = ((IFrameObjectData)arrayList.get(n4)).getImageInformation();
                    IImageInformation iImageInformation5 = ((IFrameObjectData)arrayList.get(n4 + 1)).getImageInformation();
                    object2 = iImageInformation.getVectorOrigin();
                    Vector3d vector3d5 = iImageInformation5.getVectorOrigin();
                    vector3d5.sub((Tuple3d)object2);
                    double d11 = vector3d5.length();
                    if (n4 == 0) {
                        d8 = d11;
                    } else if (n4 == arrayList.size() - 2) {
                        d9 = d11;
                    } else {
                        d10 = d11;
                    }
                    if (d11 < 0.01 || d != 0.0 && d11 < 0.1 * d && d11 < 0.1 * d7) {
                        arrayList.remove(n4 + 1);
                        --n4;
                        ++n2;
                        logger.warn("(almost) duplicate slice!");
                    } else {
                        d7 = d;
                        d = d11;
                    }
                    ++n4;
                }
                if ((double)n2 > 0.2 * (double)arrayList.size() && n2 > 10) {
                    throw new SortingException("Multiple duplicate slices, possible mixed-up series.");
                }
                if (d9 > 3.0 * d10) {
                    logger.warn("slice sequence ends with outlier, removed");
                    arrayList.remove(arrayList.size() - 1);
                }
                if (d8 > 3.0 * d10) {
                    logger.warn("slice sequence starts with outlier, removed");
                    arrayList.remove(0);
                }
                list2.addAll(arrayList);
                object = new double[list2.size()];
                Point3d point3d = list2.get(0).getImageInformation().getPointOrigin();
                n = imgPositionComparator.inv;
                object[0] = 0.0;
                iImageInformation = new Vector3d();
                int n5 = 1;
                while (n5 < list2.size()) {
                    object2 = list2.get(n5).getImageInformation();
                    iImageInformation.sub((Tuple3d)point3d, (Tuple3d)object2.getPointOrigin());
                    object[n5] = iImageInformation.length();
                    ++n5;
                }
            }
            return object;
        }
        catch (SortingException sortingException) {
            throw sortingException;
        }
        catch (Exception exception) {
            throw new SortingException(exception);
        }
    }

    private static Point3d findExtremalImageOrigin(List<IFrameObjectData> list) {
        Point3d point3d = null;
        double d = -1.0;
        for (IFrameObjectData iFrameObjectData : list) {
            Point3d point3d2 = iFrameObjectData.getImageInformation().getPointOrigin();
            double d2 = point3d2.x * point3d2.x + point3d2.y * point3d2.y + point3d2.z * point3d2.z;
            if (!(d2 > d)) continue;
            d = d2;
            point3d = point3d2;
        }
        return point3d;
    }

    private static double[] handleNMMultiFrame(List<IFrameObjectData> list, List<IFrameObjectData> list2) {
        HashSet<IImageObjectData> hashSet = new HashSet<IImageObjectData>();
        for (IFrameObjectData object2 : list) {
            hashSet.add(object2.getMainFrame());
        }
        if (hashSet.size() != 1) {
            logger.error("Images without position can be only NM Multiframes");
            return null;
        }
        HashSet<ImageType> hashSet2 = new HashSet<ImageType>();
        hashSet2.add(ImageType.RECON_TOMO);
        hashSet2.add(ImageType.RECON_TOMO_GATED);
        IImageObjectData iImageObjectData = (IImageObjectData)hashSet.iterator().next();
        hashSet2.retainAll(iImageObjectData.getImageInformation().getImageType());
        if (hashSet2.isEmpty()) {
            logger.error("Only RECON TOMO and RECON TOMO GATED supported");
            return null;
        }
        list2.addAll(list);
        Collections.sort(list2, new FrameSorter());
        double d = list.get(0).getImageInformation().getDataset().getDouble(0x180088, 0.0);
        if (d == 0.0) {
            logger.error("Missing spacing between slices in NM");
            return null;
        }
        if (d < 0.0) {
            Collections.reverse(list2);
            d = -d;
        }
        double[] dArray = new double[list.size()];
        double d2 = 0.0;
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = d2;
            d2 += d;
            ++n;
        }
        return dArray;
    }

    private static void checkEnhancedCTMR(List<IFrameObjectData> list) {
        if (list.get(0).getMainFrame().getFrameCount() > 1) {
            HashSet<IImageObjectData> hashSet = new HashSet<IImageObjectData>();
            for (IFrameObjectData object : list) {
                hashSet.add(object.getMainFrame());
            }
            logger.info("Waiting for enhanced CT/MR instances");
            do {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    if (!((IImageObjectData)iterator.next()).isHeaderInitialised()) continue;
                    iterator.remove();
                }
                if (hashSet.size() <= 0) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            } while (hashSet.size() > 0);
            logger.info("Waiting finished");
        }
    }

    public static SliceDistanceType getUniqueSliceDistances(double[] dArray, double[] dArray2, Double d) {
        if (d == null) {
            d = 0.02;
        }
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            double d4 = dArray[n2];
            if (d4 > d3) {
                d3 = d4;
            }
            if (d4 < d2) {
                d2 = d4;
            }
            if (n2 > 0) {
                double d5 = dArray[n2] - dArray[n2 - 1];
                if (n2 == 1) {
                    dArray2[n++] = d5;
                } else {
                    int n3 = 0;
                    while (n3 < n) {
                        double d6 = Math.abs(d5 - dArray2[n3]);
                        if (d6 < d) break;
                        ++n3;
                    }
                    if (n3 == n) {
                        dArray2[n++] = d5;
                    }
                }
            }
            ++n2;
        }
        logger.debug("tp range: " + d2 + " - " + d3);
        n2 = SliceDistanceCalculator.checkDistances(n, dArray2) ? 1 : 0;
        if (n2 == 0 && n > 1) {
            return SliceDistanceType.IRREGULAR;
        }
        if (n2 != 0) {
            return SliceDistanceType.ALL_MULTIPLE_OF_SMALLEST;
        }
        return SliceDistanceType.ALL_EQUAL;
    }

    private static boolean checkDistances(int n, double[] dArray) {
        if (dArray == null || dArray.length < n || n == 1) {
            return false;
        }
        Arrays.sort(dArray, 0, n);
        double d = dArray[0];
        int n2 = 1;
        while (n2 < n) {
            double d2 = dArray[n2] - (double)Math.round(dArray[n2] / d) * d;
            if (d2 > 0.02) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static class FrameSorter
    implements Comparator<IFrameObjectData> {
        private FrameSorter() {
        }

        @Override
        public int compare(IFrameObjectData iFrameObjectData, IFrameObjectData iFrameObjectData2) {
            return Integer.signum(iFrameObjectData.getFrameNumber() - iFrameObjectData2.getFrameNumber());
        }
    }

    private static class ImgPositionComparator
    implements Comparator<IFrameObjectData> {
        private int inv;
        private Point3d refPoint;

        public ImgPositionComparator(Point3d point3d, int n) {
            this.refPoint = point3d;
            this.inv = n;
        }

        @Override
        public int compare(IFrameObjectData iFrameObjectData, IFrameObjectData iFrameObjectData2) {
            Vector3d vector3d = new Vector3d();
            vector3d.sub((Tuple3d)this.refPoint, (Tuple3d)iFrameObjectData.getImageInformation().getPointOrigin());
            double d = vector3d.lengthSquared();
            vector3d.sub((Tuple3d)this.refPoint, (Tuple3d)iFrameObjectData2.getImageInformation().getPointOrigin());
            double d2 = vector3d.lengthSquared();
            return Double.compare(d, d2) * this.inv;
        }

        void invertOrdering() {
            this.inv = -this.inv;
        }
    }

    public static enum SliceDistanceType {
        ALL_EQUAL,
        ALL_MULTIPLE_OF_SMALLEST,
        IRREGULAR;

    }

    private static class SliceLocationComparator
    implements Comparator<IFrameObjectData> {
        private int inv;
        private Map<IFrameObjectData, Double> calculatedSliceLocations;

        public SliceLocationComparator(int n, Map<IFrameObjectData, Double> map) {
            this.inv = n;
            this.calculatedSliceLocations = map;
        }

        @Override
        public int compare(IFrameObjectData iFrameObjectData, IFrameObjectData iFrameObjectData2) {
            double d;
            double d2 = this.calculatedSliceLocations.get(iFrameObjectData);
            if (d2 < (d = this.calculatedSliceLocations.get(iFrameObjectData2).doubleValue())) {
                return -1 * this.inv;
            }
            if (d2 == d) {
                return 0;
            }
            return 1 * this.inv;
        }
    }

    public static class SortingException
    extends Exception {
        SortingException(String string) {
            super(string);
        }

        SortingException(Throwable throwable) {
            super(throwable);
        }
    }
}

