/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.data.shared.pixel.IPixelAccessor;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.valuemapping.IValueMapping;
import com.agfa.pacs.data.shared.valuemapping.IdentityValueMapping;
import com.tiani.base.data.IPixelDataMask;
import com.tiani.base.data.IPixelDataWrapper;
import com.tiani.jvision.renderer.filter.ImageFilterOperator;
import java.util.ArrayDeque;
import java.util.Arrays;
import javax.vecmath.Point2i;

public class PixelDataWrapperFactory {
    static final IDataCacheProvider CACHE = DataCacheProviderFactory.getCache();

    private PixelDataWrapperFactory() {
    }

    public static IPixelDataWrapper createPixelData(IPixelDataFrame<?> iPixelDataFrame) {
        return PixelDataWrapperFactory.createPixelData(iPixelDataFrame, IdentityValueMapping.INSTANCE);
    }

    public static IPixelDataWrapper createPixelData(IPixelDataFrame<?> iPixelDataFrame, IValueMapping iValueMapping) {
        if (iPixelDataFrame.getPixelDataClass() == byte[].class) {
            return new BytePixelDataWrapper(iPixelDataFrame, iValueMapping);
        }
        if (iPixelDataFrame.getPixelDataClass() == short[].class) {
            return new ShortPixelDataWrapper(iPixelDataFrame, iValueMapping);
        }
        return null;
    }

    public static IPixelDataWrapper createPixelData(IPixelDataFrame<?> iPixelDataFrame, IValueMapping iValueMapping, ImageFilterOperator ... imageFilterOperatorArray) {
        if (imageFilterOperatorArray == null || imageFilterOperatorArray.length == 0 || imageFilterOperatorArray.length == 1 && imageFilterOperatorArray[0] == null) {
            return PixelDataWrapperFactory.createPixelData(iPixelDataFrame, iValueMapping);
        }
        if (iPixelDataFrame.getPixelDataClass() == byte[].class) {
            return new CachedArrayPixelDataWrapper(PixelDataWrapperFactory.filterBytePixelData(iPixelDataFrame, iValueMapping, imageFilterOperatorArray));
        }
        if (iPixelDataFrame.getPixelDataClass() == short[].class) {
            return new CachedArrayPixelDataWrapper(PixelDataWrapperFactory.filterShortPixelData(iPixelDataFrame, iValueMapping, imageFilterOperatorArray));
        }
        return null;
    }

    private static double[] filterBytePixelData(IPixelDataFrame<?> iPixelDataFrame, IValueMapping iValueMapping, ImageFilterOperator ... imageFilterOperatorArray) {
        byte[] byArray = null;
        try {
            byArray = PixelDataWrapperFactory.filterBytePixelData(iPixelDataFrame, imageFilterOperatorArray);
            double[] dArray = CACHE.allocDoubles((long)byArray.length);
            int n = 0;
            while (n < dArray.length) {
                dArray[n] = iValueMapping.applyMapping((int)byArray[n]);
                ++n;
            }
            double[] dArray2 = dArray;
            return dArray2;
        }
        finally {
            if (byArray != null) {
                CACHE.free(byArray);
            }
        }
    }

    private static byte[] filterBytePixelData(IPixelDataFrame<?> iPixelDataFrame, ImageFilterOperator ... imageFilterOperatorArray) {
        byte[] byArray;
        byte[] byArray2;
        block10: {
            IPixelAccessor iPixelAccessor = null;
            byArray2 = null;
            try {
                Object object;
                iPixelAccessor = iPixelDataFrame.getPixelAccessor();
                byte[] byArray3 = (byte[])iPixelAccessor.getData();
                byArray2 = CACHE.allocBytes((long)byArray3.length);
                byte[] byArray4 = byArray3;
                byte[] byArray5 = byArray2;
                byte[] byArray6 = null;
                ImageFilterOperator[] imageFilterOperatorArray2 = imageFilterOperatorArray;
                int n = imageFilterOperatorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = imageFilterOperatorArray2[n2];
                    if (byArray5 == null) {
                        byArray6 = CACHE.allocAndClearBytes((long)byArray3.length);
                        byArray5 = byArray6;
                    } else {
                        Arrays.fill(byArray5, (byte)0);
                    }
                    object.applyFilter(byArray4, byArray5, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), 0, iPixelDataFrame.getWidth(), 1 << iPixelDataFrame.getBitsPerPixel(), iPixelDataFrame.isSigned() ? 1 << iPixelDataFrame.getHighBit() : 0);
                    byArray4 = byArray5;
                    byArray5 = byArray4 == byArray2 ? byArray6 : byArray2;
                    ++n2;
                }
                object = byArray4;
                if (object == byArray3) {
                    System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
                    object = byArray2;
                }
                if (object == byArray2) {
                    byArray2 = byArray6;
                }
                byArray = object;
                if (iPixelAccessor == null) break block10;
            }
            catch (Throwable throwable) {
                if (iPixelAccessor != null) {
                    iPixelAccessor.release();
                }
                if (byArray2 != null) {
                    CACHE.free(byArray2);
                }
                throw throwable;
            }
            iPixelAccessor.release();
        }
        if (byArray2 != null) {
            CACHE.free(byArray2);
        }
        return byArray;
    }

    private static double[] filterShortPixelData(IPixelDataFrame<?> iPixelDataFrame, IValueMapping iValueMapping, ImageFilterOperator ... imageFilterOperatorArray) {
        short[] sArray = null;
        try {
            sArray = PixelDataWrapperFactory.filterShortPixelData(iPixelDataFrame, imageFilterOperatorArray);
            double[] dArray = CACHE.allocDoubles((long)sArray.length);
            int n = 0;
            while (n < dArray.length) {
                dArray[n] = iValueMapping.applyMapping((int)sArray[n]);
                ++n;
            }
            double[] dArray2 = dArray;
            return dArray2;
        }
        finally {
            if (sArray != null) {
                CACHE.free(sArray);
            }
        }
    }

    private static short[] filterShortPixelData(IPixelDataFrame<?> iPixelDataFrame, ImageFilterOperator ... imageFilterOperatorArray) {
        short[] sArray;
        short[] sArray2;
        block10: {
            IPixelAccessor iPixelAccessor = null;
            sArray2 = null;
            try {
                Object object;
                iPixelAccessor = iPixelDataFrame.getPixelAccessor();
                short[] sArray3 = (short[])iPixelAccessor.getData();
                sArray2 = CACHE.allocShorts((long)sArray3.length);
                short[] sArray4 = sArray3;
                short[] sArray5 = sArray2;
                short[] sArray6 = null;
                ImageFilterOperator[] imageFilterOperatorArray2 = imageFilterOperatorArray;
                int n = imageFilterOperatorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = imageFilterOperatorArray2[n2];
                    if (sArray5 == null) {
                        sArray6 = CACHE.allocAndClearShorts((long)sArray3.length);
                        sArray5 = sArray6;
                    } else {
                        Arrays.fill(sArray5, (short)0);
                    }
                    object.applyFilter(sArray4, sArray5, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), 0, iPixelDataFrame.getWidth(), 1 << iPixelDataFrame.getBitsPerPixel(), iPixelDataFrame.isSigned() ? 1 << iPixelDataFrame.getHighBit() : 0);
                    sArray4 = sArray5;
                    sArray5 = sArray4 == sArray2 ? sArray6 : sArray2;
                    ++n2;
                }
                object = sArray4;
                if (object == sArray3) {
                    System.arraycopy(sArray3, 0, sArray2, 0, sArray2.length);
                    object = sArray2;
                }
                if (object == sArray2) {
                    sArray2 = sArray6;
                }
                sArray = object;
                if (iPixelAccessor == null) break block10;
            }
            catch (Throwable throwable) {
                if (iPixelAccessor != null) {
                    iPixelAccessor.release();
                }
                if (sArray2 != null) {
                    CACHE.free(sArray2);
                }
                throw throwable;
            }
            iPixelAccessor.release();
        }
        if (sArray2 != null) {
            CACHE.free(sArray2);
        }
        return sArray;
    }

    public static IPixelDataMask createThresholdMask(IPixelDataFrame<?> iPixelDataFrame, int n, ImageFilterOperator ... imageFilterOperatorArray) {
        if (iPixelDataFrame.getPixelDataClass() == byte[].class) {
            return new CachedArrayPixelDataMask(PixelDataWrapperFactory.createByteThresholdMask(iPixelDataFrame, n, imageFilterOperatorArray));
        }
        if (iPixelDataFrame.getPixelDataClass() == short[].class) {
            return new CachedArrayPixelDataMask(PixelDataWrapperFactory.createShortThresholdMask(iPixelDataFrame, n, imageFilterOperatorArray));
        }
        return null;
    }

    private static int[] createByteThresholdMask(IPixelDataFrame<?> iPixelDataFrame, int n, ImageFilterOperator ... imageFilterOperatorArray) {
        byte[] byArray = null;
        try {
            byArray = PixelDataWrapperFactory.filterBytePixelData(iPixelDataFrame, imageFilterOperatorArray);
            int[] nArray = CACHE.allocAndClearInts((long)((byArray.length + 31) / 32));
            PixelDataWrapperFactory.floodByteThresholdMask(byArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(0, 0));
            PixelDataWrapperFactory.floodByteThresholdMask(byArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(iPixelDataFrame.getWidth() - 1, 0));
            PixelDataWrapperFactory.floodByteThresholdMask(byArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(0, iPixelDataFrame.getHeight() - 1));
            PixelDataWrapperFactory.floodByteThresholdMask(byArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(iPixelDataFrame.getWidth() - 1, iPixelDataFrame.getHeight() - 1));
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            if (byArray != null) {
                CACHE.free(byArray);
            }
        }
    }

    private static void floodByteThresholdMask(byte[] byArray, int[] nArray, int n, int n2, int n3, Point2i point2i) {
        ArrayDeque<Point2i> arrayDeque = new ArrayDeque<Point2i>();
        Point2i point2i2 = point2i;
        while (point2i2 != null) {
            int n4 = point2i2.y * n;
            int n5 = n4 + point2i2.x;
            if (byArray[n5] < n3 && (nArray[n5 >> 5] & 1 << (n5 & 0x1F)) == 0) {
                int n6 = point2i2.x;
                while (n6 >= 0 && byArray[n4 + n6] < n3) {
                    n5 = n4 + n6;
                    int n7 = n5 >> 5;
                    nArray[n7] = nArray[n7] | 1 << (n5 & 0x1F);
                    if (point2i2.y > 0 && byArray[n5 - n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y - 1));
                    }
                    if (point2i2.y < n2 - 1 && byArray[n5 + n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y + 1));
                    }
                    --n6;
                }
                n6 = point2i2.x + 1;
                while (n6 < n && byArray[n4 + n6] < n3) {
                    n5 = n4 + n6;
                    int n8 = n5 >> 5;
                    nArray[n8] = nArray[n8] | 1 << (n5 & 0x1F);
                    if (point2i2.y > 0 && byArray[n5 - n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y - 1));
                    }
                    if (point2i2.y < n2 - 1 && byArray[n5 + n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y + 1));
                    }
                    ++n6;
                }
            }
            point2i2 = (Point2i)arrayDeque.poll();
        }
    }

    private static int[] createShortThresholdMask(IPixelDataFrame<?> iPixelDataFrame, int n, ImageFilterOperator ... imageFilterOperatorArray) {
        short[] sArray = null;
        try {
            sArray = PixelDataWrapperFactory.filterShortPixelData(iPixelDataFrame, imageFilterOperatorArray);
            int[] nArray = CACHE.allocAndClearInts((long)((sArray.length + 31) / 32));
            PixelDataWrapperFactory.floodShortThresholdMask(sArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(0, 0));
            PixelDataWrapperFactory.floodShortThresholdMask(sArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(iPixelDataFrame.getWidth() - 1, 0));
            PixelDataWrapperFactory.floodShortThresholdMask(sArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(0, iPixelDataFrame.getHeight() - 1));
            PixelDataWrapperFactory.floodShortThresholdMask(sArray, nArray, iPixelDataFrame.getWidth(), iPixelDataFrame.getHeight(), n, new Point2i(iPixelDataFrame.getWidth() - 1, iPixelDataFrame.getHeight() - 1));
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            if (sArray != null) {
                CACHE.free(sArray);
            }
        }
    }

    private static void floodShortThresholdMask(short[] sArray, int[] nArray, int n, int n2, int n3, Point2i point2i) {
        ArrayDeque<Point2i> arrayDeque = new ArrayDeque<Point2i>();
        Point2i point2i2 = point2i;
        while (point2i2 != null) {
            int n4 = point2i2.y * n;
            int n5 = n4 + point2i2.x;
            if (sArray[n5] < n3 && (nArray[n5 >> 5] & 1 << (n5 & 0x1F)) == 0) {
                int n6 = point2i2.x;
                while (n6 >= 0 && sArray[n4 + n6] < n3) {
                    n5 = n4 + n6;
                    int n7 = n5 >> 5;
                    nArray[n7] = nArray[n7] | 1 << (n5 & 0x1F);
                    if (point2i2.y > 0 && sArray[n5 - n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y - 1));
                    }
                    if (point2i2.y < n2 - 1 && sArray[n5 + n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y + 1));
                    }
                    --n6;
                }
                n6 = point2i2.x + 1;
                while (n6 < n && sArray[n4 + n6] < n3) {
                    n5 = n4 + n6;
                    int n8 = n5 >> 5;
                    nArray[n8] = nArray[n8] | 1 << (n5 & 0x1F);
                    if (point2i2.y > 0 && sArray[n5 - n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y - 1));
                    }
                    if (point2i2.y < n2 - 1 && sArray[n5 + n] < n3) {
                        arrayDeque.add(new Point2i(n6, point2i2.y + 1));
                    }
                    ++n6;
                }
            }
            point2i2 = (Point2i)arrayDeque.poll();
        }
    }

    private static abstract class AbstractPixelDataWrapper
    implements IPixelDataWrapper {
        protected final IPixelAccessor<?> pa;
        private final boolean isUnsigned;
        private final int mask;
        private final IValueMapping mapping;

        public AbstractPixelDataWrapper(IPixelDataFrame<?> iPixelDataFrame, IValueMapping iValueMapping) {
            this.pa = iPixelDataFrame.getPixelAccessor();
            this.isUnsigned = !iPixelDataFrame.isSigned();
            this.mask = this.pa.getMask();
            this.mapping = iValueMapping;
        }

        @Override
        public double getValueAt(int n) {
            int n2 = this.getRawValueAt(n);
            if (this.isUnsigned) {
                n2 &= this.mask;
            }
            return this.mapping.applyMapping(n2);
        }

        abstract int getRawValueAt(int var1);

        @Override
        public void release() {
            this.pa.release();
        }
    }

    private static class BytePixelDataWrapper
    extends AbstractPixelDataWrapper {
        private final byte[] data;

        BytePixelDataWrapper(IPixelDataFrame<?> iPixelDataFrame, IValueMapping iValueMapping) {
            super(iPixelDataFrame, iValueMapping);
            this.data = (byte[])this.pa.getData();
        }

        @Override
        public int getLength() {
            return this.data.length;
        }

        @Override
        int getRawValueAt(int n) {
            return this.data[n];
        }
    }

    private static class CachedArrayPixelDataMask
    implements IPixelDataMask {
        private final int[] mask;

        public CachedArrayPixelDataMask(int[] nArray) {
            this.mask = nArray;
        }

        @Override
        public boolean isMasked(int n) {
            return (this.mask[n >> 5] & 1 << (n & 0x1F)) != 0;
        }

        @Override
        public void release() {
            CACHE.free(this.mask);
        }
    }

    private static class CachedArrayPixelDataWrapper
    implements IPixelDataWrapper {
        private final double[] data;

        public CachedArrayPixelDataWrapper(double[] dArray) {
            this.data = dArray;
        }

        @Override
        public int getLength() {
            return this.data.length;
        }

        @Override
        public double getValueAt(int n) {
            return this.data[n];
        }

        @Override
        public void release() {
            CACHE.free(this.data);
        }
    }

    private static class ShortPixelDataWrapper
    extends AbstractPixelDataWrapper {
        private final short[] data;

        ShortPixelDataWrapper(IPixelDataFrame<?> iPixelDataFrame, IValueMapping iValueMapping) {
            super(iPixelDataFrame, iValueMapping);
            this.data = (short[])this.pa.getData();
        }

        @Override
        public int getLength() {
            return this.data.length;
        }

        @Override
        int getRawValueAt(int n) {
            return this.data[n];
        }
    }
}

