/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.pacs.data.shared.dicom.Laterality;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.impl.MammoCREvaluation;
import com.agfa.pacs.math.Matrix2d;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.ImageInformation2;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;

public enum Orientation {
    AXIAL(0),
    SAGITTAL(1),
    CORONAL(2),
    CPR(-1),
    REFORMAT_PREVIEW(3),
    LEFT("L"),
    RIGHT("R"),
    UNKNOWN(-1);

    private static final boolean AUTO_ROTATE_AXIAL_IMAGES;
    private final int index;
    private String value;

    static {
        AUTO_ROTATE_AXIAL_IMAGES = Config.impaxee.jvision.DISPLAY.ShowAxialSeriesInHFSOrientation.get();
    }

    private Orientation(String string2) {
        this.index = -1;
        this.value = string2;
    }

    private Orientation(int n2) {
        this.index = n2;
        this.value = this.name();
    }

    public String getValue() {
        return this.value;
    }

    public static Orientation getOrientation(IImageInformation iImageInformation) {
        if (iImageInformation.getImageOrientation() == null || iImageInformation.getImageClass() == IImageInformation.ImageClass.MG || ImageInformation2.isTomosynthesisImage(iImageInformation)) {
            if (iImageInformation.getImageClass() == IImageInformation.ImageClass.CR && MammoCREvaluation.getInstance().isMammoImage(iImageInformation)) {
                return MammoCREvaluation.getInstance().getDisplaySetOrientation(iImageInformation);
            }
            Laterality laterality = iImageInformation.getImageLaterality();
            if (laterality == Laterality.Left) {
                return LEFT;
            }
            if (laterality == Laterality.Right) {
                return RIGHT;
            }
            return UNKNOWN;
        }
        return Orientation.getOrientation3D(iImageInformation);
    }

    public static Orientation getOrientation3D(IImageInformation iImageInformation) {
        Vector3d vector3d = iImageInformation.getPlaneNormalUV();
        return Orientation.getOrientation3D(vector3d);
    }

    public static Orientation getOrientation3D(Vector3d vector3d) {
        if (vector3d != null) {
            double d = Math.abs(vector3d.x);
            double d2 = Math.abs(vector3d.y);
            double d3 = Math.abs(vector3d.z);
            if (d3 > d && d3 > d2) {
                return AXIAL;
            }
            if (d > d3 && d > d2) {
                return SAGITTAL;
            }
            return CORONAL;
        }
        return AXIAL;
    }

    public int getIndex() {
        return this.index;
    }

    public static Matrix2d createStandardTransform2D(IImageInformation iImageInformation) {
        if (AUTO_ROTATE_AXIAL_IMAGES && Orientation.getOrientation3D(iImageInformation) == AXIAL) {
            Vector3d vector3d = iImageInformation.getVectorU();
            Vector3d vector3d2 = iImageInformation.getVectorV();
            if (vector3d != null && vector3d2 != null) {
                Orientation.projectToNearestAxis(vector3d, vector3d2);
                if (!(vector3d.x == 0.0 && vector3d.y == 0.0 || vector3d2.x == 0.0 && vector3d2.y == 0.0)) {
                    return new Matrix2d(vector3d.x, vector3d2.x, vector3d.y, vector3d2.y);
                }
            }
        }
        return Matrix2d.identity;
    }

    public static Transform3D createStandardTransform3D(Vector3d vector3d, Vector3d vector3d2) {
        Orientation.projectToNearestAxis(vector3d, vector3d2);
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d, vector3d2);
        return new Transform3D(new double[]{vector3d.x, vector3d2.x, vector3d3.x, 0.0, vector3d.y, vector3d2.y, vector3d3.y, 0.0, vector3d.z, vector3d2.z, vector3d3.z, 0.0, 0.0, 0.0, 0.0, 1.0});
    }

    private static void projectToNearestAxis(Vector3d vector3d, Vector3d vector3d2) {
        vector3d.normalize();
        vector3d2.normalize();
        if (Orientation.getMaximumCoordinateValue(vector3d) < Orientation.getMaximumCoordinateValue(vector3d2)) {
            Orientation.projectToNearestAxisImpl(vector3d2, vector3d);
        } else {
            Orientation.projectToNearestAxisImpl(vector3d, vector3d2);
        }
    }

    private static double getMaximumCoordinateValue(Vector3d vector3d) {
        if (Math.abs(vector3d.x) > Math.abs(vector3d.y) && Math.abs(vector3d.x) > Math.abs(vector3d.z)) {
            return vector3d.x;
        }
        if (Math.abs(vector3d.y) > Math.abs(vector3d.z)) {
            return vector3d.y;
        }
        return vector3d.z;
    }

    private static void projectToNearestAxisImpl(Vector3d ... vector3dArray) {
        int n = 0;
        while (n < vector3dArray.length) {
            int n2;
            Vector3d vector3d = vector3dArray[n];
            if (Math.abs(vector3d.x) > Math.abs(vector3d.y) && Math.abs(vector3d.x) > Math.abs(vector3d.z)) {
                vector3d.x = vector3d.x < 0.0 ? -1.0 : 1.0;
                vector3d.z = 0.0;
                vector3d.y = 0.0;
                n2 = n + 1;
                while (n2 < vector3dArray.length) {
                    vector3dArray[n2].x = 0.0;
                    ++n2;
                }
            } else if (Math.abs(vector3d.y) > Math.abs(vector3d.z)) {
                vector3d.y = vector3d.y < 0.0 ? -1.0 : 1.0;
                vector3d.z = 0.0;
                vector3d.x = 0.0;
                n2 = n + 1;
                while (n2 < vector3dArray.length) {
                    vector3dArray[n2].y = 0.0;
                    ++n2;
                }
            } else {
                vector3d.z = vector3d.z < 0.0 ? -1.0 : 1.0;
                vector3d.y = 0.0;
                vector3d.x = 0.0;
                n2 = n + 1;
                while (n2 < vector3dArray.length) {
                    vector3dArray[n2].z = 0.0;
                    ++n2;
                }
            }
            ++n;
        }
    }

    public static Orientation valueOf(String string) {
        return Enum.valueOf(Orientation.class, string);
    }
}

