/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.windowingtree;

import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.windowingtree.WindowingTree;
import com.agfa.pacs.impaxee.windowingtree.WindowingTreeNode;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.permission.Permissions;
import java.awt.Component;
import java.awt.Dimension;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class WindowingTreeCellEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private static final ALogger log = ALogger.getLogger(WindowingTreeCellEditor.class);
    private JTextField textEditor = null;
    private JSpinner integerEditor = null;
    private WindowingTreeNode node;

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        WindowingTreeNode windowingTreeNode;
        this.node = windowingTreeNode = (WindowingTreeNode)object;
        if (this.isIntegerNode(windowingTreeNode)) {
            int n2 = ((Long)windowingTreeNode.getUserObject()).intValue();
            int n3 = Integer.MIN_VALUE;
            if (windowingTreeNode.getID().equals("width")) {
                n3 = 0;
                if (n2 < 0) {
                    n2 = -n2;
                }
            }
            this.integerEditor = ComponentFactory.instance.createSpinner(new SpinnerNumberModel(n2, n3, Integer.MAX_VALUE, 1));
            this.integerEditor.setPreferredSize(new Dimension(20, this.integerEditor.getHeight()));
            return this.integerEditor;
        }
        this.textEditor = ComponentFactory.instance.createTextField((String)windowingTreeNode.getUserObject());
        return this.textEditor;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        WindowingTreeNode windowingTreeNode;
        if (!Permissions.getInstance().isAllowed("ImageArea/AllowToEditWindowingTree")) {
            return false;
        }
        if (eventObject == null) {
            windowingTreeNode = this.node;
        } else {
            TreePath treePath = ((WindowingTree)eventObject.getSource()).getSelectionPath();
            if (treePath == null) {
                return false;
            }
            windowingTreeNode = (WindowingTreeNode)treePath.getLastPathComponent();
        }
        if (windowingTreeNode != null && windowingTreeNode.getID().equals(WindowingTree.ROOT)) {
            return false;
        }
        return super.isCellEditable(eventObject);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isIntegerNode(this.node)) {
            return ((Integer)this.integerEditor.getValue()).longValue();
        }
        return this.textEditor.getText();
    }

    @Override
    public boolean stopCellEditing() {
        if (this.isIntegerNode(this.node)) {
            try {
                this.integerEditor.commitEdit();
            }
            catch (ParseException parseException) {
                log.debug("Committing window value failed.", (Throwable)parseException);
            }
        }
        return super.stopCellEditing();
    }

    private boolean isIntegerNode(WindowingTreeNode windowingTreeNode) {
        return windowingTreeNode.getID().equals("center") || windowingTreeNode.getID().equals("width");
    }
}

