/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.valuemapping.suv;

import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.data.shared.valuemapping.DefaultValueMappingOption;
import com.agfa.pacs.data.shared.valuemapping.ISUVData;
import com.agfa.pacs.data.shared.valuemapping.IValueMappingFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVCalibrationDialog;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVMappingFactory;
import com.agfa.pacs.impaxee.valuemapping.suv.SUVUtil;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameListener;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.ISelectionListener;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import java.awt.Component;
import java.util.Date;
import java.util.List;

public class SUVDataAction
extends AbstractPDataAction {
    public static final String ID = "SUV";

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new SUVAction(pDataScope, pDataProvider);
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentDisplay};
    }

    @Override
    public String getID() {
        return ID;
    }

    protected static Date getEarliestAcquisitionDate(IDisplaySet iDisplaySet) {
        IFrameObjectData[] iFrameObjectDataArray;
        Date date = null;
        IFrameObjectData[] iFrameObjectDataArray2 = iFrameObjectDataArray = iDisplaySet.getObjects();
        int n = iFrameObjectDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFrameObjectData iFrameObjectData = iFrameObjectDataArray2[n2];
            Date date2 = iFrameObjectData.getImageInformation().getAcquisitionDateTime();
            if (date == null || date2 != null && date2.before(date)) {
                date = date2;
            }
            ++n2;
        }
        return date;
    }

    private class SUVAction
    extends AbstractPDataAction.SelectableInnerPAction
    implements ISelectionListener {
        private boolean isEnabled;

        SUVAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super("suv.svg", pDataScope, pDataProvider);
            if (pDataScope != null) {
                DataSelectionManager.getInstance().addSelectionListener(this);
            }
        }

        @Override
        public String getCaption() {
            return Messages.getString("ValueMapping.SUV.Label");
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ValueMapping.SUV.ToolTip");
        }

        @Override
        public void lastModifiedChanged(int n, VisDisplayData visDisplayData) {
            this.isEnabled = visDisplayData == null ? false : SUVUtil.isSUVSupported(visDisplayData.getVisDisplay());
            this.fireEnabledChanged();
        }

        @Override
        public boolean isAvailable() {
            return SUVUtil.isSUVPermitted();
        }

        @Override
        protected boolean isEnabledImpl() {
            if (this.scope == null) {
                return SUVUtil.isSUVSupported(this.getVisDisplay());
            }
            return this.isEnabled;
        }

        @Override
        public boolean isEnabled(VisData visData) {
            return SUVUtil.isSUVSupported(visData.getParent().getVisDisplay());
        }

        @Override
        protected boolean isSelectedImpl() {
            return SUVUtil.isSUVActive(this.getVisDisplay());
        }

        private VisDisplay2 getVisDisplay() {
            List<VisDisplay2> list = this.scope != null ? SUVDataAction.getVisDisplays(this.scope) : this.provider.getVisDisplays();
            if (list != null && list.size() == 1) {
                return list.get(0);
            }
            return null;
        }

        @Override
        public boolean perform(Component component) {
            VisDisplay2 visDisplay2 = this.getVisDisplay();
            if (!SUVUtil.isSUVSupported(visDisplay2)) {
                ALogger.getLogger(SUVDataAction.class).debug("SUV calculation not supported for current display.");
                return false;
            }
            this.notifyActionPerformed();
            CursorUtil.setWaitCursor((Component)visDisplay2);
            visDisplay2.getVis(visDisplay2.getNavigPos()).getView().getFrameData().addListener(new SUVActivator(visDisplay2));
            return true;
        }
    }

    private static class SUVActivator
    implements IFrameListener {
        private final VisDisplay2 vd;

        SUVActivator(VisDisplay2 visDisplay2) {
            this.vd = visDisplay2;
        }

        @Override
        public void notifyHasError(String string) {
            if (CursorUtil.isWaitCursor((Component)this.vd)) {
                CursorUtil.resetWaitCursor((Component)this.vd);
            }
        }

        @Override
        public boolean frameAvailable(IFrameObjectData iFrameObjectData, String string) {
            Object object;
            if (CursorUtil.isWaitCursor((Component)this.vd)) {
                CursorUtil.resetWaitCursor((Component)this.vd);
            }
            if ((object = SUVUtil.isSUVActive(this.vd) ? new DefaultValueMappingOption(null) : this.createSUVMapping(this.vd.getData().getDisplaySet(), iFrameObjectData)) != null) {
                TEvent tEvent = new TEvent(120);
                TEventDispatch.sendEventToVis(this.vd, tEvent, object, TEventDispatch.ALL_VISUALS);
            }
            if (this.vd.hasAction(SUVDataAction.ID)) {
                this.vd.getAction(SUVDataAction.ID).forcedSelectionChanged();
            }
            return false;
        }

        private IValueMappingFactory createSUVMapping(IDisplaySet iDisplaySet, IFrameObjectData iFrameObjectData) {
            ISUVData iSUVData = SUVUtil.getSUVDataForFrame(this.vd, iFrameObjectData);
            SUVCalibrationDialog sUVCalibrationDialog = new SUVCalibrationDialog(JVision2.getMainFrame(), iSUVData, SUVDataAction.getEarliestAcquisitionDate(iDisplaySet));
            sUVCalibrationDialog.setVisible(true);
            if (sUVCalibrationDialog.isOKPressed()) {
                return new SUVMappingFactory(iSUVData);
            }
            return null;
        }
    }
}

