/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.valuemapping.suv;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.data.shared.valuemapping.IIsotope;
import com.agfa.pacs.data.shared.valuemapping.IPatientBodyData;
import com.agfa.pacs.data.shared.valuemapping.ISUVData;
import com.agfa.pacs.data.shared.valuemapping.IStandardizedUptakeValueMethod;
import com.agfa.pacs.data.shared.valuemapping.NamedIsotope;
import com.agfa.pacs.data.shared.valuemapping.PatientSex;
import com.agfa.pacs.data.shared.valuemapping.SUVData;
import com.agfa.pacs.data.shared.valuemapping.SUVIsotope;
import com.agfa.pacs.data.shared.valuemapping.StandardizedUptakeValueMethod;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.gui.JDoubleField;
import com.tiani.gui.dialog.StandardDialog;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorDoubleField;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

class SUVCalibrationDialog
extends StandardDialog
implements ActionListener,
JDoubleField.CommitEditListener,
KeyListener {
    private static final int GAP = ComponentFactory.instance.scaleInt(5);
    private final ISUVData suvData;
    private final Date earliestAcquisitionDateTime;
    private final Collection<JLabel> labels = new ArrayList<JLabel>();
    private final Map<JComponent, WarningMark> warningLabels = new HashMap<JComponent, WarningMark>();
    private final JComboBox<StandardizedUptakeValueMethod> method;
    private final JComboBox<PatientSex> patientGender;
    private final JDoubleField patientWeight;
    private final JDoubleField patientHeight;
    private final JComboBox<IIsotope> isotope;
    private final JDoubleField halfLife;
    private JLabel halfLifeLabel;
    private final JDoubleField injectedDose;
    private final JDoubleField acquisitionDelay;
    private TimeLabel earliestAcquisitionTimeLabel;
    private TimeLabel injectionTimeLabel;
    private final WarningLabel warningText;
    private boolean isOKPressed;

    public SUVCalibrationDialog(JFrame jFrame, ISUVData iSUVData, Date date) {
        super((Frame)jFrame, Messages.getString("SUVCalibrationDialog.Title"));
        this.suvData = iSUVData;
        this.earliestAcquisitionDateTime = date;
        this.method = ComponentFactory.instance.createMultiMonitorComboBox(StandardizedUptakeValueMethod.values());
        this.method.setSelectedItem(iSUVData.getMethod());
        this.patientGender = ComponentFactory.instance.createMultiMonitorComboBox(PatientSex.values());
        this.patientGender.setSelectedItem(iSUVData.getPatientSex());
        this.patientWeight = SUVCalibrationDialog.createDoubleInputField(iSUVData.getPatientWeight());
        this.patientHeight = SUVCalibrationDialog.createDoubleInputField(iSUVData.getPatientHeight());
        this.isotope = ComponentFactory.instance.createMultiMonitorComboBox(SUVCalibrationDialog.getAvailableIsotopes(iSUVData));
        this.isotope.setSelectedItem(iSUVData.getIsotope());
        this.isotope.addActionListener(this);
        IIsotope iIsotope = (IIsotope)this.isotope.getSelectedItem();
        this.halfLife = SUVCalibrationDialog.createDoubleInputField(iIsotope.getHalfLife());
        this.halfLife.setEnabled(iIsotope.isEditable());
        this.injectedDose = SUVCalibrationDialog.createDoubleInputField(iSUVData.getInjectedDose() == null ? null : Double.valueOf(iSUVData.getInjectedDose() / 1000000.0));
        this.acquisitionDelay = SUVCalibrationDialog.createDoubleInputField(SUVData.calculateAcquisitionDelay((Date)date, (Date)iSUVData.getInjectionTime()));
        this.acquisitionDelay.addCommitEditListener(this);
        this.acquisitionDelay.addKeyListener(this);
        this.acquisitionDelay.setToolTipText(Messages.getString("SUVCalibrationDialog.Data.AcquisitionDelay.ToolTip"));
        this.earliestAcquisitionTimeLabel = new TimeLabel(date);
        this.injectionTimeLabel = new TimeLabel(iSUVData.getInjectionTime());
        this.injectionTimeLabel.setToolTipText(Messages.getString("SUVCalibrationDialog.Data.InjectionTime.ToolTip"));
        this.warningText = new WarningLabel("&nbsp;");
        this.init();
    }

    private static IIsotope[] getAvailableIsotopes(ISUVData iSUVData) {
        NamedIsotope[] namedIsotopeArray = NamedIsotope.values();
        IIsotope iIsotope = iSUVData.getIsotope();
        ArrayList<Object> arrayList = new ArrayList<Object>(namedIsotopeArray.length + 2);
        if (iSUVData.getIsotopeFromData() != null) {
            arrayList.add(iSUVData.getIsotopeFromData());
        }
        NamedIsotope[] namedIsotopeArray2 = namedIsotopeArray;
        int n = namedIsotopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NamedIsotope namedIsotope = namedIsotopeArray2[n2];
            arrayList.add(namedIsotope);
            ++n2;
        }
        if (arrayList.contains(iIsotope)) {
            arrayList.add(SUVIsotope.CUSTOM);
        } else {
            arrayList.add(iIsotope);
        }
        return arrayList.toArray(new IIsotope[arrayList.size()]);
    }

    private static JDoubleField createDoubleInputField(Double d) {
        return new MultiMonitorDoubleField(d, false, 8);
    }

    private void init() {
        JPanel jPanel = ComponentFactory.instance.createPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = this.createTitledPanel(jPanel, "SUVCalibrationDialog.MethodPanel.Title");
        this.createRow(jPanel2, 0, "Method", this.method, null);
        JPanel jPanel3 = this.createTitledPanel(jPanel, "SUVCalibrationDialog.PatientPanel.Title");
        this.createRow(jPanel3, 0, "Gender", this.patientGender, null);
        this.createRow(jPanel3, 1, "BodyWeight", this.patientWeight, "kg");
        this.createRow(jPanel3, 2, "BodyHeight", this.patientHeight, "cm");
        JPanel jPanel4 = this.createTitledPanel(jPanel, "SUVCalibrationDialog.InjectionPanel.Title");
        this.createRow(jPanel4, 0, "Isotope", this.isotope, null);
        this.halfLifeLabel = this.createRow(jPanel4, 1, "HalfLife", this.halfLife, "s");
        this.createRow(jPanel4, 2, "InjectedDose", this.injectedDose, "MBq");
        JPanel jPanel5 = this.createTitledPanel(jPanel, "SUVCalibrationDialog.TimePanel.Title");
        String string = Messages.getString("SUVCalibrationDialog.TimePanel.Unit");
        this.createRow(jPanel5, 0, "EarliestAcquisitionTime", this.earliestAcquisitionTimeLabel, string);
        this.createRow(jPanel5, 1, "AcquisitionDelay", this.acquisitionDelay, "s");
        this.createRow(jPanel5, 2, "InjectionTime", this.injectionTimeLabel, string);
        JPanel jPanel6 = ComponentFactory.instance.createPanel(new FlowLayout(0));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(0, GAP, 0, GAP));
        jPanel6.add(this.warningText);
        jPanel.add(jPanel6);
        int n = 0;
        for (JLabel jLabel : this.labels) {
            int n2 = jLabel.getPreferredSize().width;
            if (n >= n2) continue;
            n = n2;
        }
        for (JLabel jLabel : this.labels) {
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width = n;
            jLabel.setPreferredSize(dimension);
        }
        this.addOKButton(new ConfirmAction());
        this.addCancelButton(new CancelAction());
        this.setContent(jPanel);
        this.pack();
        this.initLocation();
    }

    private JLabel createRow(JPanel jPanel, int n, String string, JComponent jComponent, String string2) {
        JLabel jLabel;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = n;
        jPanel.add((Component)this.createLabel(string), gridBagConstraints);
        gridBagConstraints.insets.left = GAP;
        gridBagConstraints.insets.right = GAP;
        WarningMark warningMark = new WarningMark();
        jPanel.add((Component)warningMark, gridBagConstraints);
        this.warningLabels.put(jComponent, warningMark);
        gridBagConstraints.insets.left = 0;
        if (string2 == null) {
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets.right = 0;
        }
        jPanel.add((Component)jComponent, gridBagConstraints);
        if (string2 == null) {
            jLabel = null;
        } else {
            jLabel = ComponentFactory.instance.createLabel(string2);
            jLabel.setEnabled(jComponent.isEnabled());
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        return jLabel;
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = ComponentFactory.instance.createLabel(Messages.getString("SUVCalibrationDialog.Data." + string + ".Label"));
        this.labels.add(jLabel);
        return jLabel;
    }

    private JPanel createTitledPanel(Container container, String string) {
        JPanel jPanel = ComponentFactory.instance.createPanel(new FlowLayout(0));
        JPanel jPanel2 = ComponentFactory.instance.createPanel(new GridBagLayout());
        jPanel.setBorder(ComponentFactory.instance.createTitledBorder(Messages.getString(string)));
        jPanel2.setOpaque(false);
        jPanel.add(jPanel2);
        container.add(jPanel);
        return jPanel2;
    }

    protected void updateDialog() {
        boolean bl = !this.suvData.getMethod().isValidGender((IPatientBodyData)this.suvData);
        this.warningLabels.get(this.patientGender).setWarning(bl);
        this.warningLabels.get(this.patientWeight).setWarning(!this.suvData.getMethod().isValidWeight((IPatientBodyData)this.suvData));
        this.warningLabels.get(this.patientHeight).setWarning(!this.suvData.getMethod().isValidHeight((IPatientBodyData)this.suvData));
        this.warningLabels.get(this.halfLife).setWarning(SUVData.isInvalid((Double)this.suvData.getIsotope().getHalfLife()));
        this.warningLabels.get(this.injectedDose).setWarning(SUVData.isInvalid((Double)this.suvData.getInjectedDose()));
        this.warningLabels.get(this.acquisitionDelay).setWarning(this.suvData.getInjectionTime() == null);
        String string = bl ? "UnsupportedGender" : "General";
        this.warningText.setWarning(Messages.getString("SUVCalibrationDialog.Warning." + string));
    }

    public boolean isOKPressed() {
        return this.isOKPressed;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isotope.equals(actionEvent.getSource())) {
            IIsotope iIsotope = (IIsotope)this.isotope.getSelectedItem();
            this.halfLife.setValue(iIsotope.getHalfLife());
            this.halfLife.setEnabled(iIsotope.isEditable());
            this.halfLifeLabel.setEnabled(iIsotope.isEditable());
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() != '\n') {
            this.injectionTimeLabel.setTime(null);
        }
    }

    @Override
    public void notifyCommitEdit() {
        this.injectionTimeLabel.setTime(SUVData.calculateInjectionTime((Date)this.earliestAcquisitionDateTime, (Double)this.acquisitionDelay.getValue()));
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", Messages.getString("Cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SUVCalibrationDialog.this.isOKPressed = false;
            SUVCalibrationDialog.this.setVisible(false);
        }
    }

    private class ConfirmAction
    extends AbstractAction {
        public ConfirmAction() {
            this.putValue("ShortDescription", Messages.getString("SUVCalibrationDialog.ConfirmAction.ToolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SUVCalibrationDialog.this.suvData.setMethod((IStandardizedUptakeValueMethod)SUVCalibrationDialog.this.method.getSelectedItem());
            SUVCalibrationDialog.this.suvData.setPatientSex((PatientSex)SUVCalibrationDialog.this.patientGender.getSelectedItem());
            SUVCalibrationDialog.this.suvData.setPatientWeight(SUVCalibrationDialog.this.patientWeight.getValue());
            SUVCalibrationDialog.this.suvData.setPatientHeight(SUVCalibrationDialog.this.patientHeight.getValue());
            IIsotope iIsotope = (IIsotope)SUVCalibrationDialog.this.isotope.getSelectedItem();
            if (iIsotope.getHalfLife() == null) {
                iIsotope = SUVIsotope.createCustomIsotope((Double)SUVCalibrationDialog.this.halfLife.getValue());
            }
            SUVCalibrationDialog.this.suvData.setIsotope(iIsotope);
            if (SUVCalibrationDialog.this.injectedDose.getValue() == null) {
                SUVCalibrationDialog.this.suvData.setInjectedDose(null);
            } else {
                SUVCalibrationDialog.this.suvData.setInjectedDose(Double.valueOf(SUVCalibrationDialog.this.injectedDose.getValue() * 1000000.0));
            }
            SUVCalibrationDialog.this.suvData.setAcquisitionDelay(SUVCalibrationDialog.this.earliestAcquisitionDateTime, SUVCalibrationDialog.this.acquisitionDelay.getValue());
            if (SUVCalibrationDialog.this.suvData.needsData()) {
                SUVCalibrationDialog.this.updateDialog();
            } else {
                SUVCalibrationDialog.this.isOKPressed = true;
                SUVCalibrationDialog.this.setVisible(false);
            }
        }
    }

    private static class TimeLabel
    extends MultiMonitorLabel {
        TimeLabel(Date date) {
            this.setHorizontalAlignment(11);
            this.setTime(date);
            ComponentFactory.instance.scaleFont(this);
        }

        void setTime(Date date) {
            if (date == null) {
                this.setText("NA");
            } else {
                this.setText(DateTimeUtils.time2LongerString((Date)date));
            }
        }
    }

    private static class WarningLabel
    extends MultiMonitorLabel {
        WarningLabel() {
            this.setForeground(UIManager.getColor("warningColor"));
        }

        WarningLabel(String string) {
            this();
            this.setWarning(string);
            ComponentFactory.instance.scaleFont(this);
        }

        void setWarning(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            stringBuilder.append(string);
            if (string.indexOf("<br") < 0) {
                stringBuilder.append("<br >&nbsp;");
            }
            stringBuilder.append("</html>");
            this.setText(stringBuilder.toString());
        }
    }

    private static class WarningMark
    extends WarningLabel {
        private static final String WARNING_MARK = "!";

        WarningMark() {
            this.setText(WARNING_MARK);
            this.setFont(this.getFont().deriveFont(1, (float)this.getFont().getSize() * 1.25f));
            ComponentFactory.instance.scaleFont(this);
            this.setPreferredSize(this.getPreferredSize());
            this.setWarning(false);
        }

        void setWarning(boolean bl) {
            if (bl) {
                this.setText(WARNING_MARK);
            } else {
                this.setText(null);
            }
        }
    }
}

