/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.statistics;

import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageInformationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcm4che3.data.Attributes;

public class StatisticsData<T extends IImageInformationProvider>
implements Comparable<StatisticsData<T>> {
    private static final ALogger log = ALogger.getLogger(StatisticsData.class);
    private static final long[] POSSIBLE_DATE_TIME_TAGS = new long[]{2251945843097650L, 2251950138064947L};
    private static final AtomicInteger ID_PROVIDER = new AtomicInteger(0);
    private final T data;
    private final long acquisitionDateTime;
    private final int id;

    private StatisticsData(T t, long l) {
        this.data = t;
        this.acquisitionDateTime = l;
        this.id = ID_PROVIDER.incrementAndGet();
    }

    static <T extends IImageInformationProvider> List<StatisticsData<T>> create(List<T> list) {
        ArrayList<StatisticsData<T>> arrayList = new ArrayList<StatisticsData<T>>(list.size());
        Long l = null;
        int n = 0;
        while (n < list.size()) {
            Date date;
            IImageInformationProvider iImageInformationProvider = (IImageInformationProvider)list.get(n);
            IImageInformation iImageInformation = iImageInformationProvider.getImageInformation();
            if (l == null) {
                l = StatisticsData.getDateTimeTag(iImageInformation.getDataset());
            }
            if ((date = StatisticsData.getDateTime(iImageInformation.getDataset(), l)) == null) {
                log.warn("Skipping image without date/time information: " + iImageInformation.getSeriesInstanceUID());
            } else {
                long l2 = date.getTime();
                arrayList.add(new StatisticsData<IImageInformationProvider>(iImageInformationProvider, l2));
            }
            ++n;
        }
        return arrayList;
    }

    public static <T extends IImageInformationProvider> List<StatisticsData<T>> createSortedList(List<T> list) {
        List<StatisticsData<T>> list2 = StatisticsData.create(list);
        Collections.sort(list2);
        return list2;
    }

    private static Long getDateTimeTag(Attributes attributes) {
        long[] lArray = POSSIBLE_DATE_TIME_TAGS;
        int n = POSSIBLE_DATE_TIME_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            Date date = attributes.getDate(l);
            if (date != null) {
                return l;
            }
            ++n2;
        }
        return null;
    }

    private static Date getDateTime(Attributes attributes, Long l) {
        if (l == null) {
            return null;
        }
        return attributes.getDate(l.longValue());
    }

    public T getData() {
        return this.data;
    }

    long getAcquisitionDateTime() {
        return this.acquisitionDateTime;
    }

    @Override
    public int compareTo(StatisticsData<T> statisticsData) {
        if (this.acquisitionDateTime < statisticsData.acquisitionDateTime) {
            return -1;
        }
        if (this.acquisitionDateTime > statisticsData.acquisitionDateTime) {
            return 1;
        }
        return (int)Math.signum(this.id - statisticsData.id);
    }
}

