/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.statistics;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.statistics.ChartData;
import com.agfa.pacs.impaxee.statistics.ChartSeriesData;
import com.agfa.pacs.impaxee.statistics.IStatisticsChartData;
import com.agfa.pacs.impaxee.statistics.IStatisticsChartSeries;
import com.agfa.pacs.impaxee.statistics.StatisticsData;
import com.agfa.pacs.impaxee.statistics.StatisticsTable;
import com.agfa.pacs.impaxee.utils.GuiUtil;
import com.agfa.pacs.impaxee.utils.TSVCreator;
import com.agfa.pacs.listtext.dicomobject.module.equipment.ConversionType;
import com.agfa.pacs.listtext.dicomobject.module.image.ImagePixel;
import com.agfa.pacs.listtext.dicomobject.type.ImageType;
import com.agfa.pacs.listtext.lta.util.DicomTagDictionaryFactory;
import com.agfa.pacs.listtext.lta.util.Modality;
import com.agfa.pacs.listtext.pixeldata.frame.PixelDataUtilities;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.SecondaryCapture;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class StatisticsChart<T extends IStatisticsChartData> {
    private static final ALogger log = ALogger.getLogger(StatisticsChart.class);
    private static final Color HIGHLIGHTED_DATA_POINT_FILL_COLOR = Color.DARK_GRAY;
    private static final Color HIGHLIGHTED_DATA_POINT_OUTLINE_COLOR = new Color(236, 236, 236);
    private final long earliestAcquisitionDateTime;
    private final boolean isLegendEnabled;
    private final boolean isZoomEnabled;
    private final ChartPanel chartPanel;
    private final List<? extends IStatisticsChartSeries<T>> chartSeries;
    private JFreeChart chart;
    private Map<XYSeries, ChartSeriesData> seriesMap;
    private DateFormat timeFormatter = DateFormat.getTimeInstance(2);
    private boolean isRelative = false;
    private boolean isInconsistent = false;
    private int referenceIndex = 0;
    private double scalingFactor = GUI.getScaleDiagnosticFactor();
    private static final String HTML_BR = "<br>";
    private static final String BLANK = " ";
    private static final String SEC = "sec";
    private static final String PERCENT = "%";
    private static final String EMPTY_STRING = "";
    private static final boolean USE_MAXMIMUM = Config.impaxee.jvision.OVERLAY.Statistics.useMaximumPixelValue.get();
    private static final Color BASE_COLOR = Color.white;
    private static final int SC_CHART_SIZE = 512;
    private static final Color[] DEFAULT_COLORS = new Color[]{new Color(55, 218, 255), new Color(255, 201, 0), new Color(255, 0, 171), new Color(255, 94, 35), new Color(30, 255, 0), new Color(0, 255, 151)};

    public StatisticsChart(List<? extends IStatisticsChartSeries<T>> list) {
        this(list, true, true);
    }

    public StatisticsChart(List<? extends IStatisticsChartSeries<T>> list, boolean bl, boolean bl2) {
        this.earliestAcquisitionDateTime = StatisticsChart.calculateEarliestAcquisitionTime(list);
        this.isLegendEnabled = bl;
        this.isZoomEnabled = bl2;
        this.chartSeries = list;
        try {
            this.chart = this.createChart();
        }
        catch (Exception exception) {
            log.error("Creating chart failed.", (Throwable)exception);
            this.chart = this.createEmptyChart(Messages.getString("StatisticsChart.InternalError"));
        }
        this.chartPanel = new ChartPanel(this.chart, false, false, false, bl2, true);
        this.chartPanel.setMouseZoomable(bl2);
        this.chartPanel.setDismissDelay(15000);
        this.chartPanel.setOpaque(false);
    }

    private static <T extends IStatisticsChartData> long calculateEarliestAcquisitionTime(Iterable<? extends IStatisticsChartSeries<T>> iterable) {
        long l = Long.MAX_VALUE;
        for (IStatisticsChartSeries<T> iStatisticsChartSeries : iterable) {
            long l2 = StatisticsData.createSortedList(iStatisticsChartSeries.getData()).get(0).getAcquisitionDateTime();
            if (l2 >= l) continue;
            l = l2;
        }
        return l;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void setRelative(boolean bl) {
        this.isRelative = bl;
        this.updateChart();
    }

    public void setReferenceIndex(int n) {
        this.referenceIndex = n;
        this.updateChart();
    }

    public int getReferenceIndex() {
        return this.referenceIndex;
    }

    public Color getSeriesColor(int n) {
        Paint paint = ((XYLineAndShapeRenderer)((XYPlot)this.chartPanel.getChart().getPlot()).getRenderer()).lookupSeriesPaint(n);
        if (paint instanceof Color) {
            return (Color)paint;
        }
        return null;
    }

    protected boolean isHighlighted(int n, int n2) {
        return n2 == this.referenceIndex;
    }

    private JFreeChart createChart() {
        int n;
        ChartSeriesData chartSeriesData;
        XYSeries xYSeries;
        Object object;
        ArrayList<ChartData> arrayList;
        XYPlot xYPlot;
        Object object2;
        Object object32;
        String string = null;
        ArrayList<XYSeries> arrayList2 = new ArrayList<XYSeries>();
        this.seriesMap = new HashMap<XYSeries, ChartSeriesData>();
        for (Object object32 : this.chartSeries) {
            Object object42;
            object2 = null;
            xYPlot = StatisticsData.create(object32.getData());
            arrayList = new ArrayList();
            for (Object object42 : xYPlot) {
                object = new ChartData();
                IStatisticsChartData iStatisticsChartData = (IStatisticsChartData)((StatisticsData)object42).getData();
                long l = ((StatisticsData)object42).getAcquisitionDateTime();
                if (!iStatisticsChartData.getStatistics().isValid()) continue;
                object2 = iStatisticsChartData.getStatistics();
                String string2 = object2.getUnit();
                if (string == null) {
                    string = string2;
                }
                if (!CompareUtils.equals((Object)string, (Object)string2)) {
                    log.warn("Different units: '" + string + "' vs. '" + string2 + '\'');
                    return this.createEmptyChart(Messages.getString("Chart.InconsistentData"));
                }
                double d = USE_MAXMIMUM ? object2.getMax() : object2.getMean();
                ((ChartData)object).setY(d);
                double d2 = (double)(l - this.earliestAcquisitionDateTime) / 1000.0;
                ((ChartData)object).setX(d2);
                ((ChartData)object).setAcquisitionDateTime(l);
                int n2 = iStatisticsChartData.getImageInformation().getDataset().getInt(0x200011, 0);
                ((ChartData)object).setSeriesNumber(n2);
                arrayList.add((ChartData)object);
            }
            if (arrayList.isEmpty() || arrayList.size() < 2 || object2 == null) {
                return this.createEmptyChart(Messages.getString("StatisticsChart.NotEnoughData"));
            }
            this.isInconsistent = false;
            object42 = new ChartSeriesData();
            ((ChartSeriesData)object42).setYUnit(string == null ? EMPTY_STRING : string);
            ((ChartSeriesData)object42).setXUnit(SEC);
            ((ChartSeriesData)object42).setROIName(object32.getName());
            ((ChartSeriesData)object42).setChartData(arrayList);
            if (this.referenceIndex >= ((ChartSeriesData)object42).getChartData().size()) {
                this.referenceIndex = ((ChartSeriesData)object42).getChartData().size() - 1;
            }
            xYSeries = new XYSeries((Comparable)((Object)((ChartSeriesData)object42).getROIName()));
            object = ((ChartSeriesData)object42).getChartData().get(this.referenceIndex);
            for (ChartData chartData : ((ChartSeriesData)object42).getChartData()) {
                chartData.setYRel(chartData.getY() * 100.0 / ((ChartData)object).getY());
                if (this.isRelative) {
                    xYSeries.add(chartData.getX(), chartData.getYRel());
                    continue;
                }
                xYSeries.add(chartData.getX(), chartData.getY());
            }
            if (xYSeries.isEmpty()) continue;
            arrayList2.add(xYSeries);
            this.seriesMap.put(xYSeries, (ChartSeriesData)object42);
        }
        this.cleanUpSeriesMap();
        if (this.seriesMap.size() == 1 && (chartSeriesData = (ChartSeriesData)(object32 = this.seriesMap.values().iterator()).next()).getChartData().size() < 2) {
            return this.createEmptyChart(Messages.getString("StatisticsChart.NotEnoughData"));
        }
        object32 = new XYSeriesCollection();
        for (XYSeries xYSeries2 : arrayList2) {
            object32.addSeries(xYSeries2);
        }
        String string3 = this.isRelative ? PERCENT : string;
        object2 = ChartFactory.createXYLineChart(null, (String)SEC, (String)string3, (XYDataset)object32, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.isLegendEnabled, (boolean)true, (boolean)false);
        object2.setBackgroundPaint(null);
        xYPlot = (XYPlot)object2.getPlot();
        arrayList = new HighlightingXYLineAndShapeRenderer();
        arrayList.setSeriesLinesVisible(0, true);
        arrayList.setSeriesShapesVisible(0, true);
        arrayList.setBaseToolTipGenerator(new ExtendedToolTipGenerator(this.seriesMap));
        if (GuiUtil.isOnColorMonitor()) {
            n = 0;
            while (n < object32.getSeriesCount()) {
                if (DEFAULT_COLORS.length > n) {
                    arrayList.setSeriesPaint(n, DEFAULT_COLORS[n]);
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            n = 0;
            while (n < object32.getSeriesCount()) {
                arrayList.setSeriesPaint(n, BASE_COLOR);
                ++n;
            }
        }
        xYPlot.setRenderer(arrayList);
        xYPlot.setBackgroundAlpha(0.0f);
        n = this.getDefaultFontSize();
        xYSeries = (NumberAxis)xYPlot.getRangeAxis();
        xYSeries.setAutoRangeIncludesZero(false);
        object = xYSeries.getTickLabelFont().deriveFont(0, n);
        xYSeries.setTickLabelFont((Font)object);
        xYSeries.setTickLabelPaint((Paint)BASE_COLOR);
        object = xYSeries.getLabelFont().deriveFont(1, n);
        xYSeries.setLabelFont((Font)object);
        xYSeries.setLabelPaint((Paint)BASE_COLOR);
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        object = valueAxis.getTickLabelFont().deriveFont(0, n);
        valueAxis.setTickLabelFont((Font)object);
        valueAxis.setTickLabelPaint((Paint)BASE_COLOR);
        object = valueAxis.getLabelFont().deriveFont(1, n);
        valueAxis.setLabelFont((Font)object);
        valueAxis.setLabelPaint((Paint)BASE_COLOR);
        LegendTitle legendTitle = object2.getLegend();
        if (legendTitle != null) {
            object = legendTitle.getItemFont().deriveFont(0, n);
            legendTitle.setItemFont((Font)object);
            legendTitle.setItemPaint((Paint)BASE_COLOR);
            legendTitle.setBackgroundPaint(null);
        }
        return object2;
    }

    private void cleanUpSeriesMap() {
        Iterator<ChartSeriesData> iterator = this.seriesMap.values().iterator();
        while (iterator.hasNext()) {
            ChartSeriesData chartSeriesData = iterator.next();
            if (chartSeriesData.getChartData().size() >= 2) continue;
            iterator.remove();
        }
    }

    private JFreeChart createEmptyChart(String string) {
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(null, (String)EMPTY_STRING, (String)EMPTY_STRING, (XYDataset)new XYSeriesCollection(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        jFreeChart.setBackgroundPaint(null);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        ((XYLineAndShapeRenderer)xYPlot.getRenderer()).setSeriesLinesVisible(0, false);
        ((XYLineAndShapeRenderer)xYPlot.getRenderer()).setSeriesShapesVisible(0, false);
        ((XYLineAndShapeRenderer)xYPlot.getRenderer()).setSeriesPaint(0, (Paint)(GuiUtil.isOnColorMonitor() ? DEFAULT_COLORS[0] : BASE_COLOR));
        xYPlot.setBackgroundAlpha(0.0f);
        xYPlot.setDomainAxis(null);
        xYPlot.setRangeAxis(null);
        xYPlot.setDomainGridlinesVisible(false);
        xYPlot.setRangeGridlinesVisible(false);
        xYPlot.setOutlineVisible(false);
        Font font = xYPlot.getNoDataMessageFont().deriveFont(1, this.getDefaultFontSize());
        xYPlot.setNoDataMessage(string);
        xYPlot.setNoDataMessageFont(font);
        xYPlot.setNoDataMessagePaint((Paint)BASE_COLOR);
        this.isInconsistent = true;
        return jFreeChart;
    }

    private int getDefaultFontSize() {
        return (int)(13.0 * this.scalingFactor + 0.5);
    }

    public void updateChart() {
        try {
            this.chart = this.createChart();
            this.chartPanel.setChart(this.chart);
            this.chartPanel.setMouseZoomable(this.isZoomEnabled);
        }
        catch (Exception exception) {
            log.error("Creating line chart failed.", (Throwable)exception);
        }
    }

    public boolean isInconsistent() {
        return this.isInconsistent;
    }

    public void copyToClipboard() {
        if (this.seriesMap == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DicomTagDictionaryFactory.getLocaleDictionary().getNameForTag(0x200011));
        arrayList.add(SEC);
        arrayList.add(Messages.getString("StatisticsChart.AcquisitionTime"));
        ArrayList<List<String>> arrayList2 = new ArrayList<List<String>>();
        DecimalFormat decimalFormat = new DecimalFormat("#0.00");
        boolean bl = true;
        for (Map.Entry<XYSeries, ChartSeriesData> object2 : this.seriesMap.entrySet()) {
            ChartSeriesData chartSeriesData = object2.getValue();
            String string = chartSeriesData.getROIName();
            String string2 = String.valueOf(chartSeriesData.getYUnit()) + BLANK + string;
            String string3 = "% " + string;
            arrayList.add(string2);
            arrayList.add(string3);
            List<ChartData> list = chartSeriesData.getChartData();
            int n = 0;
            while (n < list.size()) {
                List<String> list2;
                ChartData chartData = list.get(n);
                if (bl) {
                    list2 = new ArrayList<String>();
                    list2.add(Integer.toString(chartData.getSeriesNumber()));
                    list2.add(decimalFormat.format(chartData.getX()));
                    list2.add(this.timeFormatter.format(chartData.getAcquisitionDateTime()));
                    list2.add(decimalFormat.format(chartData.getY()));
                    list2.add(decimalFormat.format(chartData.getYRel()));
                    arrayList2.add(list2);
                } else {
                    list2 = (List)arrayList2.get(n);
                    list2.add(decimalFormat.format(chartData.getY()));
                    list2.add(decimalFormat.format(chartData.getYRel()));
                    arrayList2.set(n, list2);
                }
                ++n;
            }
            bl = false;
        }
        TSVCreator tSVCreator = new TSVCreator(arrayList, arrayList2, (JComponent)this.chartPanel);
        tSVCreator.copyToClipboard();
    }

    public ISeriesData createSecondaryCapture(View view) {
        try {
            this.scalingFactor = 1.0;
            this.updateChart();
            ISeriesData iSeriesData = view.getFrameData().getParent().getParent().createSeriesData(Modality.OT.dicom());
            String string = Messages.getString("StatisticsChart.SeriesDescription");
            iSeriesData.getDicomObject().setString(528446, VR.LO, string);
            this.createChartSC(iSeriesData);
            this.isRelative = !this.isRelative;
            this.updateChart();
            this.createChartSC(iSeriesData);
            this.createTableSC(iSeriesData);
            SecondaryCapture secondaryCapture = new SecondaryCapture(Collections.singletonList(view.getVis()), View.OverlayMode.PRINT_OVERLAY_ALL_AND_ROI, true);
            secondaryCapture.putSCSeries(iSeriesData.getParent(), iSeriesData);
            secondaryCapture.run();
            iSeriesData.getDicomObject().setString(528446, VR.LO, string);
            for (IImageObjectData iImageObjectData : iSeriesData.getObjects()) {
                iImageObjectData.getDicomObject().setString(528446, VR.LO, string);
            }
            this.isRelative = !this.isRelative;
            return iSeriesData;
        }
        catch (Exception exception) {
            log.error("Creating secondary capture failed.", (Throwable)exception);
            return null;
        }
    }

    private void createChartSC(ISeriesData iSeriesData) {
        BufferedImage bufferedImage = this.chart.createBufferedImage(512, 512);
        this.createSCData(iSeriesData, bufferedImage);
    }

    private void createTableSC(ISeriesData iSeriesData) {
        for (Map.Entry<XYSeries, ChartSeriesData> entry : this.seriesMap.entrySet()) {
            StatisticsTable statisticsTable = new StatisticsTable(entry.getValue(), 512, 512);
            for (BufferedImage bufferedImage : statisticsTable.getBufferdImages()) {
                this.createSCData(iSeriesData, bufferedImage);
            }
        }
    }

    private void createSCData(ISeriesData iSeriesData, BufferedImage bufferedImage) {
        IImageObjectData iImageObjectData = iSeriesData.createObjectData(IImageObjectData.class, "1.2.840.10008.5.1.4.1.1.7", "1.2.840.10008.1.2.1");
        Attributes attributes = iImageObjectData.getImageInformation().getDataset();
        attributes.setString(524296, VR.CS, ImageType.getDerivedSecondary());
        attributes.setString(0x204000, VR.LT, Messages.getString("StatisticsChart.ImageComment"));
        attributes.setString(524400, VR.LO, Product.getProductVendor());
        attributes.setString(524388, VR.CS, ConversionType.Workstation.dicom());
        attributes.setString(1576982, VR.LO, Product.getProductVendor());
        attributes.setString(1576982, VR.LO, Product.getProductName());
        attributes.setString(1576985, VR.LO, Product.getVersionString());
        ImagePixel imagePixel = ImagePixel.create((BufferedImage)bufferedImage);
        IPixelDataFrame iPixelDataFrame = PixelDataUtilities.createPixelDataFrame((ImagePixel)imagePixel, (BufferedImage)bufferedImage);
        attributes.addAll(imagePixel.toDataset());
        iImageObjectData.initFromDicomObject(attributes);
        iImageObjectData.setFrame(iPixelDataFrame, 0);
    }

    private class ExtendedToolTipGenerator
    implements XYToolTipGenerator {
        private Map<XYSeries, ChartSeriesData> xySeriesMap;
        private DecimalFormat decimalFormat = new DecimalFormat("#0.00");

        public ExtendedToolTipGenerator(Map<XYSeries, ChartSeriesData> map) {
            this.xySeriesMap = map;
        }

        public String generateToolTip(XYDataset xYDataset, int n, int n2) {
            ChartSeriesData chartSeriesData;
            StringBuilder stringBuilder = new StringBuilder();
            if (xYDataset instanceof XYSeriesCollection && (chartSeriesData = this.xySeriesMap.get(((XYSeriesCollection)xYDataset).getSeries(n))) != null) {
                ChartData chartData = chartSeriesData.getChartData().get(n2);
                Date date = new Date(chartData.getAcquisitionDateTime());
                stringBuilder.append("<html>");
                if (StatisticsChart.this.scalingFactor > 1.0) {
                    int n3 = (int)(3.0 * StatisticsChart.this.scalingFactor + 0.5);
                    stringBuilder.append("<font size=" + n3 + ">");
                }
                stringBuilder.append("Seq. Nr. ");
                stringBuilder.append(chartData.getSeriesNumber());
                stringBuilder.append(StatisticsChart.HTML_BR);
                stringBuilder.append(this.decimalFormat.format(chartData.getX()));
                stringBuilder.append(StatisticsChart.BLANK);
                stringBuilder.append(StatisticsChart.SEC);
                stringBuilder.append(StatisticsChart.HTML_BR);
                stringBuilder.append(StatisticsChart.this.timeFormatter.format(date));
                stringBuilder.append(StatisticsChart.HTML_BR);
                if (StatisticsChart.this.isRelative && StatisticsChart.this.referenceIndex == n2 && this.xySeriesMap.size() > 1) {
                    for (Map.Entry<XYSeries, ChartSeriesData> entry : this.xySeriesMap.entrySet()) {
                        ChartData chartData2 = entry.getValue().getChartData().get(n2);
                        stringBuilder.append(this.decimalFormat.format(chartData2.getY()));
                        stringBuilder.append(StatisticsChart.BLANK);
                        stringBuilder.append(entry.getValue().getYUnit());
                        stringBuilder.append(" (");
                        stringBuilder.append(entry.getValue().getROIName());
                        stringBuilder.append(")");
                        stringBuilder.append(StatisticsChart.HTML_BR);
                    }
                } else {
                    stringBuilder.append(this.decimalFormat.format(chartData.getY()));
                    stringBuilder.append(StatisticsChart.BLANK);
                    stringBuilder.append(chartSeriesData.getYUnit());
                    stringBuilder.append(StatisticsChart.HTML_BR);
                }
                stringBuilder.append(this.decimalFormat.format(chartData.getYRel()));
                stringBuilder.append(StatisticsChart.BLANK);
                stringBuilder.append(StatisticsChart.PERCENT);
                if (stringBuilder.toString().contains("<font")) {
                    stringBuilder.append("</font>");
                }
                stringBuilder.append("</html>");
                return stringBuilder.toString();
            }
            return null;
        }
    }

    private class HighlightingXYLineAndShapeRenderer
    extends XYLineAndShapeRenderer {
        HighlightingXYLineAndShapeRenderer() {
            this.setUseFillPaint(true);
            this.setUseOutlinePaint(true);
        }

        public Paint getSeriesFillPaint(int n) {
            return this.getSeriesPaint(n);
        }

        public Paint getSeriesOutlinePaint(int n) {
            return this.getSeriesPaint(n);
        }

        public Paint getItemFillPaint(int n, int n2) {
            if (StatisticsChart.this.isHighlighted(n, n2)) {
                return HIGHLIGHTED_DATA_POINT_FILL_COLOR;
            }
            return this.getItemPaint(n, n2);
        }

        public Paint getItemOutlinePaint(int n, int n2) {
            if (StatisticsChart.this.isHighlighted(n, n2)) {
                return HIGHLIGHTED_DATA_POINT_OUTLINE_COLOR;
            }
            return this.getItemPaint(n, n2);
        }
    }
}

