/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.runtime;

import com.agfa.pacs.data.shared.primitives.IntHashSet;
import com.agfa.pacs.impaxee.descriptors.Descriptor;
import com.agfa.pacs.impaxee.descriptors.DescriptorRegistry;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.impaxee.hanging.model.xml.ReferencedDescriptor;
import com.agfa.pacs.impaxee.splitsort.CrossStudyDisplaySetComparator;
import com.agfa.pacs.impaxee.splitsort.DisplaySetComparator;
import com.agfa.pacs.impaxee.splitsort.FrameObjectDataComparator;
import com.agfa.pacs.impaxee.splitsort.model.xml.AbstractConditionalCriterion;
import com.agfa.pacs.impaxee.splitsort.model.xml.ConditionalSortDisplaySetsCriterion;
import com.agfa.pacs.impaxee.splitsort.model.xml.ConditionalSortImagesCriterion;
import com.agfa.pacs.impaxee.splitsort.model.xml.ConditionalSplitCriterion;
import com.agfa.pacs.impaxee.splitsort.model.xml.SortField;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitAndSort;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitField;
import com.agfa.pacs.impaxee.splitsort.registry.SplitSortRegistry;
import com.agfa.pacs.listtext.lta.util.primitives.ArrayIntList;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.Orientation;
import com.tiani.jvision.main.DisplaySetType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.StandardElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public class SplitAndSortEngine {
    private static final ALogger log = ALogger.getLogger(SplitAndSortEngine.class);
    private static SplitAndSortEngine instance = new SplitAndSortEngine(SplitSortRegistry.getInstance().getSplitAndSort());
    private SplitAndSort splitSort;
    private ConditionalSplitCriterion defaultElseSplit = null;
    private ConditionalSortImagesCriterion defaultElseImagesSort = null;
    private ConditionalSortDisplaySetsCriterion defaultElseDisplaySetSort = null;

    public static SplitAndSortEngine getInstance() {
        return instance;
    }

    protected SplitAndSortEngine(SplitAndSort splitAndSort) {
        this.splitSort = splitAndSort;
        for (ConditionalSplitCriterion abstractConditionalCriterion : this.splitSort.conditionalSplitCriteria()) {
            if (!abstractConditionalCriterion.getIsDefault().booleanValue()) continue;
            this.defaultElseSplit = abstractConditionalCriterion;
            break;
        }
        for (ConditionalSortDisplaySetsCriterion conditionalSortDisplaySetsCriterion : this.splitSort.conditionalSortDisplaySetsCriteria()) {
            if (!conditionalSortDisplaySetsCriterion.getIsDefault().booleanValue()) continue;
            this.defaultElseDisplaySetSort = conditionalSortDisplaySetsCriterion;
            break;
        }
        for (ConditionalSortImagesCriterion conditionalSortImagesCriterion : this.splitSort.conditionalSortImagesCriteria()) {
            if (!conditionalSortImagesCriterion.getIsDefault().booleanValue()) continue;
            this.defaultElseImagesSort = conditionalSortImagesCriterion;
            break;
        }
    }

    List<IDisplaySet> addDisplaySets(List<IDisplaySet> list, List<IDisplaySet> list2) {
        IntHashSet intHashSet = new IntHashSet(32);
        for (IDisplaySet object2 : list) {
            intHashSet.add(object2.getID());
        }
        Iterator<IDisplaySet> iterator = list2.iterator();
        while (iterator.hasNext()) {
            IDisplaySet iDisplaySet = iterator.next();
            if (iDisplaySet.getFrameCount() == 0) continue;
            if (!intHashSet.contains(iDisplaySet.getID())) {
                list.add(iDisplaySet);
                continue;
            }
            iterator.remove();
        }
        if (list.size() > 0) {
            Collections.sort(list, new CrossStudyDisplaySetComparator());
        }
        return list2;
    }

    List<IFrameObjectData[]> splitPresortData(Collection<ISeriesData> collection) {
        List<IFrameObjectData[]> list = this.split(collection);
        for (IFrameObjectData[] iFrameObjectDataArray : list) {
            this.sortImageFrames(iFrameObjectDataArray);
        }
        return list;
    }

    public void sortImageFrames(IFrameObjectData[] iFrameObjectDataArray) {
        Arrays.sort(iFrameObjectDataArray, new FrameObjectDataComparator(this.getImageSortTags(iFrameObjectDataArray[0])));
    }

    public List<SortField> getDSSortTags(IFrameObjectData iFrameObjectData) {
        ArrayList<SortField> arrayList = new ArrayList<SortField>();
        boolean bl = false;
        boolean bl2 = log.isDebugEnabled();
        for (ConditionalSortDisplaySetsCriterion object : this.splitSort.conditionalSortDisplaySetsCriteria()) {
            if (object == this.defaultElseDisplaySetSort) continue;
            if (this.meetsCriterion((AbstractConditionalCriterion)object, iFrameObjectData)) {
                if (bl2) {
                    log.debug(object + " evaluated to true[DS Sort]");
                }
                for (SortField sortField : object.sortFields()) {
                    arrayList.add(sortField);
                    bl = true;
                }
                continue;
            }
            if (!object.hasElseSortFields()) continue;
            if (bl2) {
                log.debug(object + " evaluated to false[DS Sort]");
            }
            for (SortField sortField : object.elseSortFields()) {
                arrayList.add(sortField);
                bl = true;
            }
        }
        if (!bl && this.defaultElseDisplaySetSort != null) {
            if (bl2) {
                log.debug("No condition applied, default sort[DS Sort]");
            }
            for (SortField sortField : this.defaultElseDisplaySetSort.sortFields()) {
                arrayList.add(sortField);
            }
        }
        if (bl2) {
            log.debug("Sort displaysets by " + SplitAndSortEngine.outputSortTags(arrayList));
        }
        return arrayList;
    }

    public DisplaySetComparator getDisplaySetComparator(IFrameObjectData iFrameObjectData) {
        int n;
        List<SortField> list = this.getDSSortTags(iFrameObjectData);
        if (list.size() > 0 && ((n = list.get(0).getTag().intValue()) == 524320 || n == 524336)) {
            list.remove(0);
        }
        if (list.size() > 0 && ((n = list.get(0).getTag().intValue()) == 524320 || n == 524336)) {
            list.remove(0);
        }
        return new DisplaySetComparator(list.toArray(new SortField[list.size()]));
    }

    public List<SortField> getImageSortTags(IFrameObjectData iFrameObjectData) {
        ArrayList<SortField> arrayList = new ArrayList<SortField>();
        boolean bl = false;
        boolean bl2 = log.isDebugEnabled();
        for (ConditionalSortImagesCriterion object : this.splitSort.conditionalSortImagesCriteria()) {
            if (object == this.defaultElseImagesSort) continue;
            if (this.meetsCriterion((AbstractConditionalCriterion)object, iFrameObjectData)) {
                if (bl2) {
                    log.debug(object + " evaluated to true[IM Sort]");
                }
                for (SortField sortField : object.sortFields()) {
                    arrayList.add(sortField);
                    bl = true;
                }
                continue;
            }
            if (!object.hasElseSortFields()) continue;
            if (bl2) {
                log.debug(object + " evaluated to false[IM Sort]");
            }
            for (SortField sortField : object.elseSortFields()) {
                arrayList.add(sortField);
                bl = true;
            }
        }
        if (!bl && this.defaultElseImagesSort != null) {
            if (bl2) {
                log.debug("No condition applied, default sort[IM Sort]");
            }
            for (SortField sortField : this.defaultElseImagesSort.sortFields()) {
                arrayList.add(sortField);
            }
        }
        if (bl2) {
            log.debug("Sort display set:" + iFrameObjectData.getSOPInstanceUID() + "(" + iFrameObjectData.getParent().getKey() + ") by " + SplitAndSortEngine.outputSortTags(arrayList));
        }
        return arrayList;
    }

    private static String outputSortTags(List<SortField> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < list.size()) {
            stringBuilder.append(TagUtils.toString((int)list.get(n).getTag()));
            stringBuilder.append(list.get(n).getIsDescending() != false ? (char)'A' : 'D').append(',');
            ++n;
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private static String outputTags(ArrayIntList arrayIntList) {
        if (arrayIntList == null || arrayIntList.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < arrayIntList.size()) {
            stringBuilder.append(TagUtils.toString((int)arrayIntList.get(n))).append(',');
            ++n;
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private List<IFrameObjectData[]> split(Collection<ISeriesData> collection) {
        boolean bl = log.isDebugEnabled();
        HashMap<String, ArrayList<IFrameObjectData>> hashMap = new HashMap<String, ArrayList<IFrameObjectData>>();
        for (ISeriesData object2 : collection) {
            ArrayIntList arrayIntList = this.determineSplitTags(object2);
            if (bl) {
                log.debug("Splitting serie: " + object2.getKey() + " by " + SplitAndSortEngine.outputTags(arrayIntList));
            }
            for (IImageObjectData iImageObjectData : object2.getObjects()) {
                IFrameObjectData[] iFrameObjectDataArray = iImageObjectData.frames();
                int n = iFrameObjectDataArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n2];
                    String string = this.getKey(iFrameObjectData, arrayIntList);
                    ArrayList<IFrameObjectData> arrayList = (ArrayList<IFrameObjectData>)hashMap.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList<IFrameObjectData>(64);
                        hashMap.put(string, arrayList);
                    }
                    arrayList.add(iFrameObjectData);
                    ++n2;
                }
            }
        }
        ArrayList<IFrameObjectData[]> arrayList = new ArrayList<IFrameObjectData[]>(hashMap.size());
        for (Object object4 : hashMap.values()) {
            IFrameObjectData[] iFrameObjectDataArray = new IFrameObjectData[object4.size()];
            int n = 0;
            while (n < iFrameObjectDataArray.length) {
                iFrameObjectDataArray[n] = (IFrameObjectData)object4.get(n);
                ++n;
            }
            arrayList.add(iFrameObjectDataArray);
        }
        return arrayList;
    }

    private String getKey(IFrameObjectData iFrameObjectData, ArrayIntList arrayIntList) {
        String string = iFrameObjectData.getMainFrame().getParent().getSeriesInstanceUID();
        String string2 = iFrameObjectData.getMainFrame().getParent().getParent().getStudyInstanceUID();
        StringBuilder stringBuilder = new StringBuilder(64 * arrayIntList.size());
        int n = 0;
        while (n < arrayIntList.size()) {
            int n2 = arrayIntList.get(n);
            switch (n2) {
                case 2097207: {
                    double[] dArray = iFrameObjectData.getDicomObject().getDoubles(n2);
                    int n3 = 0;
                    while (n3 < dArray.length) {
                        stringBuilder.append((int)(dArray[n3] * 1000.0));
                        ++n3;
                    }
                    break;
                }
                case 0x20000E: {
                    stringBuilder.append(string);
                    break;
                }
                case 0x20000D: {
                    stringBuilder.append(string2);
                    break;
                }
                case 5505040: 
                case 5505056: 
                case 5505072: 
                case 0x540050: 
                case 5505120: 
                case 5505136: 
                case 5505168: 
                case 5505280: {
                    int n3 = iFrameObjectData.getImageInformation().getNMVectorValue(n2, iFrameObjectData.getFrameNumber());
                    if (n3 < 0) break;
                    stringBuilder.append(n3);
                    break;
                }
                case 2134102: 
                case 2134103: 
                case 2134312: 
                case 2134369: 
                case 2135123: {
                    stringBuilder.append(this.getPerFrameFunctionalGroupSequenceNested(iFrameObjectData, 2134289, n2));
                    break;
                }
                case 1609863: {
                    if (iFrameObjectData.isEnhancedSliceObject()) {
                        stringBuilder.append(this.getPerFrameFunctionalGroupSequenceNested(iFrameObjectData, 1610007, n2));
                        break;
                    }
                    Object object = iFrameObjectData.getDicomObject().getString(1609863);
                    if (object == null) break;
                    stringBuilder.append((String)object);
                    break;
                }
                case -65528: {
                    stringBuilder.append(Orientation.getOrientation(iFrameObjectData.getImageInformation()).name());
                    break;
                }
                case -65527: {
                    stringBuilder.append(DisplaySetType.getDisplaySetType(iFrameObjectData.getImageInformation()).name());
                    break;
                }
                default: {
                    int n4;
                    Object[] objectArray;
                    Object object = StandardElementDictionary.vrOf((int)n2, null);
                    if (object == VR.FD || object == VR.FL || object == VR.DS) {
                        objectArray = iFrameObjectData.getDicomObject().getDoubles(n2);
                        if (objectArray == null) break;
                        n4 = 0;
                        while (n4 < objectArray.length) {
                            stringBuilder.append((long)(objectArray[n4] * 100.0));
                            ++n4;
                        }
                    } else {
                        objectArray = iFrameObjectData.getDicomObject().getStrings(n2);
                        if (objectArray == null) break;
                        n4 = 0;
                        while (n4 < objectArray.length) {
                            stringBuilder.append((String)objectArray[n4]);
                            ++n4;
                        }
                        break block0;
                    }
                }
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private String getPerFrameFunctionalGroupSequenceNested(IFrameObjectData iFrameObjectData, int n, int n2) {
        Attributes attributes;
        String string;
        Attributes attributes2 = iFrameObjectData.getPerFrameDicomObject();
        Sequence sequence = attributes2.getSequence(n);
        if (sequence != null && sequence.size() > 0 && (string = (attributes = (Attributes)sequence.get(0)).getString(n2)) != null) {
            return string;
        }
        return "";
    }

    public ArrayIntList determineSplitTags(ISeriesData iSeriesData) {
        ArrayIntList arrayIntList = new ArrayIntList(5);
        arrayIntList.add(0x20000D);
        boolean bl = false;
        boolean bl2 = log.isDebugEnabled();
        for (ConditionalSplitCriterion object : this.splitSort.conditionalSplitCriteria()) {
            if (object == this.defaultElseSplit) continue;
            IImageObjectData iImageObjectData = iSeriesData.getFirstObject();
            if (iImageObjectData != null && this.meetsCriterion((AbstractConditionalCriterion)object, iImageObjectData) || this.meetsCriterion((AbstractConditionalCriterion)object, iSeriesData)) {
                if (bl2) {
                    log.debug(object + " evaluated to true[Split]");
                }
                bl = true;
                for (SplitField splitField : object.splitFields()) {
                    arrayIntList.add(splitField.getTag().intValue());
                }
                continue;
            }
            if (!object.hasElseSplitFields()) continue;
            if (bl2) {
                log.debug(object + " evaluated to false[Split]");
            }
            for (SplitField splitField : object.elseSplitFields()) {
                arrayIntList.add(splitField.getTag().intValue());
                bl = true;
            }
        }
        if (!bl && this.defaultElseSplit != null) {
            if (bl2) {
                log.debug("No condition applied, using default one[Split]");
            }
            for (SplitField splitField : this.defaultElseSplit.splitFields()) {
                arrayIntList.add(splitField.getTag().intValue());
            }
        }
        if (arrayIntList.size() >= 2 && arrayIntList.get(1) == 0x20000D) {
            arrayIntList.removeElementAt(1);
        }
        return arrayIntList;
    }

    private boolean meetsCriterion(AbstractConditionalCriterion abstractConditionalCriterion, IFrameObjectData iFrameObjectData) {
        IImageObjectData iImageObjectData = iFrameObjectData.getMainFrame();
        ReferencedDescriptor[] referencedDescriptorArray = abstractConditionalCriterion.referencedDescriptors();
        int n = referencedDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferencedDescriptor referencedDescriptor = referencedDescriptorArray[n2];
            Descriptor descriptor = DescriptorRegistry.getInstance().getDescriptorWithID(referencedDescriptor.getId());
            List<Condition> list = descriptor.conditions();
            int n3 = 0;
            while (n3 < list.size()) {
                if (!Condition.evaluate(list.get(n3), iImageObjectData)) {
                    return false;
                }
                ++n3;
            }
            ++n2;
        }
        return true;
    }

    private boolean meetsCriterion(AbstractConditionalCriterion abstractConditionalCriterion, IDataObject iDataObject) {
        ReferencedDescriptor[] referencedDescriptorArray = abstractConditionalCriterion.referencedDescriptors();
        int n = referencedDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferencedDescriptor referencedDescriptor = referencedDescriptorArray[n2];
            Descriptor descriptor = DescriptorRegistry.getInstance().getDescriptorWithID(referencedDescriptor.getId());
            List<Condition> list = descriptor.conditions();
            int n3 = 0;
            while (n3 < list.size()) {
                if (!Condition.evaluate(list.get(n3), iDataObject)) {
                    return false;
                }
                ++n3;
            }
            ++n2;
        }
        return true;
    }
}

