/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.runtime;

import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.sessions.SessionDisplaySet;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSet;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortDisplaySetListener;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitAndSort;
import com.agfa.pacs.impaxee.splitsort.runtime.AbstractSplitAndSortRuntime;
import com.agfa.pacs.impaxee.splitsort.runtime.SplitAndSortEngine;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SessionSplitAndSortRuntime
extends AbstractSplitAndSortRuntime
implements ISplitAndSortDisplaySetListener {
    private List<IDisplaySet> displaySets;
    public List<SessionDisplaySet> sessionDisplaySets = new ArrayList<SessionDisplaySet>();
    private Set<IStudyData> usedStudies = new LinkedHashSet<IStudyData>();

    public SessionSplitAndSortRuntime(IPatientRepresentation iPatientRepresentation) {
        super(iPatientRepresentation);
        this.displaySets = new ArrayList<IDisplaySet>();
    }

    @Override
    public void addDisplaySet(IDisplaySet iDisplaySet) {
        this.addDisplaySetImpl(iDisplaySet, new SessionDisplaySet(iDisplaySet, (ISplitAndSortRuntime)this));
    }

    public Iterable<IStudyData> getStudies() {
        return this.usedStudies;
    }

    public boolean hasStudies(String string) {
        for (IStudyData iStudyData : this.usedStudies) {
            if (!iStudyData.getKey().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void addDisplaySetImpl(IDisplaySet iDisplaySet, SessionDisplaySet sessionDisplaySet) {
        if (iDisplaySet.getOneObject() != null) {
            this.usedStudies.add(iDisplaySet.getOneObject().getParent().getParent());
        }
        this.displaySets.add(iDisplaySet);
        this.sessionDisplaySets.add(sessionDisplaySet);
        this.fireDisplaySetsAdded(Collections.singletonList(iDisplaySet));
    }

    @Override
    public IDisplaySet getDisplaySetAt(int n) {
        if (n >= 0 && n < this.displaySets.size()) {
            return this.displaySets.get(n);
        }
        return null;
    }

    @Override
    public IDisplaySet getDisplaySetByID(int n) {
        for (IDisplaySet iDisplaySet : this.displaySets) {
            if (n != iDisplaySet.getID()) continue;
            return iDisplaySet;
        }
        return null;
    }

    @Override
    public IDisplaySet getKeyImageDisplaySet(IStudyData iStudyData) {
        return null;
    }

    @Override
    public int getDisplaySetPosition(IDisplaySet iDisplaySet) {
        return this.displaySets.indexOf(iDisplaySet);
    }

    @Override
    public int getDisplaySetCount() {
        return this.displaySets.size();
    }

    @Override
    public IDisplaySet[] getDisplaySets() {
        return this.displaySets.toArray(new IDisplaySet[this.displaySets.size()]);
    }

    @Override
    public void splitAndSortSingleStudy(IStudyData iStudyData, SplitAndSort splitAndSort) {
    }

    @Override
    public SplitAndSortChangeSet addSeries(Collection<ISeriesData> collection) {
        return null;
    }

    public void addDisplaySets(IDisplaySet[] iDisplaySetArray) {
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
        IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDisplaySet iDisplaySet = iDisplaySetArray2[n2];
            if (iDisplaySet.getOneObject() != null && !this.usedStudies.contains(iDisplaySet.getOneObject().getParent().getParent())) {
                arrayList.add(iDisplaySet);
                this.sessionDisplaySets.add(new SessionDisplaySet(iDisplaySet, (ISplitAndSortRuntime)this));
            }
            ++n2;
        }
        SplitAndSortEngine.getInstance().addDisplaySets(this.displaySets, arrayList);
    }

    @Override
    public void displaySetsRemoved(IDisplaySet[] iDisplaySetArray) {
        IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDisplaySet iDisplaySet = iDisplaySetArray2[n2];
            this.removeDisplaySet(iDisplaySet);
            ++n2;
        }
    }

    @Override
    public void displaySetAdded(IPatientRepresentation iPatientRepresentation, List<IDisplaySet> list) {
        this.addDisplaySets(list.toArray(new IDisplaySet[list.size()]));
    }

    @Override
    public void removeDisplaySet(IDisplaySet iDisplaySet) {
        Iterator<SessionDisplaySet> iterator = this.sessionDisplaySets.iterator();
        while (iterator.hasNext()) {
            if (iDisplaySet != iterator.next().getDisplaySet()) continue;
            iterator.remove();
            break;
        }
        this.displaySets.remove(iDisplaySet);
        this.fireDisplaySetsRemoved(Collections.singletonList(iDisplaySet));
    }

    public void addSessionDisplaySet(SessionDisplaySet sessionDisplaySet) {
        if (sessionDisplaySet.getDisplaySet().getFrameCount() != 0) {
            this.addDisplaySetImpl(sessionDisplaySet.getDisplaySet(), sessionDisplaySet);
        }
    }

    public void removeSessionDisplaySet(SessionDisplaySet sessionDisplaySet) {
        this.removeDisplaySet(sessionDisplaySet.getDisplaySet());
    }

    public void removeStudy(IStudyData iStudyData) {
        if (this.usedStudies.remove(iStudyData)) {
            Object object;
            Object object2 = this.sessionDisplaySets.iterator();
            while (object2.hasNext()) {
                object = object2.next().getDisplaySet();
                if (!iStudyData.equals(object.getStudy())) continue;
                object2.remove();
            }
            object2 = new ArrayList();
            object = this.displaySets.iterator();
            while (object.hasNext()) {
                IDisplaySet iDisplaySet = (IDisplaySet)object.next();
                if (!iStudyData.equals(iDisplaySet.getStudy())) continue;
                ((ArrayList)object2).add(iDisplaySet);
                object.remove();
            }
            DataManager.getInstance().removeDisplaySet(((ArrayList)object2).toArray(new IDisplaySet[((ArrayList)object2).size()]), true);
        }
    }

    @Override
    public List<String> getStudyOrdering() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        for (IDisplaySet iDisplaySet : this.displaySets) {
            if (string.equals(iDisplaySet.getStudyUID())) continue;
            string = iDisplaySet.getStudyUID();
            arrayList.add(string);
        }
        return arrayList;
    }
}

