/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.runtime;

import com.agfa.pacs.impaxee.data.fetcher.DataHandlerProviderFactory;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.impl.HangingFactory;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.splitsort.DisplaySetComparator;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSet;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitAndSort;
import com.agfa.pacs.impaxee.splitsort.runtime.AbstractSplitAndSortRuntime;
import com.agfa.pacs.impaxee.splitsort.runtime.DisplaySetContainer;
import com.agfa.pacs.impaxee.splitsort.runtime.IDisplaySetContainerRuntime;
import com.agfa.pacs.impaxee.splitsort.runtime.ManualSplitAndSortEngine;
import com.agfa.pacs.impaxee.splitsort.runtime.SplitAndSortEngine;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConditionalSplitAndSortRuntime
extends AbstractSplitAndSortRuntime
implements IDisplaySetContainerRuntime {
    private DisplaySetContainer runtimeContainer;
    private DisplaySetContainer defaultContainer = DisplaySetContainer.createDefaultInstance(this);
    private DisplaySetContainer koContainer = DisplaySetContainer.createKeyImageInstance(this);
    private DisplaySetContainer koPerStudyContainer = DisplaySetContainer.createKeyImageInstance(this);
    private boolean loading = false;

    public ConditionalSplitAndSortRuntime(IPatientRepresentation iPatientRepresentation) {
        super(iPatientRepresentation);
        this.runtimeContainer = DisplaySetContainer.createRuntimeInstance(this);
        this.runtimeContainer.addDisplaySetContainerListener(new RuntimeContainerListener());
    }

    @Override
    public List<String> getStudyOrdering() {
        return this.runtimeContainer.getStudyOrdering();
    }

    @Override
    public void addDisplaySet(IDisplaySet iDisplaySet) {
        this.populateContainers(Collections.singletonList(iDisplaySet.getObjects()), iDisplaySet, null);
    }

    @Override
    public void removeDisplaySet(IDisplaySet iDisplaySet) {
        this.runtimeContainer.removeDisplaySet(iDisplaySet, null);
    }

    @Override
    public IDisplaySet getDisplaySetAt(int n) {
        return this.runtimeContainer.getDisplaySetAt(n);
    }

    @Override
    public IDisplaySet getDisplaySetByID(int n) {
        return this.runtimeContainer.getDisplaySetForId(n);
    }

    @Override
    public IDisplaySet getKeyImageDisplaySet(IStudyData iStudyData) {
        List<IDisplaySet> list = this.koPerStudyContainer.getDisplaySetsOfStudy(iStudyData);
        return list != null && !list.isEmpty() ? list.get(0) : null;
    }

    @Override
    public int getDisplaySetCount() {
        return this.runtimeContainer.getNumberOfDisplaySets();
    }

    @Override
    public int getDisplaySetPosition(IDisplaySet iDisplaySet) {
        return this.runtimeContainer.getIndexOfDisplaySet(iDisplaySet);
    }

    @Override
    public IDisplaySet[] getDisplaySets() {
        return this.runtimeContainer.getDisplaySets().toArray(new IDisplaySet[0]);
    }

    @Override
    public void splitAndSortSingleStudy(IStudyData iStudyData, SplitAndSort splitAndSort) {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IDisplaySet[] iDisplaySetArray = this.getDisplaySets();
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = iDisplaySetArray[n2];
            if (object2.getStudy().getKey().equals(iStudyData.getKey())) {
                arrayList.add(object2);
            }
            ++n2;
        }
        for (Object object2 : arrayList) {
            this.removeDisplaySet((IDisplaySet)object2);
        }
        object2 = new ManualSplitAndSortEngine(splitAndSort);
        List<IFrameObjectData[]> list = ((SplitAndSortEngine)object2).splitPresortData(iStudyData.getSeries());
        this.populateContainers(list, null, null, Collections.singletonMap(iStudyData.getStudyInstanceUID(), ((SplitAndSortEngine)object2).getDisplaySetComparator(((IFrameObjectData[])list.get(0))[0])));
    }

    @Override
    public SplitAndSortChangeSet addSeries(Collection<ISeriesData> collection) {
        List<IFrameObjectData[]> list = SplitAndSortEngine.getInstance().splitPresortData(collection);
        DisplaySetContainer.ChangeSet changeSet = this.runtimeContainer.createNewChangeSet();
        this.populateContainers(list, null, changeSet);
        return changeSet;
    }

    @Override
    public boolean isStudyCollapsableOrExpandable(IStudyData iStudyData) {
        IDisplaySet iDisplaySet = this.runtimeContainer.getFirstDisplaySetOfStudy(iStudyData);
        if (iDisplaySet != null) {
            if (this.isDisplaySetCollapsed(iDisplaySet)) {
                return !this.isStudyLoaded(iStudyData) || this.defaultContainer.containsDisplaySetOfStudy(iStudyData);
            }
            return this.koContainer.containsDisplaySetOfStudy(iStudyData);
        }
        return false;
    }

    @Override
    public boolean isStudyCollapsed(IStudyData iStudyData) {
        IDisplaySet iDisplaySet = this.runtimeContainer.getFirstDisplaySetOfStudy(iStudyData);
        if (iDisplaySet != null) {
            return this.isDisplaySetCollapsed(iDisplaySet);
        }
        return false;
    }

    @Override
    public boolean isDisplaySetCollapsable(IDisplaySet iDisplaySet) {
        if (this.runtimeContainer.containsDisplaySet(iDisplaySet)) {
            return this.koContainer.containsDisplaySet(iDisplaySet) || this.koContainer.getRelatedDisplaySet(iDisplaySet) != null;
        }
        return false;
    }

    @Override
    public boolean isDisplaySetExpandable(IDisplaySet iDisplaySet) {
        if (this.runtimeContainer.containsDisplaySet(iDisplaySet)) {
            return !this.isStudyLoaded(iDisplaySet.getStudy()) || this.defaultContainer.getRelatedDisplaySet(iDisplaySet) != null;
        }
        return false;
    }

    @Override
    public boolean isDisplaySetCollapsed(IDisplaySet iDisplaySet) {
        return this.koContainer.containsDisplaySet(iDisplaySet);
    }

    @Override
    public void setStudyCollapsed(IStudyData iStudyData) {
        List<IDisplaySet> list;
        if (!this.isStudyCollapsed(iStudyData) && (list = this.runtimeContainer.getDisplaySetsOfStudy(iStudyData)) != null) {
            DisplaySetContainer.ChangeSet changeSet = this.runtimeContainer.createNewChangeSet();
            for (IDisplaySet iDisplaySet : list) {
                IDisplaySet iDisplaySet2 = this.koContainer.getRelatedDisplaySet(iDisplaySet);
                if (iDisplaySet2 != null) {
                    this.runtimeContainer.replaceDisplaySet(iDisplaySet, iDisplaySet2, changeSet);
                    continue;
                }
                this.runtimeContainer.removeDisplaySet(iDisplaySet, changeSet);
            }
            DataManager.getInstance().applySplitAndSortChange(changeSet);
        }
    }

    @Override
    public void setStudyExpanded(IStudyData iStudyData) {
        if (this.isStudyCollapsed(iStudyData)) {
            List<IDisplaySet> list;
            if (!this.isStudyLoaded(iStudyData)) {
                this.loadStudy(iStudyData);
            }
            if ((list = this.defaultContainer.getDisplaySetsOfStudy(iStudyData)) != null) {
                DisplaySetContainer.ChangeSet changeSet = this.runtimeContainer.createNewChangeSet();
                for (IDisplaySet iDisplaySet : list) {
                    IDisplaySet iDisplaySet2 = this.runtimeContainer.getRelatedDisplaySet(iDisplaySet);
                    if (iDisplaySet2 != null) {
                        this.runtimeContainer.replaceDisplaySet(iDisplaySet2, iDisplaySet, changeSet);
                        continue;
                    }
                    this.runtimeContainer.addDisplaySets(Collections.singletonList(iDisplaySet), changeSet);
                }
                DataManager.getInstance().applySplitAndSortChange(changeSet);
            }
        }
    }

    @Override
    public void setDisplaySetCollapsed(IDisplaySet iDisplaySet) {
        IDisplaySet iDisplaySet2;
        if (this.runtimeContainer.containsDisplaySet(iDisplaySet) && !this.isDisplaySetCollapsed(iDisplaySet) && (iDisplaySet2 = this.koContainer.getRelatedDisplaySet(iDisplaySet)) != null) {
            DisplaySetContainer.ChangeSet changeSet = this.runtimeContainer.createNewChangeSet();
            this.runtimeContainer.replaceDisplaySet(iDisplaySet, iDisplaySet2, changeSet);
            DataManager.getInstance().applySplitAndSortChange(changeSet);
        }
    }

    @Override
    public void setDisplaySetExpanded(IDisplaySet iDisplaySet) {
        if (this.runtimeContainer.containsDisplaySet(iDisplaySet) && this.isDisplaySetCollapsed(iDisplaySet)) {
            IDisplaySet iDisplaySet2;
            IStudyData iStudyData = iDisplaySet.getStudy();
            if (iStudyData != null && !this.isStudyLoaded(iStudyData)) {
                this.loadStudy(iStudyData);
            }
            if ((iDisplaySet2 = this.defaultContainer.getRelatedDisplaySet(iDisplaySet)) != null) {
                DisplaySetContainer.ChangeSet changeSet = this.runtimeContainer.createNewChangeSet();
                this.runtimeContainer.replaceDisplaySet(iDisplaySet, iDisplaySet2, changeSet);
                DataManager.getInstance().applySplitAndSortChange(changeSet);
            }
        }
    }

    private synchronized void populateContainers(List<IFrameObjectData[]> list, IDisplaySet iDisplaySet, DisplaySetContainer.ChangeSet changeSet) {
        this.populateContainers(list, iDisplaySet, changeSet, null);
    }

    private synchronized void populateContainers(List<IFrameObjectData[]> list, IDisplaySet iDisplaySet, DisplaySetContainer.ChangeSet changeSet, Map<String, DisplaySetComparator> map) {
        if (list.isEmpty()) {
            return;
        }
        if (iDisplaySet != null && list.size() > 1) {
            throw new UnsupportedOperationException();
        }
        KeyImageManager keyImageManager = KeyImageManager.getInstance();
        boolean bl = DataManager.getInstance().isPreferablyLoadKeyImagesEnabled();
        boolean bl2 = false;
        boolean bl3 = !keyImageManager.isEmpty();
        boolean bl4 = iDisplaySet == null;
        IDisplaySet iDisplaySet2 = null;
        ArrayList<Object> arrayList = null;
        LinkedHashMap<IStudyData, ArrayList<Object>> linkedHashMap = new LinkedHashMap<IStudyData, ArrayList<Object>>(3);
        ArrayList<IDisplaySet> arrayList2 = new ArrayList<IDisplaySet>(list.size());
        ArrayList<IDisplaySet> arrayList3 = new ArrayList<IDisplaySet>(list.size());
        for (IFrameObjectData[] iFrameObjectDataArray : list) {
            if (iFrameObjectDataArray == null) continue;
            bl2 = false;
            arrayList = null;
            if (bl3) {
                IFrameObjectData[] iFrameObjectDataArray2 = iFrameObjectDataArray;
                int n = iFrameObjectDataArray.length;
                int iDisplaySet3 = 0;
                while (iDisplaySet3 < n) {
                    IFrameObjectData iFrameObjectData = iFrameObjectDataArray2[iDisplaySet3];
                    if (keyImageManager.isMarked(iFrameObjectData)) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<Object>(32);
                        }
                        arrayList.add(iFrameObjectData);
                        IStudyData iStudyData = iFrameObjectData.getParent().getParent();
                        ArrayList<Object> arrayList4 = (ArrayList<Object>)linkedHashMap.get(iStudyData);
                        if (arrayList4 == null) {
                            arrayList4 = new ArrayList<Object>();
                            linkedHashMap.put(iStudyData, arrayList4);
                        }
                        arrayList4.add(iFrameObjectData);
                    }
                    if (!bl2 && iFrameObjectData.getMainFrame().getFrameCount() > 1) {
                        bl2 = true;
                    }
                    ++iDisplaySet3;
                }
            }
            if (bl4) {
                iDisplaySet = HangingFactory.getInstance().newDisplaySet(iFrameObjectDataArray, this);
            }
            iDisplaySet2 = null;
            if (arrayList != null) {
                if (arrayList.size() == iFrameObjectDataArray.length) {
                    iDisplaySet2 = iDisplaySet;
                    this.koContainer.addDisplaySets(Collections.singletonList(iDisplaySet), map, null);
                } else {
                    iDisplaySet2 = HangingFactory.getInstance().newDisplaySet(arrayList.toArray(new IFrameObjectData[0]), this);
                    this.koContainer.addDisplaySets(Collections.singletonList(iDisplaySet2), map, null);
                }
            }
            if (arrayList == null || arrayList.size() != iFrameObjectDataArray.length) {
                arrayList2.add(iDisplaySet);
            }
            if (this.loading) continue;
            if (bl && bl2 && iDisplaySet2 != null && arrayList != null && arrayList.size() != iFrameObjectDataArray.length) {
                arrayList3.add(iDisplaySet2);
                continue;
            }
            arrayList3.add(iDisplaySet);
        }
        if (!linkedHashMap.isEmpty()) {
            IFrameObjectData[] iFrameObjectDataArray;
            iFrameObjectDataArray = new ArrayList(linkedHashMap.size());
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                IDisplaySet iDisplaySet3 = HangingFactory.getInstance().newDisplaySet(((List)entry.getValue()).toArray(new IFrameObjectData[0]), this);
                iDisplaySet3.getDisplaySetType();
                iFrameObjectDataArray.add(iDisplaySet3);
            }
            this.koPerStudyContainer.addDisplaySets((List<IDisplaySet>)iFrameObjectDataArray, map, null);
        }
        if (!arrayList2.isEmpty()) {
            this.defaultContainer.addDisplaySets(arrayList2, map, changeSet);
        }
        if (!arrayList3.isEmpty()) {
            this.runtimeContainer.addDisplaySets(arrayList3, map, changeSet);
        }
    }

    private void loadStudy(IStudyData iStudyData) {
        try {
            this.loading = true;
            DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getRetriever().loadCompleteStudy(iStudyData);
        }
        finally {
            this.loading = false;
        }
    }

    private boolean isStudyLoaded(IStudyData iStudyData) {
        return iStudyData.getNumberOfLoadedImages() >= iStudyData.getNumberOfAvailableImages();
    }

    private class RuntimeContainerListener
    implements DisplaySetContainer.IDisplaySetContainerListener {
        private RuntimeContainerListener() {
        }

        @Override
        public void displaySetsAdded(List<IDisplaySet> list) {
            ConditionalSplitAndSortRuntime.this.fireDisplaySetsAdded(list);
        }

        @Override
        public void displaySetRemoved(IDisplaySet iDisplaySet) {
            ConditionalSplitAndSortRuntime.this.fireDisplaySetsRemoved(Collections.singletonList(iDisplaySet));
        }
    }
}

