/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.runtime;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortDisplaySetListener;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.logging.ALogger;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

abstract class AbstractSplitAndSortRuntime
implements ISplitAndSortRuntime {
    private static final ALogger log = ALogger.getLogger(AbstractSplitAndSortRuntime.class);
    private final IPatientRepresentation patientRepresentation;
    private Set<ISplitAndSortDisplaySetListener> displaySetListeners;

    AbstractSplitAndSortRuntime(IPatientRepresentation iPatientRepresentation) {
        this.patientRepresentation = iPatientRepresentation;
        this.displaySetListeners = new CopyOnWriteArraySet<ISplitAndSortDisplaySetListener>();
    }

    @Override
    public final IPatientRepresentation getPatientRepresentation() {
        return this.patientRepresentation;
    }

    @Override
    public void addDisplaySetListener(ISplitAndSortDisplaySetListener iSplitAndSortDisplaySetListener) {
        this.displaySetListeners.add(iSplitAndSortDisplaySetListener);
    }

    @Override
    public void removeDisplaySetListener(ISplitAndSortDisplaySetListener iSplitAndSortDisplaySetListener) {
        this.displaySetListeners.remove(iSplitAndSortDisplaySetListener);
    }

    protected void fireDisplaySetsAdded(final List<IDisplaySet> list) {
        if (list != null && !list.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (ISplitAndSortDisplaySetListener iSplitAndSortDisplaySetListener : AbstractSplitAndSortRuntime.this.displaySetListeners) {
                        iSplitAndSortDisplaySetListener.displaySetAdded(AbstractSplitAndSortRuntime.this.patientRepresentation, list);
                    }
                }
            };
            try {
                EventUtil.invoke((Runnable)runnable);
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    protected void fireDisplaySetsRemoved(List<IDisplaySet> list) {
        if (list != null && !list.isEmpty()) {
            final IDisplaySet[] iDisplaySetArray = list.toArray(new IDisplaySet[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (ISplitAndSortDisplaySetListener iSplitAndSortDisplaySetListener : AbstractSplitAndSortRuntime.this.displaySetListeners) {
                        iSplitAndSortDisplaySetListener.displaySetsRemoved(iDisplaySetArray);
                    }
                }
            };
            try {
                EventUtil.invoke((Runnable)runnable);
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
    }
}

