/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.model;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.splitsort.ManualSortSplitProcessor;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitAndSort;
import com.agfa.pacs.impaxee.splitsort.runtime.ManualSplitAndSortEngine;
import com.agfa.pacs.security.role.IRole;
import com.agfa.pacs.security.role.RoleManagerFactory;
import com.tiani.base.data.IFrameObjectData;

public enum ManualSplitAndSortPresetsType {
    FULL(true, true, true, Config.impaxee.jvision.manualSplitSortPresets.getKey()){

        @Override
        public String getActionID() {
            return "SERIES_SPLIT_SORT";
        }

        @Override
        public void applyManualSplitAndSort(IDisplaySet iDisplaySet, SplitAndSort splitAndSort) {
            ManualSortSplitProcessor.getInstance().applyManualSplitAndSort(iDisplaySet.getStudy(), splitAndSort);
        }
    }
    ,
    IMAGE_SORT(false, false, true, Config.impaxee.jvision.manualImageSortPresets.getKey()){

        @Override
        public void applyManualSplitAndSort(IDisplaySet iDisplaySet, SplitAndSort splitAndSort) {
            if (splitAndSort != null) {
                ManualSortSplitProcessor.getInstance().changeImageSort(iDisplaySet, new ManualImageFrameSorter(splitAndSort));
            }
        }
    };

    private final boolean isSplitEnabled;
    private final boolean isSeriesSortEnabled;
    private final boolean isImageSortEnabled;
    private final String configKey;

    private ManualSplitAndSortPresetsType(boolean bl, boolean bl2, boolean bl3, String string2) {
        this.isSplitEnabled = bl;
        this.isSeriesSortEnabled = bl2;
        this.isImageSortEnabled = bl3;
        this.configKey = string2;
    }

    public String getActionID() {
        return "MANUAL_SPLIT_AND_SORT_" + this.name();
    }

    public String getTitle() {
        return this.getString("Title");
    }

    public String getCaption() {
        return this.getString("Caption");
    }

    private String getString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ManualSplitAndSortPresetsType.");
        stringBuilder.append(this.name());
        stringBuilder.append('.');
        stringBuilder.append(string);
        return Messages.getString(stringBuilder.toString());
    }

    public boolean isSplitEnabled() {
        return this.isSplitEnabled;
    }

    public boolean isSeriesSortEnabled() {
        return this.isSeriesSortEnabled;
    }

    public boolean isImageSortEnabled() {
        return this.isImageSortEnabled;
    }

    public IConfigurationList getConfigList() {
        IConfigurationProvider iConfigurationProvider = ManualSplitAndSortPresetsType.getEnterpriseConfiguration();
        if (iConfigurationProvider.exists(this.configKey)) {
            return iConfigurationProvider.getList(this.configKey);
        }
        return null;
    }

    public void updateConfig() {
        IConfigurationProvider iConfigurationProvider = ManualSplitAndSortPresetsType.getEnterpriseConfiguration();
        iConfigurationProvider.storeConfigurationForRole(iConfigurationProvider.getRole());
        ConfigurationProviderFactory.getConfig().updateCache(this.configKey);
    }

    private static IConfigurationProvider getEnterpriseConfiguration() {
        IConfigurationProvider iConfigurationProvider;
        if (ConfigurationProviderFactory.getConfig().isSupportingRoles()) {
            IRole iRole = RoleManagerFactory.getInstance().getEnterpriseRole();
            iConfigurationProvider = ConfigurationProviderFactory.getAdministrationFactory().getConfigForRole(iRole.getFullPath());
        } else {
            iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        }
        return iConfigurationProvider;
    }

    public abstract void applyManualSplitAndSort(IDisplaySet var1, SplitAndSort var2);

    /* synthetic */ ManualSplitAndSortPresetsType(String string, int n, boolean bl, boolean bl2, boolean bl3, String string2, ManualSplitAndSortPresetsType manualSplitAndSortPresetsType) {
        this(bl, bl2, bl3, string2);
    }

    private static class ManualImageFrameSorter
    implements ManualSortSplitProcessor.IFrameSorter {
        private final ManualSplitAndSortEngine engine;

        ManualImageFrameSorter(SplitAndSort splitAndSort) {
            this.engine = new ManualSplitAndSortEngine(splitAndSort);
        }

        @Override
        public void sort(IFrameObjectData[] iFrameObjectDataArray) {
            this.engine.sortImageFrames(iFrameObjectDataArray);
        }
    }
}

